/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt.tate;

import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.Border;
import net.hizlab.kagetaka.awt.ImageCreator;
import net.hizlab.kagetaka.awt.LayoutUtils;
import net.hizlab.kagetaka.awt.tate.Button;
import net.hizlab.kagetaka.awt.tate.TextField;
import net.hizlab.kagetaka.rendering.Option;

public class FileField
extends Container {
    private static final String RESOURCE = "net.hizlab.kagetaka.awt.tate.Resource";
    private static final String BASE = "filefield";
    private static int nameCounter = 0;
    private String name;
    private boolean nameExplicitlySet = false;
    private TextField text;
    private Button button;
    private String title;
    private FilenameFilter filter;

    public FileField(Option option, ImageCreator imageCreator) {
        this(option, imageCreator, null, 20);
    }

    public FileField(Option option, ImageCreator imageCreator, String string) {
        this(option, imageCreator, string, 20);
    }

    public FileField(Option option, ImageCreator imageCreator, String string, int n) {
        this.text = new TextField(option, imageCreator, string, n);
        this.button = new Button(option, imageCreator, Resource.getMessage((String)RESOURCE, (String)"filefield.button.browse", null));
        GridBagLayout gridBagLayout = new GridBagLayout();
        Insets insets = new Insets(0, 0, 0, 0);
        this.setLayout(gridBagLayout);
        LayoutUtils.addGridBag(this, this.text, gridBagLayout, 0, 0, 1, 1, 1.0, 1.0, 3, 11, insets);
        insets.top = 2;
        LayoutUtils.addGridBag(this, this.button, gridBagLayout, 0, 1, 1, 1, 1.0, 0.0, 0, 15, insets);
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Container container = FileField.this.getParent();
                if (container == null) {
                    return;
                }
                while (!(container instanceof Frame)) {
                    if ((container = container.getParent()) != null) continue;
                    return;
                }
                String string = FileField.this.title;
                if (string == null) {
                    string = Resource.getMessage((String)FileField.RESOURCE, (String)"filefield.browse.title", null);
                }
                FileDialog fileDialog = new FileDialog((Frame)container, string);
                String string2 = FileField.this.text.getText();
                if (string2.length() > 0 && string2.indexOf(42) == -1 && string2.indexOf(63) == -1) {
                    File file = new File(string2);
                    fileDialog.setDirectory(file.getParent());
                    fileDialog.setFile(file.getName());
                }
                if (FileField.this.filter != null) {
                    fileDialog.setFilenameFilter(FileField.this.filter);
                }
                fileDialog.show();
                string2 = fileDialog.getFile();
                if (string2 != null) {
                    FileField.this.text.setText(fileDialog.getDirectory() + string2);
                }
            }
        });
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    protected String paramString() {
        String string = super.paramString();
        return string + ",file=" + this.text.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        if (this.name == null && !this.nameExplicitlySet) {
            FileField fileField = this;
            synchronized (fileField) {
                if (this.name == null && !this.nameExplicitlySet) {
                    this.name = BASE + nameCounter++;
                }
            }
        }
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String string) {
        FileField fileField = this;
        synchronized (fileField) {
            super.setName(string);
            this.name = string;
            this.nameExplicitlySet = true;
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public Border getBorder() {
        return this.text.getBorder();
    }

    public void setBorder(Border border) {
        this.text.setBorder(border);
        this.button.setBorder(border);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getFile() {
        return this.text.getText();
    }

    public void setFile(String string) {
        this.text.setText(string);
    }

    public FilenameFilter getFilenameFilter() {
        return this.filter;
    }

    public void setFilenameFilter(FilenameFilter filenameFilter) {
        this.filter = filenameFilter;
    }
}

