/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt.tate;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import net.hizlab.kagetaka.awt.Border;
import net.hizlab.kagetaka.awt.GraphicsUtils;
import net.hizlab.kagetaka.awt.ImageCreator;
import net.hizlab.kagetaka.awt.Text;
import net.hizlab.kagetaka.awt.image.GrayFilter;
import net.hizlab.kagetaka.awt.image.SyncObserver;
import net.hizlab.kagetaka.awt.tate.CheckboxGroup;
import net.hizlab.kagetaka.awt.tate.Component;
import net.hizlab.kagetaka.rendering.Option;
import net.hizlab.kagetaka.util.Environment;

public class Checkbox
extends Component {
    private static final String BASE = "checkbox";
    private static int nameCounter = 0;
    private static final int INSET_H = 3;
    private static final int INSET_V = 3;
    private static final int INSET_S = 5;
    private static final int CHECK_WIDTH = 14;
    private static final int CHECK_HEIGHT = 14;
    private static final int[] CHECK_CHECK = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int RADIO_WIDTH = 12;
    private static final int RADIO_HEIGHT = 12;
    private static final int[] RADIO_FRAME1 = new int[]{0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] RADIO_FRAME2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] RADIO_FRAME3 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] RADIO_FRAME4 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0};
    private static final int[] RADIO_BACK = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] RADIO_CHECK = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private Color iconColor;
    private Image backImage;
    private String label;
    private Text text;
    private boolean state;
    CheckboxGroup group;
    private boolean resetText = true;

    public Checkbox(Option option, ImageCreator imageCreator) {
        this(option, imageCreator, null, false, null);
    }

    public Checkbox(Option option, ImageCreator imageCreator, String string) {
        this(option, imageCreator, string, false, null);
    }

    public Checkbox(Option option, ImageCreator imageCreator, String string, boolean bl) {
        this(option, imageCreator, string, bl, null);
    }

    public Checkbox(Option option, ImageCreator imageCreator, String string, boolean bl, CheckboxGroup checkboxGroup) {
        super(option, imageCreator);
        this.setLabel(string);
        this.setState(bl);
        this.setCheckboxGroup(checkboxGroup);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (!Checkbox.this.isEnabled()) {
                    return;
                }
                switch (keyEvent.getKeyCode()) {
                    case 32: {
                        keyEvent.consume();
                        Checkbox.this.setViewState(3);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void keyReleased(KeyEvent keyEvent) {
                if (!Checkbox.this.isEnabled()) {
                    return;
                }
                switch (keyEvent.getKeyCode()) {
                    case 32: {
                        keyEvent.consume();
                        if (Checkbox.this.getViewState() != 3) break;
                        Checkbox.this.setViewState(0);
                        if (!Checkbox.this.isEnabled()) break;
                        Checkbox checkbox = Checkbox.this;
                        synchronized (checkbox) {
                            Checkbox.this.setState(Checkbox.this.group == null ? !Checkbox.this.state : true);
                            break;
                        }
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!Checkbox.this.isEnabled()) {
                    return;
                }
                mouseEvent.consume();
                if ((mouseEvent.getModifiers() & 0x10) != 0) {
                    Checkbox checkbox = Checkbox.this;
                    synchronized (checkbox) {
                        Checkbox.this.setState(Checkbox.this.group == null ? !Checkbox.this.state : true);
                    }
                }
            }
        });
        if (Environment.javaVersion < 102) {
            this.setIconcolor(SystemColor.window);
        } else {
            this.setIconcolor(SystemColor.text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize() {
        Checkbox checkbox = this;
        synchronized (checkbox) {
            if (this.resetText) {
                this.resetText();
            }
        }
        return super.getPreferredSize();
    }

    protected String paramString() {
        String string = super.paramString();
        String string2 = this.label;
        if (string2 != null) {
            string = string + ",label=" + string2;
        }
        return string + ",state=" + this.state;
    }

    String constructComponentName() {
        return BASE + nameCounter++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh(Graphics graphics, Dimension dimension, int n, boolean bl) {
        Border border;
        int n2;
        Color color = this.getForeground();
        Color color2 = this.getBackground();
        Text text = null;
        boolean bl2 = true;
        boolean bl3 = false;
        Object object = this;
        synchronized (object) {
            if (this.resetText) {
                this.resetText();
            }
            text = this.text;
            bl2 = this.group == null;
            bl3 = this.state;
        }
        if (this.backImage != null) {
            object = new SyncObserver();
            Checkbox checkbox = object;
            synchronized (checkbox) {
                object.init(graphics, 0, 0, dimension.width, dimension.height);
                if (!graphics.drawImage(this.backImage, 0, 0, dimension.width, dimension.height, (ImageObserver)object)) {
                    try {
                        object.wait(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        System.out.println("wait to draw a backimage");
                    }
                }
            }
        }
        graphics.setColor(color2);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        if (bl2) {
            int n3 = (dimension.width - 14) / 2;
            n2 = text != null ? 3 : 1;
            graphics.setColor(SystemColor.controlShadow);
            graphics.drawLine(n3, n2, n3 + 14 - 2, n2);
            graphics.drawLine(n3, n2, n3, n2 + 14 - 2);
            graphics.setColor(SystemColor.controlDkShadow);
            graphics.drawLine(n3 + 1, n2 + 1, n3 + 14 - 3, n2 + 1);
            graphics.drawLine(n3 + 1, n2 + 1, n3 + 1, n2 + 14 - 3);
            graphics.setColor(SystemColor.controlHighlight);
            graphics.drawLine(n3 + 14 - 2, n2 + 1, n3 + 14 - 2, n2 + 14 - 2);
            graphics.drawLine(n3 + 1, n2 + 14 - 2, n3 + 14 - 2, n2 + 14 - 2);
            graphics.setColor(SystemColor.controlLtHighlight);
            graphics.drawLine(n3 + 14 - 1, n2, n3 + 14 - 1, n2 + 14 - 1);
            graphics.drawLine(n3, n2 + 14 - 1, n3 + 14 - 1, n2 + 14 - 1);
            graphics.setColor(n == 2 || n == 3 || n == 4 ? SystemColor.controlHighlight : this.iconColor);
            graphics.fillRect(n3 + 2, n2 + 2, 10, 10);
            if (bl3) {
                this.drawArray(graphics, CHECK_CHECK, new int[196], n3, n2, 14, 14, color);
            }
        } else {
            object = new int[144];
            n2 = (dimension.width - 12) / 2;
            int n4 = text != null ? 3 : 1;
            Object var13_21 = null;
            this.drawArray(graphics, RADIO_FRAME1, (int[])object, n2, n4, 12, 12, SystemColor.controlShadow);
            this.drawArray(graphics, RADIO_FRAME2, (int[])object, n2, n4, 12, 12, SystemColor.controlDkShadow);
            this.drawArray(graphics, RADIO_FRAME3, (int[])object, n2, n4, 12, 12, SystemColor.controlHighlight);
            this.drawArray(graphics, RADIO_FRAME4, (int[])object, n2, n4, 12, 12, SystemColor.controlLtHighlight);
            this.drawArray(graphics, RADIO_BACK, (int[])object, n2, n4, 12, 12, n == 2 || n == 3 || n == 4 ? SystemColor.controlHighlight : this.iconColor);
            if (bl3) {
                this.drawArray(graphics, RADIO_CHECK, (int[])object, n2, n4, 12, 12, color);
            }
        }
        if (text != null) {
            Color color3 = color;
            if (n == 4) {
                color3 = new Color(new GrayFilter(color2).filterRGB(0, 0, color3.getRGB()));
            }
            graphics.setColor(color3);
            graphics.setFont(this.getFont());
            text.draw(graphics, dimension.width - 3, 8 + (bl2 ? 14 : 12), 0);
        }
        if ((border = this.getBorder()) != null) {
            border.draw(graphics, 0, 0, dimension.width - 1, dimension.height - 1, color);
        }
        if (bl) {
            graphics.setColor(color);
            n2 = 0;
            int n5 = 0;
            if (bl2) {
                n2 = 16;
                n5 = 16;
            } else {
                n2 = 14;
                n5 = 14;
            }
            int n6 = (dimension.width - n2) / 2;
            int n7 = text != null ? 2 : 0;
            GraphicsUtils.drawDashed((Graphics)graphics, (int)n6, (int)n7, (int)n2, (int)1, (int)1, (int)1, (int)1);
            GraphicsUtils.drawDashed((Graphics)graphics, (int)n6, (int)n7, (int)1, (int)n5, (int)1, (int)1, (int)2);
            GraphicsUtils.drawDashed((Graphics)graphics, (int)n6, (int)(n7 + n5 - 1), (int)n2, (int)1, (int)1, (int)1, (int)1);
            GraphicsUtils.drawDashed((Graphics)graphics, (int)(n6 + n2 - 1), (int)n7, (int)1, (int)n5, (int)1, (int)1, (int)2);
            if (text != null) {
                n6 = 1;
                n7 = n5 - 2 + 3 + 5 - 2;
                n2 = dimension.width - 2;
                n5 = dimension.height - n7 - 1;
                GraphicsUtils.drawDashed((Graphics)graphics, (int)n6, (int)n7, (int)n2, (int)1, (int)1, (int)1, (int)1);
                GraphicsUtils.drawDashed((Graphics)graphics, (int)n6, (int)n7, (int)1, (int)n5, (int)1, (int)1, (int)2);
                GraphicsUtils.drawDashed((Graphics)graphics, (int)n6, (int)(n7 + n5 - 1), (int)n2, (int)1, (int)1, (int)1, (int)1);
                GraphicsUtils.drawDashed((Graphics)graphics, (int)(n6 + n2 - 1), (int)n7, (int)1, (int)n5, (int)1, (int)1, (int)2);
            }
        }
    }

    public Color getIconcolor() {
        return this.iconColor;
    }

    public synchronized void setIconcolor(Color color) {
        this.iconColor = color;
    }

    public synchronized void setBackground(Image image) {
        this.backImage = image;
    }

    public String getLabel() {
        return this.label;
    }

    public synchronized void setLabel(String string) {
        if (this.label == string || this.label != null && string != null && this.label.compareTo(string) == 0) {
            return;
        }
        this.label = string;
        this.text = null;
        this.resetText = true;
        if (this.isVisible()) {
            this.repaintForce();
        }
    }

    public boolean getState() {
        return this.state;
    }

    public synchronized void setState(boolean bl) {
        if (this.state == bl) {
            return;
        }
        CheckboxGroup checkboxGroup = this.group;
        if (checkboxGroup != null) {
            if (bl) {
                checkboxGroup.setSelectedCheckbox(this);
            } else if (checkboxGroup.getSelectedCheckbox() == this) {
                checkboxGroup.selectedCheckbox = null;
            }
        }
        this.setStateInternal(bl);
    }

    public CheckboxGroup getCheckboxGroup() {
        return this.group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCheckboxGroup(CheckboxGroup checkboxGroup) {
        CheckboxGroup checkboxGroup2 = null;
        boolean bl = false;
        Checkbox checkbox = this;
        synchronized (checkbox) {
            checkboxGroup2 = this.group;
            bl = this.state;
        }
        if (checkboxGroup2 != null && bl) {
            checkboxGroup2.setSelectedCheckbox(null);
        }
        checkbox = this;
        synchronized (checkbox) {
            this.group = checkboxGroup;
            if (this.state && checkboxGroup != null) {
                checkboxGroup.setSelectedCheckbox(this);
            }
        }
    }

    private void resetText() {
        this.resetText = false;
        this.text = null;
        int n = 0;
        int n2 = 0;
        if (this.group == null) {
            n = 14;
            n2 = 14;
        } else {
            n = 12;
            n2 = 12;
        }
        if (this.label != null) {
            try {
                this.text = this.getText(this.label);
                Dimension dimension = this.text.getSize(0);
                this.setPreferredSize(Math.max(n + 2, dimension.width + 6), n2 + dimension.height + 6 + 5);
            }
            catch (IllegalStateException illegalStateException) {}
        } else {
            this.setPreferredSize(n + 2, n2 + 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawArray(Graphics graphics, int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, Color color) {
        SyncObserver syncObserver;
        int n5 = color.getRGB() | 0xFF000000;
        int n6 = 0;
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = nArray[i] == 1 ? n5 : n6;
        }
        MemoryImageSource memoryImageSource = new MemoryImageSource(n3, n4, nArray2, 0, n3);
        memoryImageSource.setAnimated(false);
        Image image = this.getToolkit().createImage(memoryImageSource);
        SyncObserver syncObserver2 = syncObserver = new SyncObserver();
        synchronized (syncObserver2) {
            syncObserver.init(graphics, n, n2, n3, n4);
            if (!graphics.drawImage(image, n, n2, n3, n4, (ImageObserver)syncObserver)) {
                try {
                    syncObserver.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("wait to draw a icon");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setStateInternal(boolean bl) {
        Checkbox checkbox = this;
        synchronized (checkbox) {
            if (this.state == bl) {
                return;
            }
            this.state = bl;
        }
        this.repaintForce();
    }
}

