/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.util.Hashtable;
import java.util.Vector;
import net.hizlab.kagetaka.awt.FontData;
import net.hizlab.kagetaka.awt.ImageCreator;
import net.hizlab.kagetaka.awt.TextManager;
import net.hizlab.kagetaka.awt.image.SyncObserver;
import net.hizlab.kagetaka.util.CharList;

public class Text {
    private static final char TYPE_MASK = '\u00ff';
    private static final char TYPE_NONE = '1';
    private static final char TYPE_RIGHT = '2';
    private static final char TYPE_LTRB = '3';
    private static final char TYPE_BR = '5';
    private static final char KK_MASK = '\u0f00';
    private static final char KK_OK = '\u0000';
    private static final char KK_NG = '\u0100';
    private static final int MT_WAIT = 10000;
    private ImageCreator imageCreator;
    private Toolkit toolkit;
    private CharList charsSpinRight;
    private CharList charsSpinLtrb;
    private CharList charsKinsokuHead;
    private CharList charsKinsokuTail;
    private FontData fd;
    private Dimension fs;
    private FontMetrics fm;
    private int ff;
    private int fh;
    private int fx;
    private int fz;
    private StringBuffer values = new StringBuffer();
    private StringBuffer types = new StringBuffer();
    private StringBuffer widths = new StringBuffer();
    private StringBuffer heights = new StringBuffer();
    private int nowLength = 0;
    private int nowWidth = 0;
    private int nowHeight = 0;
    private boolean lastPending = false;
    private boolean lastHankakuEisu = false;
    private int p = -1;
    private boolean mastHeight = true;
    private SyncObserver syncObserver = new SyncObserver();
    private Hashtable cacheSize = new Hashtable();
    private Detail cacheZero = new Detail();
    private char c;
    private char s;
    private int i;
    private int w;
    private int h;
    private Detail detail;
    private char[] tateCs = new char[1];

    Text(TextManager textManager, FontData fontData, String string) {
        this.imageCreator = textManager.imageCreator;
        this.toolkit = this.imageCreator.getToolkit();
        this.charsSpinRight = textManager.charsSpinRight;
        this.charsSpinLtrb = textManager.charsSpinLtrb;
        this.charsKinsokuHead = textManager.charsKinsokuHead;
        this.charsKinsokuTail = textManager.charsKinsokuTail;
        this.fd = fontData;
        this.fs = fontData.getFullSize();
        this.fm = fontData.getFontMetrics();
        this.ff = fontData.getFullBase();
        this.fh = fontData.getHalfBase();
        this.fx = fontData.getHalfHeight();
        this.fz = fontData.getMaxHeight();
        this.append(string, 0, string.length());
        if (this.nowLength > 0) {
            this.newLine();
        }
    }

    private void append(String string, int n, int n2) {
        this.i = n;
        while (this.i < n2) {
            this.c = string.charAt(this.i);
            if (this.c == '\n') {
                this.commit();
                this.append(this.c, '5', false);
                this.newLine();
            } else if ('0' <= this.c && this.c <= '9' || 'A' <= this.c && this.c <= 'Z' || 'a' <= this.c && this.c <= 'z') {
                if (!this.lastHankakuEisu) {
                    this.commit();
                }
                this.append(this.c, '2', true);
                this.lastHankakuEisu = true;
            } else {
                this.lastHankakuEisu = false;
                this.s = (char)49;
                if (this.c <= '\u00ff' || '\uff61' <= this.c && this.c <= '\uff9f' || this.charsSpinRight.contains(this.c)) {
                    this.s = (char)50;
                } else if (this.charsSpinLtrb.contains(this.c)) {
                    this.s = (char)51;
                }
                if (this.charsKinsokuHead.contains(this.c)) {
                    this.append(this.c, this.s, true);
                } else if (this.charsKinsokuTail.contains(this.c)) {
                    this.commit();
                    this.append(this.c, this.s, false);
                } else {
                    this.commit();
                    this.append(this.c, this.s, true);
                }
            }
            ++this.i;
        }
    }

    private void append(char c, char c2, boolean bl) {
        if (bl) {
            if (this.lastPending) {
                this.types.setCharAt(this.p, (char)(this.types.charAt(this.p) | 0x100));
            } else {
                this.lastPending = true;
            }
        }
        this.w = this.calculateWidth(c, c2);
        this.h = this.calculateHeight(c, c2);
        this.values.append(c);
        this.types.append(c2);
        this.widths.append((char)this.w);
        this.heights.append((char)this.h);
        ++this.p;
        ++this.nowLength;
        this.nowWidth = Math.max(this.nowWidth, this.w);
        this.nowHeight += this.h;
    }

    private void commit() {
        if (this.lastPending) {
            this.lastPending = false;
        }
    }

    private int calculateWidth(char c, char c2) {
        switch (c2) {
            case '2': 
            case '3': {
                return c <= '\u00ff' || '\uff61' <= c && c <= '\uff9f' ? this.fx : this.fs.width;
            }
        }
        return this.fm.charWidth(c);
    }

    private int calculateHeight(char c, char c2) {
        switch (c2) {
            case '2': 
            case '3': {
                return this.fm.charWidth(c);
            }
        }
        return this.fs.height;
    }

    private void newLine() {
        this.cacheZero.addLine(this.nowLength, this.nowWidth, this.nowHeight);
        this.nowLength = 0;
        this.nowWidth = 0;
        this.nowHeight = 0;
    }

    public Dimension getSize(int n) {
        return new Dimension(this.getDatail(n).size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Detail getDatail(int n) {
        if (n <= 0) {
            return this.cacheZero;
        }
        Hashtable hashtable = this.cacheSize;
        synchronized (hashtable) {
            Integer n2 = new Integer(n);
            this.detail = (Detail)this.cacheSize.get(n2);
            if (this.detail != null) {
                return this.detail;
            }
            this.detail = new Detail();
            this.cacheSize.put(n2, this.detail);
            char c = '\u0000';
            char c2 = '\u0000';
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            this.i = 0;
            while (this.i <= this.p) {
                this.s = this.types.charAt(this.i);
                c = this.widths.charAt(this.i);
                c2 = this.heights.charAt(this.i);
                if (this.mastHeight && n8 + n5 + c2 > n) {
                    if (n6 > 0) {
                        this.detail.addLine(n6, n7, n8);
                        n8 = 0;
                        n7 = 0;
                        n6 = 0;
                    }
                    if (n5 + c2 > n) {
                        this.detail.addLine(n3, n4, n5);
                        n5 = 0;
                        n4 = 0;
                        n3 = 0;
                    }
                }
                if ((this.s & 0xF00) == 256) {
                    ++n3;
                    n4 = Math.max(n4, c);
                    n5 += c2;
                } else {
                    if (n3 > 0) {
                        ++n3;
                        n4 = Math.max(n4, c);
                        if (!this.mastHeight && n8 + (n5 += c2) > n) {
                            if (n6 > 0) {
                                this.detail.addLine(n6, n7, n8);
                            }
                            n6 = n3;
                            n7 = n4;
                            n8 = n5;
                        } else {
                            n6 += n3;
                            n7 = Math.max(n7, n4);
                            n8 += n5;
                        }
                        n5 = 0;
                        n4 = 0;
                        n3 = 0;
                    } else if (!this.mastHeight && n8 + c2 > n) {
                        if (n6 > 0) {
                            this.detail.addLine(n6, n7, n8);
                        }
                        n6 = 1;
                        n7 = c;
                        n8 = c2;
                    } else {
                        ++n6;
                        n7 = Math.max(n7, c);
                        n8 += c2;
                    }
                    if (this.s == '5') {
                        this.detail.addLine(n6, n7, n8);
                        n8 = 0;
                        n7 = 0;
                        n6 = 0;
                    }
                }
                ++this.i;
            }
            if (n6 > 0) {
                this.detail.addLine(n6, n7, n8);
            }
            return this.detail;
        }
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        this.detail = this.getDatail(n3);
        int n4 = n;
        int n5 = n2;
        int n6 = 0;
        Line line = null;
        int n7 = -1;
        int n8 = 0;
        this.i = 0;
        while (this.i <= this.p) {
            if (n8 == 0) {
                if (n <= 0) break;
                line = (Line)this.detail.lines.elementAt(++n7);
                n8 = line.length;
                n -= line.width;
                n2 = n5;
            }
            this.s = (char)(this.types.charAt(this.i) & 0xFF);
            this.w = this.widths.charAt(this.i);
            this.h = this.heights.charAt(this.i);
            switch (this.s) {
                case '1': {
                    this.tateCs[0] = this.values.charAt(this.i);
                    graphics.drawChars(this.tateCs, 0, 1, this.fs.width > this.w ? n + (this.fs.width - this.w) / 2 : n, n2 + this.ff);
                    n2 += this.h;
                    --n8;
                    ++this.i;
                    break;
                }
                case '2': 
                case '3': {
                    n6 = this.i;
                    while (true) {
                        ++this.i;
                        if (--n8 == 0 || (this.types.charAt(this.i) & 0xFF) != this.s) break;
                        this.w = Math.max(this.w, this.widths.charAt(this.i));
                        this.h += this.heights.charAt(this.i);
                    }
                    this.drawTextWithSpin(graphics, n6, this.i, n, n2, this.w, this.h, this.s);
                    n2 += this.h;
                    break;
                }
                case '5': {
                    --n8;
                    ++this.i;
                }
            }
        }
    }

    private void drawTextWithSpin(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, char c) {
        if (n6 == 0) {
            return;
        }
        Color color = Color.white;
        Color color2 = Color.black;
        Image image = null;
        Graphics graphics2 = null;
        try {
            image = this.imageCreator.createImage(n6, n5);
            graphics2 = image.getGraphics();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("e=[" + this.values + "],[" + n + "],[" + n2 + "],[" + n6 + "],[" + n5 + "]");
            return;
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            System.out.println("e=[" + this.values + "],[" + n + "],[" + n2 + "],[" + n6 + "],[" + n5 + "]");
            return;
        }
        graphics2.setColor(color);
        graphics2.fillRect(0, 0, n6, n5);
        graphics2.setColor(color2);
        graphics2.setFont(this.fd.getFont());
        int n7 = 0;
        if (c == '3') {
            n7 = this.ff + (this.fs.height - this.ff) / 2;
        }
        int n8 = 0;
        for (int i = n; i < n2; ++i) {
            char c2;
            this.tateCs[0] = c2 = this.values.charAt(i);
            if (c == '2') {
                n7 = c2 <= '\u00ff' || '\uff61' <= c2 && c2 <= '\uff9f' ? this.fh : this.ff;
            }
            graphics2.drawChars(this.tateCs, 0, 1, n8, n7);
            n8 += this.heights.charAt(i);
        }
        graphics2.dispose();
        int[] nArray = new int[n5 * n6];
        int[] nArray2 = new int[n5 * n6];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n6, n5, nArray, 0, n6);
        try {
            pixelGrabber.grabPixels(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        switch (c) {
            case '2': {
                int n9;
                for (n8 = 0; n8 < n6; ++n8) {
                    for (n9 = 0; n9 < n5; ++n9) {
                        nArray2[n8 * n5 + n9] = nArray[n8 + (n5 - n9 - 1) * n6];
                    }
                }
                break;
            }
            case '3': {
                int n9;
                for (n8 = 0; n8 < n6; ++n8) {
                    for (n9 = 0; n9 < n5; ++n9) {
                        nArray2[n8 * n5 + n9] = nArray[n8 + n9 * n6];
                    }
                }
                break;
            }
        }
        int n10 = color.getRGB();
        int n11 = graphics.getColor().getRGB() | 0xFF000000;
        for (int i = 0; i < nArray2.length; ++i) {
            if (nArray2[i] == n10) {
                int n12 = i;
                nArray2[n12] = nArray2[n12] & 0xFFFFFF;
                continue;
            }
            nArray2[i] = n11;
        }
        MemoryImageSource memoryImageSource = new MemoryImageSource(n5, n6, nArray2, 0, n5);
        memoryImageSource.setAnimated(false);
        Image image2 = this.toolkit.createImage(memoryImageSource);
        this.drawImageSync(graphics, image2, n3, n4, n5, n6);
        image.flush();
        image2.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawImageSync(Graphics graphics, Image image, int n, int n2, int n3, int n4) {
        SyncObserver syncObserver = this.syncObserver;
        synchronized (syncObserver) {
            this.syncObserver.init(graphics, n, n2, n3, n4);
            if (!graphics.drawImage(image, n, n2, n3, n4, (ImageObserver)this.syncObserver)) {
                try {
                    this.syncObserver.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("wait to draw a text");
                }
            }
        }
    }

    public void dispose() {
    }

    private class Line {
        private int length;
        private int width;
        private int height;

        private Line(int n, int n2, int n3) {
            this.length = n;
            this.width = n2;
            this.height = n3;
        }
    }

    private class Detail {
        private Dimension size = new Dimension();
        private Vector lines = new Vector();

        private Detail() {
        }

        private void addLine(int n, int n2, int n3) {
            n2 = Math.max(n2, Text.this.fz);
            this.lines.addElement(new Line(n, n2, n3));
            this.size.width += n2;
            this.size.height = Math.max(this.size.height, n3);
        }
    }
}

