/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.awt;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.SystemColor;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import net.hizlab.kagetaka.awt.AWTEventMulticaster;
import net.hizlab.kagetaka.awt.FontData;
import net.hizlab.kagetaka.awt.ImageCreator;
import net.hizlab.kagetaka.awt.ImageCreatorComponent;
import net.hizlab.kagetaka.awt.ImageUtils;
import net.hizlab.kagetaka.awt.SizedComponent;
import net.hizlab.kagetaka.awt.event.StateEvent;
import net.hizlab.kagetaka.awt.event.StateListener;
import net.hizlab.kagetaka.awt.image.GrayFilter;
import net.hizlab.kagetaka.awt.image.OffscreenObserver;

public class ImageButton
extends SizedComponent {
    private static final Font DEFAULT_FONT = Font.decode("Dialog-plain-12");
    private static final int LABEL_RIGHT = 3;
    public static final int NORMAL = 0;
    public static final int OVER = 1;
    public static final int DOWN = 2;
    public static final int DISABLE = 3;
    public static final int HOTSPOT_OVER = 4;
    public static final int HOTSPOT_DOWN = 5;
    private Image backImage;
    private Dimension backImageSize;
    private ImageCreatorComponent icc = new ImageCreatorComponent((Component)this);
    private int state;
    private int stateEnable;
    private int stateDown;
    private int statePaint = -1;
    private Object stateLock = new Object();
    private int pressX = -1;
    private int pressY = -1;
    private Polygon hotspot;
    private boolean isSeparate;
    private Image base;
    private Image over;
    private Image down;
    private Image disable;
    private Polygon sarea;
    private Image sover;
    private Image sdown;
    private Image sdisable;
    private String label;
    private Dimension labelSize;
    private Dimension baseSize;
    private Dimension spotSize;
    private Image offScreen;
    private Graphics og;
    private Object ogLock = new Object();
    private OffscreenObserver oob;
    private OffscreenObserver oos;
    private transient StateListener stateListener;

    public ImageButton(Image image) {
        this(null, true, image, null, null, null, null, null, null, null);
    }

    public ImageButton(String string, Image image) {
        this(string, true, image, null, null, null, null, null, null, null);
    }

    public ImageButton(Image image, Image image2) {
        this(null, true, image, null, null, null, image2, null, null, null);
    }

    public ImageButton(String string, Image image, Image image2) {
        this(string, true, image, null, null, null, image2, null, null, null);
    }

    public ImageButton(boolean bl, Image image, Image image2, Image image3, Image image4, Image image5, Image image6, Image image7, Polygon polygon) {
        this(null, bl, image, image3, image2, image4, image5, image6, image7, polygon);
    }

    public ImageButton(String string, boolean bl, Image image, Image image2, Image image3, Image image4, Image image5, Image image6, Image image7, Polygon polygon) {
        this.setImageImpl(bl, image, image3, image2, image4, image5, image6, image7, polygon);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiers() & 0x10) == 0) {
                    return;
                }
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                if (n < 0 || n2 < 0 || n >= ImageButton.this.size.width || n2 > ImageButton.this.size.height) {
                    return;
                }
                if (ImageButton.this.hotspot != null && ImageButton.this.hotspot.contains(n, n2)) {
                    ImageButton.this.changeState(5);
                } else {
                    ImageButton.this.changeState(2);
                }
                ImageButton.this.pressX = mouseEvent.getX();
                ImageButton.this.pressY = mouseEvent.getY();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiers() & 0x10) == 0) {
                    return;
                }
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                if (n < 0 || n2 < 0 || n >= ImageButton.this.size.width || n2 > ImageButton.this.size.height) {
                    ImageButton.this.changeState(0);
                } else if (ImageButton.this.hotspot != null && ImageButton.this.hotspot.contains(mouseEvent.getX(), mouseEvent.getY())) {
                    ImageButton.this.changeState(4);
                } else {
                    ImageButton.this.changeState(1);
                }
                if (mouseEvent.getClickCount() > 0 && n >= 0 && n2 >= 0 && n < ImageButton.this.size.width && n2 < ImageButton.this.size.height && (n != ImageButton.this.pressX || n2 != ImageButton.this.pressY)) {
                    ImageButton.this.getToolkit().getSystemEventQueue().postEvent(new MouseEvent(mouseEvent.getComponent(), 500, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                if (ImageButton.this.hotspot != null && ImageButton.this.hotspot.contains(mouseEvent.getX(), mouseEvent.getY())) {
                    ImageButton.this.changeState(4);
                } else {
                    ImageButton.this.changeState(1);
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                ImageButton.this.changeState(0);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                if (ImageButton.this.state == 0) {
                    return;
                }
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                if (n < 0 || n2 < 0 || n >= ImageButton.this.size.width || n2 > ImageButton.this.size.height) {
                    return;
                }
                ImageButton.this.changeState(ImageButton.this.stateDown);
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                if (ImageButton.this.hotspot == null) {
                    return;
                }
                if (ImageButton.this.hotspot.contains(mouseEvent.getX(), mouseEvent.getY())) {
                    ImageButton.this.changeState(4);
                } else {
                    ImageButton.this.changeState(1);
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void componentResized(ComponentEvent componentEvent) {
                Object object = ImageButton.this.ogLock;
                synchronized (object) {
                    if (ImageButton.this.offScreen != null) {
                        if (ImageButton.this.oob != null) {
                            ImageButton.this.oob.dispose();
                            ImageButton.this.oob = null;
                        }
                        if (ImageButton.this.oos != null) {
                            ImageButton.this.oos.dispose();
                            ImageButton.this.oos = null;
                        }
                        ImageButton.this.og.dispose();
                        ImageButton.this.offScreen.flush();
                    }
                    Dimension dimension = ImageButton.this.getSize();
                    if (dimension.width == 0 || dimension.height == 0) {
                        ImageButton.this.offScreen = null;
                        ImageButton.this.og = null;
                    } else {
                        ImageButton.this.offScreen = ImageButton.this.createImage(dimension.width, dimension.height);
                        ImageButton.this.og = ImageButton.this.offScreen.getGraphics();
                        ImageButton.this.repaint();
                    }
                    if (ImageButton.this.hotspot != null && (dimension.width > ImageButton.this.size.width || dimension.height > ImageButton.this.size.height)) {
                        ImageButton.this.calculateHotspot();
                    }
                }
            }
        });
        this.setFont(DEFAULT_FONT);
        this.setForeground(SystemColor.controlText);
        this.setBackground(SystemColor.control);
        this.setLabel(string);
    }

    public boolean isSeparate() {
        return this.isSeparate;
    }

    public boolean hasHotspot() {
        return this.hotspot != null;
    }

    public String getLabel() {
        return this.label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLabel(String string) {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isSeparate) {
                return;
            }
            if (this.label == string || this.label != null && string != null && this.label.compareTo(string) == 0) {
                return;
            }
            this.label = string;
            this.labelSize = null;
            if (string != null) {
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                this.labelSize = new Dimension(fontMetrics.stringWidth(string) + 3, fontMetrics.getHeight());
            }
            this.calculateSize();
        }
    }

    public void setImage(Image image) {
        this.setImageImpl(true, image, null, null, null, null, null, null, null);
    }

    public void setImage(Image image, Image image2) {
        this.setImageImpl(true, image, null, null, null, image2, null, null, null);
    }

    public void setImage(boolean bl, Image image, Image image2, Image image3, Image image4, Image image5, Image image6, Image image7, Polygon polygon) {
        this.setImageImpl(bl, image, image2, image3, image4, image5, image6, image7, polygon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setImageImpl(boolean bl, Image image, Image image2, Image image3, Image image4, Image image5, Image image6, Image image7, Polygon polygon) {
        Object object = this.stateLock;
        synchronized (object) {
            if (image != null && !ImageUtils.load((Image)image, (Component)this)) {
                image = null;
            }
            if (image3 != null && !ImageUtils.load((Image)image3, (Component)this)) {
                image3 = null;
            }
            if (image2 != null && !ImageUtils.load((Image)image2, (Component)this)) {
                image2 = null;
            }
            if (image4 != null && !ImageUtils.load((Image)image4, (Component)this)) {
                image4 = null;
            }
            if (image5 != null && !ImageUtils.load((Image)image5, (Component)this)) {
                image5 = null;
            }
            if (image6 != null && !ImageUtils.load((Image)image6, (Component)this)) {
                image6 = null;
            }
            if (image7 != null && !ImageUtils.load((Image)image7, (Component)this)) {
                image7 = null;
            }
            this.isSeparate = bl;
            this.base = image;
            this.over = image2;
            this.down = image3;
            this.disable = image4;
            this.sover = image5;
            this.sdown = image6;
            this.sdisable = image7;
            this.sarea = polygon;
            this.baseSize = new Dimension(0, 0);
            this.spotSize = null;
            if (image != null) {
                this.baseSize.width = image.getWidth(this);
                this.baseSize.height = image.getHeight(this);
                if (this.isSeparate) {
                    this.baseSize.width += 3;
                    this.baseSize.height += 3;
                }
            }
            if (this.isSeparate && image5 != null) {
                this.spotSize = new Dimension(image5.getWidth(this) + 3, image5.getHeight(this) + 3);
            }
            if (!this.isSeparate) {
                this.label = null;
                this.labelSize = null;
            }
            this.calculateSize();
            this.repaint();
        }
    }

    private void calculateSize() {
        Dimension dimension = new Dimension(this.baseSize.width, this.baseSize.height);
        if (this.spotSize != null) {
            dimension.width += this.spotSize.width;
            dimension.height = Math.max(dimension.height, this.spotSize.height);
        }
        if (this.labelSize != null) {
            dimension.width += this.labelSize.width;
            dimension.height = Math.max(dimension.height, this.labelSize.height);
        }
        this.calculateHotspot();
        if (!this.size.equals(dimension)) {
            this.size = dimension;
            this.invalidate();
        }
    }

    private void calculateHotspot() {
        if (this.sover == null) {
            return;
        }
        Dimension dimension = this.getSize();
        if (this.sarea != null) {
            int n;
            int n2 = (dimension.width - this.size.width) / 2;
            if (this.isSeparate) {
                n = (dimension.height - this.spotSize.height) / 2;
                n2 += this.baseSize.width;
                if (this.labelSize != null) {
                    n2 += this.labelSize.width;
                }
            } else {
                n = (dimension.height - this.size.height) / 2;
            }
            if (n2 == 0 && n == 0) {
                this.hotspot = this.sarea;
            } else {
                int n3 = this.sarea.npoints;
                int[] nArray = new int[n3];
                int[] nArray2 = new int[n3];
                System.arraycopy(this.sarea.xpoints, 0, nArray, 0, n3);
                System.arraycopy(this.sarea.ypoints, 0, nArray2, 0, n3);
                int n4 = 0;
                while (n4 < n3) {
                    int n5 = n4;
                    nArray[n5] = nArray[n5] + n2;
                    int n6 = n4++;
                    nArray2[n6] = nArray2[n6] + n;
                }
                this.hotspot = new Polygon(nArray, nArray2, n3);
            }
        } else {
            int n = this.baseSize.width + (dimension.width - this.size.width) / 2;
            if (this.labelSize != null) {
                n += this.labelSize.width;
            }
            this.hotspot = new Polygon(new int[]{n, n + this.spotSize.width, n + this.spotSize.width, n}, new int[]{0, 0, dimension.height, dimension.height}, 4);
        }
    }

    public Polygon getHotspotArea() {
        return this.hotspot;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        Object object = this.ogLock;
        synchronized (object) {
            Object object2 = this.stateLock;
            synchronized (object2) {
                if (this.state != this.statePaint) {
                    this.refresh();
                }
            }
            if (this.offScreen != null) {
                graphics.drawImage(this.offScreen, 0, 0, this);
            }
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.changeState(bl ? this.stateEnable : 3);
    }

    protected String paramString() {
        String string = super.paramString();
        return string + ",state=" + this.state;
    }

    public synchronized void addStateListener(StateListener stateListener) {
        this.enableEvents(0L);
        this.stateListener = AWTEventMulticaster.add(this.stateListener, stateListener);
    }

    public synchronized void removeStateListener(StateListener stateListener) {
        this.stateListener = AWTEventMulticaster.remove(this.stateListener, stateListener);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof StateEvent) {
            this.processStateEvent((StateEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processStateEvent(StateEvent stateEvent) {
        if (this.stateListener == null) {
            return;
        }
        switch (stateEvent.getID()) {
            case 3010: {
                this.stateListener.stateChanged(stateEvent);
            }
        }
    }

    private void postStateEvent(int n) {
        StateEvent stateEvent = new StateEvent(this, 3010, n);
        try {
            this.getToolkit().getSystemEventQueue().postEvent(stateEvent);
        }
        catch (SecurityException securityException) {
            this.processStateEvent(stateEvent);
        }
    }

    public void setBackImage(Image image) {
        this.backImage = image;
        if (image != null && !ImageUtils.load((Image)image, (Component)this)) {
            image = null;
        }
        if (image != null) {
            this.backImageSize = new Dimension(image.getWidth(this), image.getHeight(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        Object object = this.ogLock;
        synchronized (object) {
            int n;
            if (this.offScreen == null) {
                return;
            }
            if (this.oob != null) {
                this.oob.dispose();
                this.oob = null;
            }
            if (this.oos != null) {
                this.oos.dispose();
                this.oos = null;
            }
            Dimension dimension = this.getSize();
            Point point = new Point((dimension.width - this.size.width) / 2, 0);
            Color color = this.getBackground();
            this.og.setColor(color);
            this.og.fillRect(0, 0, dimension.width, dimension.height);
            if (this.backImage != null) {
                int n2 = 0;
                int n3 = 0;
                for (n2 = 0; n2 < dimension.width; n2 += this.backImageSize.width) {
                    for (n3 = 0; n3 < dimension.height; n3 += this.backImageSize.height) {
                        this.og.drawImage(this.backImage, n2, n3, this);
                    }
                }
            }
            Image image = null;
            Image image2 = null;
            if (this.isSeparate) {
                n = this.baseSize.width + (this.labelSize != null ? this.labelSize.width : 0);
                switch (this.state) {
                    case 0: {
                        ++point.x;
                        ++point.y;
                        image = this.base;
                        image2 = this.sover;
                        break;
                    }
                    case 1: 
                    case 4: {
                        this.og.setColor(color.brighter());
                        this.og.drawLine(point.x, point.y, point.x + dimension.width - 2, point.y);
                        this.og.drawLine(point.x, point.y, point.x, point.y + dimension.height - 2);
                        if (this.hotspot != null) {
                            this.og.drawLine(point.x + n, point.y, point.x + n, point.y + dimension.height - 2);
                        }
                        this.og.setColor(color.darker());
                        this.og.drawLine(point.x, point.y + dimension.height - 1, point.x + dimension.width - 1, point.y + dimension.height - 1);
                        this.og.drawLine(point.x + dimension.width - 1, point.y, point.x + dimension.width - 1, point.y + dimension.height - 1);
                        if (this.hotspot != null) {
                            this.og.drawLine(point.x + n - 1, point.y, point.x + n - 1, point.y + dimension.height - 1);
                        }
                        ++point.x;
                        ++point.y;
                        image = this.over != null ? this.over : this.base;
                        image2 = this.sover;
                        break;
                    }
                    case 2: {
                        this.og.setColor(color.darker());
                        this.og.drawLine(point.x, point.y, point.x + dimension.width - 1, point.y);
                        this.og.drawLine(point.x, point.y, point.x, point.y + dimension.height - 1);
                        if (this.hotspot != null) {
                            this.og.drawLine(point.x + n, point.y, point.x + n, point.y + dimension.height - 2);
                        }
                        this.og.setColor(color.brighter());
                        this.og.drawLine(point.x + 1, point.y + dimension.height - 1, point.x + dimension.width - 1, point.y + dimension.height - 1);
                        this.og.drawLine(point.x + dimension.width - 1, point.y + 1, point.x + dimension.width - 1, point.y + dimension.height - 1);
                        if (this.hotspot != null) {
                            this.og.drawLine(point.x + n - 1, point.y, point.x + n - 1, point.y + dimension.height - 1);
                        }
                        point.x += 2;
                        point.y += 2;
                        image = this.down != null ? this.down : this.base;
                        image2 = this.sdown != null ? this.sdown : this.sover;
                        break;
                    }
                    case 3: {
                        if (this.disable == null) {
                            this.disable = this.getDisableImage(this.base);
                        }
                        if (this.hotspot != null && this.sdisable == null) {
                            this.sdisable = this.getDisableImage(this.sover);
                        }
                        ++point.x;
                        ++point.y;
                        image = this.disable;
                        image2 = this.sdisable;
                        break;
                    }
                    case 5: {
                        this.og.setColor(color.brighter());
                        this.og.drawLine(point.x, point.y, point.x + n - 2, point.y);
                        this.og.drawLine(point.x, point.y, point.x, point.y + dimension.height - 2);
                        this.og.drawLine(point.x + dimension.width - 1, point.y, point.x + dimension.width - 1, point.y + dimension.height - 1);
                        this.og.drawLine(point.x + n, point.y + dimension.height - 1, point.x + dimension.width - 2, point.y + dimension.height - 1);
                        this.og.setColor(color.darker());
                        this.og.drawLine(point.x, point.y + dimension.height - 1, point.x + n - 1, point.y + dimension.height - 1);
                        this.og.drawLine(point.x + n - 1, point.y, point.x + n - 1, point.y + dimension.height - 2);
                        this.og.drawLine(point.x + n, point.y, point.x + dimension.width - 2, point.y);
                        this.og.drawLine(point.x + n, point.y, point.x + n, point.y + dimension.height - 2);
                        ++point.x;
                        ++point.y;
                        image = this.base;
                        image2 = this.sdown != null ? this.sdown : this.sover;
                    }
                }
            } else {
                switch (this.state) {
                    case 0: {
                        image = this.base;
                        break;
                    }
                    case 1: {
                        image = this.over;
                        break;
                    }
                    case 2: {
                        image = this.down;
                        break;
                    }
                    case 3: {
                        if (this.disable == null) {
                            this.disable = this.getDisableImage(this.base);
                        }
                        image = this.disable;
                        break;
                    }
                    case 4: {
                        image = this.sover;
                        break;
                    }
                    case 5: {
                        image = this.sdown;
                    }
                }
            }
            if (image != null) {
                n = (dimension.height - this.baseSize.height) / 2;
                this.oob = new OffscreenObserver((Component)this, this.og, point.x, point.y + n, null);
                this.og.drawImage(image, point.x, point.y + n, (ImageObserver)this.oob);
                point.x += this.baseSize.width;
            }
            if (this.label != null) {
                Font font = this.getFont();
                this.og.setFont(font);
                Color color2 = this.getForeground();
                if (this.state == 3) {
                    color2 = new Color(new GrayFilter(this.getBackground()).filterRGB(0, 0, color2.getRGB()));
                }
                this.og.setColor(color2);
                FontData fontData = FontData.getInstance((ImageCreator)this.icc, (Font)font);
                FontMetrics fontMetrics = fontData.getFontMetrics();
                n = (int)((double)(dimension.height - fontData.getFullSize().height - 3) / 2.0 + 0.5);
                int n4 = fontData.getHalfBase() + n + point.y;
                int n5 = fontData.getFullBase() + n + point.y;
                char[] cArray = new char[1];
                for (int i = 0; i < this.label.length(); ++i) {
                    char c;
                    cArray[0] = c = this.label.charAt(i);
                    int n6 = fontMetrics.charWidth(c);
                    this.og.drawChars(cArray, 0, 1, point.x, c <= '\u00ff' || '\uff61' <= c && c <= '\uff9f' ? n4 : n5);
                    point.x += n6;
                }
                point.x += 3;
            }
            if (image2 != null) {
                if (this.state == 5) {
                    ++point.x;
                    ++point.y;
                }
                n = (dimension.height - this.spotSize.height) / 2;
                this.oos = new OffscreenObserver((Component)this, this.og, point.x, point.y + n, null);
                this.og.drawImage(image2, point.x, point.y + n, (ImageObserver)this.oos);
            }
            this.statePaint = this.state;
        }
    }

    private Image getDisableImage(Image image) {
        return this.createImage(new FilteredImageSource(image.getSource(), new GrayFilter(this.getBackground())));
    }

    public int getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeState(int n) {
        Object object = this.stateLock;
        synchronized (object) {
            if (n != 3) {
                this.stateEnable = n;
            }
            if (!this.isEnabled()) {
                n = 3;
            }
            if (this.state != n) {
                this.state = n;
                switch (this.state) {
                    case 2: 
                    case 5: {
                        this.stateDown = this.state;
                    }
                }
                if (this.isVisible()) {
                    Graphics graphics = this.getGraphics();
                    if (graphics != null) {
                        try {
                            this.update(graphics);
                        }
                        finally {
                            graphics.dispose();
                        }
                    } else {
                        this.repaint();
                    }
                }
                this.postStateEvent(n);
            }
        }
    }
}

