/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.style;

import java.io.IOException;
import java.io.InputStream;
import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.style.CSSParser;
import net.hizlab.kagetaka.style.Selector;
import net.hizlab.kagetaka.style.Style;
import net.hizlab.kagetaka.token.StartToken;
import net.hizlab.kagetaka.token.TokenTypes;

public class StyleManager
extends net.hizlab.kagetaka.token.StyleManager {
    private Reporter reporter;
    private Style top = null;
    private Style last = null;

    public StyleManager(Reporter reporter) {
        this.reporter = reporter;
    }

    public void addStyle(InputStream inputStream, String string) throws IOException {
        this.addStyle(new CSSParser(this.reporter, inputStream, string));
    }

    public void addStyle(String string) {
        try {
            this.addStyle(new CSSParser(this.reporter, string));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addStyle(CSSParser cSSParser) throws IOException {
        Style style = null;
        while ((style = cSSParser.next()) != null) {
            this.addStyle(style);
        }
        cSSParser.close();
    }

    private void addStyle(Style style) {
        if (this.top == null) {
            this.top = this.last = style;
        } else {
            this.last = this.last.next = style;
        }
    }

    public void changeStatus(Document document, StartToken startToken, Status status) {
        if (this.top == null) {
            return;
        }
        boolean bl = TokenTypes.isBlockEx(startToken.getType());
        Style style = this.top;
        Selector selector = null;
        int n = document.media;
        do {
            if (style.isPage() || (style.getMedia() & n) == 0 || (selector = style.getSelector()) != null && !selector.isMatch(startToken)) continue;
            style.changeStatus(document, bl, status);
        } while ((style = style.next) != null);
    }
}

