/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.style;

import java.text.ParseException;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.token.Attribute;
import net.hizlab.kagetaka.token.StartToken;
import net.hizlab.kagetaka.token.TokenTypes;

public class Selector {
    private Operator operator = null;
    private Operator lastOperator = null;

    public Selector(String string) throws ParseException {
        if (string == null) {
            return;
        }
        int n = string.length();
        if (n == 0) {
            return;
        }
        int n2 = 0;
        char c = string.charAt(0);
        while (c == ' ') {
            if (++n2 >= n) {
                return;
            }
            c = string.charAt(n2);
        }
        Operator operator = new Operator(null);
        char c2 = '\u0000';
        int n3 = 0;
        block22: for (n2 = 0; n2 <= n; ++n2) {
            c = n2 < n ? (char)string.charAt(n2) : (char)' ';
            switch (c) {
                case ' ': 
                case '#': 
                case '+': 
                case ',': 
                case '.': 
                case ':': 
                case '>': 
                case '[': {
                    switch (c2) {
                        case '\u0000': {
                            if (n3 == n2) {
                                operator.targetType = -20;
                                break;
                            }
                            String string2 = string.substring(n3, n2);
                            if (string2.compareTo("*") == 0) {
                                operator.targetType = -20;
                                break;
                            }
                            if ((operator.targetType = TokenTypes.getType(string2 + "_START")) != -1) break;
                            throw new ParseException(Resource.getMessage("selector.error.unknowntarget", new String[]{string2}), n2);
                        }
                        case '[': {
                            operator.addAttribute(null, null, 0);
                            break;
                        }
                        case '.': {
                            operator.addClass(string.substring(n3, n2));
                            break;
                        }
                        case '#': {
                            operator.addId(string.substring(n3, n2));
                            break;
                        }
                        case ':': {
                            String string2 = string.substring(n3, n2);
                            if (string2.compareTo("first-child") == 0) {
                                operator.pseudoClasses |= 1;
                                break;
                            }
                            if (string2.compareTo("link") == 0) {
                                operator.pseudoClasses |= 2;
                                break;
                            }
                            if (string2.compareTo("visited") == 0) {
                                operator.pseudoClasses |= 4;
                                break;
                            }
                            if (string2.compareTo("hover") == 0) {
                                operator.pseudoClasses |= 8;
                                break;
                            }
                            if (string2.compareTo("active") == 0) {
                                operator.pseudoClasses |= 16;
                                break;
                            }
                            if (string2.compareTo("focus") == 0) {
                                operator.pseudoClasses |= 32;
                                break;
                            }
                            if (string2.startsWith("lang(") && string2.endsWith(")")) {
                                operator.pseudoClasses |= 64;
                                operator.pseudoLang = string2.substring(5, string2.length() - 1);
                                break;
                            }
                            if (string2.compareTo("first-line") == 0) {
                                operator.pseudoElements |= 1;
                                break;
                            }
                            if (string2.compareTo("first-letter") == 0) {
                                operator.pseudoElements |= 2;
                                break;
                            }
                            if (string2.compareTo("before") == 0) {
                                operator.pseudoElements |= 4;
                                break;
                            }
                            if (string2.compareTo("after") == 0) {
                                operator.pseudoElements |= 8;
                                break;
                            }
                            throw new ParseException(Resource.getMessage("selector.error.invalidpseudo", new String[]{string, string2}), n2);
                        }
                    }
                    c2 = c;
                    n3 = n2 + 1;
                    block10 : switch (c) {
                        case '#': 
                        case '.': 
                        case ':': 
                        case '[': {
                            break;
                        }
                        default: {
                            while (c == ' ') {
                                if (++n2 >= n) break block22;
                                c = string.charAt(n2);
                            }
                            c2 = c;
                            switch (c2) {
                                case '+': 
                                case ',': 
                                case '>': {
                                    do {
                                        if (++n2 < n) continue;
                                        throw new ParseException(Resource.getMessage("selector.error.nosimpleselector", new String[]{string, String.valueOf(c2)}), n2);
                                    } while ((c = (char)string.charAt(n2)) == 32);
                                }
                            }
                            switch (c2) {
                                case ',': {
                                    this.lastOperator = this.operator == null ? (this.operator = operator) : (this.lastOperator.nextOperator = operator);
                                    operator = new Operator(null);
                                    c2 = '\u0000';
                                    break block10;
                                }
                                case '>': {
                                    operator.combinator = 2;
                                    break;
                                }
                                case '+': {
                                    operator.combinator = 3;
                                    break;
                                }
                                default: {
                                    operator.combinator = 1;
                                }
                            }
                            operator = new Operator(operator);
                            c2 = '\u0000';
                        }
                    }
                }
                default: {
                    continue block22;
                }
            }
        }
        this.lastOperator = this.operator == null ? (this.operator = operator) : (this.lastOperator.nextOperator = operator);
    }

    public boolean isMatch(StartToken startToken) {
        if (this.operator == null) {
            return true;
        }
        Operator operator = this.operator;
        do {
            if (!operator.isMatch(startToken)) continue;
            return true;
        } while ((operator = operator.nextOperator) != null);
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        if (this.operator != null) {
            Operator operator = this.operator;
            stringBuffer.append(operator.toString());
            while ((operator = operator.nextOperator) != null) {
                stringBuffer.append(", ");
                stringBuffer.append(operator.toString());
            }
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    private class StringChain {
        private String value;
        private StringChain next;
        private StringChain last;

        private StringChain(String string) {
            this.value = string;
        }

        private void add(String string) {
            StringChain stringChain = new StringChain(string);
            if (this.last == null) {
                this.next = stringChain;
            } else {
                this.last.next = stringChain;
            }
            this.last = stringChain;
        }

        private boolean isMatch(String string) {
            if (string.compareTo(this.value) != 0) {
                return false;
            }
            return this.next == null;
        }

        private boolean isMatch(String[] stringArray) {
            StringChain stringChain = this;
            block0: do {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].compareTo(stringChain.value) == 0) continue block0;
                }
                return false;
            } while ((stringChain = stringChain.next) != null);
            return true;
        }
    }

    private class AttributeChain {
        private AttributeChain next;

        private AttributeChain(String string, String string2, int n) {
        }

        private void add(String string, String string2, int n) {
        }

        private boolean isMatch(Attribute attribute) {
            return false;
        }

        public String toString() {
            return "[]";
        }
    }

    private class Operator {
        private static final int ALL = -20;
        private static final int OWN = 0;
        private static final int ANCESTOR = 1;
        private static final int PARENT = 2;
        private static final int PREDECESSOR = 3;
        private static final int FIRST_CHILD = 1;
        private static final int LINK = 2;
        private static final int VISITED = 4;
        private static final int HOVER = 8;
        private static final int ACTIVE = 16;
        private static final int FOCUS = 32;
        private static final int LANG = 64;
        private static final int FIRST_LINE = 1;
        private static final int FIRST_LETTER = 2;
        private static final int BEFORE = 4;
        private static final int AFTER = 8;
        private Operator nextOperator;
        private Operator nestedOperator;
        private int combinator;
        private int targetType;
        private AttributeChain targetAttribute;
        private StringChain targetClass;
        private StringChain targetId;
        private int pseudoClasses;
        private int pseudoElements;
        private String pseudoLang;
        private String[] tokenClass;
        private String tokenId;
        private Attribute tokenAttribute;

        private Operator(Operator operator) {
            this.nestedOperator = operator;
        }

        private void addAttribute(String string, String string2, int n) {
            if (this.targetAttribute == null) {
                this.targetAttribute = new AttributeChain(string, string2, n);
            } else {
                this.targetAttribute.add(string, string2, n);
            }
        }

        private void addClass(String string) {
            if (this.targetClass == null) {
                this.targetClass = new StringChain(string);
            } else {
                this.targetClass.add(string);
            }
        }

        private void addId(String string) {
            if (this.targetId == null) {
                this.targetId = new StringChain(string);
            } else {
                this.targetId.add(string);
            }
        }

        private boolean isMatch(StartToken startToken) {
            switch (this.combinator) {
                case 0: 
                case 2: 
                case 3: {
                    return this.isInnerMatch(startToken);
                }
                case 1: {
                    while (!this.isInnerMatch(startToken)) {
                        do {
                            if ((startToken = startToken.getParent()) != null) continue;
                            return false;
                        } while (startToken.getCompleteToken());
                    }
                    return true;
                }
            }
            return false;
        }

        private boolean isInnerMatch(StartToken startToken) {
            this.tokenAttribute = startToken.getAttribute();
            if (this.tokenAttribute != null) {
                this.tokenClass = this.tokenAttribute.getBaseClass();
                this.tokenId = this.tokenAttribute.getBaseId();
            } else {
                this.tokenClass = null;
                this.tokenId = null;
            }
            if (this.targetType != -20 && this.targetType != startToken.getType()) {
                return false;
            }
            if (!(this.targetAttribute == null || this.tokenAttribute != null && this.targetAttribute.isMatch(this.tokenAttribute))) {
                return false;
            }
            if (!(this.targetClass == null || this.tokenClass != null && this.targetClass.isMatch(this.tokenClass))) {
                return false;
            }
            if (!(this.targetId == null || this.tokenId != null && this.targetId.isMatch(this.tokenId))) {
                return false;
            }
            if (this.pseudoClasses != 0) {
                return false;
            }
            if (this.pseudoElements != 0) {
                return false;
            }
            if (this.nestedOperator != null) {
                if (this.nestedOperator.combinator == 3) {
                    while ((startToken = startToken.getBeforeStartToken()) != null && startToken.getCompleteToken()) {
                    }
                } else {
                    while ((startToken = startToken.getParent()) != null && startToken.getCompleteToken()) {
                    }
                }
                if (startToken == null) {
                    return false;
                }
                return this.nestedOperator.isMatch(startToken);
            }
            return true;
        }

        public String toString() {
            Object object;
            StringBuffer stringBuffer = new StringBuffer();
            if (this.nestedOperator != null) {
                stringBuffer.append(this.nestedOperator.toString());
                stringBuffer.append(' ');
            }
            if (this.targetType == -20) {
                stringBuffer.append('*');
            } else {
                stringBuffer.append(TokenTypes.getName(this.targetType));
            }
            if (this.targetAttribute != null) {
                object = this.targetAttribute;
                do {
                    stringBuffer.append(((AttributeChain)object).toString());
                } while ((object = ((AttributeChain)object).next) != null);
            }
            if (this.targetClass != null) {
                object = this.targetClass;
                do {
                    stringBuffer.append('.');
                    stringBuffer.append(((StringChain)object).value);
                } while ((object = ((StringChain)object).next) != null);
            }
            if (this.targetId != null) {
                object = this.targetId;
                do {
                    stringBuffer.append('#');
                    stringBuffer.append(((StringChain)object).value);
                } while ((object = ((StringChain)object).next) != null);
            }
            if (this.pseudoClasses != 0) {
                if ((this.pseudoClasses & 1) != 0) {
                    stringBuffer.append(":first-child");
                }
                if ((this.pseudoClasses & 2) != 0) {
                    stringBuffer.append(":link");
                }
                if ((this.pseudoClasses & 4) != 0) {
                    stringBuffer.append(":visited");
                }
                if ((this.pseudoClasses & 8) != 0) {
                    stringBuffer.append(":hover");
                }
                if ((this.pseudoClasses & 0x10) != 0) {
                    stringBuffer.append(":active");
                }
                if ((this.pseudoClasses & 0x20) != 0) {
                    stringBuffer.append(":focus");
                }
                if ((this.pseudoClasses & 0x40) != 0) {
                    stringBuffer.append(":lang(");
                    stringBuffer.append(this.pseudoLang);
                    stringBuffer.append(')');
                }
            }
            if (this.pseudoClasses != 0) {
                if ((this.pseudoElements & 1) != 0) {
                    stringBuffer.append(":first-line");
                }
                if ((this.pseudoElements & 2) != 0) {
                    stringBuffer.append(":first-letter");
                }
                if ((this.pseudoElements & 4) != 0) {
                    stringBuffer.append(":before");
                }
                if ((this.pseudoElements & 8) != 0) {
                    stringBuffer.append(":after");
                }
            }
            switch (this.combinator) {
                case 2: {
                    stringBuffer.append(" >");
                    break;
                }
                case 3: {
                    stringBuffer.append(" +");
                }
            }
            return stringBuffer.toString();
        }
    }
}

