/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.rendering;

import java.awt.Point;
import java.util.Vector;
import net.fclabs.util.Queue;
import net.hizlab.kagetaka.rendering.Box;
import net.hizlab.kagetaka.rendering.Caddy;
import net.hizlab.kagetaka.rendering.Drawkit;
import net.hizlab.kagetaka.rendering.Position;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.token.FormItem;
import net.hizlab.kagetaka.token.Value;
import net.hizlab.kagetaka.util.TextFormat;

class Paragraph {
    private static final String BR = String.valueOf('\n');
    private static final String SPACE = String.valueOf(' ');
    private static final int LS_BEGIN = 0;
    private static final int LS_TRUE = 1;
    private static final int LS_FALSE = 2;
    Box box;
    private Drawkit drawkit;
    int preferredHeight;
    private boolean rearrange = false;
    private boolean hasFloat = false;
    private int whiteSpace = 3;
    private int indent = 0;
    private boolean reference = true;
    private Caddy caddy = null;
    private Caddy topCaddy = null;
    private Caddy lastCaddy = null;
    private Vector widthList = new Vector();
    private Vector heightList = new Vector();
    private Vector offsetList = new Vector();
    private Vector topList = new Vector();
    private Vector bottomList = new Vector();
    private int lineno = 0;
    int width = 0;
    int height = 0;
    int maxHeight = 0;
    int drawOffsetX = 0;
    int lineWidth = 0;
    int lineHeight = 0;
    int lineOffset = 0;
    int linePitch = 0;
    int lineMaxHeight = 0;
    int floatTop = 0;
    int floatBottom = 0;
    int floatHeight = 0;
    private boolean statusChanged = false;
    private Status listStatus = null;
    private int lastSpace = 0;
    private Queue floatQueue = null;

    Paragraph(Box box, Status status, int n) {
        this.box = box;
        this.drawkit = box.drawkit;
        this.preferredHeight = n;
        Status status2 = this.drawkit.status;
        if (status2.textIndent != null) {
            this.indent = status2.textIndent.getValue(status2.fd, status2.fdFontSize.height, 2);
            this.lineHeight += this.indent;
        }
        this.whiteSpace = status2.whiteSpace;
        this.reference = status2.reference;
        if (status != null) {
            if (status.listLevel == 0) {
                this.drawkit.status = status;
                this.statusChanged();
                this.appendString("\u30fb");
                this.drawkit.status = status2;
                this.statusChanged();
            } else {
                this.listStatus = status;
            }
        }
    }

    void appendString(String string) {
        int n = this.lastSpace;
        int n2 = 0;
        string = this.whiteSpace != 51 ? TextFormat.convertXhtml(string, n != 2, false, true, this.reference) : TextFormat.convertXhtml(string, false, false, false, this.reference);
        n2 = string.length();
        if (n2 == 0) {
            return;
        }
        this.checkCaddy(false, true, true);
        if (this.whiteSpace != 51 && !this.lastCaddy.ruby && string.charAt(n2 - 1) == ' ') {
            --n2;
            this.lastSpace = 1;
        }
        this.caddy.append(string, 0, n2);
    }

    void appendImage(String string, String string2, Value value, Value value2, int n, int n2) {
        boolean bl = n2 == 3;
        this.checkCaddy(false, bl, bl);
        this.caddy.append(string, string2, value, value2, n, n2);
        if (!bl) {
            this.caddy.statusChanged();
        }
    }

    void appendFloat(Box box) {
        this.checkCaddy(false, false, false);
        this.caddy.append(box);
        this.caddy.statusChanged();
    }

    void appendForm(FormItem formItem) {
        this.checkCaddy(false, true, true);
        this.caddy.append(formItem);
    }

    void setRuby(int n) {
        switch (n) {
            case 1: {
                this.commitCaddy();
                this.checkCaddy(true, true, true);
                break;
            }
            case 7: {
                this.caddy.setRuby(7);
                this.commitCaddy();
                break;
            }
            default: {
                this.caddy.setRuby(n);
            }
        }
    }

    void newLine() {
        this.checkCaddy(false, false, false);
        if (!this.caddy.ruby) {
            this.caddy.append(BR, 0, 1);
        }
        this.lastSpace = 0;
    }

    void appendLastLine(boolean bl, int n) {
        int n2;
        int n3;
        this.lineMaxHeight += this.lineHeight;
        if (bl) {
            this.maxHeight = Math.max(this.maxHeight, this.lineMaxHeight);
            this.lineMaxHeight = 0;
        }
        if (this.lineno > 0) {
            this.lineWidth += this.linePitch;
        }
        this.width += this.lineWidth;
        this.width += this.lineOffset;
        this.height = Math.max(this.height, this.lineHeight);
        ++this.lineno;
        this.widthList.addElement(new Integer(this.lineWidth));
        this.heightList.addElement(new Integer(this.lineHeight));
        this.offsetList.addElement(new Integer(this.lineOffset));
        this.topList.addElement(new Integer(this.floatTop));
        this.bottomList.addElement(new Integer(this.floatBottom));
        this.lineWidth = 0;
        this.lineHeight = 0;
        this.lineOffset = 0;
        this.linePitch = 0;
        if (this.floatQueue != null) {
            FloatBlock floatBlock;
            while ((floatBlock = (FloatBlock)this.floatQueue.get()) != null) {
                this.allocateFloatBlock(floatBlock);
            }
        }
        this.floatTop = this.getFloatHeight(31);
        this.floatBottom = this.getFloatHeight(32);
        this.floatHeight = this.floatTop + this.floatBottom;
        if (n > 0 && this.floatHeight > 0 && (n3 = this.drawOffsetX + this.width) != (n2 = this.box.getFloatGap(n3, n, this.preferredHeight))) {
            this.linePitch = n2 - n3;
            this.floatTop = this.box.getFloatHeight(n2, 31);
            this.floatBottom = this.box.getFloatHeight(n2, 32);
            this.floatHeight = this.floatTop + this.floatBottom;
        }
    }

    void appendFloatBlock(int n, int n2, int n3, Point point, int n4) {
        if (!this.rearrange) {
            this.height = Math.max(this.height, n2);
            this.hasFloat = true;
            return;
        }
        FloatBlock floatBlock = new FloatBlock(n, n2, n3, point);
        if (this.lineHeight + n4 == 0) {
            this.allocateFloatBlock(floatBlock);
            this.floatTop = this.getFloatHeight(31);
            this.floatBottom = this.getFloatHeight(32);
            this.floatHeight = this.floatTop + this.floatBottom;
            return;
        }
        if (this.floatQueue == null) {
            this.floatQueue = new Queue();
        }
        this.floatQueue.put(floatBlock);
    }

    private void allocateFloatBlock(FloatBlock floatBlock) {
        int n = this.drawOffsetX;
        Point point = this.box.addFloat(n + this.width, floatBlock.width, floatBlock.height, floatBlock.type, this.preferredHeight);
        ((FloatBlock)floatBlock).offset.x = point.x - n;
        ((FloatBlock)floatBlock).offset.y = point.y;
    }

    int getFloatHeight(int n) {
        return this.box.getFloatHeight(this.drawOffsetX + this.width, n);
    }

    void commit() {
        if (this.caddy != null) {
            this.caddy.commit();
            this.caddy = null;
        }
        if (this.lineHeight > 0) {
            this.appendLastLine(true, 0);
        }
    }

    void statusChanged() {
        if (this.caddy == null) {
            return;
        }
        this.statusChanged = true;
    }

    void rearrange(int n, boolean bl) {
        if (!bl && !this.hasFloat && this.preferredHeight == n) {
            return;
        }
        this.rearrange = true;
        this.preferredHeight = n;
        this.widthList.removeAllElements();
        this.heightList.removeAllElements();
        this.offsetList.removeAllElements();
        this.topList.removeAllElements();
        this.bottomList.removeAllElements();
        this.lineno = 0;
        this.width = 0;
        this.height = 0;
        this.lineWidth = 0;
        this.lineHeight = this.indent;
        this.lineOffset = 0;
        this.linePitch = 0;
        this.floatTop = this.getFloatHeight(31);
        this.floatBottom = this.getFloatHeight(32);
        this.floatHeight = this.floatTop + this.floatBottom;
        this.floatQueue = null;
        Caddy caddy = this.topCaddy;
        while (caddy != null) {
            caddy.rearrange(n);
            caddy = caddy.next;
        }
        this.commit();
    }

    void draw(int n, int n2) {
        if (this.lineno == 0 && !this.hasFloat) {
            return;
        }
        n -= this.drawOffsetX;
        int[] nArray = new int[this.lineno];
        int[] nArray2 = new int[this.lineno];
        int[] nArray3 = new int[this.lineno];
        int[] nArray4 = new int[this.lineno];
        int[] nArray5 = new int[this.lineno];
        for (int i = 0; i < this.lineno; ++i) {
            nArray[i] = (Integer)this.widthList.elementAt(i);
            nArray2[i] = (Integer)this.heightList.elementAt(i);
            nArray3[i] = (Integer)this.offsetList.elementAt(i);
            nArray4[i] = (Integer)this.topList.elementAt(i);
            nArray5[i] = (Integer)this.bottomList.elementAt(i);
        }
        Position position = new Position(n, n2, this.box.status.align, this.preferredHeight, nArray, nArray2, nArray3, nArray4, nArray5);
        if (this.listStatus != null) {
            this.drawkit.drawListItem(position.x, position.y, this.listStatus);
        }
        position.y += this.indent;
        Caddy caddy = this.topCaddy;
        while (caddy != null) {
            caddy.draw(position);
            caddy = caddy.next;
        }
    }

    private void checkCaddy(boolean bl, boolean bl2, boolean bl3) {
        if (this.caddy == null) {
            this.caddy = new Caddy(this, bl);
            if (this.topCaddy == null) {
                this.topCaddy = this.lastCaddy = this.caddy;
            } else {
                this.lastCaddy = this.lastCaddy.next = this.caddy;
            }
        } else {
            if (bl2 && this.lastSpace == 1) {
                this.caddy.append(SPACE, 0, 1);
            }
            if (this.statusChanged) {
                this.caddy.statusChanged();
                this.whiteSpace = this.drawkit.status.whiteSpace;
                this.reference = this.drawkit.status.reference;
            }
        }
        if (bl3 && this.lastSpace != 2) {
            this.lastSpace = 2;
        }
    }

    private void commitCaddy() {
        if (this.caddy == null) {
            return;
        }
        this.caddy.commit();
        this.caddy = null;
    }

    private class FloatBlock {
        private int width;
        private int height;
        private int type;
        private Point offset;

        private FloatBlock(int n, int n2, int n3, Point point) {
            this.width = n;
            this.height = n2;
            this.type = n3;
            this.offset = point;
        }
    }
}

