/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.rendering;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.net.FileNameMap;
import java.net.URL;
import java.net.URLConnection;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.image.RotateFilter;
import net.hizlab.kagetaka.rendering.Counter;
import net.hizlab.kagetaka.rendering.DelayRectangle;
import net.hizlab.kagetaka.rendering.Drawkit;
import net.hizlab.kagetaka.rendering.HawkContext;
import net.hizlab.kagetaka.rendering.ImageCache;
import net.hizlab.kagetaka.rendering.Option;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.rendering.StopException;
import net.hizlab.kagetaka.token.Value;

class ImageHolder
implements DelayRectangle {
    private static final int IMAGE_WAIT = 60000;
    private static final int IMG_WIDTH = 28;
    private static final int IMG_HEIGHT = 28;
    private static final int D_IMG_PITCH = 4;
    private static final int TYPE_UNKNOWN = 0;
    private static final int TYPE_GIF = 1;
    private static final int TYPE_JPEG = 2;
    private static Image dummyImage = null;
    private static Object dummyImageLock = new Object();
    private static Dimension dummyImageSize = null;
    private HawkContext context;
    private Drawkit drawkit;
    private Status status;
    Rectangle position;
    int border;
    int floatType;
    Point floatOffset;
    int floatDelayX;
    int floatDelayY;
    private URL url;
    private String src;
    private String alt;
    private Observer observer;
    private Image original;
    private Image image;
    private Dimension imageSize;
    private Graphics g;
    private Counter gCounter;
    private int offset;
    private boolean sameSize = false;
    private boolean hasError = false;
    private boolean spin = false;
    boolean complete = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ImageHolder(Drawkit drawkit, Status status, String string, String string2, Value value, Value value2, int n, int n2) {
        Object object;
        this.context = drawkit.context;
        this.drawkit = drawkit;
        this.status = status;
        this.url = drawkit.createURL(string);
        this.src = string;
        this.alt = string2;
        this.observer = new Observer();
        this.imageSize = new Dimension(0, 0);
        this.position = new Rectangle(0, 0, value == null || value.getUnit() == 9 ? 0 : value.getNumber().intValue(), value2 == null || value2.getUnit() == 9 ? 0 : value2.getNumber().intValue());
        this.image = drawkit.getImage(this.url, string);
        this.border = n;
        this.floatType = n2;
        if (n2 != 3) {
            this.floatOffset = new Point(0, 0);
        }
        Option option = this.context.getOption();
        int n3 = 0;
        if ((option.getSpinGifImage() || option.getSpinJpegImage()) && this.url != null) {
            FileNameMap fileNameMap;
            object = ImageCache.getInstance().getContentType(this.url);
            if (object == null && (fileNameMap = URLConnection.getFileNameMap()) != null) {
                object = fileNameMap.getContentTypeFor(string);
            }
            if (object != null) {
                if (((String)object).startsWith("image/gif")) {
                    n3 = 1;
                } else if (((String)object).startsWith("image/jpeg") || ((String)object).startsWith("image/jpg")) {
                    n3 = 2;
                }
            }
            boolean bl = this.spin = option.getSpinGifImage() && n3 == 1 || option.getSpinJpegImage() && n3 == 2;
        }
        if (this.image != null) {
            object = this.position;
            synchronized (object) {
                if (this.position.width <= 0) {
                    this.position.width = this.image.getWidth(this.observer);
                }
            }
            object = this.position;
            synchronized (object) {
                if (this.position.height <= 0) {
                    this.position.height = this.image.getHeight(this.observer);
                }
            }
            object = this.position;
            synchronized (object) {
                if (!(this.hasError || this.position.width >= 0 && this.position.height >= 0)) {
                    try {
                        this.position.wait(60000L);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new StopException("wait to get a position");
                    }
                }
            }
        }
        if (this.position.width <= 0 || this.position.height <= 0) {
            if (this.position.width <= 0) {
                this.position.width = 28;
            }
            if (this.position.height <= 0) {
                this.position.height = 28;
            }
            this.image = null;
        } else {
            if (value != null && value.getUnit() == 9) {
                this.position.width = this.position.width * value.getNumber().intValue() / 100;
            }
            if (value2 != null && value2.getUnit() == 9) {
                this.position.height = this.position.height * value2.getNumber().intValue() / 100;
            }
            if (this.spin) {
                int n4 = 0;
                double d = 0.0;
                switch (n3) {
                    case 1: {
                        n4 = option.getSpinGifMinWidth();
                        d = option.getSpinGifAspectRatio();
                        break;
                    }
                    case 2: {
                        n4 = option.getSpinJpegMinWidth();
                        d = option.getSpinJpegAspectRatio();
                    }
                }
                if (this.position.width >= n4 && !((double)this.position.width / (double)this.position.height > d) && !((double)this.position.height / (double)this.position.width > d)) {
                    this.spin = false;
                }
            }
            if (this.spin) {
                int n5 = this.position.width;
                this.position.width = this.position.height;
                this.position.height = n5;
                this.observer.enabled = false;
                this.observer = new Observer();
                if (this.image != null) {
                    this.image = this.context.createImage(new FilteredImageSource(this.image.getSource(), new RotateFilter()));
                }
            }
        }
    }

    void draw(int n, int n2) {
        this.g = this.drawkit.g;
        this.gCounter = this.drawkit.gCounter;
        this.position.x = n + this.border;
        this.position.y = n2 + this.border;
        this.offset = this.drawkit.size.width - this.position.x - this.position.width;
        this.gCounter.increment();
        this.drawkit.imageCounter.increment();
        if (this.border > 0) {
            this.g.setColor(this.status.foreColor);
            for (int i = 1; i <= this.border; ++i) {
                this.g.drawRect(this.position.x - i, this.position.y - i, this.position.width + i * 2 - 1, this.position.height + i * 2 - 1);
            }
        }
        if (this.status.href != null) {
            this.drawkit.itemMap.addHref(this.offset - this.border, n2, this.offset + this.position.width + this.border, this.position.y + this.position.height + this.border, this.status.href);
        }
        if (this.url != null) {
            this.drawkit.itemMap.addImage(this.offset, this.position.y, this.offset + this.position.width, this.position.y + this.position.height, this.url);
        }
        if (this.alt != null || this.status.tip != null) {
            this.drawkit.itemMap.addInfo(this.offset, this.position.y, this.offset + this.position.width, this.position.y + this.position.height, this.alt != null ? this.alt : this.status.tip);
        }
        if (this.image != null) {
            this.original = this.context.createImage(this.position.width, this.position.height);
            Graphics graphics = this.original.getGraphics();
            graphics.drawImage(this.drawkit.panel, 0, 0, this.position.width, this.position.height, this.position.x, this.position.y, this.position.x + this.position.width, this.position.y + this.position.height, this.observer);
            graphics.dispose();
            if (this.drawImage(this.image)) {
                this.dispose();
            }
        } else {
            this.drawDummy();
            this.dispose();
        }
    }

    public void drawDelay() {
        this.draw(this.floatDelayX, this.floatDelayY);
    }

    private boolean drawImage(Image image) {
        try {
            return this.g.drawImage(image, this.position.x, this.position.y, this.position.width, this.position.height, this.observer);
        }
        catch (Exception exception) {
            this.drawkit.reportMessage(7, "render.warning.image.draw", new String[]{this.src, exception.toString()});
            image = null;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loaded() {
        if (!this.complete) {
            Counter counter = this.drawkit.imageCounter;
            synchronized (counter) {
                this.drawkit.imageCounter.decrement();
                this.drawkit.imageCounter.notify();
            }
            this.complete = true;
        }
    }

    synchronized void dispose() {
        this.loaded();
        if (this.g != null) {
            if (this.gCounter.decrement() <= 0) {
                this.g.dispose();
            }
            if (this.original != null) {
                this.original.flush();
            }
            this.g = null;
        }
    }

    private void overwriteDummy() {
        if (this.g == null) {
            return;
        }
        if (this.original != null) {
            this.drawkit.drawImageSync(this.g, this.original, this.position.x, this.position.y, this.position.width, this.position.height);
        }
        this.drawDummy();
        this.context.repaint(this.offset, this.position.y, this.position.width, this.position.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void drawDummy() {
        if (this.g == null) {
            return;
        }
        Object object = dummyImageLock;
        synchronized (object) {
            if (dummyImage == null) {
                dummyImage = Resource.getImageResource("render.image.notfound", this.context.getToolkit());
                if (dummyImage == null) {
                    return;
                }
                this.drawkit.loadImage(dummyImage, "wait to load a dummy image");
                dummyImageSize = new Dimension(dummyImage.getWidth(null), dummyImage.getHeight(null));
            }
        }
        this.g.setColor(Color.black);
        this.g.drawLine(this.position.x, this.position.y, this.position.x + this.position.width - 1, this.position.y);
        this.g.drawLine(this.position.x, this.position.y, this.position.x, this.position.y + this.position.height - 1);
        this.g.setColor(Color.lightGray);
        this.g.drawLine(this.position.x + this.position.width - 1, this.position.y + 1, this.position.x + this.position.width - 1, this.position.y + this.position.height - 1);
        this.g.drawLine(this.position.x + 1, this.position.y + this.position.height - 1, this.position.x + this.position.width - 1, this.position.y + this.position.height - 1);
        int n = Math.min(ImageHolder.dummyImageSize.width, this.position.width - 4);
        int n2 = Math.min(ImageHolder.dummyImageSize.height, this.position.height - 4);
        this.drawkit.drawImageSync(this.g, dummyImage, this.position.x + 4, this.position.y + 4, this.position.x + 4 + n, this.position.y + 4 + n2, 0, 0, n, n2);
    }

    public String toString() {
        if (this.url != null) {
            return this.url.toString();
        }
        return this.src;
    }

    private class Observer
    implements ImageObserver {
        private boolean enabled = true;

        private Observer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            if (!this.enabled) {
                return false;
            }
            if ((n & 0xC0) != 0) {
                Rectangle rectangle = ImageHolder.this.position;
                synchronized (rectangle) {
                    ImageHolder.this.hasError = true;
                    if (ImageHolder.this.position.width <= 0 || ImageHolder.this.position.height <= 0) {
                        ImageHolder.this.position.notify();
                    }
                }
                if ((n & 0x40) != 0) {
                    ImageHolder.this.overwriteDummy();
                    ImageHolder.this.drawkit.reportMessage(7, "render.warning.image.load.error", new String[]{ImageHolder.this.src});
                } else {
                    ImageHolder.this.drawkit.reportMessage(7, "render.warning.image.load.abort", new String[]{ImageHolder.this.src});
                }
                ImageHolder.this.dispose();
                return false;
            }
            if ((n & 3) != 0) {
                Rectangle rectangle = ImageHolder.this.position;
                synchronized (rectangle) {
                    if ((n & 1) != 0 && ImageHolder.this.position.width <= 0) {
                        ImageHolder.this.position.width = n4;
                    }
                    if ((n & 2) != 0 && ImageHolder.this.position.height <= 0) {
                        ImageHolder.this.position.height = n5;
                    }
                    if (ImageHolder.this.position.width > 0 && ImageHolder.this.position.height > 0) {
                        ImageHolder.this.position.notify();
                    }
                }
                if ((n & 1) != 0) {
                    ((ImageHolder)ImageHolder.this).imageSize.width = n4;
                }
                if ((n & 2) != 0) {
                    ((ImageHolder)ImageHolder.this).imageSize.height = n5;
                }
                ImageHolder.this.sameSize = ((ImageHolder)ImageHolder.this).imageSize.width == ImageHolder.this.position.width && ((ImageHolder)ImageHolder.this).imageSize.height == ImageHolder.this.position.height;
            }
            if (ImageHolder.this.g != null) {
                try {
                    if ((n & 8) != 0 && ImageHolder.this.sameSize) {
                        if (ImageHolder.this.original != null) {
                            ImageHolder.this.g.drawImage(ImageHolder.this.original, ImageHolder.this.position.x + n2, ImageHolder.this.position.y + n3, ImageHolder.this.position.x + n2 + n4, ImageHolder.this.position.y + n3 + n5, n2, n3, n2 + n4, n3 + n5, ImageHolder.this.observer);
                        }
                        ImageHolder.this.g.drawImage(image, ImageHolder.this.position.x + n2, ImageHolder.this.position.y + n3, ImageHolder.this.position.x + n2 + n4, ImageHolder.this.position.y + n3 + n5, n2, n3, n2 + n4, n3 + n5, ImageHolder.this.observer);
                        ImageHolder.this.context.repaint(ImageHolder.this.offset + (ImageHolder.this.position.width - (n2 + n4)), ImageHolder.this.position.y + n3, n4, n5);
                    }
                    if ((n & 0x30) != 0) {
                        ImageHolder.this.g.drawImage(image, ImageHolder.this.position.x, ImageHolder.this.position.y, ImageHolder.this.position.width, ImageHolder.this.position.height, ImageHolder.this.observer);
                        ImageHolder.this.context.repaint(ImageHolder.this.offset, ImageHolder.this.position.y, ImageHolder.this.position.width, ImageHolder.this.position.height);
                    }
                    if ((n & 0x10) != 0) {
                        ImageHolder.this.loaded();
                    }
                    if ((n & 0x20) != 0) {
                        ImageHolder.this.dispose();
                    }
                }
                catch (Exception exception) {
                    ImageHolder.this.drawkit.reportMessage(7, "render.warning.image.draw", new String[]{ImageHolder.this.src, exception.toString()});
                    ImageHolder.this.overwriteDummy();
                    ImageHolder.this.dispose();
                    return false;
                }
            }
            return (n & 0xE0) == 0;
        }
    }
}

