/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.rendering;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.text.ParseException;
import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.build.Parser;
import net.hizlab.kagetaka.build.ParserManager;
import net.hizlab.kagetaka.build.TokenCoordinator;
import net.hizlab.kagetaka.io.CounterInputStream;
import net.hizlab.kagetaka.io.CounterListener;
import net.hizlab.kagetaka.java2.NETWrapper;
import net.hizlab.kagetaka.rendering.ConnectWrapper;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.EngineListener;
import net.hizlab.kagetaka.rendering.HawkContext;
import net.hizlab.kagetaka.rendering.ImageCache;
import net.hizlab.kagetaka.rendering.ItemMap;
import net.hizlab.kagetaka.rendering.Option;
import net.hizlab.kagetaka.rendering.Render;
import net.hizlab.kagetaka.rendering.Request;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.rendering.StopException;
import net.hizlab.kagetaka.token.EndToken;
import net.hizlab.kagetaka.token.StartToken;
import net.hizlab.kagetaka.token.TextToken;
import net.hizlab.kagetaka.token.Token;
import net.hizlab.kagetaka.token.TokenTypes;
import net.hizlab.kagetaka.token.Value;
import net.hizlab.kagetaka.util.Charset;
import net.hizlab.kagetaka.util.ContentType;
import net.hizlab.kagetaka.util.StringUtils;

public class HawkEngine {
    private static final ContentType DEFAULT_CONTENT_TYPE = new ContentType("text", "html");
    private static final int LT_TEXT = 0;
    private static final int LT_HTML = 1;
    private static final int LT_IMAGE = 2;
    private static final int LT_BINARY = 3;
    private static NETWrapper netWrapper = NETWrapper.getInstance();
    private final HawkContext context;
    private final Reporter reporter;
    private final Option option;
    private ImageCache imageCache;
    private Object threadLock = new Object();
    private LoadThread oldThread = null;
    private LoadThread loadThread = null;
    private EngineListener listener = null;
    private Object renderLock = new Object();
    private Render render = null;

    public HawkEngine(HawkContext hawkContext) {
        this.context = hawkContext;
        this.reporter = hawkContext.getReporter();
        this.option = hawkContext.getOption();
        this.imageCache = ImageCache.getInstance();
    }

    public void setEngineListener(EngineListener engineListener) {
        this.listener = engineListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load(Request request) {
        if (this.isLoading()) {
            this.stop();
        }
        Object object = this.threadLock;
        synchronized (object) {
            if (this.loadThread != null) {
                this.loadThread.dispose();
                if (this.oldThread == null) {
                    this.oldThread = this.loadThread;
                }
            }
        }
        this.loadThread = new LoadThread(request);
        this.loadThread.start();
    }

    public synchronized void stop() {
        if (this.isLoading()) {
            this.loadThread.interrupt();
        }
    }

    public synchronized boolean isLoading() {
        return this.loadThread != null && this.loadThread.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dispose() {
        if (this.isLoading()) {
            this.loadThread.interrupt();
        }
        Object object = this.renderLock;
        synchronized (object) {
            if (this.render != null) {
                this.render.dispose();
            }
        }
    }

    static /* synthetic */ Object access$100(HawkEngine hawkEngine) {
        return hawkEngine.threadLock;
    }

    static /* synthetic */ LoadThread access$200(HawkEngine hawkEngine) {
        return hawkEngine.oldThread;
    }

    static /* synthetic */ LoadThread access$202(HawkEngine hawkEngine, LoadThread loadThread) {
        hawkEngine.oldThread = loadThread;
        return hawkEngine.oldThread;
    }

    static /* synthetic */ ContentType access$300() {
        return DEFAULT_CONTENT_TYPE;
    }

    static /* synthetic */ ImageCache access$500(HawkEngine hawkEngine) {
        return hawkEngine.imageCache;
    }

    static /* synthetic */ Object access$700(HawkEngine hawkEngine) {
        return hawkEngine.renderLock;
    }

    static /* synthetic */ Render access$802(HawkEngine hawkEngine, Render render) {
        hawkEngine.render = render;
        return hawkEngine.render;
    }

    private class Chatty
    implements CounterListener {
        private LoadThread thread;
        private String name;
        private int max;
        private int percent = 0;
        private int p;

        private Chatty(LoadThread loadThread, String string, int n) {
            this.thread = loadThread;
            this.name = string;
            this.max = n;
        }

        public void changeLength(long l) {
            this.p = (int)(l * 100L / (long)this.max);
            if (this.p >= 100) {
                this.p = 99;
            }
            if (this.p != this.percent) {
                if (this.percent > 0) {
                    this.thread.setStatus("engine.status.load.percent", new Object[]{this.name, new Integer(this.percent)}, 3);
                }
                this.percent = this.p;
            }
        }
    }

    private class LoadThread
    extends Thread
    implements EngineListener {
        private Request request;
        private URL url;
        private String urlString;
        private boolean active = true;

        private LoadThread(Request request) {
            this.request = request;
            this.url = request.url;
            this.urlString = this.url.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            var1_1 = 1;
            var2_2 = false;
            try {
                block179: {
                    block169: {
                        var3_3 = null;
                        var4_4 = null;
                        var5_5 = null;
                        try {
                            var6_6 = HawkEngine.access$100(HawkEngine.this);
                            synchronized (var6_6) {
                                if (HawkEngine.access$200(HawkEngine.this) != null) {
                                    HawkEngine.access$200(HawkEngine.this).join();
                                    HawkEngine.access$202(HawkEngine.this, null);
                                }
                            }
                        }
                        catch (InterruptedException var6_7) {
                            this.setStatus("engine.warning.stop", new String[]{"old thread stop"}, 7);
                            var21_19 = null;
                            try {
                                if (var2_2 && var1_1 == 1) {
                                    HawkEngine.access$500(HawkEngine.this).clear();
                                    try {
                                        var22_36 = HawkEngine.access$800(HawkEngine.this).getRefreshURL();
                                        if (var22_36 != null) {
                                            this.refresh(this.request, new Request(var22_36, null, this.request.getDocument().url, null, false, false, 1));
                                        }
                                    }
                                    catch (StopException var22_37) {
                                    }
                                }
                                var24_70 = null;
                                var25_104 = this;
                            }
                            catch (Throwable var23_138) {
                                var24_71 = null;
                                var25_105 = this;
                                synchronized (var25_105) {
                                    this.active = false;
                                    throw var23_138;
                                }
                            }
                            synchronized (var25_104) {
                                this.active = false;
                                return;
                            }
                        }
                        try {
                            block170: {
                                var6_6 = HawkEngine.access$300();
                                var7_155 = null;
                                var8_156 = -1;
                                this.connecting(this.request);
                                this.setStatus("engine.status.load.open", new String[]{this.urlString}, 3);
                                var2_2 = false;
                                if (HawkEngine.access$500(HawkEngine.this).getImage(HawkEngine.access$400(HawkEngine.this), this.url, this.urlString, this.request, false) == null) break block170;
                                var1_1 = 2;
                                try {
                                    var6_6 = new ContentType(HawkEngine.access$500(HawkEngine.this).getContentType(this.url));
                                }
                                catch (ParseException var9_157) {}
                                ** GOTO lbl388
                            }
                            var3_3 = ConnectWrapper.getURLConnection(HawkEngine.access$400(HawkEngine.this), this.request);
                            if (var3_3 != null) ** GOTO lbl-1000
                            this.setStatus(null, null, 0);
                            var14_159 = null;
                            ** GOTO lbl350
                        }
                        catch (InterruptedException var6_8) {
                            block171: {
                                var14_162 = null;
                                this.connected(this.request, var2_2);
                                if (var2_2 && !this.isInterrupted()) break block169;
                                this.renderingSkipped(this.request);
                                if (this.isInterrupted()) {
                                    var2_2 = true;
                                }
                                var21_25 = null;
                                try {}
                                catch (Throwable var23_144) {
                                    var24_83 = null;
                                    var25_117 = this;
                                    synchronized (var25_117) {
                                        this.active = false;
                                        throw var23_144;
                                    }
                                }
                                if (!var2_2 || var1_1 != 1) break block171;
                                HawkEngine.access$500(HawkEngine.this).clear();
                                ** try [egrp 15[TRYBLOCK] [59 : 1410->1462)] { 
lbl86:
                                // 1 sources

                                var22_48 = HawkEngine.access$800(HawkEngine.this).getRefreshURL();
                                if (var22_48 != null) {
                                    this.refresh(this.request, new Request(var22_48, null, this.request.getDocument().url, null, false, false, 1));
                                }
                                break block171;
lbl90:
                                // 1 sources

                                catch (StopException var22_49) {
                                }
                            }
                            var24_82 = null;
                            var25_116 = this;
                            synchronized (var25_116) {
                                this.active = false;
                                return;
                            }
                        }
                        catch (SecurityException var6_9) {
                            block172: {
                                this.setStatus("engine.status.load.error.security", new String[]{this.urlString}, 7);
                                var14_163 = null;
                                this.connected(this.request, var2_2);
                                if (var2_2 && !this.isInterrupted()) break block169;
                                this.renderingSkipped(this.request);
                                if (this.isInterrupted()) {
                                    var2_2 = true;
                                }
                                var21_26 = null;
                                try {}
                                catch (Throwable var23_145) {
                                    var24_85 = null;
                                    var25_119 = this;
                                    synchronized (var25_119) {
                                        this.active = false;
                                        throw var23_145;
                                    }
                                }
                                if (!var2_2 || var1_1 != 1) break block172;
                                HawkEngine.access$500(HawkEngine.this).clear();
                                ** try [egrp 15[TRYBLOCK] [59 : 1410->1462)] { 
lbl122:
                                // 1 sources

                                var22_50 = HawkEngine.access$800(HawkEngine.this).getRefreshURL();
                                if (var22_50 != null) {
                                    this.refresh(this.request, new Request(var22_50, null, this.request.getDocument().url, null, false, false, 1));
                                }
                                break block172;
lbl126:
                                // 1 sources

                                catch (StopException var22_51) {
                                }
                            }
                            var24_84 = null;
                            var25_118 = this;
                            synchronized (var25_118) {
                                this.active = false;
                                return;
                            }
                        }
                        catch (FileNotFoundException var6_10) {
                            block173: {
                                this.setStatus("engine.status.load.error.nofile", new String[]{this.urlString}, 7);
                                var14_164 = null;
                                this.connected(this.request, var2_2);
                                if (var2_2 && !this.isInterrupted()) break block169;
                                this.renderingSkipped(this.request);
                                if (this.isInterrupted()) {
                                    var2_2 = true;
                                }
                                var21_27 = null;
                                try {}
                                catch (Throwable var23_146) {
                                    var24_87 = null;
                                    var25_121 = this;
                                    synchronized (var25_121) {
                                        this.active = false;
                                        throw var23_146;
                                    }
                                }
                                if (!var2_2 || var1_1 != 1) break block173;
                                HawkEngine.access$500(HawkEngine.this).clear();
                                ** try [egrp 15[TRYBLOCK] [59 : 1410->1462)] { 
lbl158:
                                // 1 sources

                                var22_52 = HawkEngine.access$800(HawkEngine.this).getRefreshURL();
                                if (var22_52 != null) {
                                    this.refresh(this.request, new Request(var22_52, null, this.request.getDocument().url, null, false, false, 1));
                                }
                                break block173;
lbl162:
                                // 1 sources

                                catch (StopException var22_53) {
                                }
                            }
                            var24_86 = null;
                            var25_120 = this;
                            synchronized (var25_120) {
                                this.active = false;
                                return;
                            }
                        }
                        catch (UnknownHostException var6_11) {
                            block174: {
                                this.setStatus("engine.status.load.error.hostname", new String[]{this.url.getHost()}, 7);
                                var14_165 = null;
                                this.connected(this.request, var2_2);
                                if (var2_2 && !this.isInterrupted()) break block169;
                                this.renderingSkipped(this.request);
                                if (this.isInterrupted()) {
                                    var2_2 = true;
                                }
                                var21_28 = null;
                                try {}
                                catch (Throwable var23_147) {
                                    var24_89 = null;
                                    var25_123 = this;
                                    synchronized (var25_123) {
                                        this.active = false;
                                        throw var23_147;
                                    }
                                }
                                if (!var2_2 || var1_1 != 1) break block174;
                                HawkEngine.access$500(HawkEngine.this).clear();
                                ** try [egrp 15[TRYBLOCK] [59 : 1410->1462)] { 
lbl194:
                                // 1 sources

                                var22_54 = HawkEngine.access$800(HawkEngine.this).getRefreshURL();
                                if (var22_54 != null) {
                                    this.refresh(this.request, new Request(var22_54, null, this.request.getDocument().url, null, false, false, 1));
                                }
                                break block174;
lbl198:
                                // 1 sources

                                catch (StopException var22_55) {
                                }
                            }
                            var24_88 = null;
                            var25_122 = this;
                            synchronized (var25_122) {
                                this.active = false;
                                return;
                            }
                        }
                        catch (ConnectException var6_12) {
                            block175: {
                                this.setStatus("engine.status.load.error.connect", new String[]{this.url.getHost()}, 7);
                                var14_166 = null;
                                this.connected(this.request, var2_2);
                                if (var2_2 && !this.isInterrupted()) break block169;
                                this.renderingSkipped(this.request);
                                if (this.isInterrupted()) {
                                    var2_2 = true;
                                }
                                var21_29 = null;
                                try {}
                                catch (Throwable var23_148) {
                                    var24_91 = null;
                                    var25_125 = this;
                                    synchronized (var25_125) {
                                        this.active = false;
                                        throw var23_148;
                                    }
                                }
                                if (!var2_2 || var1_1 != 1) break block175;
                                HawkEngine.access$500(HawkEngine.this).clear();
                                ** try [egrp 15[TRYBLOCK] [59 : 1410->1462)] { 
lbl230:
                                // 1 sources

                                var22_56 = HawkEngine.access$800(HawkEngine.this).getRefreshURL();
                                if (var22_56 != null) {
                                    this.refresh(this.request, new Request(var22_56, null, this.request.getDocument().url, null, false, false, 1));
                                }
                                break block175;
lbl234:
                                // 1 sources

                                catch (StopException var22_57) {
                                }
                            }
                            var24_90 = null;
                            var25_124 = this;
                            synchronized (var25_124) {
                                this.active = false;
                                return;
                            }
                        }
                        catch (IOException var6_13) {
                            block176: {
                                var7_155 = var6_13.getMessage();
                                this.setStatus("engine.status.load.error", new Object[]{this.urlString, new Integer(var7_155 != null ? 1 : 0), var7_155, var6_13.getClass().getName()}, 7);
                                if (HawkEngine.access$600(HawkEngine.this) != null && HawkEngine.access$600(HawkEngine.this).getLevel() <= -1) {
                                    var6_13.printStackTrace(System.out);
                                }
                                var14_167 = null;
                                this.connected(this.request, var2_2);
                                if (var2_2 && !this.isInterrupted()) break block169;
                                this.renderingSkipped(this.request);
                                if (this.isInterrupted()) {
                                    var2_2 = true;
                                }
                                var21_30 = null;
                                try {}
                                catch (Throwable var23_149) {
                                    var24_93 = null;
                                    var25_127 = this;
                                    synchronized (var25_127) {
                                        this.active = false;
                                        throw var23_149;
                                    }
                                }
                                if (!var2_2 || var1_1 != 1) break block176;
                                HawkEngine.access$500(HawkEngine.this).clear();
                                ** try [egrp 15[TRYBLOCK] [59 : 1410->1462)] { 
lbl269:
                                // 1 sources

                                var22_58 = HawkEngine.access$800(HawkEngine.this).getRefreshURL();
                                if (var22_58 != null) {
                                    this.refresh(this.request, new Request(var22_58, null, this.request.getDocument().url, null, false, false, 1));
                                }
                                break block176;
lbl273:
                                // 1 sources

                                catch (StopException var22_59) {
                                }
                            }
                            var24_92 = null;
                            var25_126 = this;
                            synchronized (var25_126) {
                                this.active = false;
                                return;
                            }
                        }
                        catch (RuntimeException var6_14) {
                            block177: {
                                var7_155 = var6_14.getMessage();
                                this.setStatus("engine.status.load.error", new Object[]{this.urlString, new Integer(var7_155 != null ? 1 : 0), var7_155, var6_14.getClass().getName()}, 7);
                                var6_14.printStackTrace(System.out);
                                var14_168 = null;
                                this.connected(this.request, var2_2);
                                if (var2_2 && !this.isInterrupted()) break block169;
                                this.renderingSkipped(this.request);
                                if (this.isInterrupted()) {
                                    var2_2 = true;
                                }
                                var21_31 = null;
                                try {}
                                catch (Throwable var23_150) {
                                    var24_95 = null;
                                    var25_129 = this;
                                    synchronized (var25_129) {
                                        this.active = false;
                                        throw var23_150;
                                    }
                                }
                                if (!var2_2 || var1_1 != 1) break block177;
                                HawkEngine.access$500(HawkEngine.this).clear();
                                ** try [egrp 15[TRYBLOCK] [59 : 1410->1462)] { 
lbl307:
                                // 1 sources

                                var22_60 = HawkEngine.access$800(HawkEngine.this).getRefreshURL();
                                if (var22_60 != null) {
                                    this.refresh(this.request, new Request(var22_60, null, this.request.getDocument().url, null, false, false, 1));
                                }
                                break block177;
lbl311:
                                // 1 sources

                                catch (StopException var22_61) {
                                }
                            }
                            var24_94 = null;
                            var25_128 = this;
                            synchronized (var25_128) {
                                this.active = false;
                                return;
                            }
                        }
                        catch (Throwable var13_174) {
                            block178: {
                                var14_169 = null;
                                this.connected(this.request, var2_2);
                                if (var2_2) {
                                    if (this.isInterrupted() == false) throw var13_174;
                                }
                                this.renderingSkipped(this.request);
                                if (this.isInterrupted()) {
                                    var2_2 = true;
                                }
                                var21_32 = null;
                                try {}
                                catch (Throwable var23_151) {
                                    var24_97 = null;
                                    var25_131 = this;
                                    synchronized (var25_131) {
                                        this.active = false;
                                        throw var23_151;
                                    }
                                }
                                if (!var2_2 || var1_1 != 1) break block178;
                                HawkEngine.access$500(HawkEngine.this).clear();
                                ** try [egrp 15[TRYBLOCK] [59 : 1410->1462)] { 
lbl343:
                                // 1 sources

                                var22_62 = HawkEngine.access$800(HawkEngine.this).getRefreshURL();
                                if (var22_62 == null) break block178;
                                this.refresh(this.request, new Request(var22_62, null, this.request.getDocument().url, null, false, false, 1));
                                break block178;
lbl347:
                                // 1 sources

                                catch (StopException var22_63) {
                                }
                                break block178;
lbl350:
                                // 1 sources

                                this.connected(this.request, var2_2);
                                if (var2_2 && !this.isInterrupted()) ** GOTO lbl566
                                this.renderingSkipped(this.request);
                                if (this.isInterrupted()) {
                                    var2_2 = true;
                                }
                                var21_20 = null;
                                ** GOTO lbl-1000
lbl-1000:
                                // 1 sources

                                {
                                    if (!this.isInterrupted()) ** GOTO lbl-1000
                                    var14_160 = null;
                                }
                                this.connected(this.request, var2_2);
                                if (var2_2 && !this.isInterrupted()) ** GOTO lbl618
                                this.renderingSkipped(this.request);
                                if (this.isInterrupted()) {
                                    var2_2 = true;
                                }
                                ** GOTO lbl592
lbl-1000:
                                // 1 sources

                                {
                                    this.url = var3_3.getURL();
                                    this.urlString = this.url.toString();
                                    var9_158 = var3_3.getContentType();
                                    if (var9_158 != null) {
                                        try {
                                            var6_6 = new ContentType(var9_158);
                                        }
                                        catch (ParseException var10_170) {
                                            // empty catch block
                                        }
                                    }
                                    var10_171 = var6_6.getType();
                                    var11_172 = var6_6.getSubType();
                                    if (var10_171.compareTo("text") == 0) {
                                        var1_1 = var11_172 != null && var11_172.compareTo("html") == 0 ? 1 : 0;
                                        var4_4 = this.getConnectionInputStream(var3_3);
                                        var12_173 = var6_6.getParameter("charset");
                                        if (var12_173 != null && (var7_155 = Charset.toEncoding(var12_173)) == null) {
                                            this.setStatus("charset.warning.invalid", new String[]{var12_173}, 7);
                                        }
                                    } else {
                                        var1_1 = var10_171.compareTo("image") == 0 ? 2 : 3;
                                    }
                                    var8_156 = var3_3.getContentLength();
lbl388:
                                    // 3 sources

                                    var5_5 = new Document(this.url, (ContentType)var6_6, var8_156, 128, new ItemMap(HawkEngine.access$600(HawkEngine.this)));
                                    var5_5.setEncoding(var7_155);
                                    this.request.setDocument(var5_5);
                                    var2_2 = true;
                                }
                                var14_161 = null;
                                this.connected(this.request, var2_2);
                                if (var2_2 && !this.isInterrupted()) break block169;
                                this.renderingSkipped(this.request);
                                if (this.isInterrupted()) {
                                    var2_2 = true;
                                }
                                ** GOTO lbl644
                            }
                            var24_96 = null;
                            var25_130 = this;
                            synchronized (var25_130) {
                                this.active = false;
                                return;
                            }
                        }
                    }
                    if (var1_1 != 3) break block179;
                    try {
                        var2_2 = false;
                        this.doBinary(var5_5, var3_3);
                        this.setStatus(null, null, 0);
                        var2_2 = true;
                        ** GOTO lbl670
                    }
                    finally {
                        this.renderingSkipped(this.request);
                    }
                }
                try {
                    try {
                        this.renderingStarted(this.request);
                        this.setStatus("engine.status.load.start", new String[]{this.urlString}, 3);
                        var2_2 = false;
                        var6_6 = HawkEngine.access$700(HawkEngine.this);
                        synchronized (var6_6) {
                            if (HawkEngine.access$800(HawkEngine.this) != null) {
                                HawkEngine.access$800(HawkEngine.this).dispose();
                            }
                            HawkEngine.access$802(HawkEngine.this, new Render(HawkEngine.access$400(HawkEngine.this), this.request));
                        }
                        switch (var1_1) {
                            case 0: {
                                var4_4 = this.getConnectionInputStream(var3_3);
                                this.doText(var5_5, var4_4);
                                break;
                            }
                            case 1: {
                                var4_4 = this.getConnectionInputStream(var3_3);
                                this.doHtml(var5_5, var4_4);
                                break;
                            }
                            case 2: {
                                this.doImage(var5_5);
                                break;
                            }
                        }
                        this.setStatus("engine.status.load.complete", null, 3);
                        var2_2 = true;
                    }
                    catch (StopException var6_15) {
                        if (HawkEngine.access$600(HawkEngine.this) != null) {
                            HawkEngine.access$600(HawkEngine.this).report(3, Resource.getMessage("engine.warning.stop", new String[]{var6_15.toString()}), 0, 0);
                        }
                        HawkEngine.access$800(HawkEngine.this).stopImageLoad();
                        var2_2 = true;
                        var18_177 = null;
                        this.renderingStopped(this.request, var2_2);
                        if (var4_4 != null) {
                            try {
                                var4_4.close();
                            }
                            catch (IOException var19_183) {}
                        }
                        ** GOTO lbl696
                    }
                    catch (OutOfMemoryError var6_16) {
                        this.setStatus("engine.status.load.error.oom", new String[]{this.urlString}, 7);
                        if (HawkEngine.access$600(HawkEngine.this) != null && HawkEngine.access$600(HawkEngine.this).getLevel() <= -1) {
                            var6_16.printStackTrace(System.out);
                        }
                        var18_178 = null;
                        this.renderingStopped(this.request, var2_2);
                        if (var4_4 != null) {
                            try {}
                            catch (IOException var19_184) {}
                            var4_4.close();
                        }
                        ** GOTO lbl696
                    }
                    catch (IOException var6_17) {
                        var7_155 = var6_17.getMessage();
                        this.setStatus("engine.status.load.error", new Object[]{this.urlString, new Integer(var7_155 != null ? 1 : 0), var7_155, var6_17.getClass().getName()}, 7);
                        var6_17.printStackTrace(System.out);
                        var18_179 = null;
                        this.renderingStopped(this.request, var2_2);
                        if (var4_4 != null) {
                            try {}
                            catch (IOException var19_185) {}
                            var4_4.close();
                        }
                        ** GOTO lbl696
                    }
                    catch (RuntimeException var6_18) {
                        var7_155 = var6_18.getMessage();
                        this.setStatus("engine.status.load.error", new Object[]{this.urlString, new Integer(var7_155 != null ? 1 : 0), var7_155, var6_18.getClass().getName()}, 7);
                        var6_18.printStackTrace(System.out);
                        var18_180 = null;
                        this.renderingStopped(this.request, var2_2);
                        if (var4_4 != null) {
                            try {}
                            catch (IOException var19_186) {}
                            var4_4.close();
                        }
                        ** GOTO lbl696
                    }
                    var18_176 = null;
                    this.renderingStopped(this.request, var2_2);
                    if (var4_4 != null) {
                    }
                    ** GOTO lbl696
                }
                catch (Throwable var17_188) {
                    var18_181 = null;
                    this.renderingStopped(this.request, var2_2);
                    if (var4_4 == null) throw var17_188;
                    ** try [egrp 13[TRYBLOCK] [51 : 1363->1371)] { 
lbl509:
                    // 1 sources

                    var4_4.close();
                    throw var17_188;
lbl511:
                    // 1 sources

                    catch (IOException var19_187) {
                        // empty catch block
                    }
                    throw var17_188;
                }
                try {}
                catch (IOException var19_182) {}
                var4_4.close();
                ** GOTO lbl696
            }
            catch (Throwable var20_189) {
                block180: {
                    block187: {
                        block186: {
                            block185: {
                                block184: {
                                    block183: {
                                        block182: {
                                            block181: {
                                                var21_35 = null;
                                                try {}
                                                catch (Throwable var23_154) {
                                                    var24_103 = null;
                                                    var25_137 = this;
                                                    synchronized (var25_137) {
                                                        this.active = false;
                                                        throw var23_154;
                                                    }
                                                }
                                                if (!var2_2 || var1_1 != true) break block180;
                                                HawkEngine.access$500(HawkEngine.this).clear();
                                                ** try [egrp 15[TRYBLOCK] [59 : 1410->1462)] { 
lbl533:
                                                // 1 sources

                                                var22_68 = HawkEngine.access$800(HawkEngine.this).getRefreshURL();
                                                if (var22_68 != null) {
                                                    this.refresh(this.request, new Request(var22_68, null, this.request.getDocument().url, null, false, false, 1));
                                                }
                                                break block180;
lbl537:
                                                // 1 sources

                                                catch (StopException var22_69) {
                                                }
                                                break block180;
lbl-1000:
                                                // 1 sources

                                                try {}
                                                catch (Throwable var23_139) {
                                                    var24_73 = null;
                                                    var25_107 = this;
                                                    synchronized (var25_107) {
                                                        this.active = false;
                                                        throw var23_139;
                                                    }
                                                }
                                                if (!var2_2 || var1_1 != 1) break block181;
                                                HawkEngine.access$500(HawkEngine.this).clear();
                                                ** try [egrp 15[TRYBLOCK] [59 : 1410->1462)] { 
lbl552:
                                                // 1 sources

                                                var22_38 = HawkEngine.access$800(HawkEngine.this).getRefreshURL();
                                                if (var22_38 != null) {
                                                    this.refresh(this.request, new Request(var22_38, null, this.request.getDocument().url, null, false, false, 1));
                                                }
                                                break block181;
lbl556:
                                                // 1 sources

                                                catch (StopException var22_39) {
                                                }
                                            }
                                            var24_72 = null;
                                            var25_106 = this;
                                            synchronized (var25_106) {
                                                this.active = false;
                                                return;
                                            }
lbl566:
                                            // 1 sources

                                            var21_21 = null;
                                            try {}
                                            catch (Throwable var23_140) {
                                                var24_75 = null;
                                                var25_109 = this;
                                                synchronized (var25_109) {
                                                    this.active = false;
                                                    throw var23_140;
                                                }
                                            }
                                            if (!var2_2 || var1_1 != 1) break block182;
                                            HawkEngine.access$500(HawkEngine.this).clear();
                                            ** try [egrp 15[TRYBLOCK] [59 : 1410->1462)] { 
lbl578:
                                            // 1 sources

                                            var22_40 = HawkEngine.access$800(HawkEngine.this).getRefreshURL();
                                            if (var22_40 != null) {
                                                this.refresh(this.request, new Request(var22_40, null, this.request.getDocument().url, null, false, false, 1));
                                            }
                                            break block182;
lbl582:
                                            // 1 sources

                                            catch (StopException var22_41) {
                                            }
                                        }
                                        var24_74 = null;
                                        var25_108 = this;
                                        synchronized (var25_108) {
                                            this.active = false;
                                            return;
                                        }
lbl592:
                                        // 1 sources

                                        var21_22 = null;
                                        try {}
                                        catch (Throwable var23_141) {
                                            var24_77 = null;
                                            var25_111 = this;
                                            synchronized (var25_111) {
                                                this.active = false;
                                                throw var23_141;
                                            }
                                        }
                                        if (!var2_2 || var1_1 != 1) break block183;
                                        HawkEngine.access$500(HawkEngine.this).clear();
                                        ** try [egrp 15[TRYBLOCK] [59 : 1410->1462)] { 
lbl604:
                                        // 1 sources

                                        var22_42 = HawkEngine.access$800(HawkEngine.this).getRefreshURL();
                                        if (var22_42 != null) {
                                            this.refresh(this.request, new Request(var22_42, null, this.request.getDocument().url, null, false, false, 1));
                                        }
                                        break block183;
lbl608:
                                        // 1 sources

                                        catch (StopException var22_43) {
                                        }
                                    }
                                    var24_76 = null;
                                    var25_110 = this;
                                    synchronized (var25_110) {
                                        this.active = false;
                                        return;
                                    }
lbl618:
                                    // 1 sources

                                    var21_23 = null;
                                    try {}
                                    catch (Throwable var23_142) {
                                        var24_79 = null;
                                        var25_113 = this;
                                        synchronized (var25_113) {
                                            this.active = false;
                                            throw var23_142;
                                        }
                                    }
                                    if (!var2_2 || var1_1 != 1) break block184;
                                    HawkEngine.access$500(HawkEngine.this).clear();
                                    ** try [egrp 15[TRYBLOCK] [59 : 1410->1462)] { 
lbl630:
                                    // 1 sources

                                    var22_44 = HawkEngine.access$800(HawkEngine.this).getRefreshURL();
                                    if (var22_44 != null) {
                                        this.refresh(this.request, new Request(var22_44, null, this.request.getDocument().url, null, false, false, 1));
                                    }
                                    break block184;
lbl634:
                                    // 1 sources

                                    catch (StopException var22_45) {
                                    }
                                }
                                var24_78 = null;
                                var25_112 = this;
                                synchronized (var25_112) {
                                    this.active = false;
                                    return;
                                }
lbl644:
                                // 1 sources

                                var21_24 = null;
                                try {}
                                catch (Throwable var23_143) {
                                    var24_81 = null;
                                    var25_115 = this;
                                    synchronized (var25_115) {
                                        this.active = false;
                                        throw var23_143;
                                    }
                                }
                                if (!var2_2 || var1_1 != 1) break block185;
                                HawkEngine.access$500(HawkEngine.this).clear();
                                ** try [egrp 15[TRYBLOCK] [59 : 1410->1462)] { 
lbl656:
                                // 1 sources

                                var22_46 = HawkEngine.access$800(HawkEngine.this).getRefreshURL();
                                if (var22_46 != null) {
                                    this.refresh(this.request, new Request(var22_46, null, this.request.getDocument().url, null, false, false, 1));
                                }
                                break block185;
lbl660:
                                // 1 sources

                                catch (StopException var22_47) {
                                }
                            }
                            var24_80 = null;
                            var25_114 = this;
                            synchronized (var25_114) {
                                this.active = false;
                                return;
                            }
lbl670:
                            // 1 sources

                            var21_33 = null;
                            try {}
                            catch (Throwable var23_152) {
                                var24_99 = null;
                                var25_133 = this;
                                synchronized (var25_133) {
                                    this.active = false;
                                    throw var23_152;
                                }
                            }
                            if (!var2_2 || var1_1 != 1) break block186;
                            HawkEngine.access$500(HawkEngine.this).clear();
                            ** try [egrp 15[TRYBLOCK] [59 : 1410->1462)] { 
lbl682:
                            // 1 sources

                            var22_64 = HawkEngine.access$800(HawkEngine.this).getRefreshURL();
                            if (var22_64 != null) {
                                this.refresh(this.request, new Request(var22_64, null, this.request.getDocument().url, null, false, false, 1));
                            }
                            break block186;
lbl686:
                            // 1 sources

                            catch (StopException var22_65) {
                            }
                        }
                        var24_98 = null;
                        var25_132 = this;
                        synchronized (var25_132) {
                            this.active = false;
                            return;
                        }
lbl696:
                        // 10 sources

                        var21_34 = null;
                        try {}
                        catch (Throwable var23_153) {
                            var24_101 = null;
                            var25_135 = this;
                            synchronized (var25_135) {
                                this.active = false;
                                throw var23_153;
                            }
                        }
                        if (!var2_2 || var1_1 != 1) break block187;
                        HawkEngine.access$500(HawkEngine.this).clear();
                        ** try [egrp 15[TRYBLOCK] [59 : 1410->1462)] { 
lbl708:
                        // 1 sources

                        var22_66 = HawkEngine.access$800(HawkEngine.this).getRefreshURL();
                        if (var22_66 != null) {
                            this.refresh(this.request, new Request(var22_66, null, this.request.getDocument().url, null, false, false, 1));
                        }
                        break block187;
lbl712:
                        // 1 sources

                        catch (StopException var22_67) {
                        }
                    }
                    var24_100 = null;
                    var25_134 = this;
                    synchronized (var25_134) {
                        this.active = false;
                        return;
                    }
                }
                var24_102 = null;
                var25_136 = this;
                synchronized (var25_136) {
                    this.active = false;
                    throw var20_189;
                }
            }
        }

        public void interrupt() {
            super.interrupt();
            this.setStatus("engine.status.load.stop", null, 3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            LoadThread loadThread = this;
            synchronized (loadThread) {
                this.active = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setStatus(String string, Object[] objectArray, int n) {
            String string2;
            String string3 = string2 = string != null ? Resource.getMessage(string, objectArray) : null;
            if (string2 != null && HawkEngine.this.reporter != null) {
                HawkEngine.this.reporter.report(n, string2, 0, 0);
            }
            LoadThread loadThread = this;
            synchronized (loadThread) {
                if (this.active) {
                    HawkEngine.this.context.setStatus(string2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connecting(Request request) {
            LoadThread loadThread = this;
            synchronized (loadThread) {
                if (this.active && HawkEngine.this.listener != null) {
                    HawkEngine.this.listener.connecting(request);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connected(Request request, boolean bl) {
            LoadThread loadThread = this;
            synchronized (loadThread) {
                if (this.active && HawkEngine.this.listener != null) {
                    HawkEngine.this.listener.connected(request, bl);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void renderingSkipped(Request request) {
            LoadThread loadThread = this;
            synchronized (loadThread) {
                if (this.active && HawkEngine.this.listener != null) {
                    HawkEngine.this.listener.renderingSkipped(request);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void renderingStarted(Request request) {
            LoadThread loadThread = this;
            synchronized (loadThread) {
                if (this.active && HawkEngine.this.listener != null) {
                    HawkEngine.this.listener.renderingStarted(request);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void renderingStopped(Request request, boolean bl) {
            LoadThread loadThread = this;
            synchronized (loadThread) {
                if (this.active && HawkEngine.this.listener != null) {
                    HawkEngine.this.listener.renderingStopped(request, bl);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refresh(Request request, Request request2) {
            LoadThread loadThread = this;
            synchronized (loadThread) {
                if (this.active && HawkEngine.this.listener != null) {
                    HawkEngine.this.listener.refresh(request, request2);
                }
            }
        }

        private void doText(Document document, InputStream inputStream) {
            String string;
            BufferedReader bufferedReader = null;
            String string2 = document.getEncoding();
            if (string2 != null) {
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string2));
                    document.setEncoding(string2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            if (bufferedReader == null) {
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            }
            Status status = HawkEngine.this.render.getStatus();
            status.setMargin(15, new Value(5L, 3));
            status.lineHeight = new Value(1.2, 1);
            status.whiteSpace = 51;
            status.reference = false;
            status.setFixedFont();
            HawkEngine.this.render.setTitle(StringUtils.getFile(document.url));
            HawkEngine.this.render.startBody();
            do {
                int n = 0;
                HawkEngine.this.render.save(3191);
                HawkEngine.this.render.statusChanged();
                HawkEngine.this.render.startBlock();
                try {
                    while ((string = bufferedReader.readLine()) != null) {
                        HawkEngine.this.render.drawText(string);
                        HawkEngine.this.render.drawText("\n");
                        if (++n < 100) continue;
                        break;
                    }
                }
                catch (IOException iOException) {
                    string = null;
                    String string3 = iOException.getMessage();
                    this.setStatus("engine.status.load.error", new Object[]{this.urlString, new Integer(string3 != null ? 1 : 0), string3, iOException.getClass().getName()}, 7);
                }
                HawkEngine.this.render.endBlock();
                HawkEngine.this.render.reset();
                HawkEngine.this.render.statusChanged();
            } while (string != null);
            HawkEngine.this.render.endBody();
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void doHtml(Document document, InputStream inputStream) {
            boolean bl;
            Object object;
            String string;
            if (inputStream != null && document.contentLength != -1) {
                inputStream = new CounterInputStream(inputStream, new Chatty(this, this.urlString, document.contentLength));
            }
            if ((string = HawkEngine.this.option.getInputStreamParser()) == null) {
                string = Resource.getMessage("parser.default", null);
            }
            Parser parser = ParserManager.createInstance(string, document, inputStream, HawkEngine.this.reporter);
            String[] stringArray = HawkEngine.this.option.getFilterParsers();
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    object = ParserManager.createInstance(stringArray[i], document, parser, HawkEngine.this.reporter);
                    if (object != null) {
                        parser = object;
                        continue;
                    }
                    ParserManager.ParserInfo parserInfo = ParserManager.getParser(stringArray[i]);
                    String string2 = parserInfo != null ? parserInfo.getName() : "?";
                    this.setStatus("engine.status.load.error.filter", new String[]{string2, stringArray[i]}, 7);
                }
            }
            TokenCoordinator tokenCoordinator = new TokenCoordinator(document, parser, HawkEngine.this.reporter);
            object = null;
            int n = -1;
            boolean bl2 = false;
            int n2 = 0;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = bl = HawkEngine.this.reporter != null && HawkEngine.this.reporter.getLevel() <= -1;
            block8: while ((object = tokenCoordinator.next()) != null) {
                if (bl) {
                    HawkEngine.this.reporter.report(-1, "[" + object + "]", ((Token)object).getLineNumber(), ((Token)object).getColumnNumber());
                }
                if (Thread.interrupted()) break;
                n = ((Token)object).getType();
                bl2 = n == 3501 || n == 3502 ? TokenTypes.canHaveBlock(((Token)object).getParent().getType()) : TokenTypes.isBlockEx(n) || n == 3401 || n == 3402;
                switch (n) {
                    case -1: 
                    case 0: 
                    case 3: 
                    case 4: 
                    case 5: {
                        ((Token)object).render(HawkEngine.this.render);
                        continue block8;
                    }
                }
                if (!bl4) {
                    if (n == 2) continue;
                    if (n == 2041) {
                        if (++n2 == 1) {
                            ((Token)object).render(HawkEngine.this.render);
                            HawkEngine.this.render.startBody();
                            Status status = HawkEngine.this.render.getStatus();
                            status.setMargin(15, new Value(5L, 3));
                            status.lineHeight = new Value(1.2, 1);
                            status.letterSpacing = new Value(1L, 3);
                        }
                        HawkEngine.this.render.save(n);
                        ((Token)object).render(HawkEngine.this.render);
                        HawkEngine.this.render.statusChanged();
                        HawkEngine.this.render.startBlock();
                        if (n2 != 1) continue;
                        HawkEngine.this.render.save(n);
                        HawkEngine.this.render.getStatus().setMargin(10, new Value(1L, 1));
                        HawkEngine.this.render.statusChanged();
                        HawkEngine.this.render.startBlock();
                        HawkEngine.this.render.drawText(Resource.getMessage("engine.message.useframe", null));
                        HawkEngine.this.render.endBlock();
                        HawkEngine.this.render.reset();
                        HawkEngine.this.render.statusChanged();
                        continue;
                    }
                    if (n2 > 0) {
                        switch (n) {
                            case 2043: {
                                HawkEngine.this.render.save(n);
                                ((Token)object).render(HawkEngine.this.render);
                                HawkEngine.this.render.statusChanged();
                                HawkEngine.this.render.startBlock();
                                HawkEngine.this.render.endBlock();
                                HawkEngine.this.render.reset();
                                HawkEngine.this.render.statusChanged();
                                break;
                            }
                            case 2042: {
                                ((Token)object).render(HawkEngine.this.render);
                                HawkEngine.this.render.endBlock();
                                HawkEngine.this.render.reset();
                                HawkEngine.this.render.statusChanged();
                                if (--n2 != 0) break;
                                ((Token)object).render(HawkEngine.this.render);
                                HawkEngine.this.render.endBody();
                            }
                        }
                        continue;
                    }
                    if (n == 3001) {
                        bl4 = true;
                        ((Token)object).render(HawkEngine.this.render);
                        HawkEngine.this.render.startBody();
                        continue;
                    }
                    if (!bl3) {
                        if (n == 2001) {
                            bl3 = true;
                        }
                    } else if (n == 2002) {
                        bl3 = false;
                    }
                    ((Token)object).render(HawkEngine.this.render);
                    continue;
                }
                if (bl4 && n == 3002) {
                    bl4 = false;
                    ((Token)object).render(HawkEngine.this.render);
                    HawkEngine.this.render.endBody();
                    continue;
                }
                if (object instanceof StartToken) {
                    HawkEngine.this.render.save(n);
                    ((Token)object).render(HawkEngine.this.render);
                    HawkEngine.this.render.statusChanged();
                    if (bl2) {
                        HawkEngine.this.render.startBlock();
                    }
                    if (!TokenTypes.isEmpty(((Token)object).getType())) continue;
                    if (bl2) {
                        HawkEngine.this.render.endBlock();
                    }
                    HawkEngine.this.render.reset();
                    HawkEngine.this.render.statusChanged();
                    continue;
                }
                if (object instanceof EndToken) {
                    ((Token)object).render(HawkEngine.this.render);
                    if (bl2) {
                        HawkEngine.this.render.endBlock();
                    }
                    HawkEngine.this.render.reset();
                    HawkEngine.this.render.statusChanged();
                    continue;
                }
                if (!(object instanceof TextToken)) continue;
                ((Token)object).render(HawkEngine.this.render);
            }
            HawkEngine.this.render.waitImageLoad();
        }

        private void doImage(Document document) {
            Status status = HawkEngine.this.render.getStatus();
            status.setMargin(15, new Value(5L, 3));
            HawkEngine.this.render.setTitle(StringUtils.getFile(document.url));
            HawkEngine.this.render.startBody();
            HawkEngine.this.render.save(3191);
            HawkEngine.this.render.statusChanged();
            HawkEngine.this.render.startBlock();
            HawkEngine.this.render.drawImage(this.urlString, null, null, null, new Integer(0), 3);
            HawkEngine.this.render.endBlock();
            HawkEngine.this.render.reset();
            HawkEngine.this.render.statusChanged();
            HawkEngine.this.render.endBody();
        }

        private void doBinary(Document document, URLConnection uRLConnection) {
            HawkEngine.this.context.download(document, uRLConnection);
        }

        private InputStream getConnectionInputStream(URLConnection uRLConnection) throws IOException {
            try {
                return uRLConnection.getInputStream();
            }
            catch (IOException iOException) {
                if (uRLConnection instanceof HttpURLConnection && netWrapper != null) {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    InputStream inputStream = netWrapper.getConnectionErrorStream(httpURLConnection);
                    if (inputStream != null) {
                        return inputStream;
                    }
                }
                throw iOException;
            }
        }
    }
}

