/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.rendering;

import java.io.IOException;
import java.net.URLConnection;
import net.hizlab.kagetaka.rendering.HawkContext;
import net.hizlab.kagetaka.rendering.Request;

class ConnectWrapper
extends Thread {
    private HawkContext context;
    private Request request;
    private URLConnection connection;
    private IOException ioException;
    private InterruptedException interruptedException;
    private RuntimeException runtimeException;
    private Error error;

    static URLConnection getURLConnection(HawkContext hawkContext, Request request) throws IOException, InterruptedException {
        ConnectWrapper connectWrapper = new ConnectWrapper(hawkContext, request);
        connectWrapper.start();
        try {
            connectWrapper.join();
        }
        catch (InterruptedException interruptedException) {
            connectWrapper.interrupt();
            throw interruptedException;
        }
        if (connectWrapper.connection != null) {
            return connectWrapper.connection;
        }
        if (connectWrapper.ioException != null) {
            throw connectWrapper.ioException;
        }
        if (connectWrapper.interruptedException != null) {
            throw connectWrapper.interruptedException;
        }
        if (connectWrapper.runtimeException != null) {
            throw connectWrapper.runtimeException;
        }
        if (connectWrapper.error != null) {
            throw connectWrapper.error;
        }
        return null;
    }

    private ConnectWrapper(HawkContext hawkContext, Request request) {
        this.context = hawkContext;
        this.request = request;
    }

    public void run() {
        try {
            this.connection = this.context.getURLConnection(this.request);
        }
        catch (IOException iOException) {
            this.ioException = iOException;
        }
        catch (InterruptedException interruptedException) {
            this.interruptedException = interruptedException;
        }
        catch (RuntimeException runtimeException) {
            this.runtimeException = runtimeException;
        }
        catch (Error error) {
            this.error = error;
        }
    }
}

