/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.style;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Vector;
import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.style.Selector;
import net.hizlab.kagetaka.style.Style;
import net.hizlab.kagetaka.util.Charset;

public class CSSParser {
    private static final int INPUT_BUFFER = 4096;
    private static final int TT_NOTHING = 0;
    private static final int TT_EOF = 1;
    private static final int TT_STRINGS = 2;
    private static final int TT_KEYWORD = 3;
    private static final int TT_SYNTAX = 4;
    private static final String[] START_BLOCK = new String[]{"{"};
    private static final String[] END_BLOCK = new String[]{"}"};
    private static final String[] END_PROPERTY = new String[]{":"};
    private static final String[] END_LINE = new String[]{";"};
    private static final String[] END_STYLE = new String[]{"}", ";"};
    private InputStream is = null;
    private BufferedInputStream bis = null;
    private String encoding = null;
    private CSSReader reader = null;
    private Reporter reporter = null;
    private boolean commitEncoding = false;
    private int media = 0;
    private Style style = null;
    private String token = null;
    private String tokenLC = null;
    private StringBuffer sb = new StringBuffer();
    private boolean beforeSyntax = false;
    private boolean nowSyntax = false;
    private Selector selector = null;

    public CSSParser(Reporter reporter, String string) {
        this.reporter = reporter;
        this.reader = new CSSReader(reporter, new BufferedReader(new StringReader(string)));
        this.commitEncoding = true;
    }

    public CSSParser(Reporter reporter, InputStream inputStream, String string) {
        this.reporter = reporter;
        this.is = inputStream;
        this.encoding = string;
        BufferedReader bufferedReader = null;
        if (string != null && (bufferedReader = this.createBufferedReader(inputStream, string)) != null) {
            this.commitEncoding = true;
        } else {
            this.bis = new BufferedInputStream(inputStream, 4096);
            this.bis.mark(16384);
            bufferedReader = this.createBufferedReader(this.bis, Charset.getDefaultEncoding());
        }
        this.reader = new CSSReader(reporter, bufferedReader);
    }

    private BufferedReader createBufferedReader(InputStream inputStream, String string) {
        if (string != null) {
            try {
                return new BufferedReader(new InputStreamReader(inputStream, string), 4096);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.addWarning("charset.warning.invalid", new String[]{string}, 0);
                return null;
            }
        }
        return new BufferedReader(new InputStreamReader(inputStream), 4096);
    }

    public static Style valueOf(Reporter reporter, String string) {
        string = "{" + string + "}";
        CSSReader cSSReader = new CSSReader(reporter, new BufferedReader(new StringReader(string)));
        try {
            return cSSReader.readStyle(0, null, false);
        }
        catch (EOFException eOFException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public synchronized Style next() throws IOException {
        try {
            while (true) {
                block21: {
                    if ((this.token = this.reader.readToken(true, true)) == null) continue;
                    this.tokenLC = this.token.toLowerCase();
                    if (this.tokenLC.compareTo("@charset") == 0) {
                        this.token = this.reader.readToken(false, true);
                        if (this.token == null || !this.reader.isSyntax(CSSParser.END_LINE) || this.commitEncoding) continue;
                        this.resetEncoding(this.token);
                        continue;
                    }
                    if (!this.commitEncoding) {
                        this.commitEncoding = true;
                    }
                    if (this.tokenLC.compareTo("@media") == 0) {
                        if (this.media != 0) {
                            this.reader.skipNextBlock("cssparser.warning.nestedmedia", null);
                            continue;
                        }
                        this.media = Style.convertMedia(this.reader.getList(true, true));
                        if (this.media == 0) {
                            this.reader.skipNextBlock("cssparser.warning.invalidmedia", null);
                            continue;
                        }
                        this.token = this.reader.readToken(true, true);
                        if (this.token == null) {
                            this.media = 0;
                            continue;
                        }
                        if (this.token.compareTo("{") == 0) continue;
                        this.reader.skipNextBlock("cssparser.warning.invalidposition", this.reader.lastToken);
                        this.media = 0;
                        continue;
                    }
                    if (this.tokenLC.compareTo("@import") == 0) {
                        this.token = this.reader.readToken(false, true);
                        if (this.token == null || !this.reader.isSyntax(CSSParser.END_LINE)) continue;
                        this.importStyle(this.token);
                        continue;
                    }
                    if (this.tokenLC.compareTo("@page") == 0) {
                        this.style = this.reader.readStyle(this.media, null, true);
                        if (this.style == null) continue;
                        return this.style;
                    }
                    if (this.tokenLC.startsWith("@")) {
                        this.reader.skipNextBlock("cssparser.warning.unknown", this.token);
                        continue;
                    }
                    if (this.tokenLC.compareTo("}") == 0) {
                        if (this.media == 0) {
                            this.reader.moveNextLine("cssparser.warning.invalidposition", this.token);
                            continue;
                        }
                        this.media = 0;
                        continue;
                    }
                    if (this.reader.lastTokenType == 4) {
                        this.reader.pushBack();
                        this.reader.skipNextBlock("cssparser.warning.invalidposition", this.reader.lastToken);
                        continue;
                    }
                    this.reader.pushBack();
                    this.beforeSyntax = true;
                    while (true) {
                        this.token = this.reader.readToken(true, false);
                        if (this.token != null && this.token.compareTo("{") == 0) break;
                        boolean bl = this.nowSyntax = this.reader.lastTokenType == 4;
                        if (!this.beforeSyntax && !this.nowSyntax) {
                            this.sb.append(' ');
                        }
                        this.sb.append(this.reader.lastToken);
                        this.beforeSyntax = this.nowSyntax;
                    }
                    this.reader.pushBack();
                    if (this.sb.length() > 0) {
                        this.token = this.sb.toString();
                        this.sb.setLength(0);
                        try {
                            this.selector = new Selector(this.token);
                            break block21;
                        }
                        catch (ParseException parseException) {
                            if (this.reporter != null) {
                                this.reporter.report(7, parseException.getMessage(), this.reader.lineNumber, 0);
                            }
                            this.reader.skipNextBlock(null, null);
                            continue;
                        }
                    }
                    this.selector = null;
                }
                if ((this.style = this.reader.readStyle(this.media, this.selector, false)) != null) break;
            }
            return this.style;
        }
        catch (EOFException eOFException) {
            return null;
        }
    }

    private void resetEncoding(String string) throws IOException {
        if (string == null) {
            return;
        }
        int n = this.reader.lineno();
        String string2 = Charset.toEncoding((String)string);
        if (string2 == null) {
            this.addWarning("charset.warning.invalid", new String[]{string}, n);
            return;
        }
        try {
            this.bis.reset();
            this.reader = new CSSReader(this.reporter, this.createBufferedReader(this.bis, string2));
        }
        catch (IOException iOException) {
            this.addWarning("charset.warning.reset", new String[]{string}, n);
        }
        this.encoding = string2;
        this.commitEncoding = true;
        this.reporter.report(3, Resource.getMessage((String)"charset.info.encoding", (Object[])new String[]{string2}), n, 0);
    }

    private void importStyle(String string) {
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void close() {
        try {
            if (this.bis != null) {
                ((FilterInputStream)this.bis).close();
            }
        }
        catch (IOException iOException) {
            this.addWarning("cssparser.warning.stream.close", new String[]{iOException.toString()}, 0);
        }
        try {
            if (this.is != null) {
                this.is.close();
            }
        }
        catch (IOException iOException) {
            this.addWarning("cssparser.warning.stream.close", new String[]{iOException.toString()}, 0);
        }
    }

    private void addWarning(String string, String[] stringArray, int n) {
        this.reporter.report(7, Resource.getMessage((String)string, (Object[])stringArray), n, 0);
    }

    private static class EOFException
    extends Exception {
        private EOFException() {
        }
    }

    private static class CSSReader {
        private Reporter reporter = null;
        private StreamTokenizer tokenizer = null;
        private boolean pushBack = false;
        private String lastToken = null;
        private int lastTokenType = 0;
        private int lineNumber = 0;
        private String token = null;

        private CSSReader(Reporter reporter, BufferedReader bufferedReader) {
            this.reporter = reporter;
            this.tokenizer = new StreamTokenizer(bufferedReader);
            this.tokenizer.resetSyntax();
            this.tokenizer.wordChars(0, 65535);
            this.tokenizer.ordinaryChar(34);
            this.tokenizer.ordinaryChar(58);
            this.initTokenizerEndText();
            this.tokenizer.eolIsSignificant(false);
            this.tokenizer.slashSlashComments(false);
        }

        private void initTokenizerStartText() {
            this.tokenizer.wordChars(59, 59);
            this.tokenizer.wordChars(123, 123);
            this.tokenizer.wordChars(125, 125);
            this.tokenizer.wordChars(44, 44);
            this.tokenizer.wordChars(47, 47);
            this.tokenizer.wordChars(40, 40);
            this.tokenizer.wordChars(62, 62);
            this.tokenizer.wordChars(43, 43);
            this.tokenizer.wordChars(9, 16);
            this.tokenizer.wordChars(18, 19);
            this.tokenizer.wordChars(32, 32);
            this.tokenizer.slashStarComments(false);
        }

        private void initTokenizerEndText() {
            this.tokenizer.ordinaryChar(59);
            this.tokenizer.ordinaryChar(123);
            this.tokenizer.ordinaryChar(125);
            this.tokenizer.ordinaryChar(44);
            this.tokenizer.ordinaryChar(47);
            this.tokenizer.ordinaryChar(40);
            this.tokenizer.ordinaryChar(62);
            this.tokenizer.ordinaryChar(43);
            this.tokenizer.whitespaceChars(9, 16);
            this.tokenizer.whitespaceChars(18, 19);
            this.tokenizer.whitespaceChars(32, 32);
            this.tokenizer.slashStarComments(true);
        }

        private Style readStyle(int n, Selector selector, boolean bl) throws IOException, EOFException {
            int n2 = this.tokenizer.lineno();
            this.tokenizer.ordinaryChar(58);
            if (!this.isSyntax(START_BLOCK)) {
                return null;
            }
            String string = null;
            String[] stringArray = null;
            Style style = new Style(this.reporter, n2, 0, n != 0 ? n : 0xFFFFFF, selector, bl);
            while (true) {
                if ((this.token = this.readToken(true, true)) == null) {
                    continue;
                }
                if (this.token.compareTo("}") == 0) break;
                if (this.token.compareTo(";") == 0) continue;
                if (this.lastTokenType == 4) {
                    this.moveNextLine("cssparser.warning.invalidposition", this.token);
                    continue;
                }
                string = this.token;
                if (!this.isSyntax(END_PROPERTY)) continue;
                stringArray = this.getList(false, false);
                if (!this.isSyntax(END_STYLE)) continue;
                if (stringArray != null) {
                    style.initProperties(string, stringArray);
                }
                if (this.token.compareTo("}") == 0) break;
            }
            this.tokenizer.wordChars(58, 58);
            return style;
        }

        private String readToken(boolean bl, boolean bl2) throws IOException, EOFException {
            if (this.pushBack) {
                this.pushBack = false;
                return this.lastToken;
            }
            String string = null;
            block0 : switch (this.tokenizer.nextToken()) {
                case -1: {
                    this.lastToken = null;
                    this.lastTokenType = 1;
                    this.lineNumber = this.tokenizer.lineno();
                    throw new EOFException();
                }
                case -3: {
                    string = this.lastToken = this.tokenizer.sval;
                    this.lastTokenType = 3;
                    this.lineNumber = this.tokenizer.lineno();
                    break;
                }
                case 34: 
                case 40: {
                    this.lineNumber = this.tokenizer.lineno();
                    StringBuffer stringBuffer = new StringBuffer();
                    int n = this.tokenizer.ttype;
                    boolean bl3 = false;
                    int n2 = 0;
                    this.initTokenizerStartText();
                    if (n == 40) {
                        stringBuffer.append('(');
                        this.tokenizer.wordChars(34, 34);
                        this.tokenizer.ordinaryChar(41);
                    }
                    while (true) {
                        switch (this.tokenizer.nextToken()) {
                            case -1: {
                                this.lastToken = null;
                                this.lastTokenType = 1;
                                this.lineNumber = this.tokenizer.lineno();
                                throw new EOFException();
                            }
                            case 34: 
                            case 41: {
                                if (bl3) {
                                    stringBuffer.append((char)this.tokenizer.ttype);
                                    bl3 = true;
                                    break;
                                }
                                if (n == 40) {
                                    stringBuffer.append(')');
                                    this.tokenizer.ordinaryChar(34);
                                    this.tokenizer.wordChars(41, 41);
                                }
                                this.initTokenizerEndText();
                                this.lastToken = stringBuffer.toString();
                                this.lastTokenType = 2;
                                if (!bl) {
                                    string = this.lastToken;
                                    break block0;
                                }
                                if (!bl2) break block0;
                                this.moveNextLine("cssparser.warning.invalidstrings", this.lastToken);
                                break block0;
                            }
                            default: {
                                String string2 = this.tokenizer.sval;
                                if (string2 == null) {
                                    string2 = String.valueOf(this.tokenizer.ttype);
                                }
                                n2 = string2.length();
                                for (int i = 0; i < n2; ++i) {
                                    if (bl3) {
                                        bl3 = false;
                                        continue;
                                    }
                                    if (string2.charAt(i) != '\\') continue;
                                    bl3 = true;
                                }
                                stringBuffer.append(string2);
                                break;
                            }
                        }
                    }
                }
                default: {
                    this.lastToken = String.valueOf((char)this.tokenizer.ttype);
                    this.lastTokenType = 4;
                    this.lineNumber = this.tokenizer.lineno();
                    if (bl) {
                        string = this.lastToken;
                        break;
                    }
                    if (!bl2) break;
                    this.moveNextLine("cssparser.warning.invalidposition", this.lastToken);
                }
            }
            return string;
        }

        private void pushBack() {
            this.pushBack = true;
        }

        private int lineno() {
            return this.lineNumber;
        }

        private boolean isSyntax(String[] stringArray) throws IOException, EOFException {
            this.token = this.readToken(true, true);
            if (this.token == null) {
                return false;
            }
            if (this.lastTokenType == 4) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].compareTo(this.token) != 0) continue;
                    return true;
                }
            }
            this.moveNextLine("cssparser.warning.invalidposition", this.token);
            return false;
        }

        private void moveNextLine(String string, String string2) throws IOException, EOFException {
            if (string != null) {
                String[] stringArray;
                if (string2 != null) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = string2;
                } else {
                    stringArray = null;
                }
                this.addWarning(string, stringArray, this.tokenizer.lineno());
            }
            while (true) {
                if ((this.token = this.readToken(true, false)) == null) {
                    continue;
                }
                if (this.token.compareTo(";") == 0) {
                    return;
                }
                if (this.token.compareTo("}") == 0) {
                    this.pushBack();
                    return;
                }
                if (this.token.compareTo("{") == 0) break;
            }
            int n = 1;
            while (true) {
                if ((this.token = this.readToken(true, false)) == null) {
                    continue;
                }
                if (this.token.compareTo("{") == 0) {
                    ++n;
                    continue;
                }
                if (this.token.compareTo("}") == 0 && --n == 0) break;
            }
        }

        private void skipNextBlock(String string, String string2) throws IOException, EOFException {
            if (string != null) {
                String[] stringArray;
                if (string2 != null) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = string2;
                } else {
                    stringArray = null;
                }
                this.addWarning(string, stringArray, this.tokenizer.lineno());
            }
            while ((this.token = this.readToken(true, false)) == null || this.token.compareTo("{") != 0) {
            }
            this.pushBack();
            this.moveNextLine(null, null);
        }

        private String[] getList(boolean bl, boolean bl2) throws IOException, EOFException {
            Vector<String> vector = new Vector<String>();
            boolean bl3 = false;
            while (true) {
                this.token = this.readToken(bl2 ? true : bl && bl3, false);
                if (this.token == null) {
                    if (bl || bl2) break;
                    this.token = this.lastToken;
                }
                if (bl) {
                    if (bl3) {
                        if (this.token.compareTo(",") != 0) break;
                        bl3 = false;
                        continue;
                    }
                    bl3 = true;
                } else if (this.lastTokenType == 4 && this.token.compareTo(",") != 0) break;
                vector.addElement(this.token);
            }
            this.pushBack();
            if (vector.size() == 0) {
                return null;
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }

        private void addWarning(String string, String[] stringArray, int n) {
            if (this.reporter != null) {
                this.reporter.report(7, Resource.getMessage((String)string, (Object[])stringArray), n, 0);
            }
        }
    }
}

