/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.viewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Polygon;
import java.awt.PopupMenu;
import java.awt.SystemColor;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Vector;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.ImageButton;
import net.hizlab.kagetaka.awt.LayoutUtils;
import net.hizlab.kagetaka.awt.QuietPanel;
import net.hizlab.kagetaka.awt.Toolbar;
import net.hizlab.kagetaka.awt.event.StateEvent;
import net.hizlab.kagetaka.awt.event.StateListener;
import net.hizlab.kagetaka.bookmarks.Bookmark;
import net.hizlab.kagetaka.bookmarks.BookmarkManager;
import net.hizlab.kagetaka.option.ViewerOption;
import net.hizlab.kagetaka.rendering.Request;
import net.hizlab.kagetaka.theme.Theme;
import net.hizlab.kagetaka.viewer.ContextListener;
import net.hizlab.kagetaka.viewer.HawkViewer;
import net.hizlab.kagetaka.viewer.ViewerContext;

public class ViewerToolbar
extends Toolbar
implements ContextListener {
    private static final String RESOURCE = "net.hizlab.kagetaka.viewer.Resource";
    public static final String BACK = "back";
    public static final String FORWARD = "forward";
    public static final String RELOAD = "reload";
    public static final String STOP = "stop";
    public static final String GO = "go";
    public static final String HOME = "home";
    public static final String BOOKMARK = "bookmark";
    public static final String PTF = "ptf";
    public static final String ADDRESS = "address";
    static final int TYPE_NAVI = 1;
    static final int TYPE_LINK = 2;
    private static final int BUTTON_BACK = 0;
    private static final int BUTTON_FORWARD = 1;
    private static final int BUTTON_RELOAD = 2;
    private static final int BUTTON_STOP = 3;
    private static final int BUTTON_GO = 4;
    private static final int BUTTON_HOME = 5;
    private static final int BUTTON_BOOKMARK = 6;
    private static final int BUTTONS_NUM = 7;
    private static final int TEXTFIELD_ADDRESS = 0;
    private static final int TEXTFIELD_SEARCH = 1;
    private static final int TEXTFIELDS_NUM = 2;
    private static final int PTF_BOOKMARK = -1;
    private static final int MENU_SIZE = 20;
    private static final int LOAD_BEFORE = 0;
    private static final int LOAD_LOADING = 1;
    private static final int LOAD_LOADED = 2;
    private HawkViewer viewer;
    private int type;
    private ViewerOption option;
    private Theme theme;
    private Object stateLock = new Object();
    private Font toolbarFont;
    private Color toolbarFore;
    private Color toolbarBack;
    private Image toolbarImage;
    private ImageButton[] buttons;
    private TextField[] textFields;
    private QuietPanel ptPanel;
    private GridBagLayout ptPanelLayout;
    private PopupMenu popupMenu;
    private boolean showPopupMenu;
    private Bookmark[] bookmarks;
    private String[][] values;
    private Image fileImage;
    private Image openfolderImage;
    private Image closefolderImage;
    private ViewerContext activeContext;

    ViewerToolbar(HawkViewer viewer, int type) {
        this.viewer = viewer;
        this.type = type;
        this.option = viewer.getOption();
        this.theme = this.option.getThemeManager().getTheme();
        Toolkit tk = this.getToolkit();
        this.toolbarFont = this.theme.getFont("browser.toolbar.font");
        this.toolbarFore = this.theme.getColor("browser.toolbar.foreground");
        this.toolbarBack = this.theme.getColor("browser.toolbar.background");
        this.toolbarImage = this.theme.getImage("browser.toolbar.background.image", tk);
        this.buttons = new ImageButton[7];
        this.textFields = new TextField[2];
        int index = 0;
        String key = null;
        String[] list = null;
        switch (type) {
            case 1: {
                list = this.option.getPropertyStrings("show.navibar.buttons");
                break;
            }
            case 2: {
                list = this.option.getPropertyStrings("show.linkbar.buttons");
            }
        }
        for (int i = 0; i < list.length; ++i) {
            if (list[i].compareTo(BACK) == 0) {
                index = 0;
                key = "browser.toolbar.back";
            } else if (list[i].compareTo(FORWARD) == 0) {
                index = 1;
                key = "browser.toolbar.forward";
            } else if (list[i].compareTo(RELOAD) == 0) {
                index = 2;
                key = "browser.toolbar.reload";
            } else if (list[i].compareTo(STOP) == 0) {
                index = 3;
                key = "browser.toolbar.stop";
            } else if (list[i].compareTo(GO) == 0) {
                index = 4;
                key = "browser.toolbar.go";
            } else if (list[i].compareTo(HOME) == 0) {
                index = 5;
                key = "browser.toolbar.home";
            } else if (list[i].compareTo(BOOKMARK) == 0) {
                index = 6;
                key = "browser.toolbar.bookmark";
            } else {
                if (list[i].compareTo(PTF) == 0) {
                    if (this.ptPanel != null) continue;
                    this.ptPanelLayout = new GridBagLayout();
                    this.ptPanel = new QuietPanel(this.ptPanelLayout);
                    this.add(this.ptPanel);
                    continue;
                }
                if (list[i].compareTo(ADDRESS) != 0 || this.textFields[0] != null) continue;
                this.textFields[0] = new TextField();
                this.textFields[0].setFont(this.theme.getFont("browser.toolbar.addressbar.font"));
                this.textFields[0].setForeground(this.theme.getColor("browser.toolbar.addressbar.foreground"));
                ((Component)this.textFields[0]).setBackground(this.theme.getColor("browser.toolbar.addressbar.background"));
                this.textFields[0].addKeyListener(new AddressBarKeyListener());
                this.textFields[0].addFocusListener(new AddressBarFocusListener());
                this.add((Component)this.textFields[0], "maximum");
                continue;
            }
            if (this.buttons[index] != null || (this.buttons[index] = this.theme.getImageButton(key, tk)) == null) continue;
            if (this.toolbarFont != null) {
                this.buttons[index].setFont(this.toolbarFont);
            }
            if (this.toolbarFore != null) {
                this.buttons[index].setForeground(this.toolbarFore);
            }
            if (this.toolbarBack != null) {
                this.buttons[index].setBackground(this.toolbarBack);
            }
            if (this.toolbarImage != null) {
                this.buttons[index].setBackImage(this.toolbarImage);
            }
            this.buttons[index].addMouseListener(new ButtonMouseListener(index));
            if (this.theme.getBoolean(key + ".label")) {
                this.buttons[index].setLabel(Resource.getMessage(RESOURCE, "toolbar." + list[i] + ".label", null));
            }
            this.add(this.buttons[index]);
        }
        if (this.buttons[0] != null) {
            this.buttons[0].addStateListener(new ButtonStateListener(0));
        }
        if (this.buttons[1] != null) {
            this.buttons[1].addStateListener(new ButtonStateListener(1));
        }
        if (this.buttons[6] != null) {
            this.buttons[6].addStateListener(new ButtonStateListener(6));
        }
        this.setForeground(SystemColor.controlText);
        this.setBackground(SystemColor.control);
        if (this.toolbarFont != null) {
            ((Component)this).setFont(this.toolbarFont);
        }
        if (this.toolbarFore != null) {
            this.setForeground(this.toolbarFore);
        }
        if (this.toolbarBack != null) {
            this.setBackground(this.toolbarBack);
        }
        if (this.toolbarImage != null) {
            this.setBackImage(this.toolbarImage);
        }
        this.bookmarkChanged();
    }

    public String getAddress() {
        if (this.textFields[0] == null) {
            return null;
        }
        return this.textFields[0].getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAddress(String address) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.textFields[0] != null) {
                ((TextComponent)this.textFields[0]).setText(address);
            }
        }
    }

    void addToBookmark(Bookmark parent, Bookmark bookmark) {
        this.bookmarkChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bookmarkChanged() {
        BookmarkManager bm;
        if (this.ptPanel == null) {
            return;
        }
        BookmarkManager bookmarkManager = bm = this.option.getBookmarkManager();
        synchronized (bookmarkManager) {
            int i;
            Bookmark root = bm.getPersonalToolbarFolder();
            Vector v = null;
            if (root != null) {
                v = root.getBookmarks();
            }
            if (v == null || v.size() == 0) {
                if (this.bookmarks != null) {
                    this.ptPanel.removeAll();
                    this.bookmarks = null;
                }
                return;
            }
            Object[] bookmarks = new Bookmark[v.size()];
            String[][] values = new String[v.size()][2];
            v.copyInto(bookmarks);
            for (int i2 = 0; i2 < values.length; ++i2) {
                Bookmark b = (Bookmark)v.elementAt(i2);
                values[i2][0] = b.getText();
                values[i2][1] = b.getURLText();
            }
            if (this.values != null && this.values.length == values.length) {
                boolean same = true;
                for (i = 0; i < values.length; ++i) {
                    String[] b1 = this.values[i];
                    String[] b2 = values[i];
                    if (ViewerToolbar.compareString(this.values[i][0], values[i][0]) && ViewerToolbar.compareString(this.values[i][1], values[i][1])) continue;
                    same = false;
                    break;
                }
                if (same) {
                    return;
                }
            }
            ImageButton ib = null;
            Insets insets = new Insets(0, 0, 0, 0);
            BookmarkListener listener = null;
            this.ptPanel.removeAll();
            block9: for (i = 0; i < values.length; ++i) {
                switch (((Bookmark)bookmarks[i]).getType()) {
                    case 1: {
                        if (this.openfolderImage == null) {
                            this.openfolderImage = this.theme.getImage("bookmark.openfolder", this.getToolkit());
                        }
                        if (this.closefolderImage == null) {
                            this.closefolderImage = this.theme.getImage("bookmark.closefolder", this.getToolkit());
                        }
                        ib = new ImageButton(((Bookmark)bookmarks[i]).getText(), true, this.closefolderImage, this.openfolderImage, null, null, null, null, null, null);
                        break;
                    }
                    case 2: {
                        if (this.fileImage == null) {
                            this.fileImage = this.theme.getImage("bookmark.file", this.getToolkit());
                        }
                        ib = new ImageButton(((Bookmark)bookmarks[i]).getText(), this.fileImage, null);
                        break;
                    }
                    default: {
                        continue block9;
                    }
                }
                ib.setFont(this.toolbarFont);
                ib.setForeground(this.toolbarFore);
                ib.setBackground(this.toolbarBack);
                ib.setBackImage(this.toolbarImage);
                listener = new BookmarkListener((Bookmark)bookmarks[i]);
                ib.addMouseListener(listener);
                ib.addStateListener(listener);
                LayoutUtils.addGridBag(this.ptPanel, ib, this.ptPanelLayout, i, 0, 1, 1, 0.0, 1.0, 1, 10, insets);
            }
            this.validate();
            this.bookmarks = bookmarks;
            this.values = values;
        }
    }

    private static final boolean compareString(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        return s1.compareTo(s2) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activeChanged(ViewerContext context) {
        Object object = this.stateLock;
        synchronized (object) {
            this.activeContext = context;
            if (!context.canReload()) {
                this.setLoaded(0);
            } else if (context.isLoading()) {
                this.setLoaded(1);
            } else {
                this.setLoaded(2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void documentLoading(ViewerContext context) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.activeContext != context) {
                return;
            }
            this.setLoaded(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void documentLoaded(ViewerContext context) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.activeContext != context) {
                return;
            }
            this.setLoaded(context.canReload() ? 2 : 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addressChanged(ViewerContext context, String address) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.activeContext != context) {
                return;
            }
            this.setAddress(address);
        }
    }

    public void titleChanged(ViewerContext context, String title) {
    }

    public void statusChanged(ViewerContext context, String status) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void historyChanged(ViewerContext context) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.activeContext != context) {
                return;
            }
            if (this.buttons[0] != null) {
                this.buttons[0].setEnabled(context.canBack());
            }
            if (this.buttons[1] != null) {
                this.buttons[1].setEnabled(context.canForward());
            }
        }
    }

    private void setLoaded(int load) {
        if (this.buttons[2] != null) {
            this.buttons[2].setEnabled(load != 0);
        }
        if (this.buttons[3] != null) {
            this.buttons[3].setEnabled(load == 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showPopupMenu(ViewerContext context, Component comp, int index, Bookmark bookmark) {
        PopupMenu popupMenu = this.popupMenu;
        synchronized (popupMenu) {
            if (this.showPopupMenu) {
                return;
            }
            this.popupMenu.removeAll();
            switch (index) {
                case 0: 
                case 1: {
                    Request request = context.getRequest();
                    int num = 0;
                    while (num++ < 20 && (request = index == 0 ? request.getPrevious() : request.getNext()) != null) {
                        String title = request.getDocument().getTitle();
                        if (title == null) {
                            title = "";
                        }
                        MenuItem mi = new MenuItem(title);
                        mi.addActionListener(new MoveActionListener(context, request));
                        this.popupMenu.add(mi);
                    }
                    break;
                }
                case 6: {
                    this.viewer.createBookmarkMenu((Menu)this.popupMenu, true);
                    break;
                }
                case -1: {
                    this.viewer.createBookmarkMenu((Menu)this.popupMenu, bookmark.getBookmarks());
                }
            }
            this.showPopupMenu = true;
            this.popupMenu.show(comp, 0, comp.getSize().height);
        }
    }

    private void goAddress() {
        if (this.textFields[0] == null) {
            return;
        }
        String path = this.textFields[0].getText();
        if (path != null && path.length() > 0) {
            String surl = this.option.getBookmarkManager().resolveShortcut(path);
            if (surl != null) {
                this.viewer.open(surl);
            } else {
                this.viewer.open(path);
            }
        }
    }

    private class BookmarkListener
    extends MouseAdapter
    implements StateListener {
        private Bookmark bookmark;
        private boolean folder;

        private BookmarkListener(Bookmark bookmark) {
            this.bookmark = bookmark;
            boolean bl = this.folder = bookmark.getType() == 1;
            if (ViewerToolbar.this.popupMenu == null) {
                ViewerToolbar.this.popupMenu = new PopupMenu();
                ViewerToolbar.this.add(ViewerToolbar.this.popupMenu);
            }
        }

        public void mouseClicked(MouseEvent e) {
            URL url;
            if (this.folder || !e.getComponent().isEnabled()) {
                return;
            }
            if ((e.getModifiers() & 0x10) == 16 && (url = this.bookmark.getURL()) != null) {
                ViewerToolbar.this.viewer.open(url);
            }
        }

        public void stateChanged(StateEvent e) {
            if (!this.folder) {
                return;
            }
            if (((ImageButton)e.getComponent()).getState() == 2) {
                ViewerToolbar.this.showPopupMenu(ViewerToolbar.this.activeContext, e.getComponent(), -1, this.bookmark);
            } else {
                ViewerToolbar.this.showPopupMenu = false;
            }
        }
    }

    private class AddressBarFocusListener
    implements FocusListener {
        private AddressBarFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            TextField c = (TextField)e.getSource();
            c.setCaretPosition(c.getText().length());
            c.selectAll();
        }

        public void focusLost(FocusEvent e) {
            TextField c = (TextField)e.getSource();
            c.select(0, 0);
        }
    }

    private class AddressBarKeyListener
    extends KeyAdapter {
        private AddressBarKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                e.consume();
                ViewerToolbar.this.goAddress();
            }
        }
    }

    private class MoveActionListener
    implements ActionListener {
        private ViewerContext context;
        private Request request;

        private MoveActionListener(ViewerContext context, Request request) {
            this.context = context;
            this.request = request;
        }

        public void actionPerformed(ActionEvent e) {
            this.context.load(this.request);
        }
    }

    private class ButtonStateListener
    implements StateListener {
        private int index;
        private int downState;

        private ButtonStateListener(int index) {
            this.index = index;
            if (ViewerToolbar.this.popupMenu == null) {
                ViewerToolbar.this.popupMenu = new PopupMenu();
                ViewerToolbar.this.add(ViewerToolbar.this.popupMenu);
            }
            switch (index) {
                case 0: 
                case 1: {
                    this.downState = 5;
                    break;
                }
                case 6: {
                    this.downState = 2;
                }
            }
        }

        public void stateChanged(StateEvent e) {
            if (((ImageButton)e.getComponent()).getState() == this.downState) {
                ViewerToolbar.this.showPopupMenu(ViewerToolbar.this.activeContext, e.getComponent(), this.index, null);
            } else {
                ViewerToolbar.this.showPopupMenu = false;
            }
        }
    }

    private class ButtonMouseListener
    extends MouseAdapter {
        private int index;

        private ButtonMouseListener(int index) {
            this.index = index;
        }

        public void mouseClicked(MouseEvent e) {
            if (!e.getComponent().isEnabled()) {
                return;
            }
            if ((e.getModifiers() & 0x10) == 16) {
                switch (this.index) {
                    case 0: 
                    case 1: {
                        Polygon spot = ((ImageButton)e.getComponent()).getHotspotArea();
                        if (spot == null || !spot.contains(e.getX(), e.getY())) break;
                        return;
                    }
                }
                boolean isShift = (e.getModifiers() & 1) != 0;
                switch (this.index) {
                    case 0: {
                        ViewerToolbar.this.viewer.moveHistory(-1, -1);
                        break;
                    }
                    case 1: {
                        ViewerToolbar.this.viewer.moveHistory(-1, 1);
                        break;
                    }
                    case 2: {
                        ViewerToolbar.this.viewer.reload(-1, isShift);
                        break;
                    }
                    case 3: {
                        ViewerToolbar.this.viewer.stop(-1);
                        break;
                    }
                    case 4: {
                        ViewerToolbar.this.goAddress();
                        break;
                    }
                    case 5: {
                        ViewerToolbar.this.viewer.moveHome(-1);
                        break;
                    }
                }
            }
        }
    }
}

