/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.viewer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.MessageBox;
import net.hizlab.kagetaka.download.Download;
import net.hizlab.kagetaka.history.History;
import net.hizlab.kagetaka.history.HistoryManager;
import net.hizlab.kagetaka.java2.WheelListener;
import net.hizlab.kagetaka.java2.WheelWrapper;
import net.hizlab.kagetaka.option.InvalidValueException;
import net.hizlab.kagetaka.option.OptionListener;
import net.hizlab.kagetaka.option.ViewerController;
import net.hizlab.kagetaka.option.ViewerOption;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.EngineListener;
import net.hizlab.kagetaka.rendering.HawkContext;
import net.hizlab.kagetaka.rendering.HawkEngine;
import net.hizlab.kagetaka.rendering.HawkPanel;
import net.hizlab.kagetaka.rendering.Option;
import net.hizlab.kagetaka.rendering.PanelListener;
import net.hizlab.kagetaka.rendering.Request;
import net.hizlab.kagetaka.rendering.RequestList;
import net.hizlab.kagetaka.token.FormItem;
import net.hizlab.kagetaka.util.StringUtils;
import net.hizlab.kagetaka.viewer.Connector;
import net.hizlab.kagetaka.viewer.ContextEventMulticaster;
import net.hizlab.kagetaka.viewer.ContextListener;
import net.hizlab.kagetaka.viewer.ExScrollbar;
import net.hizlab.kagetaka.viewer.HawkViewer;
import net.hizlab.kagetaka.viewer.LocalizedOption;

class ViewerContext
implements HawkContext,
PanelListener,
EngineListener,
OptionListener {
    private static final String RESOURCE = "net.hizlab.kagetaka.viewer.Resource";
    private static Hashtable supportProtocol = new Hashtable();
    private static int tagIndex;
    private ViewerOption option;
    private LocalizedOption localizedOption;
    private Reporter reporter;
    private HistoryManager historyManager;
    private Connector connector;
    private HawkEngine hawkEngine;
    private HawkPanel hawkPanel;
    private RequestList requestList;
    private ContextListener contextListener;
    private HawkViewer hawkViewer;
    private MenuItem[][] appMenu;
    private boolean active;
    private String tag;
    private String statusText;
    private long tabMode;
    private Request viewRequest;
    private Request nextRequest;
    private History viewHistory;

    ViewerContext(ViewerOption option) {
        StringTokenizer st = new StringTokenizer(Resource.getMessage("config.support.protocol", null), ",; ");
        while (st.hasMoreTokens()) {
            supportProtocol.put(st.nextToken(), "");
        }
        this.option = option;
        this.localizedOption = new LocalizedOption(option);
        this.reporter = option.getViewerConsole().getReporter();
        this.historyManager = option.getHistoryManager();
        this.tag = String.valueOf(++tagIndex);
        this.connector = new Connector(this, option);
        this.hawkEngine = new HawkEngine(this);
        this.hawkPanel = new HawkPanel(this, new ExScrollbar(0), new ExScrollbar(1));
        this.requestList = new RequestList();
        this.hawkEngine.setEngineListener(this);
        this.hawkPanel.setPanelListener(this);
        WheelWrapper wheelWrapper = WheelWrapper.getInstance();
        if (wheelWrapper != null) {
            wheelWrapper.addWheelListener(this.hawkPanel.getCanvas(), new WheelListener(){

                public void spin(int type, int value, int modifiers) {
                    if (!ViewerContext.this.option.getPropertyBoolean("mouse.wheel", true)) {
                        return;
                    }
                    if (ViewerContext.this.option.getPropertyBoolean("mouse.wheel.swap", true)) {
                        ViewerContext.this.hawkPanel.scroll(1, type, value);
                    } else {
                        ViewerContext.this.hawkPanel.scroll(2, type, value);
                    }
                }
            });
        }
        this.initContextMenu();
        option.addListener(this);
    }

    private void initContextMenu() {
        Vector items = null;
        Object menu = null;
        MenuItem mi = null;
        NewActionListener listener = null;
        items = this.hawkPanel.getLinkMenuItems();
        listener = new NewActionListener();
        mi = new MenuItem(this.getMessage("contextmenu.opennewwindow", null));
        mi.setActionCommand("open.newwindow");
        mi.addActionListener(listener);
        items.insertElementAt(mi, 0);
        mi = new MenuItem(this.getMessage("contextmenu.opennewtab", null));
        mi.setActionCommand("open.newtab");
        mi.addActionListener(listener);
        items.insertElementAt(mi, 1);
        items.insertElementAt(new MenuItem("-"), 2);
        this.initApplicationMenu();
        this.initToolTip();
    }

    private void initApplicationMenu() {
        Menu menu = null;
        Vector items = null;
        ApplicationActionListener listener = null;
        ViewerOption.Application[] apps = this.option.getApplications();
        if (apps == null || apps.length == 0) {
            if (this.appMenu == null) {
                return;
            }
            items = this.hawkPanel.getMainMenuItems();
            items.removeElement(this.appMenu[0][0]);
            items.removeElement(this.appMenu[0][1]);
            items = this.hawkPanel.getLinkMenuItems();
            items.removeElement(this.appMenu[1][0]);
            items.removeElement(this.appMenu[1][1]);
            this.appMenu = null;
            return;
        }
        String label = this.getMessage("contextmenu.openapp", null);
        if (this.appMenu == null) {
            this.appMenu = new MenuItem[2][2];
        }
        for (int i = 0; i < 2; ++i) {
            switch (i) {
                case 0: {
                    listener = new ApplicationActionListener(0, this.option);
                    items = this.hawkPanel.getMainMenuItems();
                    break;
                }
                case 1: {
                    listener = new ApplicationActionListener(1, this.option);
                    items = this.hawkPanel.getLinkMenuItems();
                }
            }
            if (this.appMenu[i][0] == null) {
                MenuItem menuItem = new MenuItem("-");
                this.appMenu[i][0] = menuItem;
                items.addElement(menuItem);
                Menu menu2 = new Menu(label);
                this.appMenu[i][1] = menu2;
                items.addElement(menu2);
            }
            menu = (Menu)this.appMenu[i][1];
            menu.removeAll();
            for (int j = 0; j < apps.length; ++j) {
                this.createApplicationMenu(apps[j], menu, listener);
            }
        }
    }

    private void initToolTip() {
        this.hawkPanel.setToolTipOption(this.option.getPropertyBoolean("tooltip.browser.use", true), this.option.getPropertyInteger("tooltip.browser.delay", 0), this.option.getPropertyInteger("tooltip.browser.term", 0));
    }

    private void createApplicationMenu(ViewerOption.Application app, Menu parent, ActionListener listener) {
        MenuItem mi = new MenuItem(app.getName());
        mi.setActionCommand(app.getId());
        mi.addActionListener(listener);
        parent.add(mi);
    }

    HawkPanel attachViewer(HawkViewer hawkViewer) {
        this.hawkViewer = hawkViewer;
        this.connector.setOwner(hawkViewer);
        return this.hawkPanel;
    }

    Component getCanvas() {
        return this.hawkPanel.getCanvas();
    }

    void addContextListener(ContextListener l) {
        this.contextListener = ContextEventMulticaster.add(this.contextListener, l);
    }

    void removeContextListener(ContextListener l) {
        this.contextListener = ContextEventMulticaster.remove(this.contextListener, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load(Request request) {
        this.hawkEngine.stop();
        if (request.getDocument() != null && request.postData != null && MessageBox.show(this.hawkViewer, this.getMessage("message.dorepost.text", null), this.getMessage("message.dorepost.title", null), 131073) != 0) {
            return;
        }
        request.setMoved(false);
        ViewerContext viewerContext = this;
        synchronized (viewerContext) {
            if (this.viewRequest != null && this.viewRequest != request && request.useCache >= 2 && StringUtils.sameFile(this.viewRequest.getDocument().url, request.url)) {
                request.copyFrom(this.viewRequest);
                this.changeHistory(request);
                this.movePosition(true);
                this.setStatus(null);
                return;
            }
            this.nextRequest = request;
            this.contextListener.documentLoading(this);
        }
        this.hawkPanel.setCursor(3);
        this.hawkEngine.load(request);
    }

    void setActived(boolean active) {
        this.active = active;
        if (active) {
            Request request = this.viewRequest;
            this.contextListener.activeChanged(this);
            if (request != null) {
                Document document = request.getDocument();
                this.setViewerTitle(document.getTitle());
                this.setViewerAddress(document.url.toString());
            } else {
                this.setViewerTitle(null);
                this.setViewerAddress(null);
            }
            this.setViewerStatus(this.statusText);
        }
    }

    Request getRequest() {
        return this.viewRequest;
    }

    boolean isLoading() {
        return this.nextRequest != null;
    }

    String getTitle() {
        if (this.viewRequest == null) {
            return "";
        }
        String title = this.viewRequest.getDocument().getTitle();
        return title != null ? title : "";
    }

    URL getURL() {
        return this.viewRequest != null ? this.viewRequest.url : null;
    }

    String getTag() {
        return this.tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void repostLoadEvent() {
        ViewerContext viewerContext = this;
        synchronized (viewerContext) {
            if (this.nextRequest != null) {
                this.contextListener.documentLoading(this);
            } else {
                this.contextListener.documentLoaded(this);
            }
        }
    }

    long getTabMode() {
        return this.tabMode;
    }

    void addTabMode(long mode) {
        this.tabMode |= mode;
    }

    void removeTabMode(long mode) {
        this.tabMode &= mode ^ 0xFFFFFFFFFFFFFFFFL;
    }

    void back(int num) {
        Request r;
        Request request = this.viewRequest;
        while (num-- > 0 && (r = request.getPrevious()) != null) {
            request = r;
        }
        if (request != this.viewRequest) {
            this.load(request);
        }
    }

    void forward(int num) {
        Request r;
        Request request = this.viewRequest;
        while (num-- > 0 && (r = request.getNext()) != null) {
            request = r;
        }
        if (request != this.viewRequest) {
            this.load(request);
        }
    }

    void dispose() {
        this.hawkEngine.dispose();
    }

    public Reporter getReporter() {
        return this.reporter;
    }

    public Toolkit getToolkit() {
        return this.hawkPanel.getToolkit();
    }

    public void openHawk(Request request) {
        String protocol = request.url.getProtocol();
        if (!supportProtocol.containsKey(protocol)) {
            MessageBox.show(this.hawkViewer, this.getMessage("message.unknownprotocol.text", new String[]{protocol}), this.getMessage("message.unknownprotocol.title", null), 65536);
            return;
        }
        this.hawkViewer.open(request);
    }

    public URLConnection getURLConnection(Request request) throws IOException, InterruptedException {
        return this.connector.getURLConnection(request);
    }

    public void download(Document document, URLConnection connection) {
        Download.show(this.hawkViewer, this.option, connection, null);
    }

    public Image createImage(ImageProducer producer) {
        return this.hawkPanel.createImage(producer);
    }

    public Image createImage(int width, int height) {
        return this.hawkPanel.createImage(width, height);
    }

    public MediaTracker getMediaTracker() {
        return this.hawkPanel.getMediaTracker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImage(Image image, int width, int height) {
        this.hawkPanel.addImage(image, width, height);
        ViewerContext viewerContext = this;
        synchronized (viewerContext) {
            this.movePosition(false);
        }
    }

    public void addFormItem(FormItem item) {
        this.hawkPanel.addFormItem(item);
    }

    public void setupCanvas(Request request) {
        String title = request.getDocument().getTitle();
        this.viewHistory.setTitle(title);
        this.setViewerTitle(title);
        this.hawkPanel.setupCanvas(request);
    }

    public void repaint(int x, int y, int width, int height) {
        this.hawkPanel.repaintCanvas(x, y, width, height);
    }

    public void setStatus(String status) {
        this.statusText = status;
        this.setViewerStatus(status);
    }

    public void setTemporaryStatus(String status) {
        this.setViewerStatus(status != null ? status : this.statusText);
    }

    public Dimension getViewportSize() {
        return this.hawkPanel.getViewportSize();
    }

    public Option getOption() {
        return this.localizedOption;
    }

    public boolean haveEverVisited(URL url) {
        return this.historyManager.contains(url.toString());
    }

    public void setCookie(String value, URL url) {
        this.connector.setCookie(value, url);
    }

    public void back() {
        this.back(1);
    }

    public boolean canBack() {
        return this.viewRequest != null && this.viewRequest.getPrevious() != null;
    }

    public void forward() {
        this.forward(1);
    }

    public boolean canForward() {
        return this.viewRequest != null && this.viewRequest.getNext() != null;
    }

    public void reload(boolean force) {
        if (this.viewRequest != null) {
            this.load(this.viewRequest);
        }
    }

    public boolean canReload() {
        return this.viewRequest != null;
    }

    public void stop() {
        this.hawkEngine.stop();
    }

    public boolean canStop() {
        return this.hawkEngine.isLoading();
    }

    public void connecting(Request request) {
    }

    public synchronized void connected(Request request, boolean noerror) {
    }

    public synchronized void renderingSkipped(Request request) {
        if (this.nextRequest != request) {
            return;
        }
        this.nextRequest = null;
        this.hawkPanel.setCursor(0);
        this.contextListener.documentLoaded(this);
    }

    public synchronized void renderingStarted(Request request) {
        if (this.nextRequest != request) {
            return;
        }
        this.changeHistory(request);
        this.hawkPanel.requestFocus();
    }

    public synchronized void renderingStopped(Request request, boolean noerror) {
        if (this.nextRequest != request) {
            return;
        }
        this.renderingSkipped(request);
        this.movePosition(true);
    }

    public synchronized void refresh(Request baseRequest, Request newRequest) {
        if (this.viewRequest != baseRequest) {
            return;
        }
        this.load(newRequest);
    }

    public void propertyChange(ViewerOption option, String key, Object oldValue, Object newValue) throws InvalidValueException {
    }

    public void propertiesChanged(ViewerOption option, ViewerController c, Enumeration list) {
        while (list.hasMoreElements()) {
            String key = (String)list.nextElement();
            if (key.startsWith("app.")) {
                this.initApplicationMenu();
                return;
            }
            if (key.compareTo("tooltip.browser.use") != 0 && key.compareTo("tooltip.browser.delay") != 0 && key.compareTo("tooltip.browser.term") != 0) continue;
            this.initToolTip();
        }
    }

    private void changeHistory(Request request) {
        if (this.viewRequest != null) {
            this.viewRequest.setPosition(this.hawkPanel.getScrollPosition());
        }
        if (!request.isMember()) {
            this.requestList.append(this.viewRequest, request);
        }
        this.viewRequest = request;
        this.viewHistory = this.historyManager.visited(request.url.toString());
        this.setViewerAddress(request.getDocument().url.toString());
    }

    private void movePosition(boolean force) {
        if (this.viewRequest.isMoved()) {
            return;
        }
        Point position = this.viewRequest.getPosition();
        if (position != null) {
            Point scpos = this.hawkPanel.getScrollPosition();
            if ((force || scpos.x == 0 && scpos.y == 0) && !this.hawkPanel.setScrollPosition(position.x, position.y, false)) {
                return;
            }
        } else if (!this.hawkPanel.setScrollPosition(this.viewRequest.getDocument().url.getRef(), force)) {
            return;
        }
        this.viewRequest.setMoved(true);
    }

    private String getMessage(String key, String[] args) {
        return Resource.getMessage(RESOURCE, key, args);
    }

    private void setViewerTitle(String title) {
        this.contextListener.titleChanged(this, title);
    }

    private void setViewerAddress(String address) {
        this.contextListener.addressChanged(this, address);
        this.contextListener.historyChanged(this);
    }

    private void setViewerStatus(String status) {
        this.contextListener.statusChanged(this, status);
    }

    private class ApplicationActionListener
    implements ActionListener {
        private static final int MAIN = 0;
        private static final int LINK = 1;
        private int type;
        private ViewerOption option;

        private ApplicationActionListener(int type, ViewerOption option) {
            this.type = type;
            this.option = option;
        }

        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            ViewerOption.Application[] apps = this.option.getApplications();
            if (apps == null) {
                return;
            }
            for (int i = 0; i < apps.length; ++i) {
                URL url;
                ViewerOption.Application app = apps[i];
                if (command.compareTo(app.getId()) != 0) continue;
                URL uRL = this.type == 0 ? (ViewerContext.this.viewRequest != null ? ((ViewerContext)ViewerContext.this).viewRequest.url : null) : (url = ViewerContext.this.hawkPanel.getSelectedLink());
                if (url == null) {
                    return;
                }
                StringBuffer path = new StringBuffer();
                try {
                    app.exec(url, path);
                    continue;
                }
                catch (IOException ex) {
                    MessageBox.show(ViewerContext.this.hawkViewer, ViewerContext.this.getMessage("message.appnotopen.text", new String[]{path.toString(), url.toString(), ex.toString()}), ViewerContext.this.getMessage("message.appnotopen.title", null), 65536);
                }
            }
        }
    }

    private class NewActionListener
    implements ActionListener {
        private static final String WINDOW = "open.newwindow";
        private static final String TAB = "open.newtab";

        private NewActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            URL referer;
            String command = e.getActionCommand();
            URL url = ViewerContext.this.hawkPanel.getSelectedLink();
            if (url == null) {
                return;
            }
            URL uRL = referer = ViewerContext.this.viewRequest != null ? ((ViewerContext)ViewerContext.this).viewRequest.getDocument().url : null;
            if (WINDOW.compareTo(command) == 0) {
                ViewerContext.this.openHawk(new Request(url, null, referer, null, true, false, 2));
            } else if (TAB.compareTo(command) == 0) {
                ViewerContext.this.openHawk(new Request(url, null, referer, null, false, true, 2));
            }
        }
    }
}

