/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.viewer;

import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.option.ViewerOption;

public class ViewerConsole {
    private ViewerReporter reporter;
    private ViewerOption option;
    private int currentLevel;

    public ViewerConsole(ViewerOption option) {
        this.option = option;
        this.reporter = new ViewerReporter();
        this.currentLevel = option.getPropertyInteger("log.level", 10);
    }

    Reporter getReporter() {
        return this.reporter;
    }

    private class ViewerReporter
    implements Reporter {
        private ViewerReporter() {
        }

        public void report(int level, String message, int line, int column) {
            if (level < ViewerConsole.this.currentLevel) {
                return;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("#");
            switch (level) {
                case 10: {
                    sb.append("ERROR");
                    break;
                }
                case 7: {
                    sb.append("WARNING");
                    break;
                }
                default: {
                    sb.append("MESSAGE");
                }
            }
            sb.append(":");
            sb.append(line);
            sb.append(":");
            sb.append(column);
            sb.append(":");
            sb.append(message);
            System.out.println(sb.toString());
        }

        public int getLevel() {
            return ViewerConsole.this.currentLevel;
        }
    }
}

