/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.viewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.ColorConverter;
import net.hizlab.kagetaka.awt.ImageButton;
import net.hizlab.kagetaka.awt.LayoutUtils;
import net.hizlab.kagetaka.awt.MessageBox;
import net.hizlab.kagetaka.awt.StatusBar;
import net.hizlab.kagetaka.awt.TabbedContainer;
import net.hizlab.kagetaka.awt.event.TabEvent;
import net.hizlab.kagetaka.awt.event.TabListener;
import net.hizlab.kagetaka.bookmarks.Bookmark;
import net.hizlab.kagetaka.bookmarks.BookmarkAs;
import net.hizlab.kagetaka.bookmarks.BookmarkManager;
import net.hizlab.kagetaka.history.HistoryManager;
import net.hizlab.kagetaka.java2.DnDListener;
import net.hizlab.kagetaka.java2.DnDWrapper;
import net.hizlab.kagetaka.option.InvalidValueException;
import net.hizlab.kagetaka.option.Setter;
import net.hizlab.kagetaka.option.ViewerOption;
import net.hizlab.kagetaka.rendering.Request;
import net.hizlab.kagetaka.theme.Theme;
import net.hizlab.kagetaka.theme.ThemeListener;
import net.hizlab.kagetaka.theme.ThemeManager;
import net.hizlab.kagetaka.util.Environment;
import net.hizlab.kagetaka.util.StringUtils;
import net.hizlab.kagetaka.util.windows.Shortcut;
import net.hizlab.kagetaka.viewer.ContextListener;
import net.hizlab.kagetaka.viewer.HawkWindow;
import net.hizlab.kagetaka.viewer.OpenDialog;
import net.hizlab.kagetaka.viewer.ViewerContext;
import net.hizlab.kagetaka.viewer.ViewerMenu;
import net.hizlab.kagetaka.viewer.ViewerToolbar;
import net.hizlab.kagetaka.viewer.WindowManager;

public class HawkViewer
extends Frame
implements HawkWindow {
    private static final String RESOURCE = "net.hizlab.kagetaka.viewer.Resource";
    private static final Dimension MINIMUM_SIZE = new Dimension(100, 70);
    private static final String URL_FILE_PROTOCOL = "file";
    private static final String URL_FILE_SCHEME = "file:/";
    public static final int CURRENT_TAB = -1;
    public static final int ALL_TAB = -2;
    public static final int LEFTALL_TAB = -3;
    public static final int RIGHTALL_TAB = -4;
    public static final int OTHERALL_TAB = -5;
    public static final int TOP_TAB = -6;
    public static final int LAST_TAB = -7;
    public static final int COMPONENT_NAVIBAR = 1;
    public static final int COMPONENT_SEARCHBAR = 2;
    public static final int COMPONENT_LINKBAR = 3;
    public static final int COMPONENT_STATUSBAR = 4;
    public static final int REFERER_SAMEHOST = 0;
    public static final int REFERER_NONE = -1;
    public static final int REFERER_ALL = -2;
    public static final long TAB_MODE_LOCK = 1L;
    private static Vector windowListeners = new Vector();
    private ViewerOption option;
    private WindowManager windowManager;
    private BookmarkManager bookmarkManager;
    private HistoryManager historyManager;
    private ThemeManager themeManager;
    private Theme theme;
    private ViewerMenu viewerMenu;
    private GridBagLayout gbl;
    private Insets insets;
    private ViewerToolbar naviBar;
    private ViewerToolbar linkBar;
    private TabbedContainer mainPanel;
    private StatusBar statusBar;
    private ViewerContextListener contextListener;
    private DnDWrapper dndWrapper;
    private DnDListener dndListener;
    private String titleMain = null;
    private String titleSuffix = null;
    private String statusText = null;
    private Vector contexts = new Vector();
    private Hashtable contextHash = new Hashtable();
    private ViewerContext context;
    private int tabContextIndex = -1;

    public HawkViewer(ViewerOption option) {
        this.option = option;
        this.windowManager = WindowManager.getInstance();
        this.bookmarkManager = option.getBookmarkManager();
        this.historyManager = option.getHistoryManager();
        this.themeManager = option.getThemeManager();
        this.theme = this.themeManager.getTheme();
        this.viewerMenu = new ViewerMenu(this);
        this.mainPanel = new TabbedContainer();
        this.contextListener = new ViewerContextListener();
        this.setTitleSuffix(this.getMessage("title", null));
        Image image = Resource.getImageResource(RESOURCE, "icon", this.getToolkit());
        if (image != null) {
            this.setIconImage(image);
        }
        this.gbl = new GridBagLayout();
        this.insets = new Insets(0, 0, 0, 0);
        this.setLayout(this.gbl);
        LayoutUtils.addGridBag(this, new MenuPanel(), this.gbl, 0, 0, 1, 1, 1.0, 0.0, 1, 10, this.insets);
        LayoutUtils.addGridBag(this, this.mainPanel, this.gbl, 0, 3, 1, 1, 1.0, 1.0, 1, 10, this.insets);
        if (option.getPropertyBoolean("show.navibar", true)) {
            this.setVisibleComponent(1, true);
        }
        if (option.getPropertyBoolean("show.linkbar", true)) {
            this.setVisibleComponent(3, true);
        }
        if (option.getPropertyBoolean("show.statusbar", true)) {
            this.setVisibleComponent(4, true);
        }
        this.validate();
        ((Component)this).setSize(option.getPropertyDimension("window.size"));
        Point position = option.getPropertyPoint("window.position");
        if (position != null) {
            ((Component)this).setLocation(position);
        } else {
            Dimension size = this.getSize();
            Dimension desktopSize = this.getToolkit().getScreenSize();
            ((Component)this).setLocation((desktopSize.width - size.width) / 2, (desktopSize.height - size.height) / 2);
        }
        this.addWindowListener(new MainWindowListener());
        for (int i = 0; i < windowListeners.size(); ++i) {
            this.addWindowListener((WindowListener)windowListeners.elementAt(i));
        }
        this.mainPanel.addTabListener(new MainPanelTabListener());
        this.mainPanel.addTabMouseListener(new MainPanelTabMouseListener());
        this.dndWrapper = DnDWrapper.getInstance();
        if (this.dndWrapper != null) {
            this.dndListener = new DnDListener(){

                public boolean isActive() {
                    return true;
                }

                public void drop(String data) {
                    HawkViewer.this.open(data.trim());
                }
            };
            this.dndWrapper.addDnDListener(this, this.dndListener);
        }
        this.themeManager.addListener(new ThemeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void themeChanged(Theme theme) {
                HawkViewer.this.theme = theme;
                HawkViewer.this.applyTheme();
                if (HawkViewer.this.naviBar != null) {
                    HawkViewer.this.changeVisibleComponent(1, false);
                    HawkViewer.this.changeVisibleComponent(1, true);
                }
                if (HawkViewer.this.linkBar != null) {
                    HawkViewer.this.changeVisibleComponent(3, false);
                    HawkViewer.this.changeVisibleComponent(3, true);
                }
                Vector vector = HawkViewer.this.contexts;
                synchronized (vector) {
                    for (int i = 0; i < HawkViewer.this.contexts.size(); ++i) {
                        ((ViewerContext)HawkViewer.this.contexts.elementAt(i)).repostLoadEvent();
                    }
                }
                HawkViewer.this.validate();
            }
        });
        this.applyTheme();
        this.createTab(-6, true);
    }

    public static void addDefaultWindowListener(WindowListener listener) {
        windowListeners.addElement(listener);
    }

    public static void removeDefaultWindowListener(WindowListener listener) {
        windowListeners.removeElement(listener);
    }

    public synchronized void setTitleSuffix(String suffix) {
        this.titleSuffix = suffix;
        this.setTitle(this.titleMain);
    }

    public ViewerOption getOption() {
        return this.option;
    }

    public void open(Request request) {
        if (request.isNewWindow) {
            this.createWindow().open(-1, request);
        } else if (request.isExtension) {
            this.open(this.createTab(-1, false), request);
        } else {
            this.open(-1, request);
        }
    }

    public void open(int index, Request request) {
        if (this.naviBar != null && (this.naviBar.getAddress() == null || this.naviBar.getAddress().length() == 0)) {
            this.naviBar.setAddress(request.url.toString());
        }
        ViewerContext[] contextList = this.getContexts(index);
        for (index = 0; index < contextList.length; ++index) {
            contextList[index].load(request);
        }
    }

    public void open(URL url) {
        this.open(-1, url);
    }

    public void open(int index, URL url) {
        this.open(index, new Request(url, null, null, null, false, false, 1));
    }

    public void open(String path) {
        this.open(-1, path);
    }

    public void open(int index, String path) {
        if (path == null) {
            return;
        }
        URL url = null;
        try {
            String realPath;
            String filePath;
            url = StringUtils.toURL(path);
            if (url.getProtocol().compareTo(URL_FILE_PROTOCOL) == 0 && Environment.isWindows && (filePath = url.toString().substring(URL_FILE_SCHEME.length())).indexOf(63) == -1 && filePath.indexOf(35) == -1 && (realPath = Shortcut.resolve(filePath)) != null) {
                url = StringUtils.toURL(realPath);
            }
        }
        catch (MalformedURLException e) {
            MessageBox.show(this, this.getMessage("message.invalidurl.text", new String[]{path, e.toString()}), this.getMessage("message.invalidurl.title", null), 65536);
            return;
        }
        this.open(index, url);
    }

    public void saveOption() {
        this.option.save();
    }

    public String getAddress() {
        if (this.naviBar == null) {
            return null;
        }
        return this.naviBar.getAddress();
    }

    public void showAddress(String address) {
        if (this.naviBar != null) {
            this.naviBar.setAddress(address);
        }
    }

    public void showStatus(String status) {
        if (this.statusBar != null) {
            this.statusBar.setText(status);
        }
    }

    public boolean isVisibleComponent(int target) {
        switch (target) {
            case 1: {
                return this.naviBar != null;
            }
            case 2: {
                return false;
            }
            case 3: {
                return this.linkBar != null;
            }
            case 4: {
                return this.statusBar != null;
            }
        }
        return false;
    }

    public void setVisibleComponent(int target, boolean b) {
        if (this.isVisibleComponent(target) == b) {
            return;
        }
        this.changeVisibleComponent(target, b);
        this.validate();
        this.viewerMenu.changeVisibleComponent(target, b);
        Setter setter = this.option.getSetter();
        try {
            switch (target) {
                case 1: {
                    setter.putPropertyBoolean("show.navibar", b);
                    break;
                }
                case 2: {
                    setter.putPropertyBoolean("show.searchbar", b);
                    break;
                }
                case 3: {
                    setter.putPropertyBoolean("show.linkbar", b);
                    break;
                }
                case 4: {
                    setter.putPropertyBoolean("show.statusbar", b);
                }
            }
            setter.commit();
        }
        catch (InvalidValueException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveTab() {
        Vector vector = this.contexts;
        synchronized (vector) {
            if (this.context == null) {
                return -1;
            }
            return this.contexts.indexOf(this.context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveTab(int index) {
        Vector vector = this.contexts;
        synchronized (vector) {
            ViewerContext c = (ViewerContext)this.contexts.elementAt(index);
            if (c == this.context) {
                return;
            }
            try {
                this.mainPanel.setActivePanel(c.getTag());
            }
            catch (IllegalArgumentException e) {
                return;
            }
            if (this.context != null) {
                this.context.setActived(false);
            }
            this.context = c;
            this.context.setActived(true);
        }
    }

    public void addTabMode(int index, long mode) {
        ViewerContext[] contextList = this.getContexts(index);
        for (index = 0; index < contextList.length; ++index) {
            contextList[index].addTabMode(mode);
        }
        this.viewerMenu.changeTabMode(this.context);
    }

    public void removeTabMode(int index, long mode) {
        ViewerContext[] contextList = this.getContexts(index);
        for (index = 0; index < contextList.length; ++index) {
            contextList[index].removeTabMode(mode);
        }
        this.viewerMenu.changeTabMode(this.context);
    }

    int getTabContextIndex() {
        return this.tabContextIndex;
    }

    public void createBookmarkMenu(Menu menu, boolean tool) {
        this.viewerMenu.createBookmarkMenu(menu, tool);
    }

    public void createBookmarkMenu(Menu menu, Vector bookmarks) {
        this.viewerMenu.createBookmarkMenu(menu, bookmarks);
    }

    public void show() {
        Dimension size1 = this.getSize();
        super.show();
        Dimension size2 = this.getSize();
        if (!size1.equals(size2)) {
            Environment.windowSizeOffset = new Dimension(size2.width - size1.width, size2.height - size1.height);
        }
    }

    public Dimension getMinimumSize() {
        return MINIMUM_SIZE;
    }

    public synchronized void setTitle(String title) {
        this.titleMain = title;
        if (this.titleMain == null && this.titleSuffix == null) {
            super.setTitle(null);
        } else if (this.titleMain == null) {
            super.setTitle(this.titleSuffix);
        } else if (this.titleSuffix == null) {
            super.setTitle(this.titleMain);
        } else {
            super.setTitle(this.titleMain + " - " + this.titleSuffix);
        }
        this.windowManager.changeWindow(this);
    }

    public void update(Graphics g) {
        ((Container)this).paint(g);
    }

    public void dispose() {
        super.dispose();
    }

    protected String paramString() {
        String str = super.paramString();
        if (this.titleSuffix != null) {
            str = str + ",suffix=" + this.titleSuffix;
        }
        return str;
    }

    public HawkViewer createWindow() {
        Point location = this.getLocationOnScreen();
        location.x += 32;
        location.y += 32;
        Dimension desktopSize = this.getToolkit().getScreenSize();
        if (desktopSize.width <= location.x || desktopSize.height <= location.y) {
            location.y = 0;
            location.x = 0;
        }
        Dimension size = this.getSize();
        size.width -= Environment.windowSizeOffset.width;
        size.height -= Environment.windowSizeOffset.height;
        HawkViewer hawkWindow = new HawkViewer(this.option);
        ((Component)hawkWindow).setLocation(location);
        hawkWindow.show();
        return hawkWindow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createTab(int index, boolean active) {
        ViewerContext c = new ViewerContext(this.option);
        c.addContextListener(this.contextListener);
        c.addContextListener(this.viewerMenu);
        c.addContextListener(this.naviBar);
        c.addContextListener(this.linkBar);
        if (this.dndWrapper != null) {
            this.dndWrapper.addDnDListener(c.getCanvas(), this.dndListener);
        }
        String tag = c.getTag();
        Vector vector = this.contexts;
        synchronized (vector) {
            switch (index) {
                case -1: {
                    index = this.contexts.indexOf(this.context) + 1;
                    break;
                }
                case -6: {
                    index = 0;
                    break;
                }
                case -7: {
                    index = -1;
                }
            }
            if (index < 0 || this.contexts.size() < index) {
                index = this.contexts.size();
            }
            this.contexts.insertElementAt(c, index);
            this.contextHash.put(tag, c);
            if (index <= this.tabContextIndex) {
                ++this.tabContextIndex;
            }
            this.mainPanel.addPanel(tag, c.getTitle(), this.theme.getImage("browser.tab.icon.normal", this.getToolkit()), c.attachViewer(this), active, index);
            if (active || this.contexts.size() == 1) {
                if (this.context != null) {
                    this.context.setActived(false);
                }
                this.context = c;
                this.context.setActived(true);
            }
        }
        return index;
    }

    public void openURL(int index) {
        String path = null;
        OpenDialog dialog = new OpenDialog(this);
        dialog.show();
        if (dialog.getResult() == 0 && (path = dialog.getPath()) != null && path.length() == 0) {
            path = null;
        }
        dialog.dispose();
        if (path != null) {
            this.open(index, path);
        }
    }

    public void openFile(int index) {
        FileDialog fd = new FileDialog((Frame)this, this.getMessage("dialog.file.open", null), 0);
        fd.show();
        String path = fd.getFile();
        if (path == null) {
            fd.dispose();
            return;
        }
        path = (fd.getDirectory() != null ? fd.getDirectory() : "") + path;
        fd.dispose();
        this.open(index, URL_FILE_SCHEME + path);
    }

    public void closeWindow() {
        Point position = this.getLocation();
        if (position.x >= 0 || position.y >= 0) {
            Dimension size = this.getSize();
            size.width -= Environment.windowSizeOffset.width;
            size.height -= Environment.windowSizeOffset.height;
            Setter setter = this.option.getSetter();
            try {
                setter.putPropertyPoint("window.position", position);
                setter.putPropertyDimension("window.size", size);
                setter.commit();
            }
            catch (InvalidValueException e) {
                // empty catch block
            }
        }
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeTab(int index) {
        boolean needCreate = false;
        Vector vector = this.contexts;
        synchronized (vector) {
            ViewerContext[] contextList = this.getContexts(index);
            if (contextList.length == 0) {
                return;
            }
            int activeIndex = 0;
            if (this.context != null) {
                activeIndex = Math.max(this.contexts.indexOf(this.context), 0);
            }
            for (index = 0; index < contextList.length; ++index) {
                String key;
                ViewerContext c = contextList[index];
                if ((c.getTabMode() & 1L) != 0L || !this.contextHash.containsKey(key = c.getTag())) continue;
                this.mainPanel.removePanel(key);
                int i = this.contexts.indexOf(c);
                if (i < this.tabContextIndex) {
                    --this.tabContextIndex;
                } else if (i == this.tabContextIndex) {
                    this.tabContextIndex = -1;
                }
                if (i <= activeIndex) {
                    --activeIndex;
                }
                c.dispose();
                this.contexts.removeElementAt(i);
                this.contextHash.remove(key);
            }
            if (this.contexts.size() > 0) {
                this.setActiveTab(Math.max(activeIndex, 0));
            } else {
                needCreate = true;
            }
        }
        if (needCreate) {
            this.createTab(-6, true);
        }
    }

    public void exitViewer() {
        this.windowManager.exit();
    }

    public void stop(int index) {
        ViewerContext[] contextList = this.getContexts(index);
        for (index = 0; index < contextList.length; ++index) {
            contextList[index].stop();
        }
    }

    public void reload(int index, boolean force) {
        ViewerContext[] contextList = this.getContexts(index);
        for (index = 0; index < contextList.length; ++index) {
            contextList[index].reload(force);
        }
    }

    public void moveHistory(int index, int num) {
        boolean forward = num > 0;
        num = Math.abs(num);
        ViewerContext[] contextList = this.getContexts(index);
        for (index = 0; index < contextList.length; ++index) {
            if (forward) {
                contextList[index].forward(num);
                continue;
            }
            contextList[index].back(num);
        }
    }

    public void moveHome(int index) {
        String home = this.option.getPropertyString("url.home");
        if (home == null || home.length() == 0) {
            home = "about:blank";
        }
        this.open(index, home);
    }

    public void showHistoryEditor() {
        this.historyManager.showEditor();
    }

    public void addBookmark(int index) {
        ViewerContext[] contextList = this.getContexts(index);
        for (index = 0; index < contextList.length; ++index) {
            Request request = contextList[index].getRequest();
            if (request == null) continue;
            Bookmark bookmark = new Bookmark(request.getDocument().getTitle(), request.url);
            Bookmark parent = this.bookmarkManager.getRootBookmark();
            parent.addBookmark(bookmark);
            this.windowManager.addToBookmark(parent, bookmark);
        }
        this.bookmarkManager.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBookmarkAs(int index) {
        ViewerContext[] contextList = this.getContexts(index);
        for (index = 0; index < contextList.length; ++index) {
            BookmarkAs.Entry[] entries;
            Request request = contextList[index].getRequest();
            if (request == null || (entries = BookmarkAs.show(this, this.option, request.getDocument().getTitle(), request.url.toString())) == null) continue;
            WindowManager windowManager = this.windowManager;
            synchronized (windowManager) {
                for (int i = 0; i < entries.length; ++i) {
                    entries[i].parent.addBookmark(entries[i].bookmark);
                    this.windowManager.addToBookmark(entries[i].parent, entries[i].bookmark);
                }
                continue;
            }
        }
        this.bookmarkManager.save();
    }

    public void showBookmarkEditor() {
        this.bookmarkManager.showEditor();
    }

    public void showOptionManager() {
        this.option.showManager(this);
    }

    public void showAbout() {
        this.createWindow().open(-1, "about:");
    }

    public void addWindowMenu(HawkWindow window) {
        this.viewerMenu.addWindowMenu(window);
    }

    public void removeWindowMenu(int index) {
        this.viewerMenu.removeWindowMenu(index);
    }

    public void changeWindowMenu(int index, HawkWindow window) {
        this.viewerMenu.changeWindowMenu(index, window);
    }

    public void addToBookmark(Bookmark parent, Bookmark bookmark) {
        this.viewerMenu.addToBookmark(parent, bookmark);
        if (this.naviBar != null) {
            this.naviBar.addToBookmark(parent, bookmark);
        }
        if (this.linkBar != null) {
            this.linkBar.addToBookmark(parent, bookmark);
        }
    }

    public void bookmarkChanged() {
        this.viewerMenu.bookmarkChanged();
        if (this.naviBar != null) {
            this.naviBar.bookmarkChanged();
        }
        if (this.linkBar != null) {
            this.linkBar.bookmarkChanged();
        }
    }

    private String getMessage(String key, String[] args) {
        return Resource.getMessage(RESOURCE, key, args);
    }

    private ViewerContext[] getContexts(int index) {
        Vector v;
        block17: {
            v = new Vector();
            try {
                if (index >= 0) {
                    v.addElement(this.contexts.elementAt(index));
                    break block17;
                }
                block1 : switch (index) {
                    case -1: {
                        v.addElement(this.context);
                        break;
                    }
                    case -2: {
                        int i;
                        for (i = 0; i < this.contexts.size(); ++i) {
                            v.addElement(this.contexts.elementAt(i));
                        }
                        break;
                    }
                    case -3: {
                        int i;
                        for (i = 0; i < this.contexts.size(); ++i) {
                            if (this.contexts.elementAt(i) == this.context) break block1;
                            v.addElement(this.contexts.elementAt(i));
                        }
                        break;
                    }
                    case -4: {
                        int current = 0;
                        while (current < this.contexts.size() && this.contexts.elementAt(current++) != this.context) {
                        }
                        for (int i = current; i < this.contexts.size(); ++i) {
                            v.addElement(this.contexts.elementAt(i));
                        }
                        break;
                    }
                    case -5: {
                        int i;
                        for (i = 0; i < this.contexts.size(); ++i) {
                            if (this.contexts.elementAt(i) == this.context) continue;
                            v.addElement(this.contexts.elementAt(i));
                        }
                        break;
                    }
                    case -6: {
                        v.addElement(this.contexts.elementAt(0));
                        break;
                    }
                    case -7: {
                        v.addElement(this.contexts.elementAt(this.contexts.size() - 1));
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                // empty catch block
            }
        }
        Object[] cs = new ViewerContext[v.size()];
        v.copyInto(cs);
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTabContextIndex(Component c) {
        String key = this.mainPanel.getKey(c);
        if (key == null) {
            return -1;
        }
        Vector vector = this.contexts;
        synchronized (vector) {
            for (int i = 0; i < this.contexts.size(); ++i) {
                if (((ViewerContext)this.contexts.elementAt(i)).getTag().compareTo(key) != 0) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeVisibleComponent(int target, boolean b) {
        if (b) {
            switch (target) {
                case 1: {
                    this.naviBar = new ViewerToolbar(this, 1);
                    Vector vector = this.contexts;
                    synchronized (vector) {
                        for (int i = 0; i < this.contexts.size(); ++i) {
                            ((ViewerContext)this.contexts.elementAt(i)).addContextListener(this.naviBar);
                        }
                        if (this.context != null) {
                            this.naviBar.activeChanged(this.context);
                        }
                    }
                    LayoutUtils.addGridBag(this, this.naviBar, this.gbl, 0, 1, 1, 1, 1.0, 0.0, 1, 10, this.insets);
                    break;
                }
                case 2: {
                    return;
                }
                case 3: {
                    this.linkBar = new ViewerToolbar(this, 2);
                    Vector vector = this.contexts;
                    synchronized (vector) {
                        for (int i = 0; i < this.contexts.size(); ++i) {
                            ((ViewerContext)this.contexts.elementAt(i)).addContextListener(this.linkBar);
                        }
                        if (this.context != null) {
                            this.linkBar.activeChanged(this.context);
                        }
                    }
                    LayoutUtils.addGridBag(this, this.linkBar, this.gbl, 0, 2, 1, 1, 1.0, 0.0, 1, 10, this.insets);
                    break;
                }
                case 4: {
                    this.statusBar = new StatusBar();
                    LayoutUtils.addGridBag(this, this.statusBar, this.gbl, 0, 4, 1, 1, 1.0, 0.0, 1, 10, this.insets);
                }
            }
        } else {
            switch (target) {
                case 1: {
                    Vector vector = this.contexts;
                    synchronized (vector) {
                        for (int i = 0; i < this.contexts.size(); ++i) {
                            ((ViewerContext)this.contexts.elementAt(i)).removeContextListener(this.naviBar);
                        }
                    }
                    this.remove(this.naviBar);
                    this.naviBar = null;
                    break;
                }
                case 2: {
                    return;
                }
                case 3: {
                    Vector vector = this.contexts;
                    synchronized (vector) {
                        for (int i = 0; i < this.contexts.size(); ++i) {
                            ((ViewerContext)this.contexts.elementAt(i)).removeContextListener(this.linkBar);
                        }
                    }
                    this.remove(this.linkBar);
                    this.linkBar = null;
                    break;
                }
                case 4: {
                    this.remove(this.statusBar);
                    this.statusBar = null;
                }
            }
        }
    }

    private void applyTheme() {
        ImageButton b2;
        Toolkit tk = this.getToolkit();
        Color c = this.theme.getColor("browser.tab.foreground");
        this.mainPanel.setForeground(c != null ? c : SystemColor.controlText);
        c = this.theme.getColor("browser.tab.background");
        this.mainPanel.setBackground(c != null ? c : SystemColor.control);
        c = this.theme.getColor("browser.tab.focus");
        this.mainPanel.setFocusFrameColor(c != null ? c : SystemColor.windowBorder);
        Font f = this.theme.getFont("browser.tab.active.font");
        this.mainPanel.setActiveTitleFont(f != null ? f : Font.decode("Dialog"));
        c = this.theme.getColor("browser.tab.active.foreground");
        this.mainPanel.setActiveTitleForeground(c != null ? c : SystemColor.controlText);
        c = this.theme.getColor("browser.tab.active.background");
        this.mainPanel.setActiveTitleBackground(c != null ? c : SystemColor.control);
        f = this.theme.getFont("browser.tab.unactive.font");
        this.mainPanel.setUnActiveTitleFont(f != null ? f : Font.decode("Dialog"));
        c = this.theme.getColor("browser.tab.unactive.foreground");
        this.mainPanel.setUnActiveTitleForeground(c != null ? c : SystemColor.controlText);
        c = this.theme.getColor("browser.tab.unactive.background");
        this.mainPanel.setUnActiveTitleBackground(c != null ? c : SystemColor.control);
        ImageButton b1 = this.theme.getImageButton("browser.tab.scrollbar.left", tk);
        if (b1 != null && (b2 = this.theme.getImageButton("browser.tab.scrollbar.right", tk)) != null) {
            this.mainPanel.setTabScrollButton(b1, b2);
        } else {
            this.mainPanel.resetTabScrollButton();
        }
    }

    private class MenuPanel
    extends Component {
        private MenuPanel() {
        }

        public void update(Graphics g) {
            this.paint(g);
        }

        public void paint(Graphics g) {
            Dimension size = this.getSize();
            g.setColor(ColorConverter.getDarker(SystemColor.menu));
            g.drawLine(0, size.height - 1, size.width - 1, size.height - 1);
        }

        public Dimension getPreferredSize() {
            return new Dimension(0, 1);
        }

        public Dimension getMinimumSize() {
            return new Dimension(1, 1);
        }
    }

    private class MainPanelTabMouseListener
    extends MouseAdapter {
        private MainPanelTabMouseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseClicked(MouseEvent e) {
            Vector vector;
            if (e.isPopupTrigger() || (e.getModifiers() & 4) == 4) {
                vector = HawkViewer.this.contexts;
                synchronized (vector) {
                    if ((HawkViewer.this.tabContextIndex = HawkViewer.this.getTabContextIndex(e.getComponent())) == -1) {
                        return;
                    }
                    HawkViewer.this.viewerMenu.showTabPopupMenu(e.getComponent(), e.getX(), e.getY());
                }
            }
            if ((e.getModifiers() & 8) == 8) {
                vector = HawkViewer.this.contexts;
                synchronized (vector) {
                    int index = HawkViewer.this.getTabContextIndex(e.getComponent());
                    if (index == -1) {
                        return;
                    }
                    HawkViewer.this.closeTab(index);
                }
                e.consume();
            }
        }
    }

    private class MainPanelTabListener
    implements TabListener {
        private MainPanelTabListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void activeChanged(TabEvent e) {
            Vector vector = HawkViewer.this.contexts;
            synchronized (vector) {
                if (HawkViewer.this.context != null) {
                    HawkViewer.this.context.setActived(false);
                }
                HawkViewer.this.context = (ViewerContext)HawkViewer.this.contextHash.get(e.getKey());
                HawkViewer.this.context.setActived(true);
            }
        }

        public void tabAdded(TabEvent e) {
        }

        public void tabRemoved(TabEvent e) {
        }

        public void tabChanged(TabEvent e) {
        }
    }

    private class ViewerContextListener
    implements ContextListener {
        private ViewerContextListener() {
        }

        public void activeChanged(ViewerContext context) {
        }

        public void documentLoading(ViewerContext context) {
            HawkViewer.this.mainPanel.setImage(context.getTag(), HawkViewer.this.theme.getImage("browser.tab.icon.loading", HawkViewer.this.getToolkit()));
        }

        public void documentLoaded(ViewerContext context) {
            HawkViewer.this.mainPanel.setImage(context.getTag(), HawkViewer.this.theme.getImage("browser.tab.icon.normal", HawkViewer.this.getToolkit()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addressChanged(ViewerContext context, String address) {
            Vector vector = HawkViewer.this.contexts;
            synchronized (vector) {
                if (HawkViewer.this.context == context) {
                    HawkViewer.this.showAddress(address);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void titleChanged(ViewerContext context, String title) {
            HawkViewer.this.mainPanel.setTitle(context.getTag(), title);
            Vector vector = HawkViewer.this.contexts;
            synchronized (vector) {
                if (HawkViewer.this.context == context) {
                    HawkViewer.this.setTitle(title);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void statusChanged(ViewerContext context, String status) {
            Vector vector = HawkViewer.this.contexts;
            synchronized (vector) {
                if (HawkViewer.this.context == context) {
                    HawkViewer.this.showStatus(status);
                }
            }
        }

        public void historyChanged(ViewerContext context) {
        }
    }

    private class MainWindowListener
    extends WindowAdapter {
        private MainWindowListener() {
        }

        public void windowActivated(WindowEvent e) {
            HawkViewer.this.windowManager.changeActiveViewer(HawkViewer.this);
        }

        public void windowOpened(WindowEvent e) {
            HawkViewer.this.windowManager.addWindow(HawkViewer.this);
        }

        public void windowClosing(WindowEvent e) {
            HawkViewer.this.closeWindow();
        }

        public void windowClosed(WindowEvent e) {
            HawkViewer.this.windowManager.removeWindow(HawkViewer.this);
        }
    }
}

