/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.viewer;

import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.DialogBox;
import net.hizlab.kagetaka.viewer.AuthenticationInfo;

public class AuthorizationDialog
extends DialogBox {
    private static final String RESOURCE = "net.hizlab.kagetaka.viewer.Resource";
    private static final int MARGIN = 3;
    public static final int SERVER = 0;
    public static final int PROXY = 1;
    private Label site;
    private Label realm;
    private int type;
    private TextField username;
    private TextField password;

    public static AuthenticationInfo show(Frame owner, String site, String realm, char atype, int type) {
        AuthorizationDialog dialog = new AuthorizationDialog(owner);
        dialog.setSite(site);
        dialog.setRealm(realm);
        dialog.setType(type);
        dialog.show();
        if (dialog.getResult() != 0) {
            return null;
        }
        return new AuthenticationInfo(realm, atype, dialog.getUsername(), dialog.getPassword());
    }

    public AuthorizationDialog(Frame owner) {
        super(owner, 1);
        this.setTitle(this.getMessage("title." + this.type));
        this.setResizable(false);
        this.setModal(true);
        GridBagLayout gbl = new GridBagLayout();
        Insets insets = new Insets(3, 3, 3, 3);
        this.mainPanel.setLayout(gbl);
        this.addToPanel(new Label(this.getMessage("message")), gbl, 0, 0, 2, 1, 1.0, 0.0, 2, 10, insets);
        this.addToPanel(new Label(this.getMessage("label.site")), gbl, 0, 1, 1, 1, 0.0, 0.0, 2, 10, insets);
        this.site = new Label(this.getMessage(null));
        this.addToPanel(this.site, gbl, 1, 1, 1, 1, 1.0, 0.0, 2, 10, insets);
        this.addToPanel(new Label(this.getMessage("label.realm")), gbl, 0, 2, 1, 1, 0.0, 0.0, 2, 10, insets);
        this.realm = new Label(this.getMessage(null));
        this.addToPanel(this.realm, gbl, 1, 2, 1, 1, 1.0, 0.0, 2, 10, insets);
        this.addToPanel(new Label(this.getMessage("label.username")), gbl, 0, 3, 1, 1, 0.0, 0.0, 2, 10, insets);
        this.username = new TextField(40);
        this.addToPanel(this.username, gbl, 1, 3, 1, 1, 1.0, 0.0, 2, 10, insets);
        this.addToPanel(new Label(this.getMessage("label.password")), gbl, 0, 4, 1, 1, 0.0, 0.0, 2, 10, insets);
        this.password = new TextField(40);
        this.addToPanel(this.password, gbl, 1, 4, 1, 1, 1.0, 0.0, 2, 10, insets);
        this.password.setEchoChar('*');
        this.pack();
    }

    private String getMessage(String key) {
        if (key == null) {
            return "";
        }
        return Resource.getMessage(RESOURCE, "authorizationdialog." + key, null);
    }

    public String getSite() {
        return this.site.getText();
    }

    public void setSite(String value) {
        this.site.setText(value);
    }

    public String getRealm() {
        return this.realm.getText();
    }

    public void setRealm(String value) {
        this.realm.setText(value);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
        this.setTitle(this.getMessage("title." + type));
    }

    public String getUsername() {
        return this.username.getText();
    }

    public void setUsername(String value) {
        ((TextComponent)this.username).setText(value);
    }

    public String getPassword() {
        return this.password.getText();
    }

    public void setPassword(String value) {
        ((TextComponent)this.password).setText(value);
    }
}

