/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;

public class URLEncoder {
    static final int caseDiff = 32;
    static BitSet dontNeedEncoding;

    private URLEncoder() {
    }

    public static String encode(String s, String encoding) {
        int maxBytesPerChar = 10;
        int length = s.length();
        ByteArrayOutputStream out = new ByteArrayOutputStream(length);
        ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
        OutputStreamWriter writer = null;
        if (encoding != null) {
            try {
                writer = new OutputStreamWriter((OutputStream)buf, encoding);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        if (writer == null) {
            writer = new OutputStreamWriter(buf);
        }
        for (int i = 0; i < length; ++i) {
            int c = s.charAt(i);
            if (dontNeedEncoding.get(c)) {
                if (c == 32) {
                    c = 43;
                }
                out.write(c);
                continue;
            }
            try {
                writer.write(c);
                writer.flush();
            }
            catch (IOException e) {
                buf.reset();
                continue;
            }
            byte[] bytes = buf.toByteArray();
            for (int j = 0; j < bytes.length; ++j) {
                out.write(37);
                char ch = Character.forDigit(bytes[j] >> 4 & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.write(ch);
                ch = Character.forDigit(bytes[j] & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.write(ch);
            }
            buf.reset();
        }
        return out.toString();
    }

    static {
        int i;
        dontNeedEncoding = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            dontNeedEncoding.set(i);
        }
        dontNeedEncoding.set(32);
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
    }
}

