/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.util;

import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;

public class TextFormat {
    private static final String RESOURCE = "net.hizlab.kagetaka.util.TextFormat";

    private TextFormat() {
    }

    public static String convertXhtml(String value, boolean before, boolean after, boolean abbr, boolean reference) {
        return TextFormat.convertXhtml(null, 0, 0, value, before, after, abbr, reference);
    }

    public static String convertXhtml(Reporter reporter, int line, int column, String value, boolean before, boolean after, boolean abbr, boolean reference) {
        StringBuffer sb;
        block31: {
            int space;
            block32: {
                int length = value.length();
                sb = new StringBuffer(length);
                StringBuffer ref = null;
                boolean passOne = before;
                space = 0;
                int lf = 0;
                int pos = -1;
                int check = 0;
                block8: for (int i = 0; i < length; ++i) {
                    char c;
                    block30: {
                        c = value.charAt(i);
                        pos = c <= '\u00ff' || '\uff61' <= c && c <= '\uff9f' ? ++pos : (pos += 2);
                        if (reference && c == '&') {
                            check = i;
                            if (ref == null) {
                                ref = new StringBuffer();
                            } else {
                                ref.setLength(0);
                            }
                            while (++i < length && (c = value.charAt(i)) != ';') {
                                ref.append(c);
                            }
                            if (i >= length) {
                                TextFormat.addWarning(reporter, "tf.warning.entity.nosemicolon", null, line + lf, column + pos);
                                i = check;
                                sb.append('&');
                                continue;
                            }
                            if (ref.length() == 0) {
                                TextFormat.addWarning(reporter, "tf.warning.entity.zerolength", null, line + lf, column + pos);
                                i = check;
                                sb.append('&');
                                continue;
                            }
                            if (ref.charAt(0) == '#') {
                                try {
                                    c = TextFormat.referCharacter(ref.toString());
                                    break block30;
                                }
                                catch (NumberFormatException e) {
                                    TextFormat.addWarning(reporter, e.getMessage(), ref.toString(), line + lf, column + pos);
                                    i = check;
                                    sb.append('&');
                                    continue;
                                }
                            }
                            try {
                                c = TextFormat.referEntity(ref.toString());
                            }
                            catch (IllegalArgumentException e) {
                                TextFormat.addWarning(reporter, e.getMessage(), ref.toString(), line + lf, column + pos);
                                i = check;
                                sb.append('&');
                                continue;
                            }
                        }
                    }
                    switch (c) {
                        case '\t': {
                            space += 8;
                            continue block8;
                        }
                        case '\f': 
                        case '\r': 
                        case ' ': 
                        case '\u200b': {
                            ++space;
                            continue block8;
                        }
                        default: {
                            if (c == '\n') {
                                ++lf;
                                pos = -1;
                                if (abbr) {
                                    ++space;
                                    continue block8;
                                }
                            }
                            if (space > 0) {
                                if (abbr) {
                                    space = 1;
                                }
                                if (passOne) {
                                    passOne = false;
                                } else {
                                    while (space-- > 0) {
                                        sb.append(' ');
                                    }
                                }
                                space = 0;
                            } else if (passOne) {
                                passOne = false;
                            }
                            sb.append(c);
                        }
                    }
                }
                if (space <= 0) break block31;
                if (sb.length() <= 0) break block32;
                if (after) break block31;
                if (abbr) {
                    space = 1;
                }
                while (space-- > 0) {
                    sb.append(' ');
                }
                break block31;
            }
            if (!before && !after) {
                if (abbr) {
                    space = 1;
                }
                while (space-- > 0) {
                    sb.append(' ');
                }
            }
        }
        return sb.toString();
    }

    private static char referEntity(String value) throws IllegalArgumentException {
        if ((value = Resource.getMessage(RESOURCE, value, null, null)) != null) {
            return value.charAt(0);
        }
        throw new IllegalArgumentException("tf.warning.entity.invalidentity");
    }

    private static char referCharacter(String value) throws NumberFormatException {
        int base = 10;
        int current = 1;
        int length = value.length() - current;
        if (length == 0) {
            throw new NumberFormatException("tf.warning.entity.zerolength");
        }
        if (value.charAt(current) == 'x') {
            base = 16;
            ++current;
            if (--length == 0) {
                throw new NumberFormatException("tf.warning.entity.zerolength");
            }
            if (length > 4) {
                throw new NumberFormatException("tf.warning.entity.overlength");
            }
        } else if (length > 5) {
            throw new NumberFormatException("tf.warning.entity.overlength");
        }
        int num = 0;
        while (--length >= 0) {
            char c;
            if ('0' <= (c = value.charAt(current++)) && c <= '9') {
                num = (int)((double)num + (double)(c - 48) * Math.pow(base, length));
                continue;
            }
            if (base == 16) {
                if ('A' <= c && c <= 'F') {
                    num = (int)((double)num + (double)(c - 65 + 10) * Math.pow(base, length));
                    continue;
                }
                if ('a' <= c && c <= 'f') {
                    num = (int)((double)num + (double)(c - 97 + 10) * Math.pow(base, length));
                    continue;
                }
            }
            throw new NumberFormatException("tf.warning.entity.invalidchar");
        }
        if (num > 65533) {
            throw new NumberFormatException("tf.warning.entity.invalidref");
        }
        return (char)num;
    }

    public static boolean hasCharacters(String value) {
        int length = value.length();
        block3: for (int i = 0; i < length; ++i) {
            switch (value.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '\u200b': {
                    continue block3;
                }
                default: {
                    return true;
                }
            }
        }
        return false;
    }

    private static void addWarning(Reporter reporter, String key, String arg, int line, int column) {
        if (reporter != null) {
            String[] args = null;
            if (arg != null) {
                args = new String[]{arg};
            }
            reporter.report(7, Resource.getMessage(key, args), line, column);
        }
    }
}

