/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import net.hizlab.kagetaka.util.Environment;

public class StringUtils {
    private StringUtils() {
    }

    public static URL toURL(String text) throws MalformedURLException {
        String path = null;
        if (text.startsWith(".")) {
            path = text;
        } else if (text.startsWith("file:")) {
            path = text.substring(5);
        } else if (Environment.isWindows) {
            if (text.length() >= 3 && text.charAt(1) == ':' || text.startsWith("\\\\")) {
                path = text;
            }
        } else if (text.startsWith("/")) {
            path = text;
        }
        if (path != null) {
            int p;
            for (p = 0; p < path.length() && path.charAt(p) == '/'; ++p) {
            }
            if (p > (Environment.isWindows ? 2 : 1)) {
                if (Environment.isWindows && p >= 5) {
                    p -= 2;
                }
                path = path.substring(p);
            }
            if (Environment.isWindows && path.length() >= 2 && path.charAt(1) == '|') {
                path = path.charAt(0) + ":" + path.substring(2);
            }
            int p1 = path.indexOf(63);
            int p2 = path.indexOf(35);
            String option = null;
            p = p1 != -1 && p2 != -1 ? Math.min(p1, p2) : Math.max(p1, p2);
            if (p != -1) {
                option = path.substring(p);
                path = path.substring(0, p);
            }
            File file = new File(path);
            try {
                path = file.getCanonicalPath().replace('\\', '/');
            }
            catch (IOException e) {
                // empty catch block
            }
            text = path.startsWith("/") ? "file:" + path : "file:/" + path;
            if (option != null) {
                text = text + option;
            }
        } else if (text.indexOf(58) == -1) {
            text = "http://" + text;
        }
        URL url = new URL(text);
        if ("http".compareTo(url.getProtocol()) == 0 && (url.getFile() == null || url.getFile().length() == 0)) {
            url = new URL(url, "/");
        }
        return url;
    }

    public static String getFile(String path) {
        int pq = 0;
        int ps = 0;
        pq = path.indexOf(63);
        if (pq == -1 && (pq = path.indexOf(35)) == -1) {
            pq = path.length();
        }
        if ((ps = path.lastIndexOf(47, pq)) == -1) {
            ps = path.lastIndexOf(92, pq);
        }
        if (ps != -1 || pq != path.length()) {
            return path.substring(ps + 1, pq);
        }
        return path;
    }

    public static String getFile(URL url) {
        return StringUtils.getFile(url.getFile());
    }

    public static boolean sameFile(URL url1, URL url2) {
        String urlString1 = url1.toExternalForm();
        String urlString2 = url2.toExternalForm();
        int p = 0;
        p = urlString1.indexOf(35);
        if (p != -1) {
            urlString1 = urlString1.substring(0, p);
        }
        if ((p = urlString2.indexOf(35)) != -1) {
            urlString2 = urlString1.substring(0, p);
        }
        return urlString1.compareTo(urlString2) == 0;
    }

    public static String replace(String value, String oldString, String newString) {
        int startPoint = 0;
        int endPoint = 0;
        endPoint = value.indexOf(oldString, startPoint);
        if (endPoint == -1) {
            return value;
        }
        int length = oldString.length();
        StringBuffer sb = new StringBuffer();
        do {
            sb.append(value.substring(startPoint, endPoint));
            sb.append(newString);
        } while ((endPoint = value.indexOf(oldString, startPoint = endPoint + length)) >= 0);
        if (value.length() > endPoint) {
            sb.append(value.substring(startPoint));
        }
        return sb.toString();
    }
}

