/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.token.table;

import java.awt.Color;
import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.token.Attribute;
import net.hizlab.kagetaka.token.AttributeConverter;
import net.hizlab.kagetaka.token.Value;

public class TdAttribute
extends Attribute {
    private Integer attributeColspan = null;
    private Integer attributeRowspan = null;
    private Value attributeWidth = null;
    private Value attributeHeight = null;
    private boolean attributeNowrap = false;
    private int attributeAlign = 1;
    private int attributeVAlign = 1;
    private Color attributeBgcolor = null;

    protected TdAttribute(Document document, Reporter reporter, int line, int column) {
        super(document, reporter, line, column);
    }

    public boolean setAttribute(String key, String value) throws IllegalArgumentException {
        if ("colspan".compareTo(key) == 0) {
            this.attributeColspan = AttributeConverter.convertToInteger(value);
            return true;
        }
        if ("rowspan".compareTo(key) == 0) {
            this.attributeRowspan = AttributeConverter.convertToInteger(value);
            return true;
        }
        if ("width".compareTo(key) == 0) {
            this.attributeWidth = AttributeConverter.convertToPercent(value);
            return true;
        }
        if ("height".compareTo(key) == 0) {
            this.attributeHeight = AttributeConverter.convertToPercent(value);
            return true;
        }
        if ("nowrap".compareTo(key) == 0) {
            this.attributeNowrap = value.toLowerCase().compareTo("nowrap") == 0;
            return true;
        }
        if ("align".compareTo(key) == 0) {
            this.attributeAlign = AttributeConverter.convertToAlign(value);
            return true;
        }
        if ("valign".compareTo(key) == 0) {
            this.attributeVAlign = AttributeConverter.convertToVAlign(value);
            return true;
        }
        if ("bgcolor".compareTo(key) == 0) {
            this.attributeBgcolor = AttributeConverter.convertToColor(value);
            return true;
        }
        return this.setBaseAttribute(key, value);
    }

    public Integer getColspan() {
        return this.attributeColspan;
    }

    public Integer getRowspan() {
        return this.attributeRowspan;
    }

    public Value getWidth() {
        return this.attributeWidth;
    }

    public Value getHeight() {
        return this.attributeHeight;
    }

    public boolean getNowrap() {
        return this.attributeNowrap;
    }

    public int getAlign() {
        return this.attributeAlign;
    }

    public int getVAlign() {
        return this.attributeVAlign;
    }

    public Color getBgcolor() {
        return this.attributeBgcolor;
    }
}

