/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.token.table;

import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.Render;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.token.Attribute;
import net.hizlab.kagetaka.token.StartToken;
import net.hizlab.kagetaka.token.Token;
import net.hizlab.kagetaka.token.TokenTypes;
import net.hizlab.kagetaka.token.Value;
import net.hizlab.kagetaka.token.table.TableAttribute;
import net.hizlab.kagetaka.token.table.TbodyAttribute;
import net.hizlab.kagetaka.token.table.TdAttribute;
import net.hizlab.kagetaka.token.table.TrAttribute;

public class TableStartToken
extends StartToken {
    private TableStartToken tableToken = null;

    public TableStartToken(Document document, Reporter reporter, int line, int column, int type, boolean complete) {
        super(document, reporter, line, column, type, complete);
    }

    protected boolean setAttributeImple(String key, String value) throws IllegalArgumentException {
        if (this.attribute == null) {
            switch (this.type) {
                case 3401: {
                    this.attribute = new TableAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber);
                    break;
                }
                case 3411: 
                case 3413: 
                case 3415: {
                    this.attribute = new TbodyAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber);
                    break;
                }
                case 3421: {
                    this.attribute = new TrAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber);
                    break;
                }
                case 3431: 
                case 3433: {
                    this.attribute = new TdAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber);
                    break;
                }
                default: {
                    this.attribute = new Attribute(this.document, this.reporter, this.lineNumber, this.columnNumber);
                }
            }
        }
        return this.attribute.setAttribute(key, value);
    }

    protected StartToken getDefaultParentTokenImple() {
        int tokenType = -1;
        switch (this.type) {
            case 3401: {
                return new StartToken(this.document, this.reporter, this.lineNumber, this.columnNumber, 3001, true);
            }
            case 3403: {
                tokenType = 3401;
                break;
            }
            case 3411: {
                tokenType = 3401;
                break;
            }
            case 3413: {
                tokenType = 3401;
                break;
            }
            case 3415: {
                tokenType = 3401;
                break;
            }
            case 3421: {
                tokenType = 3401;
                break;
            }
            case 3431: {
                tokenType = 3421;
                break;
            }
            case 3433: {
                tokenType = 3421;
                break;
            }
            default: {
                return null;
            }
        }
        return new TableStartToken(this.document, this.reporter, this.lineNumber, this.columnNumber, tokenType, true);
    }

    protected boolean isContentsImple(int childToken) {
        switch (this.type) {
            case 3401: {
                switch (childToken) {
                    case 3403: 
                    case 3411: 
                    case 3413: 
                    case 3415: 
                    case 3421: {
                        return true;
                    }
                }
                return TokenTypes.isInline(childToken);
            }
            case 3403: {
                return TokenTypes.isInline(childToken);
            }
            case 3411: 
            case 3413: 
            case 3415: {
                return childToken == 3421 || TokenTypes.isInline(childToken);
            }
            case 3421: {
                return childToken == 3431 || childToken == 3433 || TokenTypes.isInline(childToken);
            }
            case 3431: 
            case 3433: {
                return TokenTypes.isBlock(childToken) || TokenTypes.isInline(childToken);
            }
        }
        return false;
    }

    protected void includeTokenImple(Token token) {
        if (token instanceof TableStartToken) {
            ((TableStartToken)token).tableToken = this.type == 3401 ? this : this.tableToken;
        }
    }

    protected void renderImple(Render render) {
        Status status = render.getStatus();
        switch (this.type) {
            case 3401: {
                if (this.attribute != null) {
                    TableAttribute attr = (TableAttribute)this.attribute;
                    if (attr.getBorder() != null && attr.getBorder() > 0) {
                        status.setBorderWidth(15, new Value((long)attr.getBorder().intValue(), 3));
                        status.setBorderStyle(15, new Value(19));
                    }
                    status.borderVerticalSpacing = status.borderHorizontalSpacing = attr.getCellspacing();
                    status.height = attr.getWidth();
                    if (attr.getHspace() != null) {
                        status.setMargin(5, new Value((long)attr.getHspace().intValue(), 3));
                    }
                    if (attr.getVspace() != null) {
                        status.setMargin(10, new Value((long)attr.getVspace().intValue(), 3));
                    }
                    switch (attr.getAlign()) {
                        case 31: {
                            status.floatType = 31;
                            break;
                        }
                        case 32: {
                            status.floatType = 32;
                            break;
                        }
                        default: {
                            status.floatType = 3;
                        }
                    }
                    if (attr.getBgcolor() != null) {
                        status.backColor = attr.getBgcolor();
                    }
                }
                status.setFontWeight(new Value(3));
                status.align = 3;
                status.valign = 46;
                status.isTable = true;
                break;
            }
            case 3403: {
                status.setFontWeight(new Value(2));
                status.align = 31;
                status.valign = 41;
                break;
            }
            case 3411: 
            case 3413: 
            case 3415: {
                status.valign = status.parent.valign;
                status.backColor = status.parent.backColor;
                if (this.attribute == null) break;
                TbodyAttribute attr = (TbodyAttribute)this.attribute;
                if (attr.getAlign() != 1) {
                    status.align = attr.getAlign();
                }
                if (attr.getVAlign() == 1) break;
                status.valign = attr.getVAlign();
                break;
            }
            case 3421: {
                status.valign = status.parent.valign;
                status.backColor = status.parent.backColor;
                if (this.attribute != null) {
                    TrAttribute attr = (TrAttribute)this.attribute;
                    if (attr.getAlign() != 1) {
                        status.align = attr.getAlign();
                    }
                    if (attr.getVAlign() != 1) {
                        status.valign = attr.getVAlign();
                    }
                    if (attr.getBgcolor() != null) {
                        status.backColor = attr.getBgcolor();
                    }
                }
                render.createNewRow();
                break;
            }
            case 3431: 
            case 3433: {
                Attribute attr;
                int border = 0;
                Value padding = new Value(1L, 3);
                status.valign = status.parent.valign;
                status.backColor = status.parent.backColor;
                if (status.getFontWeight() < 0) {
                    status.setFontWeight(new Value(this.type == 3431 ? 75 : 2));
                }
                if (status.align == 3) {
                    int n = status.align = this.type == 3431 ? 33 : 31;
                }
                if (this.attribute != null) {
                    attr = (TdAttribute)this.attribute;
                    if (((TdAttribute)attr).getAlign() != 1) {
                        status.align = ((TdAttribute)attr).getAlign();
                    }
                    if (((TdAttribute)attr).getVAlign() != 1) {
                        status.valign = ((TdAttribute)attr).getVAlign();
                    }
                    if (((TdAttribute)attr).getBgcolor() != null) {
                        status.backColor = ((TdAttribute)attr).getBgcolor();
                    }
                    if (((TdAttribute)attr).getNowrap()) {
                        status.whiteSpace = 52;
                    }
                    if (((TdAttribute)attr).getColspan() != null) {
                        status.colSpan = ((TdAttribute)attr).getColspan();
                    }
                    if (((TdAttribute)attr).getRowspan() != null) {
                        status.rowSpan = ((TdAttribute)attr).getRowspan();
                    }
                    if (((TdAttribute)attr).getWidth() != null) {
                        status.height = ((TdAttribute)attr).getWidth();
                    }
                    if (((TdAttribute)attr).getHeight() != null) {
                        status.width = ((TdAttribute)attr).getHeight();
                    }
                }
                if (this.tableToken.attribute != null) {
                    attr = (TableAttribute)this.tableToken.attribute;
                    if (((TableAttribute)attr).getBorder() != null) {
                        border = ((TableAttribute)attr).getBorder();
                    }
                    if (((TableAttribute)attr).getCellpadding() != null) {
                        padding = ((TableAttribute)attr).getCellpadding();
                    }
                }
                if (border > 0) {
                    status.setBorderWidth(15, new Value(1L, 3));
                    status.setBorderStyle(15, new Value(18));
                }
                status.setPadding(15, padding);
                status.isVertical = true;
            }
        }
    }
}

