/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.token.table;

import java.awt.Color;
import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.token.Attribute;
import net.hizlab.kagetaka.token.AttributeConverter;
import net.hizlab.kagetaka.token.Value;

public class TableAttribute
extends Attribute {
    private String attributeSummary = null;
    private Value attributeWidth = null;
    private Integer attributeBorder = null;
    private int attributeAlign = 3;
    private Value attributeCellspacing = null;
    private Value attributeCellpadding = null;
    private Integer attributeHspace = null;
    private Integer attributeVspace = null;
    private Color attributeBgcolor = null;

    protected TableAttribute(Document document, Reporter reporter, int line, int column) {
        super(document, reporter, line, column);
    }

    public boolean setAttribute(String key, String value) throws IllegalArgumentException {
        if ("summary".compareTo(key) == 0) {
            this.attributeSummary = value;
            return true;
        }
        if ("width".compareTo(key) == 0) {
            this.attributeWidth = AttributeConverter.convertToPercent(value);
            return true;
        }
        if ("border".compareTo(key) == 0) {
            this.attributeBorder = AttributeConverter.convertToInteger(value);
            return true;
        }
        if ("align".compareTo(key) == 0) {
            this.attributeAlign = AttributeConverter.convertToAlign(value);
            return true;
        }
        if ("cellspacing".compareTo(key) == 0) {
            this.attributeCellspacing = AttributeConverter.convertToPercent(value);
            return true;
        }
        if ("cellpadding".compareTo(key) == 0) {
            this.attributeCellpadding = AttributeConverter.convertToPercent(value);
            return true;
        }
        if ("hspace".compareTo(key) == 0) {
            this.attributeHspace = AttributeConverter.convertToInteger(value);
            return true;
        }
        if ("vspace".compareTo(key) == 0) {
            this.attributeVspace = AttributeConverter.convertToInteger(value);
            return true;
        }
        if ("bgcolor".compareTo(key) == 0) {
            this.attributeBgcolor = AttributeConverter.convertToColor(value);
            return true;
        }
        return this.setBaseAttribute(key, value);
    }

    public Value getWidth() {
        return this.attributeWidth;
    }

    public Integer getBorder() {
        return this.attributeBorder;
    }

    public int getAlign() {
        return this.attributeAlign;
    }

    public Value getCellspacing() {
        return this.attributeCellspacing;
    }

    public Value getCellpadding() {
        return this.attributeCellpadding;
    }

    public Integer getHspace() {
        return this.attributeHspace;
    }

    public Integer getVspace() {
        return this.attributeVspace;
    }

    public Color getBgcolor() {
        return this.attributeBgcolor;
    }
}

