/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.token.form;

import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.token.Attribute;
import net.hizlab.kagetaka.token.AttributeConverter;

public class TextareaAttribute
extends Attribute {
    private String attributeName = null;
    private Integer attributeRows = null;
    private Integer attributeCols = null;
    private boolean attributeDisabled = false;
    private boolean attributeReadonly = false;
    private String attributeWrap = null;

    protected TextareaAttribute(Document document, Reporter reporter, int line, int column) {
        super(document, reporter, line, column);
    }

    public boolean setAttribute(String key, String value) throws IllegalArgumentException {
        if ("name".compareTo(key) == 0) {
            this.attributeName = value;
            return true;
        }
        if ("rows".compareTo(key) == 0) {
            this.attributeRows = AttributeConverter.convertToInteger(value);
            return true;
        }
        if ("cols".compareTo(key) == 0) {
            this.attributeCols = AttributeConverter.convertToInteger(value);
            return true;
        }
        if ("disabled".compareTo(key) == 0) {
            this.attributeDisabled = value.toLowerCase().compareTo(key) == 0;
            return true;
        }
        if ("readonly".compareTo(key) == 0) {
            this.attributeReadonly = value.toLowerCase().compareTo(key) == 0;
            return true;
        }
        if ("wrap".compareTo(key) == 0) {
            this.attributeWrap = value;
            return true;
        }
        return this.setBaseAttribute(key, value);
    }

    public String getName() {
        return this.attributeName;
    }

    public Integer getRows() {
        return this.attributeRows;
    }

    public Integer getCols() {
        return this.attributeCols;
    }

    public boolean getDisabled() {
        return this.attributeDisabled;
    }

    public boolean getReadonly() {
        return this.attributeReadonly;
    }

    public String getWrap() {
        return this.attributeWrap;
    }
}

