/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.token.form;

import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.token.Attribute;
import net.hizlab.kagetaka.token.AttributeConverter;

public class SelectAttribute
extends Attribute {
    private String attributeName = null;
    private Integer attributeSize = null;
    private boolean attributeMultiple = false;
    private boolean attributeDisabled = false;
    private Integer attributeTabindex = null;

    protected SelectAttribute(Document document, Reporter reporter, int line, int column) {
        super(document, reporter, line, column);
    }

    public boolean setAttribute(String key, String value) throws IllegalArgumentException {
        if ("name".compareTo(key) == 0) {
            this.attributeName = value;
            return true;
        }
        if ("size".compareTo(key) == 0) {
            this.attributeSize = AttributeConverter.convertToInteger(value);
            return true;
        }
        if ("multiple".compareTo(key) == 0) {
            this.attributeMultiple = value.toLowerCase().compareTo(key) == 0;
            return true;
        }
        if ("disabled".compareTo(key) == 0) {
            this.attributeDisabled = value.toLowerCase().compareTo(key) == 0;
            return true;
        }
        if ("tabindex".compareTo(key) == 0) {
            this.attributeTabindex = AttributeConverter.convertToInteger(value);
            return true;
        }
        return this.setBaseAttribute(key, value);
    }

    public String getName() {
        return this.attributeName;
    }

    public Integer getSize() {
        return this.attributeSize;
    }

    public boolean getMultiple() {
        return this.attributeMultiple;
    }

    public boolean getDisabled() {
        return this.attributeDisabled;
    }

    public Integer getTabindex() {
        return this.attributeTabindex;
    }
}

