/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.token;

import java.io.IOException;
import java.io.InputStream;
import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.token.StartToken;
import net.hizlab.kagetaka.token.Style;
import net.hizlab.kagetaka.token.StyleCreater;

public abstract class StyleManager {
    private static StyleCreater styleCreater;

    protected StyleManager() {
    }

    public static StyleManager createStyleManager(Reporter reporter) {
        if (styleCreater != null) {
            return styleCreater.createStyleManager(reporter);
        }
        StyleManager.reportMessage(reporter);
        return null;
    }

    public static Style createStyle(Reporter reporter, String value) {
        if (styleCreater != null) {
            return styleCreater.createStyle(reporter, value);
        }
        StyleManager.reportMessage(reporter);
        return null;
    }

    private static void reportMessage(Reporter reporter) {
        if (reporter != null) {
            reporter.report(7, Resource.getMessage("stylemanager.warning.notsupport", null), 0, 0);
        }
    }

    public static boolean canUseStyle() {
        return styleCreater != null;
    }

    public abstract void addStyle(InputStream var1, String var2) throws IOException;

    public abstract void addStyle(String var1);

    public abstract void changeStatus(Document var1, StartToken var2, Status var3);

    static {
        try {
            styleCreater = (StyleCreater)Class.forName(Resource.getMessage("stylemanager.creater", null)).newInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

