/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.token;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.Render;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.token.AAttribute;
import net.hizlab.kagetaka.token.Attribute;
import net.hizlab.kagetaka.token.BaseAttribute;
import net.hizlab.kagetaka.token.BodyAttribute;
import net.hizlab.kagetaka.token.DivAttribute;
import net.hizlab.kagetaka.token.EndToken;
import net.hizlab.kagetaka.token.FontAttribute;
import net.hizlab.kagetaka.token.FrameAttribute;
import net.hizlab.kagetaka.token.HAttribute;
import net.hizlab.kagetaka.token.HrAttribute;
import net.hizlab.kagetaka.token.ImgAttribute;
import net.hizlab.kagetaka.token.LAttribute;
import net.hizlab.kagetaka.token.LinkAttribute;
import net.hizlab.kagetaka.token.MetaAttribute;
import net.hizlab.kagetaka.token.PAttribute;
import net.hizlab.kagetaka.token.Style;
import net.hizlab.kagetaka.token.StyleManager;
import net.hizlab.kagetaka.token.Token;
import net.hizlab.kagetaka.token.TokenTypes;
import net.hizlab.kagetaka.token.Value;
import net.hizlab.kagetaka.util.TextFormat;

public class StartToken
extends Token {
    protected Vector contents = new Vector();
    protected final int type;
    protected Attribute attribute = null;
    protected String content = null;
    private boolean htmlHasHead = false;
    private boolean htmlHasBody = false;

    public StartToken(Document document, Reporter reporter, int line, int column, int type, boolean complete) {
        super(document, reporter, line, column);
        this.type = type;
        this.completeToken = complete;
    }

    public final void initAttribute(Hashtable pairs) {
        if (pairs != null) {
            Enumeration e = pairs.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = (String)pairs.get(key);
                String keyLC = key.toLowerCase();
                try {
                    if (this.setAttributeImple(keyLC, value)) continue;
                    this.reportMessage(7, "element._.error.attribute.unknown", new String[]{this.getName(), key});
                }
                catch (IllegalArgumentException ex) {
                    this.reportMessage(7, "element._.error.attribute.invalid", new String[]{this.getName(), key, value});
                }
            }
        }
    }

    protected boolean setAttributeImple(String key, String value) throws IllegalArgumentException {
        if (this.attribute == null) {
            switch (this.type) {
                case 2013: {
                    this.attribute = new BaseAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber);
                    break;
                }
                case 2015: {
                    return true;
                }
                case 2019: {
                    this.attribute = new MetaAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber);
                    break;
                }
                case 2021: {
                    this.attribute = new LinkAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber);
                    break;
                }
                case 3001: {
                    this.attribute = new BodyAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber);
                    break;
                }
                case 3101: {
                    this.attribute = new PAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber);
                    break;
                }
                case 3103: 
                case 3105: 
                case 3107: 
                case 3109: 
                case 3111: 
                case 3113: {
                    this.attribute = new HAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber);
                    break;
                }
                case 3115: {
                    this.attribute = new LAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber, 0);
                    break;
                }
                case 3117: {
                    this.attribute = new LAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber, 1);
                    break;
                }
                case 3119: {
                    this.attribute = new LAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber, 2);
                    break;
                }
                case 3121: {
                    this.attribute = new LAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber, 3);
                    break;
                }
                case 3133: {
                    this.attribute = new DivAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber);
                    break;
                }
                case 3139: {
                    this.attribute = new HrAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber);
                    break;
                }
                case 2043: {
                    this.attribute = new FrameAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber);
                    break;
                }
                case 3201: {
                    this.attribute = new AAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber);
                    break;
                }
                case 3203: {
                    this.attribute = new ImgAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber);
                    break;
                }
                case 3277: {
                    this.attribute = new FontAttribute(this.document, this.reporter, this.lineNumber, this.columnNumber);
                    break;
                }
                default: {
                    if (TokenTypes.isBody(this.type)) {
                        this.attribute = new Attribute(this.document, this.reporter, this.lineNumber, this.columnNumber);
                        break;
                    }
                    return false;
                }
            }
        }
        return this.attribute.setAttribute(key, value);
    }

    public String getName() {
        return TokenTypes.getName(this.type);
    }

    public int getType() {
        return this.type;
    }

    public final StartToken getDefaultParentToken() {
        StartToken token = this.getDefaultParentTokenImple();
        if (token != null) {
            return token;
        }
        if (this.type == 1001) {
            return null;
        }
        this.reportMessage(10, "internal.error", new String[]{"StartToken.getDefaultParentToken", "undefine token type", this.getName()});
        return null;
    }

    protected StartToken getDefaultParentTokenImple() {
        int tokenType = -1;
        switch (this.type) {
            case 1001: {
                return null;
            }
            case 2001: {
                tokenType = 1001;
                break;
            }
            case 2011: {
                tokenType = 2001;
                break;
            }
            case 2013: {
                tokenType = 2001;
                break;
            }
            case 2015: {
                tokenType = 2001;
                break;
            }
            case 2019: {
                tokenType = 2001;
                break;
            }
            case 2021: {
                tokenType = 2001;
                break;
            }
            case 2041: {
                tokenType = 1001;
                break;
            }
            case 2043: {
                tokenType = 2041;
                break;
            }
            case 2045: {
                tokenType = 1001;
                break;
            }
            case 3001: {
                tokenType = 1001;
                break;
            }
            case 3101: {
                tokenType = 3001;
                break;
            }
            case 3103: {
                tokenType = 3001;
                break;
            }
            case 3105: {
                tokenType = 3001;
                break;
            }
            case 3107: {
                tokenType = 3001;
                break;
            }
            case 3109: {
                tokenType = 3001;
                break;
            }
            case 3111: {
                tokenType = 3001;
                break;
            }
            case 3113: {
                tokenType = 3001;
                break;
            }
            case 3115: {
                tokenType = 3001;
                break;
            }
            case 3117: {
                tokenType = 3001;
                break;
            }
            case 3119: {
                tokenType = 3001;
                break;
            }
            case 3121: {
                tokenType = 3001;
                break;
            }
            case 3123: {
                tokenType = 3191;
                break;
            }
            case 3125: {
                tokenType = 3001;
                break;
            }
            case 3127: {
                tokenType = 3191;
                break;
            }
            case 3129: {
                tokenType = 3191;
                break;
            }
            case 3131: {
                tokenType = 3001;
                break;
            }
            case 3133: {
                tokenType = 3001;
                break;
            }
            case 3291: {
                tokenType = 3001;
                break;
            }
            case 3137: {
                tokenType = 3001;
                break;
            }
            case 3139: {
                tokenType = 3001;
                break;
            }
            case 3141: {
                tokenType = 3001;
                break;
            }
            case 3143: {
                tokenType = 3001;
                break;
            }
            case 3191: {
                tokenType = 3001;
                break;
            }
            case 3201: {
                tokenType = 3191;
                break;
            }
            case 3203: {
                tokenType = 3191;
                break;
            }
            case 3205: {
                tokenType = 3191;
                break;
            }
            case 3207: {
                tokenType = 3191;
                break;
            }
            case 3221: {
                tokenType = 3191;
                break;
            }
            case 3223: {
                tokenType = 3191;
                break;
            }
            case 3225: {
                tokenType = 3191;
                break;
            }
            case 3227: {
                tokenType = 3191;
                break;
            }
            case 3229: {
                tokenType = 3191;
                break;
            }
            case 3231: {
                tokenType = 3191;
                break;
            }
            case 3233: {
                tokenType = 3191;
                break;
            }
            case 3235: {
                tokenType = 3191;
                break;
            }
            case 3237: {
                tokenType = 3191;
                break;
            }
            case 3239: {
                tokenType = 3191;
                break;
            }
            case 3241: {
                tokenType = 3191;
                break;
            }
            case 3243: {
                tokenType = 3191;
                break;
            }
            case 3245: {
                tokenType = 3191;
                break;
            }
            case 3261: {
                tokenType = 3191;
                break;
            }
            case 3263: {
                tokenType = 3191;
                break;
            }
            case 3265: {
                tokenType = 3191;
                break;
            }
            case 3267: {
                tokenType = 3191;
                break;
            }
            case 3269: {
                tokenType = 3191;
                break;
            }
            case 3271: {
                tokenType = 3191;
                break;
            }
            case 3273: {
                tokenType = 3191;
                break;
            }
            case 3275: {
                tokenType = 3191;
                break;
            }
            case 3277: {
                tokenType = 3191;
                break;
            }
            default: {
                return null;
            }
        }
        return new StartToken(this.document, this.reporter, this.lineNumber, this.columnNumber, tokenType, true);
    }

    public EndToken getEndToken(Token current) {
        if (TokenTypes.isEmpty(this.type)) {
            return null;
        }
        if (current == null) {
            return new EndToken(this.document, this.reporter, this.lineNumber, this.columnNumber, this.getType() + 1, true);
        }
        return new EndToken(this.document, this.reporter, current.lineNumber, current.columnNumber, this.getType() + 1, true);
    }

    public int getEndTokenType() {
        if (TokenTypes.isEmpty(this.type)) {
            return -1;
        }
        return this.getType() + 1;
    }

    public final boolean isContents(StartToken token) {
        int childToken = token.getType();
        switch (childToken) {
            case 2015: 
            case 2019: {
                return true;
            }
        }
        if (TokenTypes.isForm(childToken) && childToken != 3507 && childToken != 3509) {
            return true;
        }
        return this.isContentsImple(childToken);
    }

    protected boolean isContentsImple(int childToken) {
        switch (this.type) {
            case 1001: {
                switch (childToken) {
                    case 2001: {
                        if (this.htmlHasHead) {
                            return false;
                        }
                        this.htmlHasHead = true;
                        return true;
                    }
                    case 3001: {
                        if (this.htmlHasBody) {
                            return false;
                        }
                        this.htmlHasHead = true;
                        this.htmlHasBody = true;
                        return true;
                    }
                    case 2041: {
                        return true;
                    }
                    case 2045: {
                        return true;
                    }
                }
                return false;
            }
            case 2001: {
                switch (childToken) {
                    case 2011: 
                    case 2013: 
                    case 2015: 
                    case 2017: 
                    case 2019: 
                    case 2021: {
                        return true;
                    }
                }
                return false;
            }
            case 2011: 
            case 2013: {
                return false;
            }
            case 2015: {
                return true;
            }
            case 2019: 
            case 2021: {
                return false;
            }
            case 2041: {
                return childToken == 2041 || childToken == 2043;
            }
            case 2043: {
                return false;
            }
            case 2045: {
                return true;
            }
            case 3001: {
                switch (childToken) {
                    case 3123: 
                    case 3127: 
                    case 3129: {
                        return false;
                    }
                }
                return TokenTypes.isBlock(childToken);
            }
            case 3101: 
            case 3103: 
            case 3105: 
            case 3107: 
            case 3109: 
            case 3111: 
            case 3113: 
            case 3131: 
            case 3141: {
                return TokenTypes.isInline(childToken);
            }
            case 3115: 
            case 3117: 
            case 3119: 
            case 3121: {
                return childToken == 3123;
            }
            case 3123: {
                return TokenTypes.isBlock(childToken) && childToken != 3123 || TokenTypes.isInline(childToken);
            }
            case 3125: {
                return childToken == 3127 || childToken == 3129;
            }
            case 3127: {
                return TokenTypes.isInline(childToken);
            }
            case 3129: {
                return TokenTypes.isBlock(childToken) && childToken != 3127 && childToken != 3129 || TokenTypes.isInline(childToken);
            }
            case 3133: 
            case 3137: 
            case 3143: 
            case 3291: {
                return TokenTypes.isBlock(childToken) || TokenTypes.isInline(childToken);
            }
            case 3139: {
                return false;
            }
            case 3191: {
                return TokenTypes.isInline(childToken) || childToken == 3123 || childToken == 3127 || childToken == 3129;
            }
            case 3201: {
                return TokenTypes.isInline(childToken) && childToken != 3201;
            }
            case 3207: 
            case 3221: 
            case 3223: 
            case 3225: 
            case 3227: 
            case 3229: 
            case 3231: 
            case 3233: 
            case 3235: 
            case 3237: 
            case 3239: 
            case 3241: 
            case 3243: 
            case 3245: 
            case 3261: 
            case 3263: 
            case 3265: 
            case 3267: 
            case 3269: 
            case 3271: 
            case 3273: 
            case 3275: 
            case 3277: {
                return TokenTypes.isInline(childToken);
            }
            case 3203: 
            case 3205: {
                return false;
            }
        }
        this.reportMessage(10, "internal.error", new String[]{"StartToken.isContents", "undefine token type", this.getName()});
        return false;
    }

    protected final boolean isContentsParent(int childToken) {
        StartToken parent = this.getParent();
        if (parent != null) {
            return parent.isContentsImple(childToken);
        }
        return false;
    }

    public final void includeToken(Token token) {
        this.contents.addElement(token);
        token.setParent(this);
        this.includeTokenImple(token);
    }

    protected void includeTokenImple(Token token) {
    }

    protected final void includeTokenParent(Token token) {
        StartToken parent = this.getParent();
        if (parent != null) {
            parent.includeTokenImple(token);
        }
    }

    public StartToken getBeforeStartToken() {
        StartToken parent = this.getParent();
        if (parent == null) {
            return null;
        }
        int p = parent.contents.indexOf(this);
        if (p <= 0) {
            return null;
        }
        while (--p >= 0) {
            Object o = parent.contents.elementAt(p);
            if (!(o instanceof StartToken)) continue;
            return (StartToken)o;
        }
        return null;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        sb.append(this.getName());
        if (TokenTypes.isEmpty(this.type)) {
            sb.append(" /");
        }
        sb.append(':');
        sb.append(this.lineNumber);
        sb.append(':');
        sb.append(this.columnNumber);
        sb.append('>');
        return sb.toString();
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public final void render(Render render) {
        Style style;
        Status status = render.getStatus();
        this.renderImple(render);
        StyleManager sm = render.getStyleManager(false);
        if (sm != null) {
            sm.changeStatus(this.document, this, status);
        }
        if (this.attribute != null && (style = this.attribute.getStyle()) != null) {
            style.changeStatus(this.document, TokenTypes.isBlockEx(this.type), status);
        }
    }

    protected void renderImple(Render render) {
        Status status = render.getStatus();
        switch (this.type) {
            case 1001: {
                break;
            }
            case 2001: {
                break;
            }
            case 2011: {
                render.setTitle(TextFormat.convertXhtml(this.content, true, true, true, true));
                break;
            }
            case 2013: {
                if (this.attribute == null) break;
                render.setBaseHref(((BaseAttribute)this.attribute).getHref());
                break;
            }
            case 2015: {
                break;
            }
            case 2019: {
                if (this.attribute == null) break;
                MetaAttribute attr = (MetaAttribute)this.attribute;
                String he = attr.getHttpEquiv();
                String content = attr.getContent();
                if (he == null || content == null) break;
                if ((he = he.trim().toLowerCase()).compareTo("refresh") == 0) {
                    int p = content.indexOf(59);
                    String time = content;
                    String href = null;
                    if (p != -1) {
                        time = content.substring(0, p);
                        href = content.substring(p + 1).trim();
                        if (href.toLowerCase().startsWith("url=")) {
                            href = href.substring(4).trim();
                        }
                    }
                    render.setRefresh(Integer.parseInt("0" + time), href);
                    break;
                }
                if (he.compareTo("set-cookie") != 0) break;
                render.setCookie(content);
                break;
            }
            case 2021: {
                LinkAttribute attr;
                String rel;
                if (this.attribute == null || (rel = (attr = (LinkAttribute)this.attribute).getRel()) == null || rel.toLowerCase().compareTo("stylesheet") != 0) break;
                render.setStyleSheet(attr.getHref(), attr.getType());
                break;
            }
            case 2041: {
                status.setList(912);
                status.setMargin(1, new Value(10L, 3));
                status.setMargin(10, new Value(5L, 3));
                break;
            }
            case 2043: {
                FrameAttribute attr;
                String src;
                if (this.attribute == null || (src = (attr = (FrameAttribute)this.attribute).getSrc()) == null) break;
                render.setListItem();
                render.setLink(src);
                status.setTextDecoration(4096);
                render.drawText(src);
                render.doBr();
                break;
            }
            case 2045: {
                break;
            }
            case 3001: {
                if (this.attribute != null) {
                    BodyAttribute attr = (BodyAttribute)this.attribute;
                    status.setBackImage(attr.getBackground());
                    if (attr.getText() != null) {
                        status.foreColor = attr.getText();
                    }
                    if (attr.getBgcolor() != null) {
                        status.backColor = attr.getBgcolor();
                    }
                    if (attr.getLink() != null) {
                        status.linkColor = attr.getLink();
                    }
                    if (attr.getVLink() != null) {
                        status.vlinkColor = attr.getVLink();
                    }
                    if (attr.getALink() != null) {
                        status.alinkColor = attr.getALink();
                    }
                }
                status.setMargin(15, new Value(5L, 3));
                status.lineHeight = new Value(1.2, 1);
                break;
            }
            case 3101: {
                if (this.attribute != null) {
                    status.align = ((PAttribute)this.attribute).getAlign();
                }
                status.setMargin(10, new Value(1L, 1));
                status.whiteSpace = 3;
                break;
            }
            case 3103: 
            case 3105: 
            case 3107: 
            case 3109: 
            case 3111: 
            case 3113: {
                switch (this.type) {
                    case 3103: {
                        status.setFontWeight(new Value(75));
                        status.setFontSize(new Value(207L, 9), 1);
                        break;
                    }
                    case 3105: {
                        status.setFontWeight(new Value(75));
                        status.setFontSize(new Value(173L, 9), 1);
                        break;
                    }
                    case 3107: {
                        status.setFontWeight(new Value(75));
                        status.setFontSize(new Value(144L, 9), 1);
                        break;
                    }
                    case 3109: {
                        status.setFontWeight(new Value(75));
                        status.setFontSize(new Value(120L, 9), 1);
                        break;
                    }
                    case 3111: {
                        status.setFontWeight(new Value(75));
                        break;
                    }
                    case 3113: {
                        status.setFontStyle(new Value(72));
                    }
                }
                if (this.attribute != null) {
                    status.align = ((HAttribute)this.attribute).getAlign();
                }
                status.setMargin(10, new Value(0.5, 1));
                break;
            }
            case 3115: 
            case 3117: 
            case 3119: 
            case 3121: {
                LAttribute attr = (LAttribute)this.attribute;
                status.setList(attr != null ? attr.getType() : (this.type == 3117 ? 84 : 912));
                if (attr != null && attr.getStart() != null) {
                    status.counterNo = attr.getStart();
                }
                status.setMargin(1, new Value(40L, 3));
                break;
            }
            case 3123: {
                if (!this.completeToken) {
                    render.setListItem();
                }
                status.setMargin(10, new Value(2L, 3));
                break;
            }
            case 3125: {
                break;
            }
            case 3127: {
                status.setFontWeight(new Value(75));
                status.setMargin(10, new Value(2L, 3));
                break;
            }
            case 3129: {
                status.setMargin(1, new Value(40L, 3));
                status.setMargin(10, new Value(2L, 3));
                break;
            }
            case 3131: {
                status.setMargin(10, new Value(1L, 1));
                status.whiteSpace = 51;
                status.setFixedFont();
                break;
            }
            case 3133: {
                if (this.attribute == null) break;
                status.align = ((DivAttribute)this.attribute).getAlign();
                break;
            }
            case 3291: {
                break;
            }
            case 3137: {
                status.setMargin(1, new Value(20L, 3));
                status.setMargin(10, new Value(5L, 3));
                break;
            }
            case 3139: {
                int size = 3;
                boolean shade = true;
                if (status.align == 3) {
                    status.align = 33;
                }
                status.hrHeight = new Value(100L, 9);
                if (this.attribute != null) {
                    HrAttribute attr = (HrAttribute)this.attribute;
                    size = Math.max(attr.getSize() != null ? attr.getSize() : size, 2);
                    boolean bl = shade = !attr.getNoshade();
                    if (attr.getAlign() != 1) {
                        status.align = attr.getAlign();
                    }
                    if (attr.getWidth() != null) {
                        status.hrHeight = attr.getWidth();
                    }
                }
                int r = status.foreColor.getRed();
                int g = status.foreColor.getGreen();
                int b = status.foreColor.getBlue();
                r = r < 128 ? (r += 128) : (r -= 128);
                g = g < 128 ? (g += 128) : (g -= 128);
                b = b < 128 ? (b += 128) : (b -= 128);
                status.isHorizontalRule = true;
                status.width = new Value((long)(size - 2), 3);
                status.height = new Value(100L, 9);
                if (shade) {
                    status.setBorderStyle(15, new Value(18));
                }
                status.setBorderWidth(15, new Value(1L, 3));
                status.setBorderColor(15, new Color(r, g, b));
                status.setMargin(10, new Value(0.7, 1));
                break;
            }
            case 3141: {
                break;
            }
            case 3143: {
                status.align = 33;
                break;
            }
            case 3191: {
                break;
            }
            case 3201: {
                if (this.attribute == null) break;
                AAttribute attr = (AAttribute)this.attribute;
                render.setLink(attr.getHref());
                render.setMark(attr.getName());
                if (attr.getHref() == null) break;
                status.setTextDecoration(4096);
                break;
            }
            case 3203: {
                if (this.attribute == null) break;
                ImgAttribute attr = (ImgAttribute)this.attribute;
                int floatType = 3;
                switch (attr.getAlign()) {
                    case 31: {
                        floatType = 31;
                        break;
                    }
                    case 32: {
                        floatType = 32;
                    }
                }
                render.drawImage(attr.getSrc(), attr.getAlt(), attr.getWidth(), attr.getHeight(), attr.getBorder(), floatType);
                break;
            }
            case 3205: {
                render.doBr();
                break;
            }
            case 3207: {
                break;
            }
            case 3221: {
                status.setFontStyle(new Value(72));
                break;
            }
            case 3223: {
                status.setFontWeight(new Value(75));
                break;
            }
            case 3225: {
                status.setFontStyle(new Value(72));
                break;
            }
            case 3227: {
                status.setFixedFont();
                break;
            }
            case 3229: {
                render.drawText("\"");
                break;
            }
            case 3231: {
                status.setFontSize(new Value(70L, 9), 1);
                status.offsetX = -((int)((double)status.getFontData().getFullSize().width * 0.5));
                break;
            }
            case 3233: {
                status.setFontSize(new Value(70L, 9), 1);
                status.offsetX = (int)((double)status.getFontData().getFullSize().width * 0.5);
                break;
            }
            case 3235: {
                status.setFixedFont();
                break;
            }
            case 3237: {
                break;
            }
            case 3239: {
                status.setFontStyle(new Value(72));
                break;
            }
            case 3241: {
                status.setFontStyle(new Value(72));
                break;
            }
            case 3243: 
            case 3245: {
                if (this.attribute == null || this.attribute.getBaseTitle() == null) break;
                render.setPopup(this.attribute.getBaseTitle());
                status.setTextDecoration(4096);
                break;
            }
            case 3261: {
                status.setFixedFont();
                break;
            }
            case 3263: {
                status.setFontStyle(new Value(72));
                break;
            }
            case 3265: {
                status.setFontWeight(new Value(75));
                break;
            }
            case 3267: {
                status.setFontSize(new Value(69), 1);
                break;
            }
            case 3269: {
                status.setFontSize(new Value(68), 1);
                break;
            }
            case 3271: {
                status.setTextDecoration(4096);
                break;
            }
            case 3273: 
            case 3275: {
                status.setTextDecoration(16384);
                break;
            }
            case 3277: {
                String fontFace;
                int size;
                Integer fontSize;
                if (this.attribute == null) break;
                FontAttribute attr = (FontAttribute)this.attribute;
                if (attr.getColor() != null) {
                    status.foreColor = attr.getColor();
                }
                if ((fontSize = attr.getSize(3)) != null && (size = fontSize.intValue()) != 3) {
                    int i;
                    Value v;
                    status.setFontSize(new Value(22), 1);
                    if (fontSize < 3) {
                        v = new Value(68);
                        for (i = fontSize.intValue(); i < 3; ++i) {
                            status.setFontSize(v, 1);
                        }
                    } else if (fontSize > 3) {
                        v = new Value(69);
                        for (i = fontSize.intValue(); i > 3; --i) {
                            status.setFontSize(v, 1);
                        }
                    }
                }
                if ((fontFace = attr.getFace()) == null || fontFace.length() <= 0) break;
                StringTokenizer st = new StringTokenizer(fontFace, ",");
                Value[] vs = new Value[st.countTokens()];
                int index = 0;
                while (st.hasMoreTokens()) {
                    vs[index++] = new Value(st.nextToken().trim());
                }
                status.setFontFamily(vs);
            }
        }
    }
}

