/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.style;

import java.awt.Color;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Hashtable;
import java.util.StringTokenizer;
import net.hizlab.kagetaka.awt.Transparent;
import net.hizlab.kagetaka.token.AttributeConverter;

class Value
extends net.hizlab.kagetaka.token.Value {
    private static Hashtable keywords = new Hashtable();
    private static Hashtable units = new Hashtable();
    private static final int[] TYPES_INT_PER;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Value(String s, int[] types) throws ParseException {
        int i;
        if (s == null || s.length() == 0) {
            throw new ParseException(s, 0);
        }
        String ls = s.toLowerCase();
        if (ls.endsWith("!important")) {
            this.important = true;
            ls = ls.substring(0, ls.length() - 10);
        }
        char c = ls.charAt(0);
        Object o = keywords.get(ls);
        if (o != null) {
            this.type = (Integer)o;
            this.string = ls;
            if (this.type == 901) {
                this.type = -5;
                this.color = Transparent.color;
            }
        } else if ('0' <= c && c <= '9' || c == '-') {
            ParsePosition pp = new ParsePosition(0);
            this.number = Value.toNumber(ls, pp);
            int index = pp.getIndex();
            String unitString = ls.substring(index);
            if (unitString.length() == 0) {
                this.type = -1;
            } else if (unitString.compareTo("%") == 0) {
                this.type = -3;
                this.unit = 9;
            } else {
                o = units.get(unitString);
                if (o == null) throw new ParseException(s, index);
                this.type = -2;
                this.unit = (Integer)o;
            }
        } else if (c == '\"' || c == '\'') {
            this.type = -4;
            this.string = ls;
        } else if (ls.startsWith("url(") && ls.endsWith(")")) {
            this.type = -6;
            this.url = ls = Value.fixString(s, 4, ls.length() - 1, true);
        } else if (ls.startsWith("rgb(") && ls.endsWith(")")) {
            this.type = -5;
            StringTokenizer st = new StringTokenizer(s.substring(4, s.length() - 1), ",");
            Value vr = null;
            Value vg = null;
            Value vb = null;
            if (st.hasMoreTokens()) {
                vr = new Value(st.nextToken().trim(), TYPES_INT_PER);
            }
            if (st.hasMoreTokens()) {
                vg = new Value(st.nextToken().trim(), TYPES_INT_PER);
            }
            if (st.hasMoreTokens()) {
                vb = new Value(st.nextToken().trim(), TYPES_INT_PER);
            }
            if (vr == null || vg == null || vb == null || st.hasMoreTokens()) {
                throw new ParseException(s, 4);
            }
            this.color = new Color(vr.getUnit() == 9 ? 255 * vr.intValue() / 100 : vr.intValue(), vg.getUnit() == 9 ? 255 * vg.intValue() / 100 : vg.intValue(), vb.getUnit() == 9 ? 255 * vb.intValue() / 100 : vb.intValue());
        } else {
            this.color = AttributeConverter.convertToColorSilent(ls);
            if (this.color != null) {
                this.type = -5;
            } else {
                this.type = -4;
                this.string = s;
            }
        }
        if (types == null) {
            return;
        }
        for (i = 0; i < types.length; ++i) {
            if (types[i] != this.type) continue;
            return;
        }
        if (this.type != -1 || this.number.intValue() != 0) throw new ParseException(s, 0);
        this.type = -2;
        this.unit = 3;
        for (i = 0; i < types.length; ++i) {
            if (types[i] != this.type) continue;
            return;
        }
        throw new ParseException(s, 0);
    }

    Value(String[] s, int[] types) throws ParseException {
        this(s.length == 1 ? s[0] : Value.concat(s), types);
    }

    private static String fixString(String s, int start, int end, boolean isString) {
        StringBuffer sb = new StringBuffer();
        char c = s.charAt(start);
        if (isString && (c == '\'' || c == '\"') && s.charAt(end - 1) == c) {
            --end;
        }
        for (int p = start; p < end; ++p) {
            block9: {
                char x;
                block11: {
                    block12: {
                        block10: {
                            c = s.charAt(p);
                            if (c != '\\') break block9;
                            if (++p < end) break;
                            c = s.charAt(p);
                            if ('0' > c || c > '9') break block10;
                            x = (char)(c - 48);
                            break block11;
                        }
                        if ('A' > c || c > 'F') break block12;
                        x = (char)(c - 55);
                        break block11;
                    }
                    if ('a' > c || c > 'f') break block9;
                    x = (char)(c - 87);
                }
                int ee = Math.min(p + 6, end);
                while (++p < end) {
                    if ('0' <= c && c <= '9') {
                        x = (char)((x << 4) + c - 48);
                        continue;
                    }
                    if ('A' <= c && c <= 'F') {
                        x = (char)((x << 4) + c - 55);
                        continue;
                    }
                    if ('a' <= c && c <= 'f') {
                        x = (char)((x << 4) + c - 87);
                        continue;
                    }
                    if (c == ' ') break;
                    --p;
                    break;
                }
                c = x;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static Number toNumber(String s, ParsePosition pp) throws ParseException {
        DecimalFormat df = new DecimalFormat("0.#");
        if (pp == null) {
            pp = new ParsePosition(0);
        }
        Number n = df.parse(s, pp);
        if (pp.getIndex() == 0) {
            throw new ParseException(s, 0);
        }
        return n;
    }

    private static String concat(String[] s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length; ++i) {
            sb.append(s[i]);
        }
        return sb.toString();
    }

    static {
        keywords.put("inherit", new Integer(1));
        keywords.put("normal", new Integer(2));
        keywords.put("none", new Integer(3));
        keywords.put("hidden", new Integer(11));
        keywords.put("dotted", new Integer(12));
        keywords.put("dashed", new Integer(13));
        keywords.put("solid", new Integer(14));
        keywords.put("double", new Integer(15));
        keywords.put("groove", new Integer(16));
        keywords.put("ridge", new Integer(17));
        keywords.put("inset", new Integer(18));
        keywords.put("outset", new Integer(19));
        keywords.put("thin", new Integer(21));
        keywords.put("medium", new Integer(22));
        keywords.put("thick", new Integer(23));
        keywords.put("left", new Integer(31));
        keywords.put("right", new Integer(32));
        keywords.put("center", new Integer(33));
        keywords.put("justify", new Integer(34));
        keywords.put("both", new Integer(35));
        keywords.put("baseline", new Integer(41));
        keywords.put("sub", new Integer(42));
        keywords.put("super", new Integer(43));
        keywords.put("top", new Integer(44));
        keywords.put("text-top", new Integer(45));
        keywords.put("middle", new Integer(46));
        keywords.put("bottom", new Integer(47));
        keywords.put("pre", new Integer(51));
        keywords.put("nowrap", new Integer(52));
        keywords.put("xx-small", new Integer(61));
        keywords.put("x-small", new Integer(62));
        keywords.put("small", new Integer(63));
        keywords.put("large", new Integer(65));
        keywords.put("x-large", new Integer(66));
        keywords.put("xx-large", new Integer(67));
        keywords.put("smaller", new Integer(68));
        keywords.put("larger", new Integer(69));
        keywords.put("oblique", new Integer(71));
        keywords.put("italic", new Integer(72));
        keywords.put("bold", new Integer(75));
        keywords.put("bolder", new Integer(76));
        keywords.put("lighter", new Integer(77));
        keywords.put("disc", new Integer(81));
        keywords.put("circle", new Integer(82));
        keywords.put("square", new Integer(83));
        keywords.put("decimal", new Integer(84));
        keywords.put("decimal-leading-zero", new Integer(85));
        keywords.put("lower-roman", new Integer(86));
        keywords.put("upper-roman", new Integer(87));
        keywords.put("hebrew", new Integer(88));
        keywords.put("georgian", new Integer(89));
        keywords.put("armenian", new Integer(90));
        keywords.put("cjk-ideographic", new Integer(91));
        keywords.put("hiragana", new Integer(92));
        keywords.put("katakana", new Integer(93));
        keywords.put("hiragana-iroha", new Integer(94));
        keywords.put("katakana-iroha", new Integer(95));
        keywords.put("lower-latin", new Integer(96));
        keywords.put("upper-latin", new Integer(97));
        keywords.put("lower-alpha", new Integer(98));
        keywords.put("upper-alpha", new Integer(99));
        keywords.put("lower-greek", new Integer(100));
        keywords.put("inside", new Integer(101));
        keywords.put("outside", new Integer(102));
        keywords.put("underline", new Integer(4096));
        keywords.put("overline", new Integer(8192));
        keywords.put("line-through", new Integer(16384));
        keywords.put("blink", new Integer(32768));
        keywords.put("transparent", new Integer(901));
        units.put("em", new Integer(1));
        units.put("ex", new Integer(2));
        units.put("px", new Integer(3));
        units.put("in", new Integer(4));
        units.put("cm", new Integer(5));
        units.put("mm", new Integer(6));
        units.put("pt", new Integer(7));
        units.put("pc", new Integer(8));
        TYPES_INT_PER = new int[]{-1, -3};
    }
}

