/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.style;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Vector;
import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.style.Selector;
import net.hizlab.kagetaka.style.Style;
import net.hizlab.kagetaka.util.Charset;

public class CSSParser {
    private static final int INPUT_BUFFER = 4096;
    private static final int TT_NOTHING = 0;
    private static final int TT_EOF = 1;
    private static final int TT_STRINGS = 2;
    private static final int TT_KEYWORD = 3;
    private static final int TT_SYNTAX = 4;
    private static final String[] START_BLOCK = new String[]{"{"};
    private static final String[] END_BLOCK = new String[]{"}"};
    private static final String[] END_PROPERTY = new String[]{":"};
    private static final String[] END_LINE = new String[]{";"};
    private static final String[] END_STYLE = new String[]{"}", ";"};
    private InputStream is = null;
    private BufferedInputStream bis = null;
    private String encoding = null;
    private CSSReader reader = null;
    private Reporter reporter = null;
    private boolean commitEncoding = false;
    private int media = 0;
    private Style style = null;
    private String token = null;
    private String tokenLC = null;
    private StringBuffer sb = new StringBuffer();
    private boolean beforeSyntax = false;
    private boolean nowSyntax = false;
    private Selector selector = null;

    public CSSParser(Reporter reporter, String data) {
        this.reporter = reporter;
        this.reader = new CSSReader(reporter, new BufferedReader(new StringReader(data)));
        this.commitEncoding = true;
    }

    public CSSParser(Reporter reporter, InputStream is, String encoding) {
        this.reporter = reporter;
        this.is = is;
        this.encoding = encoding;
        BufferedReader br = null;
        if (encoding != null && (br = this.createBufferedReader(is, encoding)) != null) {
            this.commitEncoding = true;
        } else {
            this.bis = new BufferedInputStream(is, 4096);
            this.bis.mark(16384);
            br = this.createBufferedReader(this.bis, Charset.getDefaultEncoding());
        }
        this.reader = new CSSReader(reporter, br);
    }

    private BufferedReader createBufferedReader(InputStream is, String encoding) {
        if (encoding != null) {
            try {
                return new BufferedReader(new InputStreamReader(is, encoding), 4096);
            }
            catch (UnsupportedEncodingException e) {
                this.addWarning("charset.warning.invalid", new String[]{encoding}, 0);
                return null;
            }
        }
        return new BufferedReader(new InputStreamReader(is), 4096);
    }

    public static Style valueOf(Reporter reporter, String s) {
        s = "{" + s + "}";
        CSSReader reader = new CSSReader(reporter, new BufferedReader(new StringReader(s)));
        try {
            return reader.readStyle(0, null, false);
        }
        catch (EOFException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public synchronized Style next() throws IOException {
        try {
            while (true) {
                block21: {
                    if ((this.token = this.reader.readToken(true, true)) == null) continue;
                    this.tokenLC = this.token.toLowerCase();
                    if (this.tokenLC.compareTo("@charset") == 0) {
                        this.token = this.reader.readToken(false, true);
                        if (this.token == null || !this.reader.isSyntax(CSSParser.END_LINE) || this.commitEncoding) continue;
                        this.resetEncoding(this.token);
                        continue;
                    }
                    if (!this.commitEncoding) {
                        this.commitEncoding = true;
                    }
                    if (this.tokenLC.compareTo("@media") == 0) {
                        if (this.media != 0) {
                            this.reader.skipNextBlock("cssparser.warning.nestedmedia", null);
                            continue;
                        }
                        this.media = Style.convertMedia(this.reader.getList(true, true));
                        if (this.media == 0) {
                            this.reader.skipNextBlock("cssparser.warning.invalidmedia", null);
                            continue;
                        }
                        this.token = this.reader.readToken(true, true);
                        if (this.token == null) {
                            this.media = 0;
                            continue;
                        }
                        if (this.token.compareTo("{") == 0) continue;
                        this.reader.skipNextBlock("cssparser.warning.invalidposition", this.reader.lastToken);
                        this.media = 0;
                        continue;
                    }
                    if (this.tokenLC.compareTo("@import") == 0) {
                        this.token = this.reader.readToken(false, true);
                        if (this.token == null || !this.reader.isSyntax(CSSParser.END_LINE)) continue;
                        this.importStyle(this.token);
                        continue;
                    }
                    if (this.tokenLC.compareTo("@page") == 0) {
                        this.style = this.reader.readStyle(this.media, null, true);
                        if (this.style == null) continue;
                        return this.style;
                    }
                    if (this.tokenLC.startsWith("@")) {
                        this.reader.skipNextBlock("cssparser.warning.unknown", this.token);
                        continue;
                    }
                    if (this.tokenLC.compareTo("}") == 0) {
                        if (this.media == 0) {
                            this.reader.moveNextLine("cssparser.warning.invalidposition", this.token);
                            continue;
                        }
                        this.media = 0;
                        continue;
                    }
                    if (this.reader.lastTokenType == 4) {
                        this.reader.pushBack();
                        this.reader.skipNextBlock("cssparser.warning.invalidposition", this.reader.lastToken);
                        continue;
                    }
                    this.reader.pushBack();
                    this.beforeSyntax = true;
                    while (true) {
                        this.token = this.reader.readToken(true, false);
                        if (this.token != null && this.token.compareTo("{") == 0) break;
                        boolean bl = this.nowSyntax = this.reader.lastTokenType == 4;
                        if (!this.beforeSyntax && !this.nowSyntax) {
                            this.sb.append(' ');
                        }
                        this.sb.append(this.reader.lastToken);
                        this.beforeSyntax = this.nowSyntax;
                    }
                    this.reader.pushBack();
                    if (this.sb.length() > 0) {
                        this.token = this.sb.toString();
                        this.sb.setLength(0);
                        try {
                            this.selector = new Selector(this.token);
                            break block21;
                        }
                        catch (ParseException e) {
                            if (this.reporter != null) {
                                this.reporter.report(7, e.getMessage(), this.reader.lineNumber, 0);
                            }
                            this.reader.skipNextBlock(null, null);
                            continue;
                        }
                    }
                    this.selector = null;
                }
                if ((this.style = this.reader.readStyle(this.media, this.selector, false)) != null) break;
            }
            return this.style;
        }
        catch (EOFException eOFException) {
            return null;
        }
    }

    private void resetEncoding(String charset) throws IOException {
        if (charset == null) {
            return;
        }
        int lineno = this.reader.lineno();
        String encoding = Charset.toEncoding(charset);
        if (encoding == null) {
            this.addWarning("charset.warning.invalid", new String[]{charset}, lineno);
            return;
        }
        try {
            this.bis.reset();
            this.reader = new CSSReader(this.reporter, this.createBufferedReader(this.bis, encoding));
        }
        catch (IOException e) {
            this.addWarning("charset.warning.reset", new String[]{charset}, lineno);
        }
        this.encoding = encoding;
        this.commitEncoding = true;
        this.reporter.report(3, Resource.getMessage("charset.info.encoding", new String[]{encoding}), lineno, 0);
    }

    private void importStyle(String url) {
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void close() {
        try {
            if (this.bis != null) {
                ((FilterInputStream)this.bis).close();
            }
        }
        catch (IOException e) {
            this.addWarning("cssparser.warning.stream.close", new String[]{e.toString()}, 0);
        }
        try {
            if (this.is != null) {
                this.is.close();
            }
        }
        catch (IOException e) {
            this.addWarning("cssparser.warning.stream.close", new String[]{e.toString()}, 0);
        }
    }

    private void addWarning(String key, String[] args, int lineNumber) {
        this.reporter.report(7, Resource.getMessage(key, args), lineNumber, 0);
    }

    private static class EOFException
    extends Exception {
        private EOFException() {
        }
    }

    private static class CSSReader {
        private Reporter reporter = null;
        private StreamTokenizer tokenizer = null;
        private boolean pushBack = false;
        private String lastToken = null;
        private int lastTokenType = 0;
        private int lineNumber = 0;
        private String token = null;

        private CSSReader(Reporter reporter, BufferedReader br) {
            this.reporter = reporter;
            this.tokenizer = new StreamTokenizer(br);
            this.tokenizer.resetSyntax();
            this.tokenizer.wordChars(0, 65535);
            this.tokenizer.ordinaryChar(34);
            this.tokenizer.ordinaryChar(58);
            this.initTokenizerEndText();
            this.tokenizer.eolIsSignificant(false);
            this.tokenizer.slashSlashComments(false);
        }

        private void initTokenizerStartText() {
            this.tokenizer.wordChars(59, 59);
            this.tokenizer.wordChars(123, 123);
            this.tokenizer.wordChars(125, 125);
            this.tokenizer.wordChars(44, 44);
            this.tokenizer.wordChars(47, 47);
            this.tokenizer.wordChars(40, 40);
            this.tokenizer.wordChars(62, 62);
            this.tokenizer.wordChars(43, 43);
            this.tokenizer.wordChars(9, 16);
            this.tokenizer.wordChars(18, 19);
            this.tokenizer.wordChars(32, 32);
            this.tokenizer.slashStarComments(false);
        }

        private void initTokenizerEndText() {
            this.tokenizer.ordinaryChar(59);
            this.tokenizer.ordinaryChar(123);
            this.tokenizer.ordinaryChar(125);
            this.tokenizer.ordinaryChar(44);
            this.tokenizer.ordinaryChar(47);
            this.tokenizer.ordinaryChar(40);
            this.tokenizer.ordinaryChar(62);
            this.tokenizer.ordinaryChar(43);
            this.tokenizer.whitespaceChars(9, 16);
            this.tokenizer.whitespaceChars(18, 19);
            this.tokenizer.whitespaceChars(32, 32);
            this.tokenizer.slashStarComments(true);
        }

        private Style readStyle(int media, Selector selector, boolean page) throws IOException, EOFException {
            int toplineno = this.tokenizer.lineno();
            this.tokenizer.ordinaryChar(58);
            if (!this.isSyntax(START_BLOCK)) {
                return null;
            }
            String name = null;
            String[] values = null;
            Style style = new Style(this.reporter, toplineno, 0, media != 0 ? media : 0xFFFFFF, selector, page);
            while (true) {
                if ((this.token = this.readToken(true, true)) == null) {
                    continue;
                }
                if (this.token.compareTo("}") == 0) break;
                if (this.token.compareTo(";") == 0) continue;
                if (this.lastTokenType == 4) {
                    this.moveNextLine("cssparser.warning.invalidposition", this.token);
                    continue;
                }
                name = this.token;
                if (!this.isSyntax(END_PROPERTY)) continue;
                values = this.getList(false, false);
                if (!this.isSyntax(END_STYLE)) continue;
                if (values != null) {
                    style.initProperties(name, values);
                }
                if (this.token.compareTo("}") == 0) break;
            }
            this.tokenizer.wordChars(58, 58);
            return style;
        }

        private String readToken(boolean keyword, boolean error) throws IOException, EOFException {
            if (this.pushBack) {
                this.pushBack = false;
                return this.lastToken;
            }
            String returnToken = null;
            block0 : switch (this.tokenizer.nextToken()) {
                case -1: {
                    this.lastToken = null;
                    this.lastTokenType = 1;
                    this.lineNumber = this.tokenizer.lineno();
                    throw new EOFException();
                }
                case -3: {
                    returnToken = this.lastToken = this.tokenizer.sval;
                    this.lastTokenType = 3;
                    this.lineNumber = this.tokenizer.lineno();
                    break;
                }
                case 34: 
                case 40: {
                    this.lineNumber = this.tokenizer.lineno();
                    StringBuffer sb = new StringBuffer();
                    int start = this.tokenizer.ttype;
                    boolean escape = false;
                    int length = 0;
                    this.initTokenizerStartText();
                    if (start == 40) {
                        sb.append('(');
                        this.tokenizer.wordChars(34, 34);
                        this.tokenizer.ordinaryChar(41);
                    }
                    while (true) {
                        switch (this.tokenizer.nextToken()) {
                            case -1: {
                                this.lastToken = null;
                                this.lastTokenType = 1;
                                this.lineNumber = this.tokenizer.lineno();
                                throw new EOFException();
                            }
                            case 34: 
                            case 41: {
                                if (escape) {
                                    sb.append((char)this.tokenizer.ttype);
                                    escape = true;
                                    break;
                                }
                                if (start == 40) {
                                    sb.append(')');
                                    this.tokenizer.ordinaryChar(34);
                                    this.tokenizer.wordChars(41, 41);
                                }
                                this.initTokenizerEndText();
                                this.lastToken = sb.toString();
                                this.lastTokenType = 2;
                                if (!keyword) {
                                    returnToken = this.lastToken;
                                    break block0;
                                }
                                if (!error) break block0;
                                this.moveNextLine("cssparser.warning.invalidstrings", this.lastToken);
                                break block0;
                            }
                            default: {
                                String value = this.tokenizer.sval;
                                if (value == null) {
                                    value = String.valueOf(this.tokenizer.ttype);
                                }
                                length = value.length();
                                for (int i = 0; i < length; ++i) {
                                    if (escape) {
                                        escape = false;
                                        continue;
                                    }
                                    if (value.charAt(i) != '\\') continue;
                                    escape = true;
                                }
                                sb.append(value);
                                break;
                            }
                        }
                    }
                }
                default: {
                    this.lastToken = String.valueOf((char)this.tokenizer.ttype);
                    this.lastTokenType = 4;
                    this.lineNumber = this.tokenizer.lineno();
                    if (keyword) {
                        returnToken = this.lastToken;
                        break;
                    }
                    if (!error) break;
                    this.moveNextLine("cssparser.warning.invalidposition", this.lastToken);
                }
            }
            return returnToken;
        }

        private void pushBack() {
            this.pushBack = true;
        }

        private int lineno() {
            return this.lineNumber;
        }

        private boolean isSyntax(String[] syntax) throws IOException, EOFException {
            this.token = this.readToken(true, true);
            if (this.token == null) {
                return false;
            }
            if (this.lastTokenType == 4) {
                for (int i = 0; i < syntax.length; ++i) {
                    if (syntax[i].compareTo(this.token) != 0) continue;
                    return true;
                }
            }
            this.moveNextLine("cssparser.warning.invalidposition", this.token);
            return false;
        }

        private void moveNextLine(String key, String args) throws IOException, EOFException {
            if (key != null) {
                String[] stringArray;
                if (args != null) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = args;
                } else {
                    stringArray = null;
                }
                this.addWarning(key, stringArray, this.tokenizer.lineno());
            }
            while (true) {
                if ((this.token = this.readToken(true, false)) == null) {
                    continue;
                }
                if (this.token.compareTo(";") == 0) {
                    return;
                }
                if (this.token.compareTo("}") == 0) {
                    this.pushBack();
                    return;
                }
                if (this.token.compareTo("{") == 0) break;
            }
            int level = 1;
            while (true) {
                if ((this.token = this.readToken(true, false)) == null) {
                    continue;
                }
                if (this.token.compareTo("{") == 0) {
                    ++level;
                    continue;
                }
                if (this.token.compareTo("}") == 0 && --level == 0) break;
            }
        }

        private void skipNextBlock(String key, String args) throws IOException, EOFException {
            if (key != null) {
                String[] stringArray;
                if (args != null) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = args;
                } else {
                    stringArray = null;
                }
                this.addWarning(key, stringArray, this.tokenizer.lineno());
            }
            while ((this.token = this.readToken(true, false)) == null || this.token.compareTo("{") != 0) {
            }
            this.pushBack();
            this.moveNextLine(null, null);
        }

        private String[] getList(boolean comma, boolean keyword) throws IOException, EOFException {
            Vector<String> list = new Vector<String>();
            boolean nowcomma = false;
            while (true) {
                this.token = this.readToken(keyword ? true : comma && nowcomma, false);
                if (this.token == null) {
                    if (comma || keyword) break;
                    this.token = this.lastToken;
                }
                if (comma) {
                    if (nowcomma) {
                        if (this.token.compareTo(",") != 0) break;
                        nowcomma = false;
                        continue;
                    }
                    nowcomma = true;
                } else if (this.lastTokenType == 4 && this.token.compareTo(",") != 0) break;
                list.addElement(this.token);
            }
            this.pushBack();
            if (list.size() == 0) {
                return null;
            }
            Object[] values = new String[list.size()];
            list.copyInto(values);
            return values;
        }

        private void addWarning(String key, String[] args, int lineNumber) {
            if (this.reporter != null) {
                this.reporter.report(7, Resource.getMessage(key, args), lineNumber, 0);
            }
        }
    }
}

