/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.rendering;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Vector;
import net.fclabs.util.Queue;
import net.hizlab.kagetaka.rendering.Apply;
import net.hizlab.kagetaka.rendering.Box;
import net.hizlab.kagetaka.rendering.Caddy;
import net.hizlab.kagetaka.rendering.Drawkit;
import net.hizlab.kagetaka.rendering.ImageHolder;
import net.hizlab.kagetaka.rendering.Paragraph;
import net.hizlab.kagetaka.rendering.Position;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.token.FormItem;
import net.hizlab.kagetaka.token.Value;
import net.hizlab.kagetaka.util.CharList;

class Wadge {
    static final int NORMAL = 0;
    static final int BASE = 1;
    static final int RUBY = 2;
    private Caddy caddy;
    private int type;
    private Wadge baseWadge;
    private Drawkit drawkit;
    private Paragraph paragraph;
    private int preferredHeight;
    private CharList charsSpinRight;
    private CharList charsSpinLtrb;
    private CharList charsKinsokuHead;
    private CharList charsKinsokuTail;
    private int TD_UNDERLINE;
    private int TD_OVERLINE;
    private Apply topApply;
    private Apply lastApply;
    private Status status;
    private int offsetRight;
    private int offsetLeft;
    private int linePitch;
    private int letterSpacing;
    private boolean lastHankakuEisu = false;
    private StringBuffer committedBuffer = new StringBuffer();
    private StringBuffer committedSpin = new StringBuffer();
    private int committedWidth = 0;
    private int committedHeight = 0;
    private int committedOffset = 0;
    private int committedPitch = 0;
    private StringBuffer pendingBuffer = new StringBuffer();
    private StringBuffer pendingSpin = new StringBuffer();
    private int pendingWidth = 0;
    private int pendingHeight = 0;
    private int pendingOffset = 0;
    private int pendingPitch = 0;

    Wadge(Caddy caddy, int type, Wadge baseWadge) {
        this.caddy = caddy;
        this.type = type;
        this.baseWadge = baseWadge;
        this.paragraph = caddy.paragraph;
        this.drawkit = this.paragraph.box.drawkit;
        this.preferredHeight = this.paragraph.preferredHeight;
        this.charsSpinRight = this.drawkit.charsSpinRight;
        this.charsSpinLtrb = this.drawkit.charsSpinLtrb;
        this.charsKinsokuHead = this.drawkit.charsKinsokuHead;
        this.charsKinsokuTail = this.drawkit.charsKinsokuTail;
        if (this.drawkit.swapDecoration) {
            this.TD_UNDERLINE = 8192;
            this.TD_OVERLINE = 4096;
        } else {
            this.TD_UNDERLINE = 4096;
            this.TD_OVERLINE = 8192;
        }
        this.status = this.drawkit.status;
        this.topApply = this.lastApply = new Apply(this.status);
        this.cacheStatus();
    }

    void append(String text, int begin, int end) {
        if (!this.drawkit.idQueue.isEmpty()) {
            this.appendId();
        }
        this.lastApply.length += end - begin;
        this.appendInner(text, begin, end);
    }

    private void appendInner(String text, int begin, int end) {
        for (int i = begin; i < end; ++i) {
            char c = text.charAt(i);
            if (c == '\n') {
                this.commitPending();
                this.committedBuffer.append(c);
                this.committedSpin.append('5');
                if (this.committedWidth == 0) {
                    this.committedWidth = this.status.fdFontSize.width;
                    this.committedPitch = this.linePitch;
                }
                this.newLine(true, 0);
                continue;
            }
            if ('0' <= c && c <= '9' || 'A' <= c && c <= 'Z' || 'a' <= c && c <= 'z') {
                if (!this.lastHankakuEisu) {
                    this.commitPending();
                }
                this.appendPending(c, '2');
                this.lastHankakuEisu = true;
                continue;
            }
            this.lastHankakuEisu = false;
            char s = '1';
            if (c <= '\u00ff' || '\uff61' <= c && c <= '\uff9f' || this.charsSpinRight.contains(c)) {
                s = '2';
            } else if (this.charsSpinLtrb.contains(c)) {
                s = '3';
            }
            if (this.charsKinsokuHead.contains(c)) {
                this.appendPending(c, s);
                continue;
            }
            if (this.charsKinsokuTail.contains(c)) {
                this.commitPending();
                this.appendCommit(c, s);
                continue;
            }
            this.commitPending();
            this.appendPending(c, s);
        }
    }

    private boolean canAppend(int h) {
        if (this.status.whiteSpace != 3) {
            return true;
        }
        return this.paragraph.lineHeight + this.paragraph.floatHeight + this.committedHeight + this.pendingHeight + h <= this.preferredHeight;
    }

    private void newLine(boolean br, int newHeight) {
        if (this.type == 0) {
            if (this.committedWidth == 0) {
                this.paragraph.appendLastLine(br, newHeight);
                return;
            }
            this.paragraph.lineWidth = Math.max(this.paragraph.lineWidth, this.committedWidth);
            this.paragraph.lineHeight += this.committedHeight;
            this.paragraph.lineOffset = Math.max(this.paragraph.lineOffset, this.committedOffset);
            this.paragraph.linePitch = Math.max(this.paragraph.linePitch, this.committedPitch);
            this.paragraph.appendLastLine(br, newHeight);
            this.committedWidth = 0;
            this.committedHeight = 0;
            this.committedOffset = 0;
            this.committedPitch = 0;
        } else if (this.paragraph.lineHeight != 0) {
            this.paragraph.appendLastLine(br, newHeight);
        }
    }

    private void appendCommit(char c, char s) {
        int h = this.calculateHeight(c, s);
        if (!this.canAppend(h)) {
            this.newLine(false, h);
        }
        this.committedBuffer.append(c);
        this.committedSpin.append(s);
        this.committedWidth = this.calculateWidth(c, s, this.committedWidth);
        this.committedHeight += h;
        this.committedOffset = Math.max(this.committedOffset, this.offsetLeft);
        this.committedPitch = Math.max(this.committedPitch, this.linePitch);
    }

    private void appendPending(char c, char s) {
        int h = this.calculateHeight(c, s);
        if (!this.canAppend(h)) {
            this.newLine(false, this.pendingHeight + h);
        }
        this.pendingBuffer.append(c);
        this.pendingSpin.append(s);
        this.pendingWidth = this.calculateWidth(c, s, this.pendingWidth);
        this.pendingHeight += h;
        this.pendingOffset = Math.max(this.pendingOffset, this.offsetLeft);
        this.pendingPitch = Math.max(this.pendingPitch, this.linePitch);
    }

    private int calculateWidth(char c, char s, int maxWidth) {
        switch (s) {
            case '2': 
            case '3': {
                return Math.max(maxWidth, (c <= '\u00ff' || '\uff61' <= c && c <= '\uff9f' ? this.status.fontHeightHalf : this.status.fdFontSize.width) + this.offsetRight);
            }
        }
        return Math.max(maxWidth, this.status.fdFontSize.width + this.offsetRight);
    }

    private int calculateHeight(char c, char s) {
        switch (s) {
            case '2': 
            case '3': {
                return this.status.fm.charWidth(c) + this.letterSpacing;
            }
        }
        return this.status.fdFontSize.height + this.letterSpacing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void append(String src, String alt, Value width, Value height, int border, int floatType) {
        if (!this.drawkit.idQueue.isEmpty()) {
            this.appendId();
        }
        ImageHolder ih = new ImageHolder(this.drawkit, this.status, src, alt, width, height, border, floatType);
        char index = '\u0000';
        Vector vector = this.drawkit.images;
        synchronized (vector) {
            index = (char)this.drawkit.images.size();
            this.drawkit.images.addElement(ih);
        }
        ++this.lastApply.length;
        this.appendInner(ih, index);
    }

    private void appendInner(ImageHolder ih, char index) {
        this.commitPending();
        if (ih.floatType != 3) {
            this.paragraph.appendFloatBlock(ih.position.width + ih.border * 2, ih.position.height + ih.border * 2, ih.floatType, ih.floatOffset, this.committedHeight);
            this.committedBuffer.append(index);
            this.committedSpin.append('4');
            return;
        }
        int h = ih.position.height + ih.border * 2 + this.letterSpacing;
        if (!this.canAppend(h)) {
            this.newLine(false, h);
        }
        this.committedBuffer.append(index);
        this.committedSpin.append('4');
        this.committedWidth = Math.max(this.committedWidth, ih.position.width + ih.border * 2 + this.offsetRight);
        this.committedHeight += h;
        this.committedOffset = Math.max(this.committedOffset, this.offsetLeft - ((this.status.decoration & this.TD_UNDERLINE) != 0 ? 1 : 0));
        this.committedPitch = Math.max(this.committedPitch, this.linePitch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void append(Box box) {
        char index = '\u0000';
        Vector vector = this.drawkit.floats;
        synchronized (vector) {
            index = (char)this.drawkit.floats.size();
            this.drawkit.floats.addElement(box);
        }
        ++this.lastApply.length;
        this.appendInner(box, index);
    }

    void appendInner(Box box, char index) {
        this.commitPending();
        this.paragraph.appendFloatBlock(box.drawWidth, box.drawHeight, box.status.floatType, box.floatOffset, this.committedHeight);
        this.committedBuffer.append(index);
        this.committedSpin.append('7');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void append(FormItem item) {
        char index = '\u0000';
        Vector vector = this.drawkit.formItems;
        synchronized (vector) {
            index = (char)this.drawkit.formItems.size();
            this.drawkit.formItems.addElement(item);
        }
        ++this.lastApply.length;
        this.appendInner(item, index);
    }

    void appendInner(FormItem item, char index) {
        this.commitPending();
        Dimension size = item.getSize();
        if (!this.canAppend(size.height)) {
            this.newLine(false, size.height);
        }
        this.committedBuffer.append(index);
        this.committedSpin.append('8');
        this.committedWidth = Math.max(this.committedWidth, size.width + this.offsetRight);
        this.committedHeight += size.height;
        this.committedOffset = Math.max(this.committedOffset, this.offsetLeft);
        this.committedPitch = Math.max(this.committedPitch, this.linePitch);
    }

    private void appendId() {
        String id;
        while ((id = (String)this.drawkit.idQueue.get()) != null) {
            this.appendInner((char)this.drawkit.ids.size());
            this.drawkit.ids.addElement(id);
            ++this.lastApply.length;
        }
    }

    private void appendInner(char index) {
        this.pendingBuffer.append(index);
        this.pendingSpin.append('6');
    }

    void statusChanged() {
        this.status = this.drawkit.status;
        this.lastApply = this.lastApply.next = new Apply(this.status);
        this.cacheStatus();
    }

    private void cacheStatus() {
        this.offsetRight = Math.max(this.status.offsetX, 0);
        if ((this.status.decoration & this.TD_OVERLINE) != 0) {
            ++this.offsetRight;
        }
        this.offsetLeft = Math.max(-this.status.offsetX, 0);
        if ((this.status.decoration & this.TD_UNDERLINE) != 0) {
            ++this.offsetLeft;
        }
        this.linePitch = 0;
        if (this.type != 2 && this.status.lineHeight != null) {
            this.linePitch = this.status.lineHeight.getValue(this.status.fd, this.status.fdFontSize.width, 1) - this.status.fdFontSize.width;
        }
        this.letterSpacing = 0;
        if (this.type != 2 && this.status.letterSpacing != null) {
            this.letterSpacing = this.status.letterSpacing.getValue(this.status.fd, this.status.fdFontSize.width, 2);
        }
        this.lastApply.offsetRight = this.offsetRight;
        this.lastApply.offsetLeft = this.offsetLeft;
        this.lastApply.linePitch = this.linePitch;
        this.lastApply.letterSpacing = this.letterSpacing;
    }

    void commitPending() {
        if (this.pendingBuffer.length() == 0) {
            return;
        }
        this.committedBuffer.append(this.pendingBuffer.toString());
        this.committedSpin.append(this.pendingSpin.toString());
        this.committedWidth = Math.max(this.committedWidth, this.pendingWidth);
        this.committedHeight += this.pendingHeight;
        this.committedOffset = Math.max(this.committedOffset, this.pendingOffset);
        this.committedPitch = Math.max(this.committedPitch, this.pendingPitch);
        this.pendingBuffer.setLength(0);
        this.pendingSpin.setLength(0);
        this.pendingWidth = 0;
        this.pendingHeight = 0;
        this.pendingOffset = 0;
        this.pendingPitch = 0;
    }

    void commit() {
        this.commitPending();
        switch (this.type) {
            case 0: 
            case 1: {
                this.caddy.width = this.committedWidth;
                this.caddy.height = this.committedHeight;
                this.caddy.offset = this.committedOffset;
                this.caddy.pitch = this.committedPitch;
                break;
            }
            case 2: {
                this.caddy.width += this.committedWidth;
                this.caddy.width += (int)((double)this.baseWadge.committedWidth * 0.1);
                this.caddy.width += this.committedOffset;
                this.caddy.height = Math.max(this.caddy.height, this.committedHeight);
            }
        }
    }

    void rearrange(int newHeight) {
        this.preferredHeight = newHeight;
        int length = this.committedBuffer.length();
        if (length == 0) {
            return;
        }
        String buffer = this.committedBuffer.toString();
        String spin = this.committedSpin.toString();
        this.committedBuffer.setLength(0);
        this.committedSpin.setLength(0);
        this.committedWidth = 0;
        this.committedHeight = 0;
        this.committedOffset = 0;
        this.committedPitch = 0;
        this.pendingBuffer.setLength(0);
        this.pendingSpin.setLength(0);
        this.pendingWidth = 0;
        this.pendingHeight = 0;
        this.pendingOffset = 0;
        this.pendingPitch = 0;
        Apply apply = this.topApply;
        int applyLength = apply.length;
        int num = 0;
        for (int i = 0; i < length; i += applyLength) {
            while ((applyLength = apply.length) == 0) {
                apply = apply.next;
            }
            this.status = apply.status;
            this.offsetRight = apply.offsetRight;
            this.offsetLeft = apply.offsetLeft;
            this.linePitch = apply.linePitch;
            this.letterSpacing = apply.letterSpacing;
            int end = i + applyLength;
            char s = spin.charAt(end - 1);
            switch (s) {
                case '4': 
                case '7': 
                case '8': {
                    --end;
                    break;
                }
                case '6': {
                    do {
                        ++num;
                    } while ((s = spin.charAt(--end - 1)) == '6');
                }
            }
            if (i < end) {
                this.appendInner(buffer, i, end);
            }
            switch (s) {
                case '4': {
                    char index = buffer.charAt(end);
                    this.appendInner((ImageHolder)this.drawkit.images.elementAt(index), index);
                    break;
                }
                case '6': {
                    do {
                        this.appendInner(buffer.charAt(end));
                        ++end;
                    } while (--num > 0);
                    break;
                }
                case '7': {
                    char index = buffer.charAt(end);
                    Box box = (Box)this.drawkit.floats.elementAt(index);
                    box.rearrange(box.resolvePercent(newHeight), newHeight);
                    this.appendInner(box, index);
                    break;
                }
                case '8': {
                    char index = buffer.charAt(end);
                    this.appendInner((FormItem)this.drawkit.formItems.elementAt(index), index);
                }
            }
            applyLength = 0;
            apply = apply.next;
        }
        this.commit();
    }

    void draw(Position p, int maxHeight) {
        int length = this.committedBuffer.length();
        if (length == 0) {
            return;
        }
        Graphics g = this.drawkit.g;
        this.status = null;
        int startx = p.x;
        double space = 0.0;
        if (this.committedHeight < maxHeight) {
            space = (double)(maxHeight - this.committedHeight) / (double)length / 2.0;
        }
        if (this.type == 2) {
            p.x += this.baseWadge.committedWidth;
            p.x += (int)((double)this.baseWadge.committedWidth * 0.1);
            p.y -= maxHeight;
        }
        ImageHolder ih = null;
        int i = 0;
        block8: while (i < length) {
            int w;
            if (p.y > p.height) {
                System.out.println("### Wadge.draw.newLine??? [" + p.y + "," + p.height + "]");
                System.out.println("### [" + (i - Math.max(i - 10, 0)) + "],[" + this.committedBuffer.toString().substring(Math.max(i - 10, 0), Math.min(i + 10, length)) + "]");
            }
            while (this.topApply.length == 0) {
                this.topApply = this.topApply.next;
            }
            if (this.status != this.topApply.status) {
                this.status = this.topApply.status;
                this.letterSpacing = this.topApply.letterSpacing;
                g.setColor(this.status.foreColor);
                g.setFont(this.status.font);
            }
            int begin = i;
            char c = this.committedBuffer.charAt(i);
            char s = this.committedSpin.charAt(i);
            if (s == '4') {
                ih = (ImageHolder)this.drawkit.images.elementAt(c);
            }
            if (p.y >= p.height && s != '6' && s != '7' && (s != '4' || ih.floatType == 3)) {
                p.newLine();
            }
            int y1 = p.y;
            int x = p.x + this.status.offsetX;
            switch (s) {
                case '2': 
                case '3': {
                    int h = 0;
                    w = this.status.fontHeightMax;
                    do {
                        h += this.status.fm.charWidth(this.committedBuffer.charAt(i));
                        h += (int)((double)(i * 2 + 2) * space) - (int)((double)(i * 2) * space);
                        --this.topApply.length;
                    } while (p.y + (h += this.letterSpacing) < p.height && ++i < length && this.topApply.length > 0 && this.committedSpin.charAt(i) == s);
                    this.drawkit.drawTextWithSpin(this.committedBuffer, begin, i, x, p.y, h, w, this.status, space, this.letterSpacing, s);
                    p.y += h;
                    break;
                }
                case '4': {
                    if (ih.floatType == 3) {
                        p.y += (int)((double)(i * 2 + 1) * space) - (int)((double)(i * 2) * space);
                        ih.draw(x, p.y);
                        p.y += ih.position.height + ih.border * 2;
                        p.y += (int)((double)(i * 2 + 2) * space) - (int)((double)(i * 2 + 1) * space);
                        p.y += this.letterSpacing;
                    } else {
                        ih.floatDelayX = p.startX - ih.floatOffset.x - ih.position.width - ih.border * 2;
                        ih.floatDelayY = p.startY + ih.floatOffset.y;
                        if (this.drawkit.floatQueue == null) {
                            this.drawkit.floatQueue = new Queue();
                        }
                        this.drawkit.floatQueue.put(ih);
                    }
                    --this.topApply.length;
                    ++i;
                    continue block8;
                }
                case '5': {
                    --this.topApply.length;
                    ++i;
                    continue block8;
                }
                case '6': {
                    this.drawkit.itemMap.addId((String)this.drawkit.ids.elementAt(c), this.drawkit.size.width - (x + p.width + 4), 0);
                    --this.topApply.length;
                    ++i;
                    continue block8;
                }
                case '7': {
                    Box box = (Box)this.drawkit.floats.elementAt(c);
                    box.floatDelayX = p.startX - box.floatOffset.x;
                    box.floatDelayY = p.startY + box.floatOffset.y;
                    if (this.drawkit.floatQueue == null) {
                        this.drawkit.floatQueue = new Queue();
                    }
                    this.drawkit.floatQueue.put(box);
                    --this.topApply.length;
                    ++i;
                    continue block8;
                }
                case '8': {
                    FormItem item = (FormItem)this.drawkit.formItems.elementAt(c);
                    Dimension size = item.getSize();
                    if (item.isNeedBackImage()) {
                        Image image = this.drawkit.context.createImage(size.width, size.height);
                        Graphics og = image.getGraphics();
                        this.drawkit.drawImageSync(og, this.drawkit.panel, 0, 0, size.width, size.height, p.x, p.y, size.width + p.x, size.height + p.y);
                        og.dispose();
                        item.setBackImage(image);
                    }
                    item.show(this.drawkit.size.width - (x + item.getSize().width + 1), y1);
                    p.y += size.height;
                    --this.topApply.length;
                    ++i;
                    continue block8;
                }
                default: {
                    int h = 0;
                    w = this.status.fdFontSize.width;
                    do {
                        h += this.status.fdFontSize.height;
                        h += (int)((double)(i * 2 + 2) * space) - (int)((double)(i * 2) * space);
                        --this.topApply.length;
                    } while (p.y + (h += this.letterSpacing) < p.height && ++i < length && this.topApply.length > 0 && this.committedSpin.charAt(i) == s);
                    this.drawkit.drawTextTate(this.committedBuffer, begin, i, x, p.y, this.status, space, this.letterSpacing);
                    p.y += h;
                }
            }
            int y2 = p.y;
            if (this.status.href != null) {
                this.drawkit.itemMap.addHref(this.drawkit.size.width - (x + w + 1), y1, this.drawkit.size.width - x, y2, this.status.href);
            }
            if (this.status.tip != null) {
                this.drawkit.itemMap.addTip(this.drawkit.size.width - (x + w + 1), y1, this.drawkit.size.width - x, y2, this.status.tip);
            }
            if (this.status.decoration == 0 || this.type == 2) continue;
            int right = x;
            if ((this.status.decoration & this.TD_UNDERLINE) != 0) {
                right = x - 1;
                g.drawLine(right, y1, right, y2);
            }
            if ((this.status.decoration & this.TD_OVERLINE) != 0) {
                right = x + this.status.fdFontSize.width + 1 - 1;
                g.drawLine(right, y1, right, y2);
            }
            if ((this.status.decoration & 0x4000) == 0) continue;
            right = x + (int)((double)this.status.fdFontSize.width * 0.4);
            g.drawLine(right, y1, right, y2);
        }
        if (this.type == 2) {
            p.x = startx;
        }
    }

    public String toString() {
        return this.committedBuffer.toString();
    }
}

