/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.rendering;

import java.awt.Image;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.rendering.ConnectWrapper;
import net.hizlab.kagetaka.rendering.HawkContext;
import net.hizlab.kagetaka.rendering.Request;

class ImageCache {
    private static ImageCache imageCache = new ImageCache();
    private boolean hasOldCache;
    private boolean hasNewCache;
    private Hashtable oldCache = new Hashtable();
    private Hashtable newCache = new Hashtable();
    private Hashtable typeCache = new Hashtable();

    private ImageCache() {
    }

    static ImageCache getInstance() {
        return imageCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Image getImage(HawkContext context, URL url, String src, Request request, boolean create) throws IOException, InterruptedException {
        String urlString = url.toExternalForm();
        ImageCache imageCache = this;
        synchronized (imageCache) {
            Image image = null;
            if (this.hasNewCache && (image = (Image)this.newCache.get(urlString)) != null) {
                return image;
            }
            if (this.hasOldCache && (image = (Image)this.oldCache.get(urlString)) != null) {
                this.newCache.put(urlString, image);
                this.oldCache.remove(urlString);
                this.hasNewCache = true;
                this.hasOldCache = this.oldCache.size() > 0;
                return image;
            }
            if (!create) {
                return null;
            }
            URLConnection connection = ConnectWrapper.getURLConnection(context, new Request(url, null, request.getDocument().url, null, false, false, 2));
            if (connection != null) {
                return this.createImage(context, urlString, src, connection);
            }
        }
        this.reportMessage(context, 3, "render.info.image.null", new String[]{src});
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image createImage(HawkContext context, String urlString, String src, URLConnection connection) throws IOException {
        Object content = null;
        try {
            context.setStatus(Resource.getMessage("engine.status.load.start", new String[]{urlString}));
            content = connection.getContent();
        }
        catch (Exception e) {
            this.reportMessage(context, 7, "render.warning.image.content", new String[]{src});
            return null;
        }
        if (content instanceof ImageProducer) {
            String type = connection.getContentType();
            if (type != null) {
                this.typeCache.put(urlString, type.toLowerCase());
            }
            Image image = context.createImage((ImageProducer)content);
            ImageCache imageCache = this;
            synchronized (imageCache) {
                this.newCache.put(urlString, image);
                this.hasNewCache = true;
            }
            return image;
        }
        this.reportMessage(context, 7, "render.warning.image.invalid", new String[]{src});
        return null;
    }

    String getContentType(URL url) {
        return (String)this.typeCache.get(url.toExternalForm());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        ImageCache imageCache = this;
        synchronized (imageCache) {
            if (this.oldCache.size() > 0) {
                Enumeration e = this.oldCache.elements();
                while (e.hasMoreElements()) {
                    ((Image)e.nextElement()).flush();
                }
                this.oldCache.clear();
                this.hasOldCache = false;
            }
            if (this.hasNewCache) {
                this.oldCache = this.newCache;
                this.newCache = new Hashtable();
                this.hasOldCache = true;
                this.hasNewCache = false;
            }
        }
    }

    private void reportMessage(HawkContext context, int type, String key, String[] args) {
        Reporter reporter = context.getReporter();
        if (reporter != null) {
            reporter.report(type, Resource.getMessage(key, args), 0, 0);
        }
    }
}

