/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.rendering;

import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.SystemColor;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.net.URL;
import java.util.Vector;
import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.rendering.Canvas;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.HawkContext;
import net.hizlab.kagetaka.rendering.ItemMap;
import net.hizlab.kagetaka.rendering.Option;
import net.hizlab.kagetaka.rendering.PanelListener;
import net.hizlab.kagetaka.rendering.PanelScrollbar;
import net.hizlab.kagetaka.rendering.Request;
import net.hizlab.kagetaka.token.FormItem;

public class HawkPanel
extends Container {
    private static final long RESIZE_WAIT = 10000L;
    private static final long TIP_DELAY = 700L;
    private static final long TIP_TERM = 5000L;
    private static final long EVENT_DELAY = 30L;
    private static final int MENU_MENU = 0;
    private static final int MENU_ITEM = 1;
    private static final int MENU_CHECK = 2;
    private static final int MENU_SEPARATOR = -1;
    public static final String MENU_MAIN_BACK = "canvas.menu.main.back";
    private static final int MENU_MAIN_BACK_INDEX = 2;
    public static final String MENU_MAIN_FORWARD = "canvas.menu.main.forward";
    private static final int MENU_MAIN_FORWARD_INDEX = 3;
    public static final String MENU_MAIN_STOP = "canvas.menu.main.stop";
    private static final int MENU_MAIN_STOP_INDEX = 4;
    public static final String MENU_MAIN_RELOAD = "canvas.menu.main.reload";
    private static final int MENU_MAIN_RELOAD_INDEX = 5;
    public static final String MENU_MAIN_OPTION = "canvas.menu.main.option";
    private static final int MENU_MAIN_OPTION_INDEX = 7;
    public static final String MENU_MAIN_OPTION_IMAGE = "canvas.menu.main.option.image";
    private static final int MENU_MAIN_OPTION_IMAGE_INDEX = 8;
    public static final String MENU_MAIN_OPTION_BAR = "canvas.menu.main.option.bar";
    private static final int MENU_MAIN_OPTION_BAR_INDEX = 9;
    public static final String MENU_MAIN_OPTION_SPINGIF = "canvas.menu.main.option.spingif";
    private static final int MENU_MAIN_OPTION_SPINGIF_INDEX = 10;
    public static final String MENU_MAIN_OPTION_SPINJPEG = "canvas.menu.main.option.spinjpeg";
    private static final int MENU_MAIN_OPTION_SPINJPEG_INDEX = 11;
    public static final String MENU_MAIN_INFO = "canvas.menu.main.info";
    private static final int MENU_MAIN_INFO_INDEX = 12;
    public static final String MENU_LINK_COPY = "canvas.menu.link.copy";
    private static final int MENU_LINK_COPY_INDEX = 24;
    public static final String MENU_IMAGE_OPEN = "canvas.menu.image.open";
    private static final int MENU_IMAGE_OPEN_INDEX = 32;
    public static final String MENU_IMAGE_COPY = "canvas.menu.image.copy";
    private static final int MENU_IMAGE_COPY_INDEX = 33;
    private static final int MENU_SIZE = 34;
    public static final int SCROLL_HORIZONTAL = 1;
    public static final int SCROLL_VERTICAL = 2;
    public static final int SCROLL_UNIT = 0;
    public static final int SCROLL_BLOCK = 1;
    private HawkContext hawkContext;
    private Option option;
    private GridBagLayout gbl;
    private Canvas canvas;
    private PanelScrollbar horizontal;
    private PanelScrollbar vertical;
    private boolean horizontalAdded;
    private boolean verticalAdded;
    private boolean toolTipUse = true;
    private long toolTipDelay = 700L;
    private long toolTipTerm = 5000L;
    private Dimension canvasSize;
    private Dimension viewportSize;
    private Point position;
    private PopupMenu popupMenu;
    private MenuItem[] menuItems;
    private Vector mainMenuItems = new Vector();
    private Vector linkMenuItems = new Vector();
    private Vector imageMenuItems = new Vector();
    private Dimension charScale;
    private PanelListener listener;
    private Object cursorLock = new Object();
    private int defaultCursorType = 0;
    private int temporaryCursorType = 0;
    private int cursorType = 0;
    private Request request;
    private URL currentLink;
    private URL currentImage;
    private ItemMap itemMap;
    private boolean callRequestFocus;

    public HawkPanel(HawkContext hawkContext, PanelScrollbar h, PanelScrollbar v) {
        this.hawkContext = hawkContext;
        this.option = hawkContext.getOption();
        this.gbl = new GridBagLayout();
        this.canvas = new Canvas(hawkContext);
        this.horizontal = h;
        this.vertical = v;
        this.canvasSize = new Dimension(0, 0);
        this.viewportSize = new Dimension(0, 0);
        this.position = new Point(0, 0);
        this.charScale = new Dimension(0, 0);
        h.addAdjustmentListener(new ScrollbarListener(0, h));
        v.addAdjustmentListener(new ScrollbarListener(1, v));
        this.setLayout(this.gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        this.addComponent(this.canvas, this.gbl, gbc, 1.0, 0, 0, 1);
        if (this.option.getShowScrollbar()) {
            this.fixScrollbar(true, false);
        }
        super.setBackground(SystemColor.control);
        this.initMenu();
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                HawkPanel.this.canvas.requestFocus();
            }
        });
        this.canvas.addKeyListener(new HawkCanvasKeyListener());
        this.canvas.addMouseListener(new HawkCanvasMouseListener());
        this.canvas.addMouseMotionListener(new HawkCanvasMouseMotionListener());
        this.canvas.addComponentListener(new HawkCanvasComponentListener());
    }

    private void addComponent(Component c, GridBagLayout gbl, GridBagConstraints gbc, double weight, int x, int y, int fill) {
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.weightx = weight;
        gbc.weighty = weight;
        gbc.fill = fill;
        gbl.setConstraints(c, gbc);
        this.add(c);
    }

    private void initMenu() {
        Menu menu = null;
        this.menuItems = new MenuItem[34];
        this.popupMenu = new PopupMenu(Resource.getMessage("canvas.menu", null));
        this.canvas.add(this.popupMenu);
        this.createMenuItem(2, 1, null, this.mainMenuItems);
        this.createMenuItem(3, 1, null, this.mainMenuItems);
        this.createMenuItem(-1, 1, null, this.mainMenuItems);
        this.createMenuItem(4, 1, null, this.mainMenuItems);
        this.createMenuItem(5, 1, null, this.mainMenuItems);
        this.createMenuItem(-1, 1, null, this.mainMenuItems);
        menu = (Menu)this.createMenuItem(7, 0, null, this.mainMenuItems);
        this.createMenuItem(8, 2, menu, null);
        this.createMenuItem(9, 2, menu, null);
        this.createMenuItem(10, 2, menu, null);
        this.createMenuItem(11, 2, menu, null);
        this.createMenuItem(24, 1, null, this.linkMenuItems);
        this.createMenuItem(32, 1, null, this.imageMenuItems);
        this.createMenuItem(33, 1, null, this.imageMenuItems);
    }

    private MenuItem createMenuItem(int index, int type, Menu parent, Vector items) {
        String menuKey = null;
        switch (index) {
            case -1: {
                break;
            }
            case 2: {
                menuKey = MENU_MAIN_BACK;
                break;
            }
            case 3: {
                menuKey = MENU_MAIN_FORWARD;
                break;
            }
            case 4: {
                menuKey = MENU_MAIN_STOP;
                break;
            }
            case 5: {
                menuKey = MENU_MAIN_RELOAD;
                break;
            }
            case 7: {
                menuKey = MENU_MAIN_OPTION;
                break;
            }
            case 8: {
                menuKey = MENU_MAIN_OPTION_IMAGE;
                break;
            }
            case 9: {
                menuKey = MENU_MAIN_OPTION_BAR;
                break;
            }
            case 10: {
                menuKey = MENU_MAIN_OPTION_SPINGIF;
                break;
            }
            case 11: {
                menuKey = MENU_MAIN_OPTION_SPINJPEG;
                break;
            }
            case 12: {
                menuKey = MENU_MAIN_INFO;
                break;
            }
            case 24: {
                menuKey = MENU_LINK_COPY;
                break;
            }
            case 32: {
                menuKey = MENU_IMAGE_OPEN;
                break;
            }
            case 33: {
                menuKey = MENU_IMAGE_COPY;
                break;
            }
            default: {
                Reporter reporter = this.hawkContext.getReporter();
                if (reporter != null) {
                    reporter.report(10, Resource.getMessage("internal.error", new String[]{"HawkPanel.createMenuItem", "panel menu", ""}), 0, 0);
                }
                return null;
            }
        }
        String label = menuKey == null ? "-" : Resource.getMessage(menuKey, null);
        MenuItem mi = null;
        switch (type) {
            case 0: {
                mi = new Menu(label);
                break;
            }
            case 1: {
                mi = new MenuItem(label);
                if (index == -1) break;
                mi.addActionListener(new MenuActionListner(index));
                break;
            }
            case 2: {
                mi = new CheckboxMenuItem(label);
                ((CheckboxMenuItem)mi).addItemListener(new MenuActionListner(index));
            }
        }
        mi.setActionCommand(menuKey != null ? menuKey : "-");
        if (index != -1) {
            this.menuItems[index] = mi;
        }
        if (parent != null) {
            parent.add(mi);
        }
        if (items != null) {
            items.addElement(mi);
        }
        return mi;
    }

    public Point getScrollPosition() {
        return new Point(this.position.x, this.position.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setScrollPosition(int x, int y, boolean force) {
        Dimension dimension = this.canvasSize;
        synchronized (dimension) {
            if (!force && (x > 0 && x + this.viewportSize.width > this.canvasSize.width || y > 0 && y + this.viewportSize.height > this.canvasSize.height)) {
                return false;
            }
            this.setScrollPosition(x, y);
        }
        return true;
    }

    public boolean setScrollPosition(String reference, boolean force) {
        if (reference == null || this.itemMap == null) {
            return force;
        }
        Point position = this.itemMap.getIdPoint(reference);
        if (position == null) {
            return force;
        }
        return this.setScrollPosition(position.x, position.y, force);
    }

    public Vector getMainMenuItems() {
        return this.mainMenuItems;
    }

    public Vector getLinkMenuItems() {
        return this.linkMenuItems;
    }

    public Vector getImageMenuItems() {
        return this.imageMenuItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isVisibleScrollbar() {
        Dimension dimension = this.canvasSize;
        synchronized (dimension) {
            return this.horizontalAdded;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisibleScrollbar(boolean b) {
        Dimension dimension = this.canvasSize;
        synchronized (dimension) {
            this.fixScrollbar(b, b ? this.verticalAdded : false);
            this.option.setShowScrollbar(b);
        }
    }

    public void setPanelListener(PanelListener listener) {
        this.listener = listener;
    }

    public MediaTracker getMediaTracker() {
        return new MediaTracker(this.canvas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImage(Image image, int width, int height) {
        Dimension dimension = this.canvasSize;
        synchronized (dimension) {
            this.canvasSize.width += width;
            this.canvasSize.height = Math.max(height, this.canvasSize.height);
            this.horizontal.setMaximum(Math.max(this.canvasSize.width, this.viewportSize.width));
            this.vertical.setMaximum(Math.max(this.canvasSize.height, this.viewportSize.height));
            this.canvas.addImage(image, width, height);
            if (this.horizontalAdded && this.canvasSize.height > this.viewportSize.height && !this.verticalAdded) {
                this.fixScrollbar(true, true);
            }
        }
    }

    public void addFormItem(FormItem item) {
        this.canvas.addFormItem(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setupCanvas(Request request) {
        Dimension dimension = this.canvasSize;
        synchronized (dimension) {
            this.request = request;
            Document document = request.getDocument();
            this.canvas.setupScreen(document.getBackColor(), document.getBackImage());
            this.itemMap = request.getDocument().itemMap;
            this.canvasSize.width = 0;
            this.canvasSize.height = 0;
            this.position.x = 0;
            this.position.y = 0;
            this.horizontal.setMaximum(this.viewportSize.width);
            this.vertical.setMaximum(this.viewportSize.height);
            this.charScale = document.getCharScale();
            this.horizontal.setUnitIncrement(this.charScale.width);
            this.vertical.setUnitIncrement(this.charScale.height);
            this.horizontal.setBlockIncrement(this.viewportSize.width - this.charScale.width);
            this.vertical.setBlockIncrement(this.viewportSize.height - this.charScale.height);
        }
        if (this.horizontalAdded != this.option.getShowScrollbar() || this.verticalAdded) {
            dimension = this.viewportSize;
            synchronized (dimension) {
                this.fixScrollbar(this.option.getShowScrollbar(), false);
                try {
                    this.viewportSize.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.resetStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaintCanvas(int x, int y, int width, int height) {
        Dimension dimension = this.canvasSize;
        synchronized (dimension) {
            if (this.canvasSize.width < x || this.canvasSize.height < y) {
                return;
            }
            this.canvas.repaintImage(x, y, width, height);
        }
    }

    public void setCursor(int cursor) {
        this.setCursor(Cursor.getPredefinedCursor(cursor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getViewportSize() {
        Dimension dimension = this.viewportSize;
        synchronized (dimension) {
            if (this.viewportSize.width == 0 && this.viewportSize.height == 0 && this.getParent() != null) {
                try {
                    this.viewportSize.wait(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return new Dimension(this.viewportSize.width, this.viewportSize.height);
        }
    }

    public URL getSelectedLink() {
        return this.currentLink;
    }

    public Component getCanvas() {
        return this.canvas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scroll(int sense, int type, int value) {
        Dimension dimension = this.canvasSize;
        synchronized (dimension) {
            int x = this.position.x;
            int y = this.position.y;
            if (type == 0) {
                if (sense == 1) {
                    x += this.charScale.width * value;
                } else {
                    y += this.charScale.height * value;
                }
            } else if (sense == 1) {
                x += (this.viewportSize.width - this.charScale.width) * value;
            } else {
                y += (this.viewportSize.height - this.charScale.height) * value;
            }
            this.setScrollPosition(x, y);
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        super.paint(g);
        Dimension dimension = this.viewportSize;
        synchronized (dimension) {
            this.paintCorner(g);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.canvas.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCursor(Cursor cursor) {
        Object object = this.cursorLock;
        synchronized (object) {
            this.defaultCursorType = cursor.getType();
            if (this.temporaryCursorType == 0 && this.cursorType != this.defaultCursorType) {
                this.cursorType = this.defaultCursorType;
                super.setCursor(cursor);
                this.canvas.setCursor(cursor);
            }
        }
    }

    public void setToolTipOption(boolean use, long delay, long term) {
        this.toolTipUse = use;
        this.toolTipDelay = delay;
        this.toolTipTerm = term;
    }

    public void requestFocus() {
        if (this.callRequestFocus) {
            return;
        }
        this.callRequestFocus = true;
        super.requestFocus();
        this.canvas.requestFocus();
        this.callRequestFocus = false;
    }

    public String paramString() {
        String str = super.paramString();
        return str;
    }

    private void setScrollPosition(int x, int y) {
        x = Math.max(Math.min(x, this.canvasSize.width - this.viewportSize.width), 0);
        y = Math.max(Math.min(y, this.canvasSize.height - this.viewportSize.height), 0);
        if (this.position.x == x && this.position.y == y) {
            return;
        }
        this.resetStatus();
        this.position.x = x;
        this.position.y = y;
        this.horizontal.setValue(this.horizontal.getMaximum() - this.horizontal.getVisibleAmount() - x);
        this.vertical.setValue(y);
        this.canvas.movePosition(x, y);
    }

    private void appendPopupMenuItem(Vector src) {
        if (src.size() == 0) {
            return;
        }
        if (this.popupMenu.getItemCount() > 0) {
            this.popupMenu.addSeparator();
        }
        for (int i = 0; i < src.size(); ++i) {
            MenuItem mi = (MenuItem)src.elementAt(i);
            if (mi.getLabel() != null && mi.getLabel().compareTo("-") != 0) {
                this.popupMenu.remove(mi);
            }
            this.popupMenu.add(mi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL getLinkURL(int x, int y) {
        Dimension dimension = this.canvasSize;
        synchronized (dimension) {
            if (this.itemMap == null) {
                return null;
            }
            x = this.position.x + this.viewportSize.width - x;
            return this.itemMap.getLinkURL(x, y += this.position.y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL getImageURL(int x, int y) {
        Dimension dimension = this.canvasSize;
        synchronized (dimension) {
            if (this.itemMap == null) {
                return null;
            }
            x = this.position.x + this.viewportSize.width - x;
            return this.itemMap.getImageURL(x, y += this.position.y);
        }
    }

    private void setTemporaryCursor(int type) {
        this.temporaryCursorType = type;
        if (type == 0) {
            type = this.defaultCursorType;
        }
        if (this.cursorType != type) {
            this.cursorType = type;
            Cursor cursor = Cursor.getPredefinedCursor(this.cursorType);
            super.setCursor(cursor);
            this.canvas.setCursor(cursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixScrollbar(boolean h, boolean v) {
        if (this.horizontalAdded == h && this.verticalAdded == v) {
            return;
        }
        GridBagConstraints gbc = new GridBagConstraints();
        if (this.horizontalAdded != h) {
            if (h) {
                this.addComponent(this.horizontal.getComponent(), this.gbl, gbc, 0.0, 0, 1, 2);
            } else {
                this.remove(this.horizontal.getComponent());
            }
            this.horizontalAdded = h;
        }
        if (this.verticalAdded != v) {
            if (v) {
                this.addComponent(this.vertical.getComponent(), this.gbl, gbc, 0.0, 1, 0, 3);
            } else {
                this.remove(this.vertical.getComponent());
            }
            this.verticalAdded = v;
        }
        this.validate();
        Graphics g = this.getGraphics();
        if (g != null) {
            try {
                this.paintCorner(g);
            }
            finally {
                g.dispose();
            }
        }
    }

    private void paintCorner(Graphics g) {
        if (this.verticalAdded) {
            Dimension size = this.getSize();
            Point posH = this.horizontal.getComponent().getLocation();
            Point posV = this.vertical.getComponent().getLocation();
            g.setColor(this.getBackground());
            g.fillRect(posV.x, posH.y, size.width - posH.x, size.height - posV.y);
        }
    }

    private int setupToolTip(int cursor, int x, int y) {
        if (this.toolTipUse) {
            int rx = this.position.x + this.viewportSize.width - x;
            int ry = this.position.y + y;
            String tip = null;
            tip = this.itemMap.getInfo(rx, ry);
            if (tip == null && (tip = this.itemMap.getTip(rx, ry)) != null) {
                cursor = 1;
            }
            if (tip != null && tip.length() > 0) {
                this.canvas.showToolTip(tip, x, y, this.toolTipDelay, this.toolTipTerm);
                return cursor;
            }
        }
        this.canvas.clearToolTip();
        return cursor;
    }

    private void resetStatus() {
        this.setTemporaryCursor(0);
        this.hawkContext.setTemporaryStatus(null);
        this.canvas.clearToolTip();
    }

    private void copyClipboard(String value) {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        StringSelection data = new StringSelection(value);
        clipboard.setContents(data, data);
    }

    private class ScrollbarListener
    implements AdjustmentListener {
        private static final int HORIZONTAL = 0;
        private static final int VERTICAL = 1;
        private boolean isHorizontal;
        private PanelScrollbar scrollbar;

        private ScrollbarListener(int orientation, PanelScrollbar scrollbar) {
            this.isHorizontal = orientation == 0;
            this.scrollbar = scrollbar;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void adjustmentValueChanged(AdjustmentEvent e) {
            Dimension dimension = HawkPanel.this.canvasSize;
            synchronized (dimension) {
                if (this.isHorizontal) {
                    ((HawkPanel)HawkPanel.this).position.x = this.scrollbar.getMaximum() - this.scrollbar.getVisibleAmount() - this.scrollbar.getValue();
                } else {
                    ((HawkPanel)HawkPanel.this).position.y = this.scrollbar.getValue();
                }
                HawkPanel.this.canvas.movePosition(((HawkPanel)HawkPanel.this).position.x, ((HawkPanel)HawkPanel.this).position.y);
            }
        }
    }

    private class MenuActionListner
    implements ActionListener,
    ItemListener {
        private int index = 0;

        private MenuActionListner(int index) {
            this.index = index;
        }

        public void actionPerformed(ActionEvent e) {
            if (HawkPanel.this.listener != null) {
                boolean isShift = (e.getModifiers() & 1) != 0;
                boolean isCtrl = (e.getModifiers() & 2) != 0;
                switch (this.index) {
                    case 2: {
                        HawkPanel.this.listener.back();
                        break;
                    }
                    case 3: {
                        HawkPanel.this.listener.forward();
                        break;
                    }
                    case 4: {
                        HawkPanel.this.listener.stop();
                        break;
                    }
                    case 5: {
                        HawkPanel.this.listener.reload(isCtrl);
                        break;
                    }
                    case 12: {
                        break;
                    }
                    case 24: {
                        HawkPanel.this.copyClipboard(HawkPanel.this.currentLink.toString());
                        break;
                    }
                    case 32: {
                        HawkPanel.this.listener.openHawk(new Request(HawkPanel.this.currentImage, null, ((HawkPanel)HawkPanel.this).request.getDocument().url, null, isShift, false, 2));
                        break;
                    }
                    case 33: {
                        HawkPanel.this.copyClipboard(HawkPanel.this.currentImage.toString());
                    }
                }
            }
        }

        public void itemStateChanged(ItemEvent e) {
            boolean selected = e.getStateChange() == 1;
            switch (this.index) {
                case 8: {
                    HawkPanel.this.option.setLoadImage(!selected);
                    break;
                }
                case 9: {
                    HawkPanel.this.setVisibleScrollbar(!selected);
                    break;
                }
                case 10: {
                    HawkPanel.this.option.setSpinGifImage(selected);
                    break;
                }
                case 11: {
                    HawkPanel.this.option.setSpinJpegImage(selected);
                }
            }
        }
    }

    private class HawkCanvasMouseMotionListener
    extends MouseMotionAdapter {
        private HawkCanvasMouseMotionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseMoved(MouseEvent e) {
            int cursor = 0;
            String status = null;
            Dimension dimension = HawkPanel.this.canvasSize;
            synchronized (dimension) {
                if (HawkPanel.this.itemMap == null) {
                    return;
                }
                cursor = HawkPanel.this.setupToolTip(cursor, e.getX(), e.getY());
                URL href = HawkPanel.this.getLinkURL(e.getX(), e.getY());
                if (href != null) {
                    cursor = 12;
                    status = href.toString();
                }
            }
            e.consume();
            HawkPanel.this.setTemporaryCursor(cursor);
            HawkPanel.this.hawkContext.setTemporaryStatus(status);
        }
    }

    private class HawkCanvasMouseListener
    extends MouseAdapter {
        private HawkCanvasMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            e.getComponent().requestFocus();
            if (HawkPanel.this.itemMap != null) {
                HawkPanel.this.setupToolTip(0, e.getX(), e.getY());
            }
            if (HawkPanel.this.listener == null) {
                return;
            }
            HawkPanel.this.currentLink = HawkPanel.this.getLinkURL(e.getX(), e.getY());
            HawkPanel.this.currentImage = HawkPanel.this.getImageURL(e.getX(), e.getY());
            if (e.isPopupTrigger() || (e.getModifiers() & 4) == 4) {
                HawkPanel.this.popupMenu.removeAll();
                if (HawkPanel.this.currentLink == null && HawkPanel.this.currentImage == null) {
                    HawkPanel.this.menuItems[2].setEnabled(HawkPanel.this.listener.canBack());
                    HawkPanel.this.menuItems[3].setEnabled(HawkPanel.this.listener.canForward());
                    HawkPanel.this.menuItems[4].setEnabled(HawkPanel.this.listener.canStop());
                    HawkPanel.this.menuItems[5].setEnabled(HawkPanel.this.listener.canReload());
                    ((CheckboxMenuItem)HawkPanel.this.menuItems[8]).setState(!HawkPanel.this.option.getLoadImage());
                    ((CheckboxMenuItem)HawkPanel.this.menuItems[9]).setState(!HawkPanel.this.option.getShowScrollbar());
                    ((CheckboxMenuItem)HawkPanel.this.menuItems[10]).setState(HawkPanel.this.option.getSpinGifImage());
                    ((CheckboxMenuItem)HawkPanel.this.menuItems[11]).setState(HawkPanel.this.option.getSpinJpegImage());
                    HawkPanel.this.appendPopupMenuItem(HawkPanel.this.mainMenuItems);
                }
                if (HawkPanel.this.currentLink != null) {
                    HawkPanel.this.appendPopupMenuItem(HawkPanel.this.linkMenuItems);
                }
                if (HawkPanel.this.currentImage != null) {
                    HawkPanel.this.appendPopupMenuItem(HawkPanel.this.imageMenuItems);
                }
                HawkPanel.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                e.consume();
                return;
            }
            if (HawkPanel.this.currentLink != null) {
                if ((e.getModifiers() & 0x10) == 16 || (e.getModifiers() & 8) == 8) {
                    HawkPanel.this.resetStatus();
                    HawkPanel.this.listener.openHawk(new Request(HawkPanel.this.currentLink, null, ((HawkPanel)HawkPanel.this).request.getDocument().url, null, e.isShiftDown(), (e.getModifiers() & 8) == 8, 2));
                }
                e.consume();
            }
        }

        public void mouseExited(MouseEvent e) {
            HawkPanel.this.resetStatus();
        }
    }

    private class HawkCanvasComponentListener
    extends ComponentAdapter {
        private HawkCanvasComponentListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void componentResized(ComponentEvent e) {
            boolean reload = false;
            Dimension dimension = HawkPanel.this.canvasSize;
            synchronized (dimension) {
                Dimension dimension2 = HawkPanel.this.viewportSize;
                synchronized (dimension2) {
                    Dimension size = HawkPanel.this.canvas.getSize();
                    reload = ((HawkPanel)HawkPanel.this).canvasSize.width > 0 && ((HawkPanel)HawkPanel.this).viewportSize.height != size.height;
                    ((HawkPanel)HawkPanel.this).viewportSize.width = size.width;
                    ((HawkPanel)HawkPanel.this).viewportSize.height = size.height;
                    HawkPanel.this.viewportSize.notifyAll();
                }
                HawkPanel.this.horizontal.setMaximum(Math.max(((HawkPanel)HawkPanel.this).canvasSize.width, ((HawkPanel)HawkPanel.this).viewportSize.width));
                HawkPanel.this.vertical.setMaximum(Math.max(((HawkPanel)HawkPanel.this).canvasSize.height, ((HawkPanel)HawkPanel.this).viewportSize.height));
                HawkPanel.this.horizontal.setVisibleAmount(((HawkPanel)HawkPanel.this).viewportSize.width);
                HawkPanel.this.vertical.setVisibleAmount(((HawkPanel)HawkPanel.this).viewportSize.height);
                HawkPanel.this.horizontal.setBlockIncrement(((HawkPanel)HawkPanel.this).viewportSize.width - ((HawkPanel)HawkPanel.this).charScale.width);
                HawkPanel.this.vertical.setBlockIncrement(((HawkPanel)HawkPanel.this).viewportSize.height - ((HawkPanel)HawkPanel.this).charScale.height);
                if (HawkPanel.this.horizontalAdded) {
                    HawkPanel.this.fixScrollbar(HawkPanel.this.horizontalAdded, ((HawkPanel)HawkPanel.this).canvasSize.height > ((HawkPanel)HawkPanel.this).viewportSize.height);
                }
            }
            if (reload && HawkPanel.this.listener != null && HawkPanel.this.listener.canReload()) {
                HawkPanel.this.listener.reload(false);
            }
        }
    }

    private class HawkCanvasKeyListener
    extends KeyAdapter {
        private KeyEvent oldEvent;

        private HawkCanvasKeyListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void keyPressed(KeyEvent e) {
            boolean isAlt;
            boolean bl = isAlt = (e.getModifiers() & 8) != 0;
            if (e.getWhen() + 30L < System.currentTimeMillis() && this.oldEvent != null && this.oldEvent.getKeyCode() == e.getKeyCode() && this.oldEvent.getModifiers() == e.getModifiers()) {
                return;
            }
            this.oldEvent = e;
            if (isAlt) {
                switch (e.getKeyCode()) {
                    case 37: {
                        e.consume();
                        HawkPanel.this.listener.back();
                        break;
                    }
                    case 39: {
                        e.consume();
                        HawkPanel.this.listener.forward();
                    }
                }
            } else {
                switch (e.getKeyCode()) {
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: {
                        e.consume();
                        Dimension dimension = HawkPanel.this.canvasSize;
                        synchronized (dimension) {
                            int x = ((HawkPanel)HawkPanel.this).position.x;
                            int y = ((HawkPanel)HawkPanel.this).position.y;
                            switch (e.getKeyCode()) {
                                case 37: {
                                    x += ((HawkPanel)HawkPanel.this).charScale.width;
                                    break;
                                }
                                case 39: {
                                    x -= ((HawkPanel)HawkPanel.this).charScale.width;
                                    break;
                                }
                                case 38: {
                                    y -= ((HawkPanel)HawkPanel.this).charScale.height;
                                    break;
                                }
                                case 40: {
                                    y += ((HawkPanel)HawkPanel.this).charScale.height;
                                    break;
                                }
                                case 34: {
                                    x += ((HawkPanel)HawkPanel.this).viewportSize.width - ((HawkPanel)HawkPanel.this).charScale.width;
                                    break;
                                }
                                case 33: {
                                    x -= ((HawkPanel)HawkPanel.this).viewportSize.width - ((HawkPanel)HawkPanel.this).charScale.width;
                                    break;
                                }
                                case 36: {
                                    x = 0;
                                    y = 0;
                                    break;
                                }
                                case 35: {
                                    x = ((HawkPanel)HawkPanel.this).canvasSize.width - ((HawkPanel)HawkPanel.this).viewportSize.width;
                                    y = 0;
                                    break;
                                }
                                case 32: {
                                    x += (((HawkPanel)HawkPanel.this).viewportSize.width - ((HawkPanel)HawkPanel.this).charScale.width) * (!e.isShiftDown() ? 1 : -1);
                                }
                            }
                            HawkPanel.this.setScrollPosition(x, y);
                            break;
                        }
                    }
                    case 27: {
                        e.consume();
                        if (HawkPanel.this.listener == null) break;
                        HawkPanel.this.listener.stop();
                    }
                }
            }
        }
    }
}

