/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.rendering;

import java.awt.Point;

class FloatChain {
    static final int TOP = 31;
    static final int BOTTOM = 32;
    static final int BOTH = 35;
    private Chain top;
    private Chain last;

    FloatChain() {
        this.top = this.last = new Chain(31, 0, 0);
    }

    Point allocate(int type, int x, int width, int height, int frameTop, int frameBottom, int maxHeight) {
        int[] thick = new int[2];
        Chain c = this.getGap(x, height, frameTop, frameBottom, maxHeight, thick);
        Point p = new Point(Math.max(c.x, x), 0);
        if (c.x == x && c.type != type && c.back != null && c.x == c.back.x) {
            c = c.back;
        }
        if (type == 31) {
            p.y = Math.max(thick[0] - frameTop, 0);
            height += Math.max(frameTop - thick[0], 0);
        } else {
            p.y = maxHeight - (Math.max(thick[1] - frameBottom, 0) + height);
            height += Math.max(frameBottom - thick[1], 0);
        }
        c = c.append(type, p.x, height);
        int odd = 0;
        int end = p.x + width;
        while (c.next != null && c.next.x < end) {
            if ((c = c.next).type != type || c.height >= 0) continue;
            odd += -c.height;
            c.height = 0;
        }
        c.append(type, end, -(height + odd));
        return p;
    }

    int getHeight(int type, int x, int frameTop, int frameBottom) {
        int top = 0;
        int bottom = 0;
        Chain c = this.top;
        while (c.next != null) {
            if (c.type == 31) {
                top += c.height;
            } else {
                bottom += c.height;
            }
            if (c.next.x > x) {
                switch (type) {
                    case 31: {
                        return Math.max(top - frameTop, 0);
                    }
                    case 32: {
                        return Math.max(bottom - frameBottom, 0);
                    }
                    case 35: {
                        return Math.max(top - frameTop, 0) + Math.max(bottom - frameBottom, 0);
                    }
                }
                return 0;
            }
            c = c.next;
        }
        return 0;
    }

    int getGapPosition(int x, int height, int frameTop, int frameBottom, int maxHeight) {
        return Math.max(this.getGap(x, height, frameTop, frameBottom, maxHeight, null).x, x);
    }

    int getClearPosition(int type, int x) {
        Chain c = this.last;
        while (c.x > x && (c.height >= 0 || type != 35 && type != c.type) && c.back != null) {
            c = c.back;
        }
        return Math.max(c.x, x);
    }

    int getWidth() {
        return this.last.x;
    }

    private Chain getGap(int x, int height, int frameTop, int frameBottom, int maxHeight, int[] thick) {
        Chain c = this.last;
        int newTop = 0;
        int newBottom = 0;
        while (c.x > x && c.height <= 0) {
            if (c.type == 31) {
                newTop -= c.height;
            } else {
                newBottom -= c.height;
            }
            if (maxHeight - Math.max(newTop - frameTop, 0) - Math.max(newBottom - frameBottom, 0) < height) break;
            if (thick != null) {
                thick[0] = newTop;
                thick[1] = newBottom;
            }
            if (c.back == null) break;
            c = c.back;
        }
        return c;
    }

    private class Chain {
        private int type;
        private int x;
        private int height;
        private Chain next;
        private Chain back;

        private Chain(int type, int x, int height) {
            this.type = type;
            this.x = x;
            this.height = height;
        }

        private Chain append(int type, int x, int height) {
            if (type == this.type && x == this.x) {
                this.height += height;
                return this;
            }
            Chain c = new Chain(type, x, height);
            c.next = this.next;
            c.back = this;
            if (this.next != null) {
                this.next.back = c;
            } else {
                FloatChain.this.last = c;
            }
            this.next = c;
            return c;
        }
    }
}

