/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.rendering;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Stack;
import java.util.Vector;
import net.fclabs.util.Queue;
import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.image.SyncObserver;
import net.hizlab.kagetaka.rendering.Counter;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.HawkContext;
import net.hizlab.kagetaka.rendering.ImageCache;
import net.hizlab.kagetaka.rendering.ImageHolder;
import net.hizlab.kagetaka.rendering.ItemMap;
import net.hizlab.kagetaka.rendering.Option;
import net.hizlab.kagetaka.rendering.Request;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.rendering.StopException;
import net.hizlab.kagetaka.util.CharList;

class Drawkit {
    private static final int MT_WAIT = 10000;
    private static final int UL_DISC_SIZE = 6;
    private static final int UL_CIRCLE_SIZE = 6;
    private static final int UL_SQUARE_SIZE = 5;
    HawkContext context;
    private Reporter reporter;
    private Option option;
    private ImageCache imageCache;
    Request request;
    Document document;
    Dimension viewSize;
    Dimension size;
    ItemMap itemMap;
    Status baseStatus;
    Status nextStatus;
    Status status;
    CharList charsSpinRight;
    CharList charsSpinLtrb;
    CharList charsKinsokuHead;
    CharList charsKinsokuTail;
    boolean swapDecoration;
    boolean isSetupPanel = false;
    Image panel = null;
    int panelWidth = 0;
    int panelHeight = 0;
    Graphics g = null;
    Counter gCounter = null;
    Queue idQueue = new Queue();
    Vector ids = new Vector();
    Vector images = new Vector();
    Counter imageCounter = new Counter(0);
    SyncObserver imageDrawer = new SyncObserver();
    Vector floats = new Vector();
    Queue floatQueue;
    Vector formItems = new Vector();
    private Stack statusStack = new Stack();
    private int backImageLeft = 0;
    private MediaTracker mt = null;
    private char[] tateCs = new char[1];
    private int tateW;
    private int tateMax;

    Drawkit(HawkContext context, Request request) {
        this.context = context;
        this.reporter = context.getReporter();
        this.option = context.getOption();
        this.imageCache = ImageCache.getInstance();
        this.request = request;
        this.document = request.getDocument();
        this.viewSize = context.getViewportSize();
        this.size = new Dimension(0, 0);
        this.mt = context.getMediaTracker();
        this.itemMap = this.document.itemMap;
        this.charsSpinRight = this.option.getCharsSpinRight();
        this.charsSpinLtrb = this.option.getCharsSpinLtrb();
        this.charsKinsokuHead = this.option.getCharsKinsokuHead();
        this.charsKinsokuTail = this.option.getCharsKinsokuTail();
        this.swapDecoration = this.option.getSwapDecoration();
        this.baseStatus = this.status = new Status(this);
        this.status.type = 3001;
    }

    void saveStatus(int type) {
        this.statusStack.push(this.status);
        if (this.nextStatus == null) {
            this.status = (Status)this.status.clone();
            this.status.type = type;
        } else {
            this.nextStatus.parent = this.status;
            this.status = this.nextStatus;
            this.nextStatus = null;
        }
    }

    void resetStatus() {
        this.status = (Status)this.statusStack.pop();
    }

    void insertStatus(int type) {
        this.nextStatus = this.status;
        Status s = (Status)this.statusStack.peek();
        this.status = (Status)s.clone();
        this.status.type = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitImageLoad() {
        Counter counter = this.imageCounter;
        synchronized (counter) {
            while (this.imageCounter.current() > 0) {
                try {
                    this.imageCounter.wait(10000L);
                }
                catch (InterruptedException e) {
                    for (int i = 0; i < this.images.size(); ++i) {
                        ImageHolder ih = (ImageHolder)this.images.elementAt(i);
                        if (ih.complete) continue;
                        this.reportMessage(3, "render.info.image.stop", new String[]{ih.toString()});
                    }
                    throw new StopException("wait to load images");
                }
            }
        }
    }

    void stopImageLoad() {
        if (this.imageCounter.current() <= 0) {
            return;
        }
        for (int i = 0; i < this.images.size(); ++i) {
            ((ImageHolder)this.images.elementAt(i)).dispose();
        }
    }

    void dispose() {
        for (int i = 0; i < this.images.size(); ++i) {
            ((ImageHolder)this.images.elementAt(i)).dispose();
        }
        this.images.removeAllElements();
    }

    void createPanel(int width, int height, Status status) {
        if (width == 0) {
            return;
        }
        if (height <= 0) {
            height = 1;
        }
        if (this.panel != null) {
            this.commitPanel();
            this.reportMessage(10, "internal.error", new String[]{"Render.createPanel", "panel not commit", ""});
        }
        this.panel = this.context.createImage(width, height);
        this.panelWidth = width;
        this.panelHeight = height;
        this.g = this.panel.getGraphics();
        this.gCounter = new Counter(1);
        if (this.baseStatus.backColor != null) {
            this.g.setColor(this.baseStatus.backColor);
            this.g.fillRect(0, 0, width, height);
        }
        if (this.baseStatus.backImage != null) {
            int dx1 = 0;
            int dy1 = 0;
            int dx2 = 0;
            int dy2 = 0;
            int sx1 = 0;
            int sy1 = 0;
            int sx2 = 0;
            int sy2 = 0;
            dx1 = width + this.backImageLeft;
            do {
                dx2 = dx1;
                sx1 = Math.min(0, dx1 -= this.baseStatus.backImageSize.width);
                this.backImageLeft = this.baseStatus.backImageSize.width + dx1;
                if (dx1 < 0) {
                    sx1 = -dx1;
                    dx1 = 0;
                }
                sx2 = sx1 + (dx2 - dx1);
                dy2 = 0;
                sy2 = this.baseStatus.backImageSize.height;
                do {
                    if ((dy2 = (dy1 = dy2) + this.baseStatus.backImageSize.height) > height) {
                        sy2 -= dy2 - height;
                        dy2 = height;
                    }
                    this.drawImageSync(this.g, this.baseStatus.backImage, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2);
                } while (dy2 < height);
            } while (dx1 > 0);
        }
        this.size.width += width;
        this.size.height = Math.max(this.size.height, height);
    }

    void commitPanel() {
        if (this.panel != null) {
            if (this.gCounter.decrement() <= 0) {
                this.g.dispose();
            }
            if (!this.isSetupPanel) {
                this.context.setupCanvas(this.request);
                this.isSetupPanel = true;
            }
            this.context.addImage(this.panel, this.panelWidth, this.panelHeight);
            this.panel = null;
            this.g = null;
            this.gCounter = null;
        }
    }

    void reportMessage(int type, String key, Object[] args) {
        if (this.reporter == null) {
            return;
        }
        this.reporter.report(type, Resource.getMessage(key, args), 0, 0);
    }

    URL createURL(String href) {
        try {
            return this.document.createURL(href);
        }
        catch (SecurityException e) {
            this.reportMessage(7, "render.warning.security", new String[]{href, e.toString()});
        }
        catch (MalformedURLException e) {
            this.reportMessage(7, "render.warning.href", new String[]{href, e.toString()});
        }
        return null;
    }

    Image getImage(URL url, String src) {
        if (url == null) {
            return null;
        }
        try {
            return this.imageCache.getImage(this.context, url, src, this.request, this.option.getLoadImage());
        }
        catch (SecurityException e) {
            this.reportMessage(7, "render.warning.security", new String[]{src, e.toString()});
        }
        catch (IOException e) {
            this.reportMessage(7, "render.warning.io", new String[]{src, e.toString()});
        }
        catch (InterruptedException e) {
            throw new StopException("wait to load images");
        }
        return null;
    }

    int loadImage(Image image, String message) {
        this.mt.addImage(image, 0);
        try {
            this.mt.waitForID(0, 10000L);
        }
        catch (InterruptedException e) {
            throw new StopException(message);
        }
        int status = this.mt.statusID(0, true);
        this.mt.removeImage(image, 0);
        return status;
    }

    void drawTextTate(StringBuffer buffer, int begin, int end, int x, int y, Status status, double space, int letterSpacing) {
        this.tateMax = status.fdFontSize.width;
        for (int i = begin; i < end; ++i) {
            this.tateCs[0] = buffer.charAt(i);
            this.tateW = status.fm.charWidth(this.tateCs[0]);
            this.g.drawChars(this.tateCs, 0, 1, this.tateMax > this.tateW ? x + (this.tateMax - this.tateW) / 2 : x, (y += (int)((double)(i * 2 + 1) * space) - (int)((double)(i * 2) * space)) + status.fontBaseFull);
            y += status.fdFontSize.height;
            y += (int)((double)(i * 2 + 2) * space) - (int)((double)(i * 2 + 1) * space);
            y += letterSpacing;
        }
    }

    void drawTextWithSpin(StringBuffer buffer, int begin, int end, int x, int y, int width, int height, Status status, double space, int letterSpacing, char type) {
        if (width == 0) {
            return;
        }
        Color backColor = Color.white;
        Color foreColor = Color.black;
        Image scrap = null;
        try {
            scrap = this.context.createImage(width, height);
        }
        catch (IllegalArgumentException e) {
            System.out.println("e=[" + buffer + "],[" + begin + "],[" + end + "],[" + width + "],[" + height + "]");
            return;
        }
        catch (NegativeArraySizeException e) {
            System.out.println("e=[" + buffer + "],[" + begin + "],[" + end + "],[" + width + "],[" + height + "]");
            return;
        }
        Graphics sg = scrap.getGraphics();
        sg.setColor(backColor);
        sg.fillRect(0, 0, width, height);
        sg.setColor(foreColor);
        sg.setFont(status.font);
        int base = 0;
        if (type == '3') {
            base = status.fontBaseFull + (status.fdFontSize.height - status.fontBaseFull) / 2;
        }
        int scrapX = 0;
        for (int i = begin; i < end; ++i) {
            char c;
            this.tateCs[0] = c = buffer.charAt(i);
            if (type == '2') {
                base = c <= '\u00ff' || '\uff61' <= c && c <= '\uff9f' ? status.fontBaseHalf : status.fontBaseFull;
            }
            sg.drawChars(this.tateCs, 0, 1, scrapX += (int)((double)(i * 2 + 1) * space) - (int)((double)(i * 2) * space), base);
            scrapX += status.fm.charWidth(this.tateCs[0]);
            scrapX += (int)((double)(i * 2 + 2) * space) - (int)((double)(i * 2 + 1) * space);
            scrapX += letterSpacing;
        }
        sg.dispose();
        int[] bitmap1 = new int[width * height];
        int[] bitmap2 = new int[width * height];
        PixelGrabber pg = new PixelGrabber(scrap, 0, 0, width, height, bitmap1, 0, width);
        try {
            pg.grabPixels(10000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        switch (type) {
            case '2': {
                int scrapY;
                for (scrapX = 0; scrapX < width; ++scrapX) {
                    for (scrapY = 0; scrapY < height; ++scrapY) {
                        bitmap2[scrapX * height + scrapY] = bitmap1[scrapX + (height - scrapY - 1) * width];
                    }
                }
                break;
            }
            case '3': {
                int scrapY;
                for (scrapX = 0; scrapX < width; ++scrapX) {
                    for (scrapY = 0; scrapY < height; ++scrapY) {
                        bitmap2[scrapX * height + scrapY] = bitmap1[scrapX + scrapY * width];
                    }
                }
                break;
            }
        }
        int bcc = backColor.getRGB();
        int fcc = status.foreColor.getRGB() | 0xFF000000;
        for (int i = 0; i < bitmap2.length; ++i) {
            if (bitmap2[i] == bcc) {
                int n = i;
                bitmap2[n] = bitmap2[n] & 0xFFFFFF;
                continue;
            }
            bitmap2[i] = fcc;
        }
        MemoryImageSource mis = new MemoryImageSource(height, width, bitmap2, 0, height);
        mis.setAnimated(false);
        Image image = this.context.createImage(mis);
        this.drawImageSync(this.g, image, x, y, height, width);
        scrap.flush();
        image.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drawImageSync(Graphics g, Image image, int x, int y, int width, int height) {
        SyncObserver syncObserver = this.imageDrawer;
        synchronized (syncObserver) {
            this.imageDrawer.init(g, x, y, width, height);
            if (!g.drawImage(image, x, y, width, height, this.imageDrawer)) {
                try {
                    this.imageDrawer.wait(10000L);
                }
                catch (InterruptedException e) {
                    throw new StopException("wait to draw a image");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void drawImageSync(Graphics g, Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
        SyncObserver syncObserver = this.imageDrawer;
        synchronized (syncObserver) {
            this.imageDrawer.init(g, dx1, dy1, dx2 - dx1, dy2 - dy1);
            if (!g.drawImage(image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, this.imageDrawer)) {
                try {
                    this.imageDrawer.wait(10000L);
                }
                catch (InterruptedException e) {
                    throw new StopException("wait to draw a image");
                }
            }
        }
    }

    void drawListItem(int x, int y, Status status) {
        this.g.setColor(status.foreColor);
        block0 : switch (status.listType) {
            case 3: {
                break;
            }
            case 81: {
                this.g.fillOval(x + (status.fdFontSize.width - 6) / 2, y - (status.fdFontSize.height + 6) / 2, 6, 6);
                break;
            }
            case 82: {
                this.g.drawOval(x + (status.fdFontSize.width - 6) / 2, y - (status.fdFontSize.height + 6) / 2, 6, 6);
                break;
            }
            case 83: {
                this.g.fillRect(x + (status.fdFontSize.width - 5) / 2, y - (status.fdFontSize.height + 5) / 2, 5, 5);
                break;
            }
            default: {
                StringBuffer buffer = new StringBuffer();
                switch (status.listType) {
                    case 85: {
                        if (status.counterStatus.counterNo < 10) {
                            buffer.append('0');
                        }
                        buffer.append(status.counterStatus.counterNo);
                        break;
                    }
                    case 86: 
                    case 87: {
                        if (status.counterStatus.counterNo >= 5000) {
                            buffer.append(status.counterStatus.counterNo);
                            break;
                        }
                        int no = status.counterStatus.counterNo;
                        int column = 0;
                        char[] list = null;
                        list = status.listType == 86 ? new char[]{'i', 'v', 'x', 'l', 'c', 'd', 'm', '?', '?'} : new char[]{'I', 'V', 'X', 'L', 'C', 'D', 'M', '?', '?'};
                        if (no <= 0) {
                            no = 1;
                        }
                        while (no > 0 && column < 7) {
                            char c1 = list[column];
                            char c5 = list[column + 1];
                            char c10 = list[column + 2];
                            switch (no % 10) {
                                case 1: {
                                    buffer.append(c1);
                                    break;
                                }
                                case 2: {
                                    buffer.append(c1);
                                    buffer.append(c1);
                                    break;
                                }
                                case 3: {
                                    buffer.append(c1);
                                    buffer.append(c1);
                                    buffer.append(c1);
                                    break;
                                }
                                case 4: {
                                    buffer.append(c5);
                                    buffer.append(c1);
                                    break;
                                }
                                case 5: {
                                    buffer.append(c5);
                                    break;
                                }
                                case 6: {
                                    buffer.append(c1);
                                    buffer.append(c5);
                                    break;
                                }
                                case 7: {
                                    buffer.append(c1);
                                    buffer.append(c1);
                                    buffer.append(c5);
                                    break;
                                }
                                case 8: {
                                    buffer.append(c1);
                                    buffer.append(c1);
                                    buffer.append(c1);
                                    buffer.append(c5);
                                    break;
                                }
                                case 9: {
                                    buffer.append(c10);
                                    buffer.append(c1);
                                }
                            }
                            no /= 10;
                            column += 2;
                        }
                        buffer.reverse();
                        break;
                    }
                    case 91: {
                        String list = Resource.getMessage("chars.list.cjk.ideographic", null);
                        int no = status.counterStatus.counterNo;
                        if (no <= 0) {
                            no = 1;
                        }
                        int n4 = 1;
                        int nx = 0;
                        boolean bx = false;
                        while (true) {
                            int n;
                            if ((n = no % 10) > 0) {
                                if (nx > 0 && !bx) {
                                    buffer.append(list.charAt(nx + 11));
                                    bx = true;
                                }
                                if (n4 > 1) {
                                    buffer.append(list.charAt(n4 + 7));
                                }
                                buffer.append(list.charAt(n - 1));
                            }
                            if ((no /= 10) == 0) break;
                            if (++n4 != 5) continue;
                            n4 = 1;
                            ++nx;
                            bx = false;
                        }
                        buffer.reverse();
                        break;
                    }
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 100: {
                        String key = null;
                        switch (status.listType) {
                            case 92: {
                                key = "chars.list.hiragana";
                                break;
                            }
                            case 93: {
                                key = "chars.list.katakana";
                                break;
                            }
                            case 94: {
                                key = "chars.list.hiragana.iroha";
                                break;
                            }
                            case 95: {
                                key = "chars.list.katakana.iroha";
                                break;
                            }
                            case 100: {
                                key = "chars.list.lower.greek";
                            }
                        }
                        String list = Resource.getMessage(key, null);
                        int no = status.counterStatus.counterNo - 1;
                        if (no < 0) {
                            no = 0;
                        }
                        if (no < list.length()) {
                            buffer.append(list.charAt(no));
                            break;
                        }
                        buffer.append(status.counterStatus.counterNo);
                        break;
                    }
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: {
                        boolean lower;
                        int no = status.counterStatus.counterNo;
                        if (no <= 0) {
                            no = 1;
                        }
                        boolean bl = lower = status.listType == 96 || status.listType == 98;
                        while (no > 0) {
                            buffer.append((char)(no % 26 - 1 + (lower ? 97 : 65)));
                            no /= 26;
                        }
                        buffer.reverse();
                        break;
                    }
                    default: {
                        buffer.append(status.counterStatus.counterNo);
                    }
                }
                int letterSpacing = 0;
                if (status.letterSpacing != null) {
                    letterSpacing = status.letterSpacing.getValue(status.fd, status.fdFontSize.width, 2);
                }
                char c = '\u0000';
                int s = 0;
                if (buffer.length() > 0) {
                    c = buffer.charAt(0);
                    s = c <= '\u00ff' || '\uff61' <= c && c <= '\uff9f' || this.charsSpinRight.contains(c) ? 49 : 50;
                    buffer.append(Resource.getMessage("chars.value.list." + (char)s, null));
                }
                int w = 0;
                int length = buffer.length();
                StringBuffer spin = new StringBuffer();
                for (int i = 0; i < length; ++i) {
                    c = buffer.charAt(i);
                    s = c <= '\u00ff' || '\uff61' <= c && c <= '\uff9f' || this.charsSpinRight.contains(c) ? 50 : (this.charsSpinLtrb.contains(c) ? 51 : 49);
                    spin.append((char)s);
                    w = s == 49 ? (w += status.fdFontSize.height) : (w += status.fm.charWidth(c));
                    w += letterSpacing;
                }
                this.g.setColor(status.foreColor);
                this.g.setFont(status.font);
                y -= w + 2;
                w = 0;
                char lastType = '\u0000';
                char nowType = '\u0000';
                int lastIndex = 0;
                for (int i = 0; i <= length; ++i) {
                    nowType = i < length ? spin.charAt(i) : (char)'\u0000';
                    if (lastType != nowType) {
                        if (lastType == '1') {
                            this.drawTextTate(buffer, lastIndex, i, x, y, status, 0.0, letterSpacing);
                        } else {
                            this.drawTextWithSpin(buffer, lastIndex, i, x, y, w, status.fdFontSize.height, status, 0.0, letterSpacing, lastType);
                        }
                        y += w;
                        w = 0;
                        lastType = nowType;
                        lastIndex = i;
                    }
                    if (i == length) break block0;
                    w = nowType == '1' ? (w += status.fdFontSize.height) : (w += status.fm.charWidth(buffer.charAt(i)));
                    w += letterSpacing;
                }
            }
        }
        ++status.counterStatus.counterNo;
    }
}

