/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.rendering;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Vector;
import net.hizlab.kagetaka.awt.ImageCreator;
import net.hizlab.kagetaka.awt.InnerToolTip;
import net.hizlab.kagetaka.awt.image.OffscreenObserver;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.HawkContext;
import net.hizlab.kagetaka.token.FormItem;

class Canvas
extends Container {
    private static final int TIP_BOTTOM = 22;
    private HawkContext hawkContext;
    private Object offscreenLock = new Object();
    private Image offscreen = null;
    private Dimension offscreenSize = null;
    private Graphics offscreenGraphics = null;
    private int offscreenPointer = 0;
    private int offscreenIndex = 0;
    private Object tilesLock = new Object();
    private Tile[] tiles = new Tile[10];
    private int tilesCount = 0;
    private int tilesWidth = 0;
    private Point position = new Point(0, 0);
    private Vector formItems = new Vector();
    private boolean hasFormItems = false;
    private ToolTip toolTip;
    private Color backColor = null;
    private Image backImage = null;
    private Dimension backImageSize = null;

    Canvas(HawkContext hawkContext) {
        this.hawkContext = hawkContext;
        this.setLayout(null);
        this.addComponentListener(new ComponentAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void componentResized(ComponentEvent e) {
                Object object = Canvas.this.offscreenLock;
                synchronized (object) {
                    if (Canvas.this.offscreen != null) {
                        if (Canvas.this.offscreenSize.equals(Canvas.this.getSize())) {
                            return;
                        }
                        Canvas.this.clearOffscreen();
                        Canvas.this.repaint();
                    }
                }
            }

            public void componentHidden(ComponentEvent e) {
                Canvas.this.clearOffscreen();
            }
        });
        this.backColor = Document.DEFAULT_BACKGROUND_COLOR;
        this.setBackground(this.backColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addImage(Image image, int width, int height) {
        Object object = this.tilesLock;
        synchronized (object) {
            Tile tile;
            if (this.tilesCount == this.tiles.length) {
                int newSize = (int)((double)this.tilesCount * (this.tilesCount > 300 ? 1.5 : 2.0));
                Tile[] newTiles = new Tile[newSize];
                System.arraycopy(this.tiles, 0, newTiles, 0, this.tilesCount);
                this.tiles = newTiles;
            }
            if ((tile = this.tiles[this.tilesCount]) == null) {
                this.tiles[this.tilesCount] = tile = new Tile(image, width, height);
                if (this.tilesCount > 0) {
                    this.tiles[this.tilesCount - 1].next = tile;
                }
            } else {
                tile.reset(image, width, height);
            }
            this.tilesWidth += width;
            ++this.tilesCount;
        }
        object = this.offscreenLock;
        synchronized (object) {
            if (this.isShowing() && (this.offscreen == null || this.offscreenPointer > 0)) {
                this.repaint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFormItem(FormItem item) {
        int posY;
        int posX;
        this.hasFormItems = true;
        this.formItems.addElement(item);
        Object object = this.position;
        synchronized (object) {
            posX = this.position.x;
            posY = this.position.y;
        }
        object = this.tilesLock;
        synchronized (object) {
            if (this.offscreen == null) {
                return;
            }
            Point pos = item.getPosition();
            Dimension size = item.getSize();
            if (posX <= pos.x + size.width && posY <= pos.y + size.height && posX + this.offscreenSize.width >= pos.x && posY + this.offscreenSize.height >= pos.y) {
                Component c = item.getComponent();
                this.add(c);
                c.setBounds(this.offscreenSize.width - pos.x + posX - size.width, pos.y - posY, size.width, size.height);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void repaintImage(int x, int y, int width, int height) {
        int posY;
        int posX;
        int tilesCount;
        Tile[] tiles;
        Object object = this.tilesLock;
        synchronized (object) {
            tiles = this.tiles;
            tilesCount = this.tilesCount;
        }
        Object object2 = this.position;
        synchronized (object2) {
            posX = this.position.x;
            posY = this.position.y;
        }
        object2 = this.offscreenLock;
        synchronized (object2) {
            int index;
            if (this.offscreen == null) {
                this.repaint();
                return;
            }
            int base = this.offscreenSize.width + posX;
            int right = base - x;
            int left = right - width;
            int top = y - posY;
            int bottom = top + height;
            if (right < 0 || this.offscreenSize.width <= left || bottom < 0 || this.offscreenSize.height <= top || (index = this.getTileIndex(tiles, tilesCount, x, 0)) == -1) {
                return;
            }
            int y2 = y + height;
            Tile tile = tiles[index];
            boolean first = true;
            OffscreenObserver oo = null;
            boolean sync = false;
            if (top < 0) {
                y -= top;
                top = 0;
            }
            if (this.offscreenSize.height < bottom) {
                int diff = bottom - this.offscreenSize.height;
                y2 -= diff;
                bottom -= diff;
            }
            do {
                int x2;
                int x1;
                if (!sync) {
                    oo = new OffscreenObserver(this, this.offscreenGraphics);
                    oo.y = top;
                }
                if ((x1 = base - tile.left) <= left) {
                    oo.x = left;
                    x1 = left - x1;
                    x2 = first ? x1 + width : tile.width;
                    sync = this.offscreenGraphics.drawImage(tile.image, oo.x, top, right, bottom, x1, y, x2, y2, oo);
                    break;
                }
                oo.x = x1;
                if (first) {
                    x2 = right - x1;
                    first = false;
                } else {
                    x2 = tile.width;
                }
                sync = this.offscreenGraphics.drawImage(tile.image, oo.x, top, right, bottom, 0, y, x2, y2, oo);
                right = x1;
                tile = tile.next;
            } while (++index < tilesCount);
            this.paintItem();
            Graphics g = this.getGraphics();
            if (g != null) {
                try {
                    g.drawImage(this.offscreen, 0, 0, this);
                }
                finally {
                    g.dispose();
                }
            } else {
                this.repaint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setupScreen(Color color, Image image) {
        Object object = this.position;
        synchronized (object) {
            this.position.x = 0;
            this.position.y = 0;
        }
        object = this.offscreenLock;
        synchronized (object) {
            if (this.offscreen != null) {
                this.offscreenPointer = this.offscreenSize.width;
            }
            this.offscreenIndex = 0;
        }
        object = this.tilesLock;
        synchronized (object) {
            for (int i = 0; i < this.tilesCount; ++i) {
                this.tiles[i].image.flush();
                this.tiles[i].next = null;
                this.tiles[i] = null;
            }
            this.tilesCount = 0;
            this.tilesWidth = 0;
            this.formItems.removeAllElements();
            this.hasFormItems = false;
            this.removeAll();
        }
        this.backColor = color;
        this.backImage = image;
        super.setBackground(color);
        if (image != null) {
            this.backImageSize = new Dimension(image.getWidth(this), image.getHeight(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void movePosition(int x, int y) {
        Object object = this.position;
        synchronized (object) {
            this.position.x = x;
            this.position.y = y;
        }
        object = this.offscreenLock;
        synchronized (object) {
            if (this.offscreen == null) {
                return;
            }
            this.offscreenPointer = this.offscreenSize.width;
            this.offscreenIndex = 0;
            if (this.hasFormItems) {
                this.allocateFormItems(x, y);
            }
        }
        Graphics g = this.getGraphics();
        if (g != null) {
            try {
                this.paint(g);
            }
            finally {
                g.dispose();
            }
        } else {
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void showToolTip(String tip, int x, int y, long delay, long term) {
        int posY;
        int posX;
        Dimension size = this.offscreenSize;
        Point point = this.position;
        synchronized (point) {
            posX = this.position.x;
            posY = this.position.y;
            if (this.toolTip == null) {
                this.toolTip = new ToolTip(this.hawkContext, delay, term, new Insets(0, 0, 44, 0));
            } else {
                this.toolTip.setDelay(delay);
                this.toolTip.setTerm(term);
            }
        }
        this.toolTip.showTip(tip, x, y + 22, size.width, size.height, posX, posY);
    }

    void clearToolTip() {
        if (this.toolTip != null) {
            this.toolTip.cancel();
        }
    }

    void cleanup() {
        if (this.toolTip != null) {
            this.toolTip.dispose();
            this.toolTip = null;
        }
        this.setupScreen(null, null);
        this.clearOffscreen();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        int tilesCount;
        Tile[] tiles;
        int posY;
        int posX;
        Point point = this.position;
        synchronized (point) {
            posX = this.position.x;
            posY = this.position.y;
        }
        Object object = this.tilesLock;
        synchronized (object) {
            tiles = this.tiles;
            tilesCount = this.tilesCount;
        }
        object = this.offscreenLock;
        synchronized (object) {
            if (this.offscreen == null) {
                Dimension size = this.getSize();
                this.offscreen = this.createImage(size.width, size.height);
                this.offscreenSize = size;
                this.offscreenGraphics = this.offscreen.getGraphics();
                this.offscreenPointer = size.width;
                this.offscreenIndex = 0;
                if (this.hasFormItems) {
                    this.allocateFormItems(posX, posY);
                }
            }
            int index = this.offscreenIndex;
            if (this.offscreenPointer > 0 && this.offscreenIndex < tilesCount && (tiles[index].left > posX || (index = this.getTileIndex(tiles, tilesCount, posX, this.offscreenIndex)) >= 0)) {
                Tile tile = tiles[index];
                int osHeight = this.offscreenSize.height;
                OffscreenObserver oo = null;
                boolean sync = false;
                this.offscreenPointer = this.offscreenSize.width - (tile.right - posX);
                do {
                    if (!sync) {
                        oo = new OffscreenObserver(this, this.offscreenGraphics);
                    }
                    int x2 = this.offscreenPointer;
                    int y2 = Math.min(tile.height - posY, osHeight);
                    oo.x = this.offscreenPointer -= tile.width;
                    sync = this.offscreenGraphics.drawImage(tile.image, oo.x, 0, x2, y2, 0, posY, tile.width, Math.min(tile.height, osHeight + posY), oo);
                    if (y2 < osHeight) {
                        this.drawBackground(oo.x, y2, x2, osHeight, posX, posY);
                    }
                    tile = tile.next;
                } while (++index < tilesCount && this.offscreenPointer > 0);
                this.offscreenIndex = index;
                if (this.offscreenPointer > 0) {
                    this.drawBackground(0, 0, this.offscreenPointer, this.offscreenSize.height, posX, posY);
                }
            }
            this.paintItem();
            g.drawImage(this.offscreen, 0, 0, this);
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    protected String paramString() {
        String str = super.paramString();
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearOffscreen() {
        Object object = this.offscreenLock;
        synchronized (object) {
            if (this.offscreen != null) {
                this.offscreenGraphics.dispose();
                this.offscreen.flush();
            }
            this.offscreen = null;
            this.offscreenSize = null;
            this.offscreenGraphics = null;
            this.offscreenPointer = 0;
            this.offscreenIndex = 0;
        }
    }

    private int getTileIndex(Tile[] tiles, int tilesCount, int x, int start) {
        if (tiles[tilesCount - 1].left <= x) {
            return -1;
        }
        int end = tilesCount - 1;
        while (start + 1 < end) {
            int middle = (end - start) / 2 + start;
            int right = tiles[middle].right;
            if (right == x) {
                return middle;
            }
            if (right < x) {
                start = middle;
                continue;
            }
            end = middle;
        }
        return start;
    }

    private void drawBackground(int x1, int y1, int x2, int y2, int posX, int posY) {
        if (this.backImage == null) {
            this.offscreenGraphics.setColor(this.backColor);
            this.offscreenGraphics.fillRect(x1, y1, x2 - x1, y2 - y1);
        } else {
            int sx1 = 0;
            int sy1 = 0;
            int sx2 = 0;
            int sy2 = 0;
            int dx1 = 0;
            int dy1 = 0;
            int dx2 = 0;
            int dy2 = 0;
            dx1 = (posX + (this.offscreenSize.width - x2)) % this.backImageSize.width + x2;
            int offsetY = (posY + y1) % this.backImageSize.width;
            do {
                sx1 = 0;
                sx2 = this.backImageSize.width;
                dx2 = dx1;
                dx1 -= this.backImageSize.width;
                if (dx2 > x2) {
                    sx2 -= dx2 - x2;
                    dx2 = x2;
                }
                if (dx1 < x1) {
                    sx1 = x1 - dx1;
                    dx1 = x1;
                }
                sy2 = this.backImageSize.height;
                dy2 = y1 - offsetY;
                do {
                    sy1 = 0;
                    dy1 = dy2;
                    dy2 += this.backImageSize.height;
                    if (dy1 < y1) {
                        sy1 = y1 - dy1;
                        dy1 = y1;
                    }
                    if (dy2 > y2) {
                        sy2 -= dy2 - y2;
                        dy2 = y2;
                    }
                    this.offscreenGraphics.drawImage(this.backImage, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, this);
                } while (dy2 < y2);
            } while (dx1 > x1);
        }
    }

    private void allocateFormItems(int posX, int posY) {
        for (int i = this.formItems.size() - 1; i >= 0; --i) {
            this.allocateFormItem((FormItem)this.formItems.elementAt(i), posX, posY);
        }
    }

    private void allocateFormItem(FormItem item, int posX, int posY) {
        Point pos = item.getPosition();
        Dimension size = item.getSize();
        Component c = item.getComponent();
        if (posX <= pos.x + size.width && posY <= pos.y + size.height && posX + this.offscreenSize.width >= pos.x && posY + this.offscreenSize.height >= pos.y) {
            if (c.getParent() == null) {
                this.add(c);
            }
            c.setBounds(this.offscreenSize.width - pos.x + posX - size.width, pos.y - posY, size.width, size.height);
        } else if (c.getParent() != null) {
            this.remove(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintItem() {
        ToolTip toolTip;
        if (this.hasFormItems) {
            Component[] cs = this.getComponents();
            for (int i = cs.length - 1; i >= 0; --i) {
                Component c = cs[i];
                if (c == null) continue;
                Rectangle r = c.getBounds();
                Graphics g = this.offscreenGraphics.create(r.x, r.y, r.width, r.height);
                try {
                    c.paintAll(g);
                    continue;
                }
                finally {
                    g.dispose();
                }
            }
        }
        if ((toolTip = this.toolTip) != null) {
            toolTip.paint(this.offscreenGraphics);
        }
    }

    private class ToolTip
    extends InnerToolTip {
        private int left;
        private int top;

        private ToolTip(ImageCreator creator, long delay, long term, Insets fix) {
            super(creator, delay, term, fix);
        }

        public void showTip(String value, int x, int y, int width, int height, int posX, int posY) {
            super.showTip(value, x, y, width, height);
            this.left = width + posX;
            this.top = posY;
        }

        public void repaint(int x, int y, int width, int height) {
            Canvas.this.repaintImage(this.left - x - width, this.top + y, width, height);
        }
    }

    private class Tile {
        private Image image;
        private int width;
        private int height;
        private int right;
        private int left;
        private Tile next;

        private Tile(Image image, int width, int height) {
            this.reset(image, width, height);
        }

        private void reset(Image image, int width, int height) {
            this.image = image;
            this.width = width;
            this.height = height;
            this.right = Canvas.this.tilesWidth;
            this.left = this.right + width;
        }
    }
}

