/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.rendering;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.util.Vector;
import net.hizlab.kagetaka.rendering.DelayRectangle;
import net.hizlab.kagetaka.rendering.Drawkit;
import net.hizlab.kagetaka.rendering.FloatChain;
import net.hizlab.kagetaka.rendering.Paragraph;
import net.hizlab.kagetaka.rendering.Status;
import net.hizlab.kagetaka.token.FormItem;
import net.hizlab.kagetaka.token.Value;

class Box
implements DelayRectangle {
    private static final int CUR = 0;
    private static final int MIN = 1;
    private static final int MAX = 2;
    private static final int FIX = 3;
    private static final int PER = 4;
    Drawkit drawkit;
    Status status;
    private Box origin;
    private Box parent;
    private boolean fixedBlock;
    private int level = -1;
    private Insets frame;
    private Dimension preferredSize;
    private Insets border = null;
    private Insets padding = new Insets(0, 0, 0, 0);
    private Insets margin = new Insets(0, 0, 0, 0);
    private int width = 0;
    private int height = 0;
    private int innerWidth = 0;
    private int maxHeight = 0;
    private boolean heightPercent = false;
    private boolean heightFixed = false;
    private int frameWidth = 0;
    private int frameHeight = 0;
    private int topOffset = 0;
    private Vector delayPanels = null;
    private boolean dummyBox = false;
    private FloatChain floatChain = null;
    Point floatOffset;
    int floatDelayX;
    int floatDelayY;
    int drawWidth;
    int drawHeight;
    private Cell[][] cells = null;
    private int colNum = 0;
    private int rowNum = 0;
    private int verticalSpacing = 0;
    private int horizontalSpacing = 0;
    private int totalMinHeight = 0;
    private int totalMaxHeight = 0;
    private int[] curHeights;
    private int[] minHeights;
    private int[] maxHeights;
    private int[] fixHeights;
    private int[] perHeights;
    private boolean tableHasFixed;
    private boolean tableHasPercent;
    private Point drawOffset = new Point(0, 0);
    private Insets originOffset = new Insets(0, 0, 0, 0);
    private Vector contents = null;
    private Box lastBox = null;
    private Paragraph paragraph = null;
    private Status listStatus = null;

    Box(Drawkit drawkit) {
        this(drawkit, null, null);
        if (this.level == 0 && this.frame.right > 0) {
            drawkit.createPanel(this.frame.right, 1, this.status);
            drawkit.commitPanel();
        }
    }

    private Box(Drawkit drawkit, Box parent, Box last) {
        if (parent == null) {
            this.origin = parent = this;
        }
        this.drawkit = drawkit;
        this.status = drawkit.status;
        this.origin = parent.status.isTable ? this : parent.origin;
        this.parent = parent;
        this.level = parent.level + 1;
        boolean bl = this.fixedBlock = this.level <= 1 || parent.status.isTable;
        if (this.status.floatType != 3) {
            this.origin = this;
            this.floatOffset = new Point(0, 0);
        }
        this.frame = new Insets(0, 0, 0, 0);
        if (!parent.status.isTable && this.status.margin != null) {
            int baseHeight;
            int baseWidth = this.level == 0 ? drawkit.viewSize.width : 0;
            int n = baseHeight = this.level == 0 ? drawkit.viewSize.height : 0;
            if (this.status.margin.top != null) {
                this.margin.top = this.status.margin.top.getValue(this.status.fd, baseHeight, 2);
                this.frame.top += this.margin.top;
            }
            if (this.status.margin.right != null) {
                this.margin.right = Math.max(this.status.margin.right.getValue(this.status.fd, baseWidth, 1) - (last != null ? last.margin.left : 0), 0);
                this.frame.right = this.frame.right + this.margin.right;
            }
            if (this.status.margin.bottom != null) {
                this.margin.bottom = this.status.margin.bottom.getValue(this.status.fd, baseHeight, 2);
                this.frame.bottom += this.margin.bottom;
            }
            if (this.status.margin.left != null) {
                this.margin.left = this.status.margin.left.getValue(this.status.fd, baseWidth, 1);
                this.frame.left += this.margin.left;
            }
        }
        if (this.status.border != null) {
            this.status.border.setBaseSize(this.status.fd);
            this.border = this.status.border.getWidths();
            this.frame.top += this.border.top;
            this.frame.right += this.border.right;
            this.frame.bottom += this.border.bottom;
            this.frame.left += this.border.left;
        }
        if (this.status.padding != null) {
            if (this.status.padding.top != null) {
                this.padding.top = this.status.padding.top.getValue(this.status.fd, 0, 2);
                this.frame.top += this.padding.top;
            }
            if (this.status.padding.right != null) {
                this.padding.right = this.status.padding.right.getValue(this.status.fd, 0, 1);
                this.frame.right += this.padding.right;
            }
            if (this.status.padding.bottom != null) {
                this.padding.bottom = this.status.padding.bottom.getValue(this.status.fd, 0, 2);
                this.frame.bottom += this.padding.bottom;
            }
            if (this.status.padding.left != null) {
                this.padding.left = this.status.padding.left.getValue(this.status.fd, 0, 1);
                this.frame.left += this.padding.left;
            }
        }
        this.heightPercent = this.status.height != null && this.status.height.getUnit() == 9;
        this.heightFixed = this.status.height != null && this.status.height.getUnit() != 9;
        this.frameWidth = this.frame.left + this.frame.right;
        this.frameHeight = this.frame.top + this.frame.bottom;
        this.preferredSize = this.level == 0 ? new Dimension(0, drawkit.viewSize.height - this.frameHeight) : new Dimension(this.status.width != null ? this.status.width.getValue(this.status.fd, 0, 1) : 0, parent.status.isTable ? (this.status.height != null && this.status.height.getUnit() != 9 ? this.status.height.getValue(this.status.fd, 0, 2) : 1) : (this.status.height != null ? this.status.height.getValue(this.status.fd, parent.preferredSize.height - (this.status.isTable ? 0 : this.frameHeight), 2) : parent.preferredSize.height - (this.status.isTable ? 0 : this.frameHeight)));
        if (this.status.isTable) {
            this.verticalSpacing = this.status.borderVerticalSpacing != null ? this.status.borderVerticalSpacing.getValue(this.status.fd, 0, 2) : 2;
            int n = this.horizontalSpacing = this.status.borderHorizontalSpacing != null ? this.status.borderHorizontalSpacing.getValue(this.status.fd, 0, 1) : 2;
            if (this.heightFixed && this.border != null) {
                this.preferredSize.width = Math.max(this.preferredSize.width - (this.border.left + this.border.right), 0);
                this.preferredSize.height = Math.max(this.preferredSize.height - (this.border.top + this.border.bottom), 0);
            }
        }
    }

    void dispose() {
        if (this.level == 0) {
            if (this.delayPanels != null) {
                this.drawWithQueue(false, Math.max(this.floatChain.getWidth() - this.topOffset, 0));
            }
            if (this.frame.left > 0) {
                this.drawkit.createPanel(this.frame.left, 1, this.status);
                this.drawkit.commitPanel();
            }
        }
    }

    Box createBox() {
        boolean noFloat;
        boolean bl = noFloat = this.drawkit.status.floatType == 3;
        if (noFloat) {
            this.commitParagraph();
            this.lastBox = new Box(this.drawkit, this, this.lastBox);
            if (noFloat && this.listStatus != null) {
                this.lastBox.listStatus = this.listStatus;
                this.listStatus = null;
            }
            if (this.contents == null) {
                this.contents = new Vector();
            }
            this.contents.addElement(this.lastBox);
            return this.lastBox;
        }
        Box box = null;
        if (this.level == 0) {
            this.drawkit.insertStatus(3191);
            this.drawkit.status.checkStatus();
            this.statusChanged();
            box = this.createBox();
            box.dummyBox = true;
            this.drawkit.saveStatus(-1);
            this.drawkit.status.checkStatus();
            box.statusChanged();
            return box.createBox();
        }
        box = this.lastBox = new Box(this.drawkit, this, this.lastBox);
        this.checkParagraph();
        this.paragraph.appendFloat(box);
        return box;
    }

    Box commitBox() {
        this.commitParagraph();
        if (this.status.isTable && this.lastBox != null) {
            this.lastBox.status.isVertical = false;
        }
        if (this.contents != null) {
            if (this.status.isTable) {
                this.doCountSizeTable();
            } else {
                this.doCountSizeNormal();
            }
        } else if (this.status.isHorizontalRule) {
            this.doCountSizeHR();
        }
        if (this.level == 1) {
            int parentHeight;
            this.originOffset.right = this.parent.topOffset;
            this.originOffset.top = this.parent.frame.top;
            this.originOffset.bottom = this.parent.frame.bottom;
            this.rearrange(this.preferredSize.height + (this.status.isTable ? 0 : this.frameHeight), this.parent.preferredSize.height);
            if (!this.status.isTable && this.status.height == null) {
                int diff = Math.max(this.preferredSize.width - this.width, 0);
                if (diff > 0) {
                    this.width += diff;
                    this.drawWidth += diff;
                }
                if ((diff = Math.max(this.preferredSize.height - this.height, 0)) > 0) {
                    this.height += diff;
                    this.drawHeight += diff;
                }
            }
            if ((this.status.align == 33 || this.status.align == 32) && (parentHeight = this.parent.preferredSize.height - this.frameHeight) < this.drawkit.viewSize.height && parentHeight > this.height) {
                int offset = 0;
                switch (this.parent.status.align) {
                    case 33: {
                        offset = (parentHeight - this.height) / 2;
                        break;
                    }
                    case 32: {
                        offset = parentHeight - this.height;
                    }
                }
                this.drawOffset.y += offset;
                this.height += offset;
                this.drawHeight += offset;
            }
            this.parent.topOffset += this.drawWidth;
            if (this.drawWidth > 0 && this.drawHeight > 0 || this.origin.floatChain != null) {
                if (this.origin.floatChain != null && this.origin.floatChain.getHeight(35, this.originOffset.right + this.drawWidth, this.originOffset.top, this.originOffset.bottom) > 0) {
                    if (this.parent.delayPanels == null) {
                        this.parent.delayPanels = new Vector();
                    }
                    this.parent.delayPanels.addElement(this);
                } else {
                    this.drawWithQueue(true, 0);
                }
            }
        }
        if (this.parent.dummyBox) {
            this.drawkit.resetStatus();
            this.drawkit.status.checkStatus();
            this.parent.statusChanged();
            return this.parent.commitBox();
        }
        return this.parent;
    }

    void statusChanged() {
        if (this.paragraph != null) {
            this.paragraph.statusChanged();
        }
    }

    void rearrange(int newHeight, int parentHeight) {
        int right;
        if (this.contents == null && !this.status.isHorizontalRule) {
            return;
        }
        newHeight -= this.frameHeight;
        parentHeight -= this.frameHeight;
        if (this.origin == this) {
            this.originOffset.bottom = 0;
            this.originOffset.top = 0;
            this.originOffset.right = 0;
            this.floatChain = null;
        }
        if (!this.parent.status.isTable && this.heightFixed) {
            newHeight = this.preferredSize.height;
        }
        if (this.status.clearType != 3 && this.origin.floatChain != null && (right = this.origin.floatChain.getClearPosition(this.status.clearType, this.originOffset.right) - this.originOffset.right) > this.margin.right) {
            this.margin.right += (right -= this.margin.right);
            this.frame.right += right;
            this.frameWidth += right;
        }
        int offset = 0;
        if (this.status.isTable && this.status.floatType == 3 && this.origin.floatChain != null) {
            if ((offset = this.getFloatGap(offset - this.frame.right, this.heightFixed ? newHeight : this.height, parentHeight) + this.frame.right) > 0) {
                this.drawOffset.x += offset;
            }
            this.drawOffset.y = this.origin.floatChain.getHeight(31, this.originOffset.right + offset, this.originOffset.top, this.originOffset.bottom);
            if (!this.heightFixed) {
                newHeight -= Math.max(this.origin.floatChain.getHeight(35, this.originOffset.right + offset, this.originOffset.top, this.originOffset.bottom) - (parentHeight - newHeight), 0);
            }
        }
        if (this.status.floatType != 3) {
            newHeight = Math.min(newHeight, this.maxHeight);
        }
        this.width = 0;
        this.height = 0;
        if (this.status.isTable) {
            this.rearrangeTable(newHeight);
        } else if (this.status.isHorizontalRule) {
            this.rearrangeHR(newHeight);
        } else {
            this.rearrangeNormal(newHeight);
        }
        this.drawWidth = this.width + this.frameWidth + offset;
        this.drawHeight = this.height + this.frameHeight;
        this.innerWidth = this.width;
    }

    private void draw(int x, int y) {
        int offset;
        if ((this.frame.right + this.width + this.frame.left == 0 || this.frameHeight + this.height == 0) && this.origin.floatChain == null) {
            return;
        }
        x -= this.drawOffset.x;
        y += this.drawOffset.y;
        if (this.level > 0 && this.status.backColor != null) {
            int w = this.width + this.padding.left + this.padding.right;
            int h = this.height + this.padding.top + this.padding.bottom;
            if (w > 0 && h > 0) {
                this.drawkit.g.setColor(this.status.backColor);
                this.drawkit.g.fillRect(x - this.frame.right - this.width - this.padding.left, y + (this.frame.top - this.padding.top), w, h);
            }
        }
        if (this.border != null) {
            if (!this.status.isHorizontalRule) {
                this.status.border.draw(this.drawkit.g, x - this.frame.right - this.width - this.padding.left - this.border.left, y + this.margin.top, x - this.margin.right, y + this.frame.top + this.height + this.padding.bottom + this.border.bottom, this.status.foreColor);
            } else {
                int h = this.status.hrHeight.getValue(this.status.fd, this.height, 2);
                offset = 0;
                if ((this.status.align == 33 || this.status.align == 32) && this.height < this.drawkit.viewSize.height) {
                    switch (this.status.align) {
                        case 33: {
                            offset = (this.height - h) / 2;
                            break;
                        }
                        case 32: {
                            offset = this.height - h;
                        }
                    }
                }
                this.status.border.draw(this.drawkit.g, x - this.frame.right - this.width - this.padding.left - this.border.left, y + offset + this.margin.top, x - this.margin.right, y + offset + this.frame.top + h + this.padding.bottom + this.border.bottom, this.status.foreColor);
            }
        }
        if (this.contents == null) {
            return;
        }
        x -= this.frame.right;
        y += this.frame.top;
        switch (this.status.valign) {
            case 47: {
                x -= this.width - this.innerWidth;
                break;
            }
            case 44: {
                break;
            }
            default: {
                x -= (this.width - this.innerWidth) / 2;
            }
        }
        for (int i = 0; i < this.contents.size(); ++i) {
            Object o = this.contents.elementAt(i);
            if (o instanceof Box) {
                Box box = (Box)o;
                offset = 0;
                if (!(this.status.align != 33 && this.status.align != 32 || this.level <= 1 && this.drawkit.viewSize.height <= box.height + box.frameHeight)) {
                    int h = this.level == 1 ? Math.min(this.height, this.drawkit.viewSize.height) : this.height;
                    h -= this.getFloatHeight(box.drawOffset.x, 35);
                    switch (this.status.align) {
                        case 33: {
                            offset = (h - (box.height + box.frameHeight)) / 2;
                            break;
                        }
                        case 32: {
                            offset = h - (box.height + box.frameHeight);
                        }
                    }
                }
                box.draw(x, y + offset);
                continue;
            }
            ((Paragraph)o).draw(x, y);
        }
    }

    private void drawWithQueue(boolean current, int addWidth) {
        Box box;
        int i;
        int w = addWidth;
        int h = 0;
        if (current) {
            w += this.drawWidth;
            h += this.drawHeight;
        }
        if (this.parent.delayPanels != null) {
            for (i = 0; i < this.parent.delayPanels.size(); ++i) {
                box = (Box)this.parent.delayPanels.elementAt(i);
                w += box.width + box.frameWidth;
                h = Math.max(h, box.height + box.frameHeight);
            }
        }
        this.drawkit.createPanel(w, h + this.parent.frameHeight, this.status);
        if (this.parent.delayPanels != null) {
            for (i = 0; i < this.parent.delayPanels.size(); ++i) {
                box = (Box)this.parent.delayPanels.elementAt(i);
                box.draw(w, this.parent.frame.top);
                w -= box.drawWidth;
            }
            this.parent.delayPanels = null;
        }
        if (current) {
            this.draw(w, this.parent.frame.top);
        }
        if (this.drawkit.floatQueue != null) {
            DelayRectangle dl;
            while ((dl = (DelayRectangle)this.drawkit.floatQueue.get()) != null) {
                dl.drawDelay();
            }
            this.drawkit.floatQueue = null;
        }
        this.drawkit.commitPanel();
    }

    public void drawDelay() {
        this.draw(this.floatDelayX, this.floatDelayY);
    }

    int resolvePercent(int height) {
        if (!this.heightPercent) {
            return height;
        }
        return height * this.status.height.getNumber().intValue() / 100;
    }

    Point addFloat(int offset, int width, int height, int type, int maxHeight) {
        if (this.origin.floatChain == null) {
            this.origin.floatChain = new FloatChain();
        }
        Point pos = this.origin.floatChain.allocate(type, offset += this.originOffset.right + this.frame.right, width, height, this.originOffset.top + this.frame.top, this.originOffset.bottom + this.frame.bottom, maxHeight);
        pos.x -= this.originOffset.right + this.frame.right;
        return pos;
    }

    int getFloatHeight(int offset, int type) {
        if (this.origin.floatChain == null) {
            return 0;
        }
        return this.origin.floatChain.getHeight(type, this.originOffset.right + this.frame.right + offset, this.originOffset.top + this.frame.top, this.originOffset.bottom + this.frame.bottom);
    }

    int getFloatGap(int offset, int newHeight, int maxHeight) {
        if (this.origin.floatChain == null) {
            return offset;
        }
        offset += this.originOffset.right + this.frame.right;
        offset = this.origin.floatChain.getGapPosition(offset, newHeight, this.originOffset.top + this.frame.top, this.originOffset.bottom + this.frame.bottom, maxHeight);
        return offset -= this.originOffset.right + this.frame.right;
    }

    void appendString(String text) {
        this.checkParagraph();
        this.paragraph.appendString(text);
    }

    void appendNewLine() {
        this.checkParagraph();
        this.paragraph.newLine();
    }

    void createNewRow() {
        if (this.lastBox != null) {
            this.lastBox.status.isVertical = false;
        }
    }

    void appendImage(String src, String alt, Value width, Value height, int border, int floatType) {
        this.checkParagraph();
        this.paragraph.appendImage(src, alt, width, height, border, floatType);
    }

    void appendForm(FormItem item) {
        this.checkParagraph();
        this.paragraph.appendForm(item);
    }

    void setRuby(int mode) {
        this.checkParagraph();
        this.paragraph.setRuby(mode);
    }

    void setListItem() {
        this.listStatus = this.drawkit.status;
    }

    private void checkParagraph() {
        if (this.paragraph != null) {
            return;
        }
        this.paragraph = new Paragraph(this, this.listStatus, this.preferredSize.height);
        if (!this.status.isTable) {
            if (this.contents == null) {
                this.contents = new Vector();
            }
            this.contents.addElement(this.paragraph);
            this.lastBox = null;
            this.listStatus = null;
        }
    }

    private void commitParagraph() {
        if (this.paragraph == null) {
            return;
        }
        this.paragraph.commit();
        this.paragraph = null;
    }

    private void doCountSizeNormal() {
        for (int i = 0; i < this.contents.size(); ++i) {
            Object o = this.contents.elementAt(i);
            if (o instanceof Box) {
                Box box = (Box)o;
                this.width = Math.max(this.width, box.drawOffset.x + box.width + box.frameWidth);
                this.height = Math.max(this.height, box.drawOffset.y + box.height + box.frameHeight);
                this.maxHeight = Math.max(this.maxHeight, box.maxHeight + box.frameHeight);
                continue;
            }
            Paragraph paragraph = (Paragraph)o;
            this.width = Math.max(this.width, paragraph.width + paragraph.drawOffsetX);
            this.height = Math.max(this.height, paragraph.height);
            this.maxHeight = Math.max(this.maxHeight, paragraph.maxHeight);
        }
        if (this.floatChain != null) {
            this.width = Math.max(this.width, this.floatChain.getWidth());
        }
    }

    private void doCountSizeHR() {
        this.width = this.preferredSize.width;
        this.maxHeight = this.height = this.status.hrHeight.getValue(this.status.fd, 0, 2);
    }

    private void doCountSizeTable() {
        int per;
        int min;
        Box box;
        int i;
        int cellNum = this.contents.size();
        Cell cell = null;
        this.rowNum = 0;
        this.colNum = 0;
        Row row = new Row();
        for (i = 0; i < cellNum; ++i) {
            box = (Box)this.contents.elementAt(i);
            row.add(box.status.colSpan, box.status.rowSpan);
            if (box.status.isVertical) continue;
            this.colNum = Math.max(this.colNum, row.col);
            ++this.rowNum;
            row = row.next();
        }
        while (row.col > 0) {
            this.colNum = Math.max(this.colNum, row.col);
            ++this.rowNum;
            if ((row = row.next) != null) continue;
        }
        this.cells = new Cell[this.rowNum][this.colNum];
        int r = 0;
        int c = 0;
        block2: for (i = 0; i < cellNum; ++i) {
            box = (Box)this.contents.elementAt(i);
            cell = new Cell(cell, box, c, r);
            for (int j = 0; j < cell.rowSpan; ++j) {
                for (int k = 0; k < cell.colSpan; ++k) {
                    this.cells[r + j][c + k] = cell;
                }
            }
            c += cell.colSpan;
            if (!box.status.isVertical) {
                c = this.colNum;
            }
            while (true) {
                if (c == this.colNum) {
                    c = 0;
                    if (++r != this.rowNum) continue;
                    break block2;
                }
                if (this.cells[r][c] == null) continue block2;
                ++c;
            }
        }
        this.curHeights = new int[this.colNum];
        this.minHeights = new int[this.colNum];
        this.maxHeights = new int[this.colNum];
        this.perHeights = new int[this.colNum];
        this.fixHeights = new int[this.colNum];
        for (c = this.colNum - 1; c >= 0; --c) {
            int max = 1;
            min = 1;
            int oddPer = 0;
            int oddFix = 0;
            int oddMax = 0;
            int oddMin = 0;
            per = 0;
            int fix = 0;
            for (r = 0; r < this.rowNum; ++r) {
                cell = this.cells[r][c];
                if (cell == null || cell.row != r || cell.colSpan != 1) continue;
                min = Math.max(min, cell.min);
                max = Math.max(max, cell.max);
                fix = Math.max(fix, cell.fix);
                per = Math.max(per, cell.per);
            }
            if (max < min) {
                max = min;
            }
            if (fix > 0 && fix < min) {
                fix = min;
            }
            for (r = 0; r < this.rowNum; ++r) {
                cell = this.cells[r][c];
                if (cell == null || cell.row != r || cell.colSpan == 1) continue;
                cell.min -= min;
                cell.max -= max;
                cell.fix -= fix;
                cell.per -= per;
                if (cell.col == c) {
                    oddMin = Math.max(oddMin, cell.min);
                    oddMax = Math.max(oddMax, cell.max);
                    oddFix = Math.max(oddFix, cell.fix);
                    oddPer = Math.max(oddPer, cell.per);
                    continue;
                }
                cell.min -= this.verticalSpacing;
                cell.max -= this.verticalSpacing;
                cell.fix -= this.verticalSpacing;
                cell.per -= this.verticalSpacing;
            }
            this.minHeights[c] = min;
            this.maxHeights[c] = fix > 0 ? fix : max;
            this.fixHeights[c] = fix;
            this.perHeights[c] = per;
            if (oddFix > 0) {
                this.correctOddHeights(3, c);
            }
            if (oddMax > 0) {
                this.correctOddHeights(2, c);
            }
            if (oddMin > 0) {
                this.correctOddHeights(1, c);
            }
            if (oddPer > 0) {
                this.correctOddHeights(4, c);
            }
            if (!(this.tableHasFixed || fix <= 0 && oddFix <= 0)) {
                this.tableHasFixed = true;
            }
            if (this.tableHasPercent || per <= 0 && oddPer <= 0) continue;
            this.tableHasPercent = true;
        }
        for (c = 0; c < this.colNum; ++c) {
            this.totalMinHeight += this.minHeights[c];
            this.totalMaxHeight += this.maxHeights[c];
        }
        if (this.tableHasPercent) {
            per = 0;
            for (c = 0; c < this.colNum; ++c) {
                if (this.perHeights[c] <= 0) continue;
                per = Math.max(this.maxHeights[c] * 100 / this.perHeights[c], per);
            }
            this.totalMaxHeight = Math.max(this.totalMaxHeight, per);
        }
        int vs = this.verticalSpacing * (this.colNum + 1);
        min = this.totalMinHeight + vs;
        this.width = 1;
        this.height = this.heightFixed ? Math.max(min, this.preferredSize.height) : min;
        this.maxHeight = this.totalMaxHeight + vs;
    }

    private void rearrangeNormal(int newHeight) {
        int offset = 0;
        boolean oddHeight = false;
        for (int i = 0; i < this.contents.size(); ++i) {
            Object o = this.contents.elementAt(i);
            if (o instanceof Box) {
                Box box = (Box)o;
                int h = box.resolvePercent(newHeight);
                if (this.level > 1 && h > newHeight) {
                    h = newHeight;
                }
                box.drawOffset.x = offset;
                box.originOffset.right = this.originOffset.right + this.frame.right + offset;
                box.originOffset.top = this.originOffset.top + this.frame.top;
                box.originOffset.bottom = this.originOffset.bottom + this.frame.bottom;
                box.rearrange(h, newHeight);
                offset = box.drawOffset.x + box.width + box.frameWidth;
                continue;
            }
            Paragraph paragraph = (Paragraph)o;
            paragraph.drawOffsetX = offset;
            paragraph.rearrange(newHeight, this.origin.floatChain != null);
            offset += paragraph.width;
        }
        this.doCountSizeNormal();
        this.height = Math.max(this.height, newHeight);
    }

    private void rearrangeHR(int newHeight) {
        this.width = this.preferredSize.width;
        this.height = newHeight;
    }

    private void rearrangeTable(int newHeight) {
        Cell cell;
        int r;
        int c;
        boolean smaller;
        int totalWidth = 0;
        int totalHeight = 0;
        boolean bl = smaller = (newHeight -= this.verticalSpacing * (this.colNum + 1)) >= this.totalMaxHeight;
        if (this.tableHasPercent) {
            int percentHeight = !this.heightPercent && !this.heightFixed && this.totalMaxHeight < newHeight ? this.totalMaxHeight : newHeight;
            for (c = 0; c < this.colNum; ++c) {
                if (this.perHeights[c] <= 0) continue;
                this.maxHeights[c] = Math.max(percentHeight * this.perHeights[c] / 100, this.minHeights[c]);
            }
        }
        if (!this.heightPercent && !this.heightFixed && this.totalMaxHeight <= newHeight) {
            for (c = 0; c < this.colNum; ++c) {
                this.curHeights[c] = this.maxHeights[c];
                totalHeight += this.maxHeights[c];
            }
            newHeight = this.totalMaxHeight;
        } else {
            int diff;
            for (c = 0; c < this.colNum; ++c) {
                this.curHeights[c] = this.minHeights[c];
                totalHeight += this.minHeights[c];
            }
            if (this.tableHasPercent && totalHeight < newHeight) {
                for (c = 0; c < this.colNum && totalHeight < newHeight; ++c) {
                    if (this.perHeights[c] == 0 || this.maxHeights[c] <= this.curHeights[c]) continue;
                    diff = this.maxHeights[c] - this.curHeights[c];
                    if (diff + totalHeight > newHeight) {
                        diff = newHeight - totalHeight;
                    }
                    int n = c;
                    this.curHeights[n] = this.curHeights[n] + diff;
                    totalHeight += diff;
                }
            }
            if (this.tableHasFixed && totalHeight < newHeight) {
                for (c = 0; c < this.colNum; ++c) {
                    if (this.fixHeights[c] == 0 || this.perHeights[c] > 0 || this.maxHeights[c] <= this.curHeights[c]) continue;
                    diff = this.maxHeights[c] - this.curHeights[c];
                    int n = c;
                    this.curHeights[n] = this.curHeights[n] + diff;
                    totalHeight += diff;
                }
            }
        }
        if (totalHeight < newHeight || totalHeight > newHeight && totalHeight > this.totalMinHeight) {
            totalHeight = this.correctColHeights(0, totalHeight, newHeight - totalHeight, 0, this.colNum);
        }
        if (totalHeight < newHeight) {
            System.out.println("### table height = req=[" + newHeight + "],fix=[" + totalHeight + "]");
        }
        for (c = 0; c < this.colNum; ++c) {
            for (r = 0; r < this.rowNum; ++r) {
                cell = this.cells[r][c];
                if (cell == null || cell.row != r) continue;
                cell.height += this.curHeights[c];
            }
        }
        int offset = this.verticalSpacing;
        for (c = 0; c < this.colNum; ++c) {
            for (r = 0; r < this.rowNum; ++r) {
                cell = this.cells[r][c];
                if (cell == null || cell.col != c || cell.row != r) continue;
                cell.initializeWidth(offset);
            }
            offset += this.curHeights[c] + this.verticalSpacing;
        }
        int[] widths = new int[this.rowNum];
        for (r = 0; r < this.rowNum; ++r) {
            int max = 1;
            int oddMax = 0;
            for (c = 0; c < this.colNum; ++c) {
                cell = this.cells[r][c];
                if (cell == null || cell.col != c || cell.rowSpan != 1) continue;
                max = Math.max(max, cell.width);
            }
            for (c = 0; c < this.colNum; ++c) {
                cell = this.cells[r][c];
                if (cell == null || cell.col != c || cell.rowSpan == 1) continue;
                cell.width -= max;
                if (cell.row + cell.rowSpan - 1 == r) {
                    oddMax = Math.max(oddMax, cell.width);
                    continue;
                }
                cell.width -= this.horizontalSpacing;
            }
            widths[r] = max;
            if (oddMax <= 0) continue;
            this.correctOddWidths(r, widths);
        }
        offset = this.horizontalSpacing;
        for (r = 0; r < this.rowNum; ++r) {
            for (c = 0; c < this.colNum; ++c) {
                cell = this.cells[r][c];
                if (cell == null || cell.col != c) continue;
                if (cell.row == r) {
                    ((Cell)cell).box.drawOffset.x = offset;
                } else {
                    ((Cell)cell).box.width += this.horizontalSpacing;
                }
                ((Cell)cell).box.width += widths[r];
            }
            totalWidth += widths[r];
            offset += widths[r] + this.horizontalSpacing;
        }
        this.width = totalWidth + this.horizontalSpacing * (this.rowNum + 1);
        this.height = totalHeight + this.verticalSpacing * (this.colNum + 1);
        this.curHeights = null;
        this.minHeights = null;
        this.maxHeights = null;
        this.fixHeights = null;
        this.perHeights = null;
    }

    private void correctOddHeights(int type, int c) {
        int n = 0;
        while (true) {
            Cell cell;
            int r;
            int odd = 0;
            for (r = 0; r < this.rowNum; ++r) {
                cell = this.cells[r][c];
                if (cell == null || cell.row != r || cell.col != c || cell.colSpan == 1) continue;
                switch (type) {
                    case 1: {
                        n = cell.min;
                        break;
                    }
                    case 2: {
                        n = cell.max;
                        break;
                    }
                    case 3: {
                        n = cell.fix;
                        break;
                    }
                    case 4: {
                        n = cell.per;
                    }
                }
                odd = Math.max(odd, n);
            }
            if (odd == 0) break;
            int colSpan = this.colNum;
            for (r = 0; r < this.rowNum; ++r) {
                cell = this.cells[r][c];
                if (cell == null || cell.row != r || cell.col != c || cell.colSpan == 1) continue;
                switch (type) {
                    case 1: {
                        n = cell.min;
                        break;
                    }
                    case 2: {
                        n = cell.max;
                        break;
                    }
                    case 3: {
                        n = cell.fix;
                        break;
                    }
                    case 4: {
                        n = cell.per;
                    }
                }
                if (n != odd) continue;
                colSpan = Math.min(colSpan, cell.colSpan);
            }
            this.correctColHeights(type, 0, odd, c, c + colSpan);
        }
    }

    private int correctColHeights(int type, int totalHeight, int odd, int start, int end) {
        boolean all;
        int part;
        int c;
        int diff = 0;
        int trapCounter = 0;
        int cellNum = 0;
        int total = 0;
        int maxTotal = 0;
        if (type == 2) {
            for (c = start; c < end; ++c) {
                total += this.maxHeights[c];
                if (this.perHeights[c] == 0) continue;
                ++cellNum;
                maxTotal += this.perHeights[c];
            }
            if (cellNum > 0) {
                if (maxTotal < 100) {
                    maxTotal = 100;
                }
                total += odd;
                for (c = start; c < end; ++c) {
                    if (this.perHeights[c] == 0) continue;
                    part = total * this.perHeights[c] / maxTotal;
                    diff = part > this.minHeights[c] ? part - this.maxHeights[c] : this.minHeights[c] - this.maxHeights[c];
                    odd -= diff;
                    total -= part;
                    maxTotal -= this.perHeights[c];
                    if (diff == 0) continue;
                    totalHeight = this.correctWork(type, c, totalHeight, diff);
                }
            }
        }
        boolean bl = all = type == 4;
        while (odd != 0) {
            if (++trapCounter > 1000) {
                throw new RuntimeException("internal error (table col correct)");
            }
            maxTotal = 0;
            total = 0;
            cellNum = 0;
            for (c = start; c < end; ++c) {
                if (!all && type != 1 && (this.fixHeights[c] > 0 || this.perHeights[c] > 0) || !all && type == 1 && this.minHeights[c] == this.maxHeights[c] || odd < 0 && (type == 2 ? this.maxHeights[c] : this.curHeights[c]) == this.minHeights[c]) continue;
                ++cellNum;
                switch (type) {
                    case 0: {
                        total += this.curHeights[c];
                        break;
                    }
                    case 1: {
                        total += this.minHeights[c];
                        break;
                    }
                    case 2: {
                        total += this.maxHeights[c];
                        break;
                    }
                    case 3: {
                        total += this.fixHeights[c];
                        break;
                    }
                    case 4: {
                        total += this.perHeights[c];
                    }
                }
                maxTotal += this.maxHeights[c];
            }
            if (cellNum == 0) {
                if (all) break;
                all = true;
                continue;
            }
            total += odd;
            for (c = start; c < end && odd != 0; ++c) {
                if (!all && type != 1 && (this.fixHeights[c] > 0 || this.perHeights[c] > 0) || !all && type == 1 && this.minHeights[c] == this.maxHeights[c] || odd < 0 && (type == 2 ? this.maxHeights[c] : this.curHeights[c]) == this.minHeights[c]) continue;
                part = total * this.maxHeights[c] / maxTotal;
                switch (type) {
                    case 0: {
                        if (part >= this.minHeights[c]) {
                            diff = part - this.curHeights[c];
                            break;
                        }
                        diff = this.minHeights[c] - this.curHeights[c];
                        break;
                    }
                    case 1: {
                        if (all || part <= this.maxHeights[c]) {
                            diff = part - this.minHeights[c];
                            break;
                        }
                        diff = this.maxHeights[c] - this.minHeights[c];
                        break;
                    }
                    case 2: {
                        if (part >= this.minHeights[c]) {
                            diff = part - this.maxHeights[c];
                            break;
                        }
                        diff = this.minHeights[c] - this.maxHeights[c];
                        break;
                    }
                    case 3: {
                        diff = part - this.fixHeights[c];
                        break;
                    }
                    case 4: {
                        diff = part - this.perHeights[c];
                    }
                }
                odd -= diff;
                total -= part;
                maxTotal -= this.maxHeights[c];
                if (diff == 0) continue;
                totalHeight = this.correctWork(type, c, totalHeight, diff);
            }
        }
        return totalHeight;
    }

    private int correctWork(int type, int c, int totalHeight, int diff) {
        switch (type) {
            case 0: {
                int n = c;
                this.curHeights[n] = this.curHeights[n] + diff;
                return totalHeight += diff;
            }
            case 1: {
                int n = c;
                this.minHeights[n] = this.minHeights[n] + diff;
                if (this.maxHeights[c] >= this.minHeights[c]) break;
                this.maxHeights[c] = this.minHeights[c];
                break;
            }
            case 2: {
                if (this.fixHeights[c] != 0) break;
                int n = c;
                this.maxHeights[n] = this.maxHeights[n] + diff;
                break;
            }
            case 3: {
                int n = c;
                this.fixHeights[n] = this.fixHeights[n] + diff;
                this.maxHeights[c] = Math.max(this.fixHeights[c], this.minHeights[c]);
                break;
            }
            case 4: {
                int n = c;
                this.perHeights[n] = this.perHeights[n] + diff;
            }
        }
        block13: for (int r = 0; r < this.rowNum; ++r) {
            Cell cell = this.cells[r][c];
            if (cell == null || cell.row != r || cell.colSpan == 1) continue;
            switch (type) {
                case 1: {
                    cell.min -= diff;
                    continue block13;
                }
                case 2: {
                    cell.max -= diff;
                    continue block13;
                }
                case 3: {
                    cell.fix -= diff;
                    continue block13;
                }
                case 4: {
                    cell.per -= diff;
                }
            }
        }
        return totalHeight;
    }

    private void correctOddWidths(int r, int[] widths) {
        block0: while (true) {
            int i;
            Cell cell;
            int c;
            int odd = 0;
            for (c = 0; c < this.colNum; ++c) {
                cell = this.cells[r][c];
                if (cell == null || cell.col != c || cell.rowSpan == 1 || cell.row + cell.rowSpan - 1 != r) continue;
                odd = Math.max(odd, cell.width);
            }
            if (odd == 0) break;
            int rowSpan = this.rowNum;
            for (c = 0; c < this.colNum; ++c) {
                cell = this.cells[r][c];
                if (cell == null || cell.col != c || cell.rowSpan == 1 || cell.row + cell.rowSpan - 1 != r || cell.width != odd) continue;
                rowSpan = Math.min(rowSpan, cell.rowSpan);
            }
            int maxTotal = 0;
            for (i = r - rowSpan + 1; i <= r; ++i) {
                maxTotal += widths[i];
            }
            int total = maxTotal + odd;
            i = r - rowSpan + 1;
            while (true) {
                if (i > r) continue block0;
                int part = total * widths[i] / maxTotal;
                int diff = part - widths[i];
                total -= part;
                maxTotal -= widths[i];
                widths[i] = part;
                for (c = 0; c < this.colNum; ++c) {
                    cell = this.cells[i][c];
                    if (cell == null || cell.col != c || cell.rowSpan == 1) continue;
                    cell.width -= diff;
                }
                ++i;
            }
            break;
        }
    }

    private class Cell {
        private Cell next;
        private Box box;
        private int col;
        private int row;
        private int colSpan;
        private int rowSpan;
        private int workRowSpan;
        private int min;
        private int max;
        private int fix;
        private int per;
        private int width;
        private int height;

        private Cell(Cell before, Box box, int col, int row) {
            if (before != null) {
                before.next = this;
            }
            this.box = box;
            this.col = col;
            this.row = row;
            this.colSpan = box.status.colSpan;
            this.rowSpan = box.status.rowSpan;
            this.min = Math.max(box.height + box.frameHeight, 1);
            this.max = Math.max(box.maxHeight + box.frameHeight, this.min);
            if (box.heightFixed) {
                this.fix = Math.max(((Box)box).preferredSize.height, 1);
            }
            if (box.heightPercent) {
                this.per = Math.max(box.status.height.getNumber().intValue(), 1);
            }
            this.workRowSpan = this.rowSpan;
            this.height = Box.this.verticalSpacing * (this.colSpan - 1);
        }

        private void initializeWidth(int offsetY) {
            this.box.height = this.height - this.box.frameHeight;
            ((Box)this.box).drawOffset.y = offsetY;
            this.box.rearrange(this.height, this.height);
            this.width = this.box.width + this.box.frameWidth;
            this.box.width = -this.box.frameWidth;
        }
    }

    private class Row {
        private int col;
        private Row next;

        private Row() {
        }

        private void add(int c, int r) {
            this.col += c;
            if (r > 1) {
                Row row = this;
                while (r-- > 1) {
                    row = row.next();
                    row.add(c, 1);
                }
            }
        }

        private Row next() {
            if (this.next != null) {
                return this.next;
            }
            this.next = new Row();
            return this.next;
        }
    }
}

