/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.protocol.https;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.URL;
import java.security.Permission;
import java.security.cert.Certificate;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;
import net.hizlab.kagetaka.protocol.ProxySupported;
import net.hizlab.kagetaka.protocol.URLConnectionCache;
import net.hizlab.kagetaka.protocol.https.SunDelegateHttpsURLConnection;
import net.hizlab.kagetaka.protocol.https.SunHandler;

public class SunHttpsURLConnection
extends HttpsURLConnection
implements ProxySupported {
    private SunDelegateHttpsURLConnection delegate;
    private URLConnectionCache.Entry cacheEntry;

    SunHttpsURLConnection(URL url, SunHandler handler, String proxyHost, int proxyPort, URLConnectionCache.Entry cacheEntry) throws IOException {
        super(url);
        this.delegate = new SunDelegateHttpsURLConnection(url, handler, this, proxyHost, proxyPort);
        cacheEntry.setupURLConnection(this.delegate);
        this.cacheEntry = cacheEntry;
    }

    public void connect() throws IOException {
        this.delegate.connect();
    }

    public URL getURL() {
        return this.delegate.getURL();
    }

    public int getContentLength() {
        return this.delegate.getContentLength();
    }

    public String getContentType() {
        return this.delegate.getContentType();
    }

    public String getContentEncoding() {
        return this.delegate.getContentEncoding();
    }

    public long getExpiration() {
        return this.delegate.getExpiration();
    }

    public long getDate() {
        return this.delegate.getDate();
    }

    public long getLastModified() {
        return this.delegate.getLastModified();
    }

    public String getHeaderField(String name) {
        return this.delegate.getHeaderField(name);
    }

    public int getHeaderFieldInt(String name, int Default) {
        return this.delegate.getHeaderFieldInt(name, Default);
    }

    public long getHeaderFieldDate(String name, long Default) {
        return this.delegate.getHeaderFieldDate(name, Default);
    }

    public String getHeaderFieldKey(int n) {
        return this.delegate.getHeaderFieldKey(n);
    }

    public String getHeaderField(int n) {
        return this.delegate.getHeaderField(n);
    }

    public Object getContent() throws IOException {
        return this.delegate.getContent();
    }

    public InputStream getInputStream() throws IOException {
        return this.delegate.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.delegate.getOutputStream();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public void setDoInput(boolean doinput) {
        this.delegate.setDoInput(doinput);
    }

    public boolean getDoInput() {
        return this.delegate.getDoInput();
    }

    public void setDoOutput(boolean dooutput) {
        this.delegate.setDoOutput(dooutput);
    }

    public boolean getDoOutput() {
        return this.delegate.getDoOutput();
    }

    public void setAllowUserInteraction(boolean allowuserinteraction) {
        this.delegate.setAllowUserInteraction(allowuserinteraction);
    }

    public boolean getAllowUserInteraction() {
        return this.delegate.getAllowUserInteraction();
    }

    public void setUseCaches(boolean usecaches) {
        this.delegate.setUseCaches(usecaches);
    }

    public boolean getUseCaches() {
        return this.delegate.getUseCaches();
    }

    public void setIfModifiedSince(long ifmodifiedsince) {
        this.delegate.setIfModifiedSince(ifmodifiedsince);
    }

    public long getIfModifiedSince() {
        return this.delegate.getIfModifiedSince();
    }

    public boolean getDefaultUseCaches() {
        return this.delegate.getDefaultUseCaches();
    }

    public void setDefaultUseCaches(boolean defaultusecaches) {
        this.delegate.setDefaultUseCaches(defaultusecaches);
    }

    public void setRequestProperty(String key, String value) {
        this.delegate.setRequestProperty(key, value);
        this.cacheEntry.addRequestProperty(key, value);
    }

    public String getRequestProperty(String key) {
        return this.delegate.getRequestProperty(key);
    }

    public void addRequestProperty(String key, String value) {
        this.delegate.addRequestProperty(key, value);
    }

    public Map getRequestProperties() {
        return this.delegate.getRequestProperties();
    }

    public void setInstanceFollowRedirects(boolean shouldFollow) {
        this.delegate.setInstanceFollowRedirects(shouldFollow);
    }

    public boolean getInstanceFollowRedirects() {
        return this.delegate.getInstanceFollowRedirects();
    }

    public Permission getPermission() throws IOException {
        return this.delegate.getPermission();
    }

    public void setRequestMethod(String method) throws ProtocolException {
        this.delegate.setRequestMethod(method);
    }

    public String getRequestMethod() {
        return this.delegate.getRequestMethod();
    }

    public int getResponseCode() throws IOException {
        return this.delegate.getResponseCode();
    }

    public String getResponseMessage() throws IOException {
        return this.delegate.getResponseMessage();
    }

    public void disconnect() {
        this.delegate.disconnect();
    }

    public boolean usingProxy() {
        return this.delegate.usingProxy();
    }

    public InputStream getErrorStream() {
        return this.delegate.getErrorStream();
    }

    protected void finalize() throws Throwable {
        this.delegate.finalize();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    protected void setNewClient(URL url) throws IOException {
        this.delegate.setNewClient(url, false);
    }

    protected void setNewClient(URL url, boolean useCache) throws IOException {
        this.delegate.setNewClient(url, useCache);
    }

    protected void setProxiedClient(URL url, String proxyHost, int proxyPort) throws IOException {
        this.delegate.setProxiedClient(url, proxyHost, proxyPort);
    }

    protected void setProxiedClient(URL url, String proxyHost, int proxyPort, boolean useCache) throws IOException {
        this.delegate.setProxiedClient(url, proxyHost, proxyPort, useCache);
    }

    protected boolean isConnected() {
        return this.delegate.isConnected();
    }

    protected void setConnected(boolean conn) {
        this.delegate.setConnected(conn);
    }

    public X509Certificate[] getServerCertificateChain() {
        try {
            return this.delegate.getServerCertificateChain();
        }
        catch (SSLPeerUnverifiedException e) {
            return null;
        }
    }

    public String getCipherSuite() {
        return this.delegate.getCipherSuite();
    }

    public Certificate[] getLocalCertificates() {
        return this.delegate.getLocalCertificates();
    }

    public Certificate[] getServerCertificates() throws SSLPeerUnverifiedException {
        return this.delegate.getServerCertificates();
    }
}

