/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.protocol.https;

import com.sun.net.ssl.internal.ssl.SSLSocketFactoryImpl;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.cert.X509Certificate;
import sun.net.www.http.HttpClient;
import sun.security.action.GetPropertyAction;
import sun.security.util.HostnameChecker;

class SunHttpsClient
extends HttpClient
implements HandshakeCompletedListener {
    private static final int DEFAULT_PORT = 443;
    private HostnameVerifier hv;
    private SSLSocketFactory sslSocketFactory;
    private String instTunnelHost;
    private int instTunnelPort;
    private SSLSession session;

    SunHttpsClient(SSLSocketFactory sf, URL url, String proxy, int proxyPort) throws IOException {
        this.setSSLSocketFactory(sf);
        if (proxy != null) {
            this.setTunnelProxy(proxy, proxyPort);
        }
        this.proxyDisabled = true;
        this.url = url;
        this.host = url.getHost();
        this.port = url.getPort();
        if (this.port == -1) {
            this.port = this.getDefaultPort();
        }
        this.openServer();
    }

    static SunHttpsClient New(SSLSocketFactory sf, URL url, HostnameVerifier hv) throws IOException {
        return SunHttpsClient.New(sf, url, hv, null, -1, true);
    }

    static SunHttpsClient New(SSLSocketFactory sf, URL url, HostnameVerifier hv, String proxy, int proxyPort, boolean useCache) throws IOException {
        SunHttpsClient ret = null;
        if (useCache && (ret = (SunHttpsClient)kac.get(url, sf)) != null) {
            ret.cachedHttpClient = true;
        }
        if (ret == null) {
            ret = new SunHttpsClient(sf, url, proxy, proxyPort);
        } else {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkConnect(url.getHost(), url.getPort());
            }
            ret.url = url;
        }
        ret.setHostnameVerifier(hv);
        return ret;
    }

    protected synchronized void openServer() throws IOException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkConnect(this.host, this.port);
        }
        if (this.isKeepingAlive()) {
            return;
        }
        this.openServer(this.host, this.port);
        this.usingProxy = false;
    }

    protected int getDefaultPort() {
        return 443;
    }

    void setHostnameVerifier(HostnameVerifier hv) {
        this.hv = hv;
    }

    SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    void setSSLSocketFactory(SSLSocketFactory sf) {
        this.sslSocketFactory = sf;
    }

    void setTunnelProxy(String proxy, int proxyPort) {
        this.instTunnelHost = proxy;
        this.instTunnelPort = proxyPort < 0 ? this.getDefaultPort() : proxyPort;
    }

    public boolean needsTunneling() {
        return this.instTunnelHost != null;
    }

    public String getProxyHostUsed() {
        if (!this.needsTunneling()) {
            return null;
        }
        return this.instTunnelHost;
    }

    public int getProxyPortUsed() {
        return this.instTunnelPort;
    }

    protected Socket doConnect(String host, int port) throws IOException, UnknownHostException {
        this.instTunnelHost = this.instTunnelHost != null ? this.instTunnelHost : this.getProxyHost();
        this.instTunnelPort = this.instTunnelPort != 0 ? this.instTunnelPort : this.getProxyPort();
        Socket s = null;
        SSLSocketFactory factory = this.sslSocketFactory;
        if (this.instTunnelHost == null) {
            s = factory.createSocket(host, port);
        } else {
            try {
                s = (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return new Socket(SunHttpsClient.this.instTunnelHost, SunHttpsClient.this.instTunnelPort);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (IOException)e.getException();
            }
            catch (IOException e) {
                try {
                    s = (SSLSocket)factory.createSocket(host, port);
                }
                catch (IOException ignored) {
                    throw e;
                }
            }
        }
        return s;
    }

    public void afterConnect() throws IOException, UnknownHostException {
        if (!this.isCachedConnection()) {
            SSLSocket s = null;
            SSLSocketFactory factory = this.sslSocketFactory;
            try {
                s = !(this.serverSocket instanceof SSLSocket) ? (SSLSocket)factory.createSocket(this.serverSocket, this.host, this.port, true) : (SSLSocket)this.serverSocket;
            }
            catch (IOException e) {
                try {
                    s = (SSLSocket)factory.createSocket(this.host, this.port);
                }
                catch (IOException ignored) {
                    throw e;
                }
            }
            SSLSocketFactoryImpl.checkCreate((SSLSocket)s);
            String[] protocols = this.getProtocols();
            String[] ciphers = this.getCipherSuites();
            if (protocols != null) {
                s.setEnabledProtocols(protocols);
            }
            if (ciphers != null) {
                s.setEnabledCipherSuites(ciphers);
            }
            s.addHandshakeCompletedListener(this);
            s.startHandshake();
            this.session = s.getSession();
            this.serverSocket = s;
            try {
                this.serverOutput = new PrintStream((OutputStream)new BufferedOutputStream(this.serverSocket.getOutputStream()), false, encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new InternalError(encoding + " encoding not found");
            }
            this.checkURLSpoofing(this.hv);
        } else {
            this.session = ((SSLSocket)this.serverSocket).getSession();
        }
    }

    private void checkURLSpoofing(HostnameVerifier hostnameVerifier) throws IOException {
        boolean done = false;
        String host = this.url.getHost();
        if (host != null && host.startsWith("[") && host.endsWith("]")) {
            host = host.substring(1, host.length() - 1);
        }
        Certificate[] peerCerts = null;
        try {
            peerCerts = this.session.getPeerCertificates();
            if (!(peerCerts[0] instanceof java.security.cert.X509Certificate)) {
                throw new SSLPeerUnverifiedException("");
            }
            java.security.cert.X509Certificate peerCert = (java.security.cert.X509Certificate)peerCerts[0];
            HostnameChecker checker = HostnameChecker.getInstance((byte)1);
            checker.match(host, peerCert);
            return;
        }
        catch (SSLPeerUnverifiedException e) {
        }
        catch (CertificateException cpe) {
            // empty catch block
        }
        String cipher = this.session.getCipherSuite();
        if (cipher != null && cipher.indexOf("_anon_") != -1) {
            return;
        }
        if (hostnameVerifier != null && hostnameVerifier.verify(host, this.session)) {
            return;
        }
        this.serverSocket.close();
        this.session.invalidate();
        throw new IOException("HTTPS hostname wrong:  should be <" + this.url.getHost() + ">");
    }

    protected void putInKeepAliveCache() {
        kac.put(this.url, this.sslSocketFactory, this);
    }

    String getCipherSuite() {
        return this.session.getCipherSuite();
    }

    public Certificate[] getLocalCertificates() {
        return this.session.getLocalCertificates();
    }

    Certificate[] getServerCertificates() throws SSLPeerUnverifiedException {
        return this.session.getPeerCertificates();
    }

    X509Certificate[] getServerCertificateChain() throws SSLPeerUnverifiedException {
        return this.session.getPeerCertificateChain();
    }

    public void handshakeCompleted(HandshakeCompletedEvent event) {
        this.session = event.getSession();
    }

    private String getProxyHost() {
        String host = AccessController.doPrivileged(new GetPropertyAction("https.proxyHost"));
        if (host != null && host.length() == 0) {
            host = null;
        }
        return host;
    }

    private int getProxyPort() {
        final int[] port = new int[]{0};
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (System.getProperty("https.proxyHost") != null) {
                    port[0] = Integer.getInteger("https.proxyPort", 80);
                }
                return null;
            }
        });
        return port[0] < 0 ? super.getDefaultPort() : port[0];
    }

    private String[] getProtocols() {
        String[] protocols;
        String protocolString = AccessController.doPrivileged(new GetPropertyAction("https.protocols"));
        if (protocolString == null || "".equals(protocolString)) {
            protocols = null;
        } else {
            Vector<Object> v = new Vector<Object>();
            StringTokenizer tokenizer = new StringTokenizer(protocolString, ",");
            while (tokenizer.hasMoreElements()) {
                v.addElement(tokenizer.nextElement());
            }
            protocols = new String[v.size()];
            for (int i = 0; i < protocols.length; ++i) {
                protocols[i] = (String)v.elementAt(i);
            }
        }
        return protocols;
    }

    private String[] getCipherSuites() {
        String[] ciphers;
        String cipherString = AccessController.doPrivileged(new GetPropertyAction("https.cipherSuites"));
        if (cipherString == null || "".equals(cipherString)) {
            ciphers = null;
        } else {
            Vector<Object> v = new Vector<Object>();
            StringTokenizer tokenizer = new StringTokenizer(cipherString, ",");
            while (tokenizer.hasMoreElements()) {
                v.addElement(tokenizer.nextElement());
            }
            ciphers = new String[v.size()];
            for (int i = 0; i < ciphers.length; ++i) {
                ciphers[i] = (String)v.elementAt(i);
            }
        }
        return ciphers;
    }
}

