/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.protocol.https;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.StringTokenizer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import net.hizlab.kagetaka.protocol.ProxySupported;
import net.hizlab.kagetaka.protocol.https.SunHttpsClient;
import sun.net.ProgressEntry;
import sun.net.www.MessageHeader;
import sun.net.www.protocol.http.Handler;
import sun.net.www.protocol.https.AbstractDelegateHttpsURLConnection;

public class SunDelegateHttpsURLConnection
extends AbstractDelegateHttpsURLConnection
implements ProxySupported {
    private static final String HTTP_VERSION = "HTTP/1.1";
    private HttpsURLConnection httpsURLConnection;
    private String proxyHost;
    private int proxyPort;
    private String proxyAuthorization;
    private MessageHeader responses;
    private InputStream inputStream;

    SunDelegateHttpsURLConnection(URL url, Handler handler, HttpsURLConnection httpsURLConnection, String proxyHost, int proxyPort) throws IOException {
        super(url, handler);
        this.httpsURLConnection = httpsURLConnection;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    protected SSLSocketFactory getSSLSocketFactory() {
        return this.httpsURLConnection.getSSLSocketFactory();
    }

    protected HostnameVerifier getHostnameVerifier() {
        return this.httpsURLConnection.getHostnameVerifier();
    }

    public void connect() throws IOException {
        this.connect(true);
    }

    private void connect(boolean useCache) throws IOException {
        if (this.connected) {
            return;
        }
        if (this.proxyHost == null) {
            this.plainConnect();
        } else {
            this.proxiedConnect(this.url, this.proxyHost, this.proxyPort, useCache);
            if (!this.http.isCachedConnection()) {
                this.doTunneling();
            }
        }
        if (this.inputStream == null) {
            ((SunHttpsClient)this.http).afterConnect();
        }
    }

    protected void plainConnect() throws IOException {
        if (this.connected) {
            return;
        }
        this.http = SunHttpsClient.New(this.getSSLSocketFactory(), this.url, this.getHostnameVerifier());
        this.connected = true;
    }

    protected void proxiedConnect(URL url, String proxyHost, int proxyPort, boolean useCache) throws IOException {
        if (this.connected) {
            return;
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkConnect(proxyHost, proxyPort);
        }
        this.http = SunHttpsClient.New(this.getSSLSocketFactory(), url, this.getHostnameVerifier(), proxyHost, proxyPort, useCache);
        this.connected = true;
    }

    public void setNewClient(URL url, boolean useCache) throws IOException {
        this.http = SunHttpsClient.New(this.getSSLSocketFactory(), url, this.getHostnameVerifier(), this.proxyHost, this.proxyPort, useCache);
        if (this.inputStream == null) {
            ((SunHttpsClient)this.http).afterConnect();
        }
    }

    public void setProxiedClient(URL url, String proxyHost, int proxyPort, boolean useCache) throws IOException {
        this.proxiedConnect(url, proxyHost, proxyPort, useCache);
        if (!this.http.isCachedConnection()) {
            this.doTunneling();
        }
        ((SunHttpsClient)this.http).afterConnect();
    }

    protected synchronized void doTunneling() throws IOException {
        MessageHeader responses = new MessageHeader();
        if (!this.connected) {
            this.proxiedConnect(this.url, this.proxyHost, this.proxyPort, false);
        }
        this.sendCONNECTRequest();
        this.http.parseHTTP(responses, new ProgressEntry(this.url.getFile(), null));
        StringTokenizer st = new StringTokenizer(responses.getValue(0));
        st.nextToken();
        int respCode = Integer.parseInt(st.nextToken().trim());
        if (respCode == 200) {
            return;
        }
        this.responseCode = respCode;
        this.responses = responses;
        this.inputStream = new HttpInputStream(this.http.getInputStream());
    }

    private void sendCONNECTRequest() throws IOException {
        MessageHeader requests = new MessageHeader();
        int port = this.url.getPort();
        if (port == -1) {
            port = this.url.getDefaultPort();
        }
        requests.prepend("CONNECT " + this.url.getHost() + ":" + port + " " + HTTP_VERSION, null);
        String host = this.url.getHost();
        if (port != -1 && port != 80) {
            host = host + ":" + String.valueOf(port);
        }
        requests.set("Host", host);
        this.copyRequestProperty(requests, "User-Agent");
        this.copyRequestProperty(requests, "Accept");
        this.copyRequestProperty(requests, "Accept-Language");
        this.copyRequestProperty(requests, "Accept-Encoding");
        this.copyRequestProperty(requests, "Accept-Charset");
        if (this.proxyAuthorization != null) {
            requests.set("Proxy-Authorization", this.proxyAuthorization);
        }
        this.http.writeRequests(requests, null);
    }

    private void copyRequestProperty(MessageHeader requests, String key) {
        String value = this.getRequestProperty(key);
        if (value != null) {
            requests.set(key, value);
        }
    }

    public void setRequestProperty(String key, String value) {
        if (key.equalsIgnoreCase("proxy-authorization")) {
            this.proxyAuthorization = value;
        } else {
            super.setRequestProperty(key, value);
        }
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        return super.getInputStream();
    }

    public InputStream getErrorStream() {
        if (this.connected && this.responseCode >= 400 && this.inputStream != null) {
            return this.inputStream;
        }
        return super.getErrorStream();
    }

    public String getHeaderField(String name) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.responses != null) {
            return this.responses.findValue(name);
        }
        return super.getHeaderField(name);
    }

    public Map getHeaderFields() {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.responses != null) {
            return this.responses.getHeaders();
        }
        return super.getHeaderFields();
    }

    public String getHeaderField(int n) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.responses != null) {
            return this.responses.getValue(n);
        }
        return super.getHeaderField(n);
    }

    public String getHeaderFieldKey(int n) {
        try {
            this.getInputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.responses != null) {
            return this.responses.getKey(n);
        }
        return super.getHeaderFieldKey(n);
    }

    private class HttpInputStream
    extends FilterInputStream {
        private HttpInputStream(InputStream is) {
            super(is);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                SunDelegateHttpsURLConnection.this.http = null;
            }
        }
    }
}

