/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.protocol.about;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import net.hizlab.kagetaka.Resource;

public class AboutURLConnection
extends URLConnection {
    private static final String RESOURCE = "net.hizlab.kagetaka.protocol.about.Resource";
    private static final String BUILD_RESOURCE = "net.hizlab.kagetaka.Build";
    private static final byte[] DEFAULT = "<html><head></head><body></body></html>".getBytes();
    private static final String ENCODING = "SJIS";
    private byte[] data;

    AboutURLConnection(URL url) {
        super(url);
    }

    public synchronized void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.data = Resource.getBinaryResource(RESOURCE, this.url.toString().replace(':', '.'));
        if (this.data == null) {
            this.data = DEFAULT;
        } else {
            this.replaceData();
        }
        this.connected = true;
    }

    public String getContentType() {
        return "text/html; charset=Shift_JIS";
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return new ByteArrayInputStream(this.data);
    }

    private synchronized void replaceData() {
        try {
            String value = new String(this.data, ENCODING);
            int length = value.length();
            if (length <= 1) {
                return;
            }
            StringBuffer sb = new StringBuffer();
            StringBuffer key = null;
            block6: for (int i = 0; i < length; ++i) {
                char c = value.charAt(i);
                switch (c) {
                    case '\\': {
                        if (++i >= length) continue block6;
                        sb.append(value.charAt(i));
                        continue block6;
                    }
                    case '$': {
                        if (++i >= length || value.charAt(i) != '{') continue block6;
                        if (key == null) {
                            key = new StringBuffer();
                        } else {
                            key.setLength(0);
                        }
                        while (++i < length) {
                            c = value.charAt(i);
                            if (c == '}') {
                                sb.append(this.getKeyValue(key.toString()));
                                continue block6;
                            }
                            key.append(c);
                        }
                        continue block6;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            this.data = sb.toString().getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private String getKeyValue(String key) {
        if (key.startsWith("build.")) {
            return Resource.getMessage(BUILD_RESOURCE, key, null);
        }
        return Resource.getMessage("kagetaka." + key, null);
    }
}

