/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.option;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.ToolTip;
import net.hizlab.kagetaka.bookmarks.BookmarkManager;
import net.hizlab.kagetaka.cookie.CookieManager;
import net.hizlab.kagetaka.history.HistoryManager;
import net.hizlab.kagetaka.io.PathAbsoluter;
import net.hizlab.kagetaka.option.ExProperties;
import net.hizlab.kagetaka.option.InvalidValueException;
import net.hizlab.kagetaka.option.OptionDialog;
import net.hizlab.kagetaka.option.OptionListener;
import net.hizlab.kagetaka.option.Setter;
import net.hizlab.kagetaka.option.ViewerController;
import net.hizlab.kagetaka.protocol.Protocol;
import net.hizlab.kagetaka.rendering.Option;
import net.hizlab.kagetaka.theme.ThemeManager;
import net.hizlab.kagetaka.util.CharList;
import net.hizlab.kagetaka.util.Environment;
import net.hizlab.kagetaka.viewer.ViewerConsole;

public class ViewerOption
extends Option
implements PathAbsoluter {
    public static final int TYPE_BOOLEAN = 1;
    public static final int TYPE_INT = 2;
    public static final int TYPE_DOUBLE = 3;
    public static final int TYPE_STRING = 4;
    public static final int TYPE_STRINGS = 5;
    public static final int TYPE_DIMENSION = 6;
    public static final int TYPE_FONT = 7;
    public static final int TYPE_POINT = 8;
    public static final int TYPE_FILE = 9;
    public static final int TYPE_CHARLIST = 10;
    private static final Integer OBJECT_BOOLEAN;
    private static final Integer OBJECT_INT;
    private static final Integer OBJECT_DOUBLE;
    private static final Integer OBJECT_STRING;
    private static final Integer OBJECT_STRINGS;
    private static final Integer OBJECT_DIMENSION;
    private static final Integer OBJECT_FONT;
    private static final Integer OBJECT_POINT;
    private static final Integer OBJECT_FILE;
    private static final Integer OBJECT_CHARLIST;
    private static final int PROXY_HTTP = 0;
    private static final int PROXY_HTTPS = 1;
    private static final int PROXY_FTP = 2;
    private static String kagetakaHome;
    private static String userHome;
    private static String defaultSystemOptionPath;
    private static String defaultUserOptionPath;
    Hashtable properties = new Hashtable();
    Hashtable defaultKey = new Hashtable();
    Vector defaultList = new Vector();
    Hashtable defaultTypes = new Hashtable();
    Hashtable defaultProperties;
    ExProperties systemProperties;
    ExProperties userProperties;
    Vector listeners = new Vector();
    private static final String DEFAULT_HISTORY_PATH = "history.dat";
    private static final String DEFAULT_BOOKMARKS_PATH = "bookmarks.html";
    private static final String DEFAULT_COOKIE_PATH = "cookies.txt";
    private static final String DEFAULT_USER_THEMES_PATH = "themes";
    private static final String DEFAULT_SYSTEM_THEMES_PATH = "themes";
    private static final String DEFAULT_IE_PATH = "\"C:\\Program Files\\Internet Explorer\\IEXPLORE.EXE\"";
    private static final String DEFAULT_MOZILLA_PATH = "/usr/bin/mozilla";
    public static final String KEY_PARSER_INPUT = "parser.input";
    public static final String KEY_PARSER_FILTERS = "parser.filters";
    public static final String KEY_FONT_DEFAULT = "font.default";
    public static final String KEY_FONT_FIXED = "font.fixed";
    public static final String KEY_FONT_PERPIXEL = "font.perpixel";
    public static final String KEY_CHARS_SPIN_RIGHT = "chars.spin.right";
    public static final String KEY_CHARS_SPIN_LTRB = "chars.spin.ltrb";
    public static final String KEY_CHARS_KINSOKU_HEAD = "chars.kinsoku.head";
    public static final String KEY_CHARS_KINSOKU_TAIL = "chars.kinsoku.tail";
    public static final String KEY_LOAD_IMAGE = "load.image";
    public static final String KEY_SHOW_SCROLLBAR = "show.scrollbar";
    public static final String KEY_SPIN_IMAGE_GIF = "spin.image.gif";
    public static final String KEY_SPIN_IMAGE_GIF_ASPECTRATIO = "spin.image.gif.aspectratio";
    public static final String KEY_SPIN_IMAGE_GIF_MINWIDTH = "spin.image.gif.minwidth";
    public static final String KEY_SPIN_IMAGE_JPEG = "spin.image.jpeg";
    public static final String KEY_SPIN_IMAGE_JPEG_ASPECTRATIO = "spin.image.jpeg.aspectratio";
    public static final String KEY_SPIN_IMAGE_JPEG_MINWIDTH = "spin.image.jpeg.minwidth";
    public static final String KEY_STYLE_DECORATION_SWAP = "style.decoration.swap";
    public static final String KEY_URL_HOME = "url.home";
    public static final String KEY_LOG_LEVEL = "log.level";
    public static final String KEY_WINDOW_POSITION = "window.position";
    public static final String KEY_WINDOW_SIZE = "window.size";
    public static final String KEY_SCREEN_RESOLUTION = "screen.resolution";
    public static final String KEY_HTTP_STRICT = "http.strict";
    public static final String KEY_HTTP_REFERER = "http.referer";
    public static final String KEY_HTTP_USERAGENT = "http.useragent";
    public static final String KEY_HTTP_ACCEPT = "http.accept";
    public static final String KEY_HTTP_ACCEPTCHARSET = "http.acceptcharset";
    public static final String KEY_HTTP_ACCEPTENCODING = "http.acceptencoding";
    public static final String KEY_HTTP_ACCEPTLANGUAGE = "http.acceptlanguage";
    public static final String KEY_SHOW_NAVIBAR = "show.navibar";
    public static final String KEY_SHOW_NAVIBAR_BUTTONS = "show.navibar.buttons";
    public static final String KEY_SHOW_SEARCHBAR = "show.searchbar";
    public static final String KEY_SHOW_LINKBAR = "show.linkbar";
    public static final String KEY_SHOW_LINKBAR_BUTTONS = "show.linkbar.buttons";
    public static final String KEY_SHOW_STATUSBAR = "show.statusbar";
    public static final String KEY_MOUSE_WHEEL = "mouse.wheel";
    public static final String KEY_MOUSE_WHEEL_SWAP = "mouse.wheel.swap";
    public static final String KEY_TOOLTIP_CONTROL_USE = "tooltip.control.use";
    public static final String KEY_TOOLTIP_CONTROL_DELAY = "tooltip.control.delay";
    public static final String KEY_TOOLTIP_CONTROL_TERM = "tooltip.control.term";
    public static final String KEY_TOOLTIP_BROWSER_USE = "tooltip.browser.use";
    public static final String KEY_TOOLTIP_BROWSER_DELAY = "tooltip.browser.delay";
    public static final String KEY_TOOLTIP_BROWSER_TERM = "tooltip.browser.term";
    public static final String KEY_PROXY = "proxy.";
    public static final String KEY_PROXY_USE = "proxy.use";
    public static final String KEY_PROXY_HTTP_HOST = "proxy.http.host";
    public static final String KEY_PROXY_HTTP_PORT = "proxy.http.port";
    public static final String KEY_PROXY_HTTPS_HOST = "proxy.https.host";
    public static final String KEY_PROXY_HTTPS_PORT = "proxy.https.port";
    public static final String KEY_PROXY_FTP_HOST = "proxy.ftp.host";
    public static final String KEY_PROXY_FTP_PORT = "proxy.ftp.port";
    public static final String KEY_PROXY_SOCKS_HOST = "proxy.socks.host";
    public static final String KEY_PROXY_SOCKS_PORT = "proxy.socks.port";
    public static final String KEY_PROXY_DIRECT = "proxy.direct";
    public static final String KEY_APP = "app.";
    public static final String KEY_APP_LIST = "app.list";
    public static final String[] KEY_APP_NAME;
    public static final String[] KEY_APP_PATH;
    public static final String[] KEY_APP_OPTION;
    public static final String[] KEY_APP_ONLINE;
    public static final String KEY_HISTORY_PATH = "history.path";
    public static final String KEY_HISTORY_SAVE_NUM = "history.save.num";
    public static final String KEY_HISTORY_WINDOW_POSITION = "history.window.position";
    public static final String KEY_HISTORY_WINDOW_SIZE = "history.window.size";
    public static final String KEY_BOOKMARKS_PATH = "bookmarks.path";
    public static final String KEY_BOOKMARKS_WINDOW_POSITION = "bookmarks.window.position";
    public static final String KEY_BOOKMARKS_WINDOW_SIZE = "bookmarks.window.size";
    public static final String KEY_COOKIE_PATH = "cookie.path";
    public static final String KEY_COOKIE_SAVE = "cookie.save";
    public static final String KEY_COOKIE_ACCEPT_STRICT = "cookie.accept.strict";
    public static final String KEY_COOKIE_ACCEPT_SESSION = "cookie.accept.session";
    public static final String KEY_COOKIE_ACCEPT_STRAGE = "cookie.accept.strage";
    public static final String KEY_COOKIE_WINDOW_POSITION = "cookie.window.position";
    public static final String KEY_COOKIE_WINDOW_SIZE = "cookie.window.size";
    public static final String KEY_DOWNLOAD_WINDOW_POSITION = "download.window.position";
    public static final String KEY_DOWNLOAD_WINDOW_CLOSE = "download.window.close";
    public static final String KEY_DOWNLOAD_SAVE_PATH = "download.save.path";
    public static final String KEY_USER_THEMES_PATH = "theme.user.path";
    public static final String KEY_SYSTEM_THEMES_PATH = "theme.system.path";
    public static final String KEY_THEME_KEY = "theme.key";
    private HistoryManager historyManager;
    private BookmarkManager bookmarkManager;
    private CookieManager cookieManager;
    private ThemeManager themeManager;
    private ViewerConsole viewerConsole;
    private ToolTip toolTip;
    private Proxy[] proxies;
    private Node[] proxyDirectNodes;
    private boolean proxyUseSocks;
    private Application[] applications;

    private void initializeBasic() {
        Option option = new Option();
        this.initPropertyString(KEY_PARSER_INPUT, option.getInputStreamParser());
        this.initPropertyStrings(KEY_PARSER_FILTERS, option.getFilterParsers());
        this.initPropertyFont(KEY_FONT_DEFAULT, option.getDefaultFont());
        this.initPropertyFont(KEY_FONT_FIXED, option.getDefaultFixedFont());
        this.initPropertyDouble(KEY_FONT_PERPIXEL, option.getFontPerPixel());
        this.initPropertyCharList(KEY_CHARS_SPIN_RIGHT, option.getCharsSpinRight());
        this.initPropertyCharList(KEY_CHARS_SPIN_LTRB, option.getCharsSpinLtrb());
        this.initPropertyCharList(KEY_CHARS_KINSOKU_HEAD, option.getCharsKinsokuHead());
        this.initPropertyCharList(KEY_CHARS_KINSOKU_TAIL, option.getCharsKinsokuTail());
        this.initPropertyBoolean(KEY_LOAD_IMAGE, option.getLoadImage());
        this.initPropertyBoolean(KEY_SHOW_SCROLLBAR, option.getShowScrollbar());
        this.initPropertyBoolean(KEY_SPIN_IMAGE_GIF, true);
        this.initPropertyDouble(KEY_SPIN_IMAGE_GIF_ASPECTRATIO, option.getSpinGifAspectRatio());
        this.initPropertyInteger(KEY_SPIN_IMAGE_GIF_MINWIDTH, option.getSpinGifMinWidth());
        this.initPropertyBoolean(KEY_SPIN_IMAGE_JPEG, true);
        this.initPropertyDouble(KEY_SPIN_IMAGE_JPEG_ASPECTRATIO, option.getSpinJpegAspectRatio());
        this.initPropertyInteger(KEY_SPIN_IMAGE_JPEG_MINWIDTH, option.getSpinJpegMinWidth());
        this.initPropertyBoolean(KEY_STYLE_DECORATION_SWAP, option.getSwapDecoration());
    }

    private void initializeBrowser() {
        this.initPropertyString(KEY_URL_HOME, Resource.getMessage("kagetaka.homepage", null));
        this.initPropertyInteger(KEY_LOG_LEVEL, 10);
        this.initPropertyPoint(KEY_WINDOW_POSITION, null);
        this.initPropertyDimension(KEY_WINDOW_SIZE, new Dimension(640, 480));
        this.initPropertyInteger(KEY_SCREEN_RESOLUTION, Environment.screenResolution);
        this.initPropertyBoolean(KEY_HTTP_STRICT, false);
        this.initPropertyInteger(KEY_HTTP_REFERER, 0);
        this.initPropertyString(KEY_HTTP_USERAGENT, Resource.getMessage("kagetaka.useragent", null));
        this.initPropertyString(KEY_HTTP_ACCEPT, "text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2");
        this.initPropertyString(KEY_HTTP_ACCEPTCHARSET, "Shift_JIS,utf-8;q=0.7,*;q=0.7");
        this.initPropertyString(KEY_HTTP_ACCEPTENCODING, "identity");
        this.initPropertyString(KEY_HTTP_ACCEPTLANGUAGE, "ja,en;q=0.5");
        this.initPropertyBoolean(KEY_SHOW_NAVIBAR, true);
        this.initPropertyStrings(KEY_SHOW_NAVIBAR_BUTTONS, new String[]{"back", "forward", "reload", "stop", "address", "go"});
        this.initPropertyBoolean(KEY_SHOW_SEARCHBAR, true);
        this.initPropertyBoolean(KEY_SHOW_LINKBAR, true);
        this.initPropertyStrings(KEY_SHOW_LINKBAR_BUTTONS, new String[]{"home", "bookmark", "ptf"});
        this.initPropertyBoolean(KEY_SHOW_STATUSBAR, true);
        this.initPropertyBoolean(KEY_MOUSE_WHEEL, true);
        this.initPropertyBoolean(KEY_MOUSE_WHEEL_SWAP, true);
        this.initPropertyBoolean(KEY_TOOLTIP_CONTROL_USE, Environment.javaVersion >= 104);
        this.initPropertyInteger(KEY_TOOLTIP_CONTROL_DELAY, 700);
        this.initPropertyInteger(KEY_TOOLTIP_CONTROL_TERM, 5000);
        this.initPropertyBoolean(KEY_TOOLTIP_BROWSER_USE, true);
        this.initPropertyInteger(KEY_TOOLTIP_BROWSER_DELAY, 700);
        this.initPropertyInteger(KEY_TOOLTIP_BROWSER_TERM, 5000);
        this.initPropertyBoolean(KEY_PROXY_USE, false);
        this.initPropertyString(KEY_PROXY_HTTP_HOST, System.getProperty("http.proxyHost"));
        this.initPropertyInteger(KEY_PROXY_HTTP_PORT, Integer.parseInt(System.getProperty("http.proxyPort", "0")));
        this.initPropertyString(KEY_PROXY_HTTPS_HOST, System.getProperty("https.proxyHost"));
        this.initPropertyInteger(KEY_PROXY_HTTPS_PORT, Integer.parseInt(System.getProperty("https.proxyPort", "0")));
        this.initPropertyString(KEY_PROXY_FTP_HOST, System.getProperty("ftp.proxyHost"));
        this.initPropertyInteger(KEY_PROXY_FTP_PORT, Integer.parseInt(System.getProperty("ftp.proxyPort", "0")));
        this.initPropertyString(KEY_PROXY_SOCKS_HOST, System.getProperty("socksProxyHost"));
        this.initPropertyInteger(KEY_PROXY_SOCKS_PORT, Integer.parseInt(System.getProperty("socksProxyPort", "0")));
        this.initPropertyString(KEY_PROXY_DIRECT, System.getProperty("http.nonProxyHosts"));
        this.loadProxy(this);
    }

    private void initializeApp() {
        this.initPropertyStrings(KEY_APP_LIST, null);
        if (this.containsPropertyKey(KEY_APP_LIST)) {
            String[] list = this.getPropertyStrings(KEY_APP_LIST);
            if (list != null) {
                for (int i = 0; i < list.length; ++i) {
                    String id = list[i];
                    this.initPropertyString(KEY_APP_NAME[0] + id + KEY_APP_NAME[1], null);
                    this.initPropertyFile(KEY_APP_PATH[0] + id + KEY_APP_PATH[1], null);
                    this.initPropertyString(KEY_APP_OPTION[0] + id + KEY_APP_OPTION[1], null);
                    this.initPropertyBoolean(KEY_APP_ONLINE[0] + id + KEY_APP_ONLINE[1], null);
                }
            } else if (Environment.isWindows) {
                this.properties.put(KEY_APP_LIST, "ie");
                this.initPropertyString(KEY_APP_NAME[0] + "ie" + KEY_APP_NAME[1], "Internet Explorer");
                this.initPropertyFile(KEY_APP_PATH[0] + "ie" + KEY_APP_PATH[1], new File(DEFAULT_IE_PATH));
                this.initPropertyString(KEY_APP_OPTION[0] + "ie" + KEY_APP_OPTION[1], "");
                this.initPropertyBoolean(KEY_APP_ONLINE[0] + "ie" + KEY_APP_ONLINE[1], true);
            } else {
                this.properties.put(KEY_APP_LIST, "mozilla");
                this.initPropertyString(KEY_APP_NAME[0] + "mozilla" + KEY_APP_NAME[1], "Mozilla");
                this.initPropertyFile(KEY_APP_PATH[0] + "mozilla" + KEY_APP_PATH[1], new File(DEFAULT_MOZILLA_PATH));
                this.initPropertyString(KEY_APP_OPTION[0] + "mozilla" + KEY_APP_OPTION[1], "");
                this.initPropertyBoolean(KEY_APP_ONLINE[0] + "mozilla" + KEY_APP_ONLINE[1], true);
            }
        }
        this.loadApplications(this);
    }

    private void initializeHistory() {
        this.initPropertyFile(KEY_HISTORY_PATH, new File(userHome, DEFAULT_HISTORY_PATH));
        this.initPropertyInteger(KEY_HISTORY_SAVE_NUM, 500);
        this.initPropertyPoint(KEY_HISTORY_WINDOW_POSITION, null);
        this.initPropertyDimension(KEY_HISTORY_WINDOW_SIZE, new Dimension(360, 300));
    }

    private void initializeBookmarks() {
        this.initPropertyFile(KEY_BOOKMARKS_PATH, new File(userHome, DEFAULT_BOOKMARKS_PATH));
        this.initPropertyPoint(KEY_BOOKMARKS_WINDOW_POSITION, null);
        this.initPropertyDimension(KEY_BOOKMARKS_WINDOW_SIZE, new Dimension(380, 250));
    }

    private void initializeCookie() {
        this.initPropertyFile(KEY_COOKIE_PATH, new File(userHome, DEFAULT_COOKIE_PATH));
        this.initPropertyBoolean(KEY_COOKIE_SAVE, true);
        this.initPropertyBoolean(KEY_COOKIE_ACCEPT_STRICT, false);
        this.initPropertyString(KEY_COOKIE_ACCEPT_SESSION, "yes");
        this.initPropertyString(KEY_COOKIE_ACCEPT_STRAGE, "yes");
        this.initPropertyPoint(KEY_COOKIE_WINDOW_POSITION, null);
        this.initPropertyDimension(KEY_COOKIE_WINDOW_SIZE, new Dimension(360, 300));
    }

    private void initializeDownload() {
        this.initPropertyPoint(KEY_DOWNLOAD_WINDOW_POSITION, null);
        this.initPropertyBoolean(KEY_DOWNLOAD_WINDOW_CLOSE, true);
        this.initPropertyFile(KEY_DOWNLOAD_SAVE_PATH, null);
    }

    private void initializeTheme() {
        this.initPropertyFile(KEY_USER_THEMES_PATH, new File(userHome, "themes"));
        this.initPropertyFile(KEY_SYSTEM_THEMES_PATH, new File(kagetakaHome, "themes"));
        this.initPropertyString(KEY_THEME_KEY, "system");
    }

    public ViewerOption() {
        this(defaultSystemOptionPath, defaultUserOptionPath);
    }

    public ViewerOption(String system, String user) {
        this(system != null ? new File(system) : null, user != null ? new File(user) : null);
    }

    public ViewerOption(File system, File user) {
        this.defaultProperties = new Hashtable();
        try {
            if (system != null) {
                this.systemProperties = new ExProperties(system);
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
        try {
            this.userProperties = new ExProperties(this.systemProperties, user, true);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
        this.addListener(new DefaultOptionListener());
        this.initializeBasic();
        this.initializeBrowser();
        this.initializeApp();
        this.initializeHistory();
        this.initializeBookmarks();
        this.initializeCookie();
        this.initializeDownload();
        this.initializeTheme();
        this.historyManager = new HistoryManager(this);
        this.bookmarkManager = new BookmarkManager(this);
        this.cookieManager = new CookieManager(this);
        this.themeManager = new ThemeManager(this);
        this.viewerConsole = new ViewerConsole(this);
        if (this.getPropertyBoolean(KEY_TOOLTIP_CONTROL_USE).booleanValue()) {
            this.toolTip = new ToolTip(this.getPropertyInteger(KEY_TOOLTIP_CONTROL_DELAY).intValue(), this.getPropertyInteger(KEY_TOOLTIP_CONTROL_TERM).intValue());
        }
        if (this.listeners.size() > 0) {
            ViewerController controller = new ViewerController();
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((OptionListener)this.listeners.elementAt(i)).propertiesChanged(this, controller, this.properties.keys());
            }
        }
    }

    public synchronized void save() {
        if (this.userProperties == null) {
            return;
        }
        Enumeration e = this.properties.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = this.properties.get(key);
            Object def = this.defaultProperties.get(key);
            if (def == null || !def.equals(value) || ((Hashtable)this.userProperties).containsKey(key)) {
                this.userProperties.put(key, value);
                continue;
            }
            ((Hashtable)this.userProperties).remove(key);
        }
        try {
            this.userProperties.save(this.defaultList);
        }
        catch (IOException e2) {
            e2.printStackTrace(System.out);
        }
        this.historyManager.save();
        this.bookmarkManager.save();
        this.cookieManager.save();
    }

    private void loadApplications(ViewerOption option) {
        Vector<Application> v = new Vector<Application>();
        String[] list = option.getPropertyStrings(KEY_APP_LIST);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                String id = list[i];
                String name = option.getPropertyString(KEY_APP_NAME[0] + id + KEY_APP_NAME[1]);
                File path = option.getPropertyFile(KEY_APP_PATH[0] + id + KEY_APP_PATH[1]);
                if (name == null || name.length() == 0 || path == null || path.length() == 0L) continue;
                v.addElement(new Application(id, name, path, option.getPropertyString(KEY_APP_OPTION[0] + id + KEY_APP_OPTION[1]), option.getPropertyBoolean(KEY_APP_ONLINE[0] + id + KEY_APP_ONLINE[1], false)));
            }
        }
        this.applications = new Application[v.size()];
        v.copyInto(this.applications);
    }

    private void loadProxy(ViewerOption option) {
        Boolean b = option.getPropertyBoolean(KEY_PROXY_USE);
        if (b != null && b.booleanValue()) {
            String socks;
            this.proxies = new Proxy[]{new Proxy("http", option.getPropertyString(KEY_PROXY_HTTP_HOST), option.getPropertyInteger(KEY_PROXY_HTTP_PORT, 0)), new Proxy("http", option.getPropertyString(KEY_PROXY_HTTPS_HOST), option.getPropertyInteger(KEY_PROXY_HTTPS_PORT, 0)), new Proxy("http", option.getPropertyString(KEY_PROXY_FTP_HOST), option.getPropertyInteger(KEY_PROXY_FTP_PORT, 0))};
            String direct = option.getPropertyString(KEY_PROXY_DIRECT);
            if (direct != null) {
                StringTokenizer st = new StringTokenizer(direct, " ,|");
                Vector<Node> v = new Vector<Node>();
                while (st.hasMoreTokens()) {
                    v.addElement(new Node(st.nextToken().toLowerCase()));
                }
                this.proxyDirectNodes = new Node[v.size()];
                v.copyInto(this.proxyDirectNodes);
            }
            if (this.proxyUseSocks = (socks = option.getPropertyString(KEY_PROXY_SOCKS_HOST)) != null && socks.length() > 0) {
                this.putSystemProperty("socksProxyHost", socks);
                this.putSystemProperty("socksProxyPort", option.getPropertyInteger(KEY_PROXY_SOCKS_PORT));
            } else {
                this.putSystemProperty("socksProxyHost", (String)null);
                this.putSystemProperty("socksProxyPort", (Integer)null);
            }
        } else {
            this.proxies = null;
            this.proxyDirectNodes = null;
            this.proxyUseSocks = false;
            this.putSystemProperty("socksProxyHost", (String)null);
            this.putSystemProperty("socksProxyPort", (Integer)null);
        }
    }

    private void putSystemProperty(String key, Integer value) {
        this.putSystemProperty(key, value != null ? value.toString() : null);
    }

    private void putSystemProperty(String key, String value) {
        if (value != null) {
            ((Hashtable)System.getProperties()).put(key, value);
        } else {
            ((Hashtable)System.getProperties()).remove(key);
        }
    }

    public void addListener(OptionListener l) {
        this.listeners.addElement(l);
    }

    public void removeListener(OptionListener l) {
        this.listeners.removeElement(l);
    }

    public Setter getSetter() {
        return new Setter(this);
    }

    public void initPropertyBoolean(String key, boolean value) {
        this.setDefault(key, new Boolean(value), 1);
    }

    public void initPropertyInteger(String key, int value) {
        this.setDefault(key, new Integer(value), 2);
    }

    public void initPropertyDouble(String key, double value) {
        this.setDefault(key, new Double(value), 3);
    }

    public void initPropertyBoolean(String key, Boolean value) {
        this.setDefault(key, value, 1);
    }

    public void initPropertyInteger(String key, Integer value) {
        this.setDefault(key, value, 2);
    }

    public void initPropertyDouble(String key, Double value) {
        this.setDefault(key, value, 3);
    }

    public void initPropertyString(String key, String value) {
        this.setDefault(key, value, 4);
    }

    public void initPropertyStrings(String key, String[] values) {
        this.setDefault(key, values, 5);
    }

    public void initPropertyDimension(String key, Dimension value) {
        this.setDefault(key, value, 6);
    }

    public void initPropertyFont(String key, Font value) {
        this.setDefault(key, value, 7);
    }

    public void initPropertyPoint(String key, Point value) {
        this.setDefault(key, value, 8);
    }

    public void initPropertyFile(String key, File value) {
        this.setDefault(key, value, 9);
    }

    public void initPropertyCharList(String key, CharList value) {
        this.setDefault(key, value, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setDefault(String key, Object defValue, int type) {
        Object o = null;
        Hashtable hashtable = this.defaultKey;
        synchronized (hashtable) {
            if (this.defaultKey.containsKey(key)) {
                return;
            }
            this.defaultKey.put(key, key);
            this.defaultList.addElement(key);
        }
        switch (type) {
            case 1: {
                this.defaultTypes.put(key, OBJECT_BOOLEAN);
                break;
            }
            case 2: {
                this.defaultTypes.put(key, OBJECT_INT);
                break;
            }
            case 3: {
                this.defaultTypes.put(key, OBJECT_DOUBLE);
                break;
            }
            case 4: {
                this.defaultTypes.put(key, OBJECT_STRING);
                break;
            }
            case 5: {
                this.defaultTypes.put(key, OBJECT_STRINGS);
                break;
            }
            case 6: {
                this.defaultTypes.put(key, OBJECT_DIMENSION);
                break;
            }
            case 7: {
                this.defaultTypes.put(key, OBJECT_FONT);
                break;
            }
            case 8: {
                this.defaultTypes.put(key, OBJECT_POINT);
                break;
            }
            case 9: {
                this.defaultTypes.put(key, OBJECT_FILE);
                break;
            }
            case 10: {
                this.defaultTypes.put(key, OBJECT_CHARLIST);
            }
        }
        if (this.systemProperties != null && ((Hashtable)this.systemProperties).containsKey(key)) {
            switch (type) {
                case 1: {
                    o = this.systemProperties.getPropertyBoolean(key);
                    break;
                }
                case 2: {
                    o = this.systemProperties.getPropertyInteger(key);
                    break;
                }
                case 3: {
                    o = this.systemProperties.getPropertyDouble(key);
                    break;
                }
                case 4: {
                    o = this.systemProperties.getPropertyString(key);
                    break;
                }
                case 5: {
                    o = this.systemProperties.getPropertyStrings(key);
                    break;
                }
                case 6: {
                    o = this.systemProperties.getPropertyDimension(key);
                    break;
                }
                case 7: {
                    o = this.systemProperties.getPropertyFont(key);
                    break;
                }
                case 8: {
                    o = this.systemProperties.getPropertyPoint(key);
                    break;
                }
                case 9: {
                    o = this.systemProperties.getPropertyFile(key);
                    break;
                }
                case 10: {
                    o = this.systemProperties.getPropertyCharList(key);
                }
            }
            if (o != null) {
                defValue = o;
            }
        }
        if (defValue != null) {
            this.defaultProperties.put(key, defValue);
        }
        if (this.userProperties != null && ((Hashtable)this.userProperties).containsKey(key)) {
            switch (type) {
                case 1: {
                    o = this.userProperties.getPropertyBoolean(key);
                    break;
                }
                case 2: {
                    o = this.userProperties.getPropertyInteger(key);
                    break;
                }
                case 3: {
                    o = this.userProperties.getPropertyDouble(key);
                    break;
                }
                case 4: {
                    o = this.userProperties.getPropertyString(key);
                    break;
                }
                case 5: {
                    o = this.userProperties.getPropertyStrings(key);
                    break;
                }
                case 6: {
                    o = this.userProperties.getPropertyDimension(key);
                    break;
                }
                case 7: {
                    o = this.userProperties.getPropertyFont(key);
                    break;
                }
                case 8: {
                    o = this.userProperties.getPropertyPoint(key);
                    break;
                }
                case 9: {
                    o = this.userProperties.getPropertyFile(key);
                    break;
                }
                case 10: {
                    o = this.userProperties.getPropertyCharList(key);
                }
            }
            if (o != null) {
                defValue = o;
            }
        }
        if (defValue != null) {
            this.properties.put(key, defValue);
        }
    }

    public Boolean getPropertyBoolean(String key) {
        return (Boolean)this.properties.get(key);
    }

    public boolean getPropertyBoolean(String key, boolean defval) {
        Boolean value = (Boolean)this.properties.get(key);
        return value != null ? value : defval;
    }

    public Integer getPropertyInteger(String key) {
        return (Integer)this.properties.get(key);
    }

    public int getPropertyInteger(String key, int defval) {
        Integer value = (Integer)this.properties.get(key);
        return value != null ? value : defval;
    }

    public Double getPropertyDouble(String key) {
        return (Double)this.properties.get(key);
    }

    public double getPropertyDouble(String key, double defval) {
        Double value = (Double)this.properties.get(key);
        return value != null ? value : defval;
    }

    public String getPropertyString(String key) {
        return (String)this.properties.get(key);
    }

    public String getPropertyString(String key, String defval) {
        String value = (String)this.properties.get(key);
        return value != null ? value : defval;
    }

    public String[] getPropertyStrings(String key) {
        return (String[])this.properties.get(key);
    }

    public String[] getPropertyStrings(String key, String[] defval) {
        String[] value = (String[])this.properties.get(key);
        return value != null ? value : defval;
    }

    public Dimension getPropertyDimension(String key) {
        return (Dimension)this.properties.get(key);
    }

    public Dimension getPropertyDimension(String key, Dimension defval) {
        Dimension value = (Dimension)this.properties.get(key);
        return value != null ? value : defval;
    }

    public Font getPropertyFont(String key) {
        return (Font)this.properties.get(key);
    }

    public Font getPropertyFont(String key, Font defval) {
        Font value = (Font)this.properties.get(key);
        return value != null ? value : defval;
    }

    public Point getPropertyPoint(String key) {
        return (Point)this.properties.get(key);
    }

    public Point getPropertyPoint(String key, Point defval) {
        Point value = (Point)this.properties.get(key);
        return value != null ? value : defval;
    }

    public File getPropertyFile(String key) {
        return (File)this.properties.get(key);
    }

    public File getPropertyFile(String key, File defval) {
        File value = (File)this.properties.get(key);
        return value != null ? value : defval;
    }

    public CharList getPropertyCharList(String key) {
        return (CharList)this.properties.get(key);
    }

    public CharList getPropertyCharList(String key, CharList defval) {
        CharList value = (CharList)this.properties.get(key);
        return value != null ? value : defval;
    }

    Object getPropertyObject(String key) {
        return this.properties.get(key);
    }

    public boolean containsPropertyKey(String key) {
        return this.properties.containsKey(key);
    }

    public int getPropertyType(String key) {
        Integer i = (Integer)this.defaultTypes.get(key);
        if (i == null) {
            return -1;
        }
        return i;
    }

    public void setInputStreamParser(String value) {
        this.properties.put(KEY_PARSER_INPUT, value);
        super.setInputStreamParser(value);
    }

    public void setFilterParsers(String[] value) {
        this.properties.put(KEY_PARSER_FILTERS, value);
        super.setFilterParsers(value);
    }

    public void setDefaultFont(Font value) {
        this.properties.put(KEY_FONT_DEFAULT, value);
        super.setDefaultFont(value);
    }

    public void setDefaultFixedFont(Font value) {
        this.properties.put(KEY_FONT_FIXED, value);
        super.setDefaultFixedFont(value);
    }

    public void setFontPerPixel(double value) {
        this.properties.put(KEY_FONT_PERPIXEL, new Double(value));
        super.setFontPerPixel(value);
    }

    public void setCharsSpinRight(CharList value) {
        this.properties.put(KEY_CHARS_SPIN_RIGHT, value);
        super.setCharsSpinRight(value);
    }

    public void setCharsSpinLtrb(CharList value) {
        this.properties.put(KEY_CHARS_SPIN_LTRB, value);
        super.setCharsSpinLtrb(value);
    }

    public void setCharsKinsokuHead(CharList value) {
        this.properties.put(KEY_CHARS_KINSOKU_HEAD, value);
        super.setCharsKinsokuHead(value);
    }

    public void setCharsKinsokuTail(CharList value) {
        this.properties.put(KEY_CHARS_KINSOKU_TAIL, value);
        super.setCharsKinsokuTail(value);
    }

    public void setLoadImage(boolean value) {
        this.properties.put(KEY_LOAD_IMAGE, new Boolean(value));
        super.setLoadImage(value);
    }

    public void setShowScrollbar(boolean value) {
        this.properties.put(KEY_SHOW_SCROLLBAR, new Boolean(value));
        super.setShowScrollbar(value);
    }

    public void setSpinGifImage(boolean value) {
        this.properties.put(KEY_SPIN_IMAGE_GIF, new Boolean(value));
        super.setSpinGifImage(value);
    }

    public void setSpinGifAspectRatio(double value) {
        this.properties.put(KEY_SPIN_IMAGE_GIF_ASPECTRATIO, new Double(value));
        super.setSpinGifAspectRatio(value);
    }

    public void setSpinGifMinWidth(int value) {
        this.properties.put(KEY_SPIN_IMAGE_GIF_MINWIDTH, new Integer(value));
        super.setSpinGifMinWidth(value);
    }

    public void setSpinJpegImage(boolean value) {
        this.properties.put(KEY_SPIN_IMAGE_JPEG, new Boolean(value));
        super.setSpinJpegImage(value);
    }

    public void setSpinJpegAspectRatio(double value) {
        this.properties.put(KEY_SPIN_IMAGE_JPEG_ASPECTRATIO, new Double(value));
        super.setSpinJpegAspectRatio(value);
    }

    public void setSpinJpegMinWidth(int value) {
        this.properties.put(KEY_SPIN_IMAGE_JPEG_MINWIDTH, new Integer(value));
        super.setSpinJpegMinWidth(value);
    }

    public void setSwapDecoration(boolean value) {
        this.properties.put(KEY_STYLE_DECORATION_SWAP, new Boolean(value));
        super.setSwapDecoration(value);
    }

    public HistoryManager getHistoryManager() {
        return this.historyManager;
    }

    public BookmarkManager getBookmarkManager() {
        return this.bookmarkManager;
    }

    public CookieManager getCookieManager() {
        return this.cookieManager;
    }

    public ThemeManager getThemeManager() {
        return this.themeManager;
    }

    public ViewerConsole getViewerConsole() {
        return this.viewerConsole;
    }

    public ToolTip getToolTip() {
        return this.toolTip;
    }

    public URL getProxyURL(URL url) {
        String protocol;
        if (this.proxyUseSocks) {
            return null;
        }
        Proxy[] proxies = this.proxies;
        if (proxies == null) {
            return null;
        }
        Node[] nodes = this.proxyDirectNodes;
        if (nodes != null) {
            String host = url.getHost().toLowerCase();
            for (int i = 0; i < nodes.length; ++i) {
                if (!nodes[i].isMatch(host)) continue;
                return null;
            }
        }
        if ((protocol = url.getProtocol()).compareTo("http") == 0) {
            return proxies[0].url;
        }
        if (protocol.compareTo("https") == 0) {
            return proxies[1].url;
        }
        if (protocol.compareTo("ftp") == 0) {
            return proxies[2].url;
        }
        return null;
    }

    public Application[] getApplications() {
        return this.applications;
    }

    public void showManager(Frame owner) {
        OptionDialog.show(owner, this);
    }

    public File convertCanonicalToRelative(File path) {
        return this.userProperties.convertCanonicalToRelative(path);
    }

    public File convertRelativeToCanonical(File path) {
        return this.userProperties.convertRelativeToCanonical(path);
    }

    static {
        Protocol.initialize();
        HttpURLConnection.setFollowRedirects(false);
        OBJECT_BOOLEAN = new Integer(1);
        OBJECT_INT = new Integer(2);
        OBJECT_DOUBLE = new Integer(3);
        OBJECT_STRING = new Integer(4);
        OBJECT_STRINGS = new Integer(5);
        OBJECT_DIMENSION = new Integer(6);
        OBJECT_FONT = new Integer(7);
        OBJECT_POINT = new Integer(8);
        OBJECT_FILE = new Integer(9);
        OBJECT_CHARLIST = new Integer(10);
        String sep = File.separator;
        String s = null;
        s = System.getProperty("kagetaka.home");
        if (s == null) {
            s = System.getProperty("user.dir");
            s = s != null ? s + sep + ".." : "..";
        }
        kagetakaHome = s;
        userHome = System.getProperty("user.home", ".") + sep + ".kagetaka";
        s = System.getProperty("kagetaka.config");
        if (s == null) {
            s = kagetakaHome + sep + "etc" + sep + "options";
        }
        defaultSystemOptionPath = s;
        defaultUserOptionPath = userHome + sep + "options";
        KEY_APP_NAME = new String[]{KEY_APP, ".name"};
        KEY_APP_PATH = new String[]{KEY_APP, ".path"};
        KEY_APP_OPTION = new String[]{KEY_APP, ".option"};
        KEY_APP_ONLINE = new String[]{KEY_APP, ".online"};
    }

    public static class Application {
        private String id;
        private String name;
        private File path;
        private String option;
        private boolean online;

        public Application(String id, String name, File path, String option, boolean online) {
            this.id = id;
            this.name = name;
            this.path = path;
            this.option = option;
            this.online = online;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public File getPath() {
            return this.path;
        }

        public String getOption() {
            return this.option;
        }

        public String getOption(String arg) {
            if (this.option == null || this.option.length() == 0) {
                return arg;
            }
            int p = this.option.indexOf("%s");
            if (p != -1) {
                return this.option;
            }
            return this.option.substring(0, p) + arg + this.option.substring(p + 2);
        }

        public boolean getOnline() {
            return this.online;
        }

        public Process exec(URL url, StringBuffer exec) throws IOException {
            String option = this.getOption(url.toString());
            String command = this.path.getPath() + " " + option;
            if (exec != null) {
                exec.append(command);
            }
            return Runtime.getRuntime().exec(command);
        }
    }

    private static class Node {
        private static final int EXACT = 0;
        private static final int SUFFIX = 1;
        private static final int PREFIX = 2;
        private int mode;
        private String regexp;

        private Node(String name) {
            int length = name.length();
            if (name.charAt(0) == '*') {
                this.mode = 1;
                this.regexp = name.substring(1, length);
            } else if (name.charAt(length - 1) == '*') {
                this.mode = 2;
                this.regexp = name.substring(0, length - 1);
            } else {
                this.mode = 0;
                this.regexp = name;
            }
        }

        private boolean isMatch(String host) {
            switch (this.mode) {
                case 0: {
                    return host.compareTo(this.regexp) == 0;
                }
                case 1: {
                    return host.endsWith(this.regexp);
                }
                case 2: {
                    return host.startsWith(this.regexp);
                }
            }
            return false;
        }
    }

    private static class Proxy {
        private URL url;

        private Proxy(String protocol, String host, int port) {
            try {
                this.url = new URL(protocol, host, port, "");
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
    }

    private class DefaultOptionListener
    implements OptionListener {
        private DefaultOptionListener() {
        }

        public void propertyChange(ViewerOption option, String key, Object oldValue, Object newValue) throws InvalidValueException {
        }

        public void propertiesChanged(ViewerOption option, ViewerController c, Enumeration list) {
            boolean loadApplications = false;
            boolean loadProxy = false;
            while (list.hasMoreElements()) {
                String key = (String)list.nextElement();
                if (!loadApplications && key.startsWith(ViewerOption.KEY_APP)) {
                    ViewerOption.this.loadApplications(option);
                    loadApplications = true;
                    continue;
                }
                if (!loadProxy && key.startsWith(ViewerOption.KEY_PROXY)) {
                    ViewerOption.this.loadProxy(option);
                    loadProxy = true;
                    continue;
                }
                if (key.compareTo(ViewerOption.KEY_PARSER_INPUT) == 0) {
                    ViewerOption.super.setInputStreamParser(option.getPropertyString(ViewerOption.KEY_PARSER_INPUT, null));
                    continue;
                }
                if (key.compareTo(ViewerOption.KEY_PARSER_FILTERS) == 0) {
                    ViewerOption.super.setFilterParsers(option.getPropertyStrings(ViewerOption.KEY_PARSER_FILTERS, null));
                    continue;
                }
                if (key.compareTo(ViewerOption.KEY_FONT_DEFAULT) == 0) {
                    ViewerOption.super.setDefaultFont(option.getPropertyFont(ViewerOption.KEY_FONT_DEFAULT, null));
                    continue;
                }
                if (key.compareTo(ViewerOption.KEY_FONT_FIXED) == 0) {
                    ViewerOption.super.setDefaultFixedFont(option.getPropertyFont(ViewerOption.KEY_FONT_FIXED, null));
                    continue;
                }
                if (key.compareTo(ViewerOption.KEY_FONT_PERPIXEL) == 0) {
                    ViewerOption.super.setFontPerPixel(option.getPropertyDouble(ViewerOption.KEY_FONT_PERPIXEL, 0.0));
                    continue;
                }
                if (key.compareTo(ViewerOption.KEY_CHARS_SPIN_RIGHT) == 0) {
                    ViewerOption.super.setCharsSpinRight(option.getPropertyCharList(ViewerOption.KEY_CHARS_SPIN_RIGHT, null));
                    continue;
                }
                if (key.compareTo(ViewerOption.KEY_CHARS_SPIN_LTRB) == 0) {
                    ViewerOption.super.setCharsSpinLtrb(option.getPropertyCharList(ViewerOption.KEY_CHARS_SPIN_LTRB, null));
                    continue;
                }
                if (key.compareTo(ViewerOption.KEY_CHARS_KINSOKU_HEAD) == 0) {
                    ViewerOption.super.setCharsKinsokuHead(option.getPropertyCharList(ViewerOption.KEY_CHARS_KINSOKU_HEAD, null));
                    continue;
                }
                if (key.compareTo(ViewerOption.KEY_CHARS_KINSOKU_TAIL) == 0) {
                    ViewerOption.super.setCharsKinsokuTail(option.getPropertyCharList(ViewerOption.KEY_CHARS_KINSOKU_TAIL, null));
                    continue;
                }
                if (key.compareTo(ViewerOption.KEY_LOAD_IMAGE) == 0) {
                    ViewerOption.super.setLoadImage(option.getPropertyBoolean(ViewerOption.KEY_LOAD_IMAGE, true));
                    continue;
                }
                if (key.compareTo(ViewerOption.KEY_SHOW_SCROLLBAR) == 0) {
                    ViewerOption.super.setShowScrollbar(option.getPropertyBoolean(ViewerOption.KEY_SHOW_SCROLLBAR, true));
                    continue;
                }
                if (key.compareTo(ViewerOption.KEY_SPIN_IMAGE_GIF) == 0) {
                    ViewerOption.super.setSpinGifImage(option.getPropertyBoolean(ViewerOption.KEY_SPIN_IMAGE_GIF, true));
                    continue;
                }
                if (key.compareTo(ViewerOption.KEY_SPIN_IMAGE_GIF_ASPECTRATIO) == 0) {
                    ViewerOption.super.setSpinGifAspectRatio(option.getPropertyDouble(ViewerOption.KEY_SPIN_IMAGE_GIF_ASPECTRATIO, 0.0));
                    continue;
                }
                if (key.compareTo(ViewerOption.KEY_SPIN_IMAGE_GIF_MINWIDTH) == 0) {
                    ViewerOption.super.setSpinGifMinWidth(option.getPropertyInteger(ViewerOption.KEY_SPIN_IMAGE_GIF_MINWIDTH, 0));
                    continue;
                }
                if (key.compareTo(ViewerOption.KEY_SPIN_IMAGE_JPEG) == 0) {
                    ViewerOption.super.setSpinJpegImage(option.getPropertyBoolean(ViewerOption.KEY_SPIN_IMAGE_JPEG, true));
                    continue;
                }
                if (key.compareTo(ViewerOption.KEY_SPIN_IMAGE_JPEG_ASPECTRATIO) == 0) {
                    ViewerOption.super.setSpinJpegAspectRatio(option.getPropertyDouble(ViewerOption.KEY_SPIN_IMAGE_JPEG_ASPECTRATIO, 0.0));
                    continue;
                }
                if (key.compareTo(ViewerOption.KEY_SPIN_IMAGE_JPEG_MINWIDTH) == 0) {
                    ViewerOption.super.setSpinJpegMinWidth(option.getPropertyInteger(ViewerOption.KEY_SPIN_IMAGE_JPEG_MINWIDTH, 0));
                    continue;
                }
                if (key.compareTo(ViewerOption.KEY_STYLE_DECORATION_SWAP) != 0) continue;
                ViewerOption.super.setSwapDecoration(option.getPropertyBoolean(ViewerOption.KEY_STYLE_DECORATION_SWAP, true));
            }
        }
    }
}

