/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.option;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.hizlab.kagetaka.option.ExProperties;
import net.hizlab.kagetaka.option.InvalidValueException;
import net.hizlab.kagetaka.option.OptionListener;
import net.hizlab.kagetaka.option.ViewerController;
import net.hizlab.kagetaka.option.ViewerOption;
import net.hizlab.kagetaka.util.CharList;

public class Setter {
    private ViewerOption option;
    private Hashtable oldProperties;
    private Hashtable newProperties = new Hashtable();
    private Hashtable removeProperties;
    private Hashtable defaultKey;
    private Vector defaultList;
    private Hashtable defaultProperties;
    private ExProperties userProperties;
    private OptionListener[] listeners;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Setter(ViewerOption option) {
        this.option = option;
        this.oldProperties = option.properties;
        this.defaultKey = option.defaultKey;
        this.defaultList = option.defaultList;
        this.defaultProperties = option.defaultProperties;
        this.userProperties = option.userProperties;
        this.listeners = null;
        Vector vector = option.listeners;
        synchronized (vector) {
            if (option.listeners.size() > 0) {
                this.listeners = new OptionListener[option.listeners.size()];
                option.listeners.copyInto(this.listeners);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit() {
        Hashtable hashtable = this.oldProperties;
        synchronized (hashtable) {
            Enumeration e = this.newProperties.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                this.oldProperties.put(key, this.newProperties.get(key));
            }
        }
        if (this.listeners != null) {
            ViewerController controller = new ViewerController();
            for (int i = 0; i < this.listeners.length; ++i) {
                this.listeners[i].propertiesChanged(this.option, controller, this.newProperties.keys());
            }
        }
    }

    public synchronized void rollback() {
        this.newProperties.clear();
        if (this.removeProperties != null) {
            this.removeProperties.clear();
        }
    }

    public Boolean putPropertyBoolean(String key, boolean value) throws InvalidValueException {
        return (Boolean)this.putProperty(key, new Boolean(value), true);
    }

    public Integer putPropertyInteger(String key, int value) throws InvalidValueException {
        return (Integer)this.putProperty(key, new Integer(value), true);
    }

    public Double putPropertyDouble(String key, double value) throws InvalidValueException {
        return (Double)this.putProperty(key, new Double(value), true);
    }

    public Boolean putPropertyBoolean(String key, Boolean value) throws InvalidValueException {
        return (Boolean)this.putProperty(key, value, true);
    }

    public Integer putPropertyInteger(String key, Integer value) throws InvalidValueException {
        return (Integer)this.putProperty(key, value, true);
    }

    public Double putPropertyDouble(String key, Double value) throws InvalidValueException {
        return (Double)this.putProperty(key, value, true);
    }

    public String putPropertyString(String key, String value) throws InvalidValueException {
        return (String)this.putProperty(key, value, true);
    }

    public String[] putPropertyStrings(String key, String[] value) throws InvalidValueException {
        return (String[])this.putProperty(key, value, true);
    }

    public Dimension putPropertyDimension(String key, Dimension value) throws InvalidValueException {
        return (Dimension)this.putProperty(key, value, true);
    }

    public Font putPropertyFont(String key, Font value) throws InvalidValueException {
        return (Font)this.putProperty(key, value, true);
    }

    public Point putPropertyPoint(String key, Point value) throws InvalidValueException {
        return (Point)this.putProperty(key, value, true);
    }

    public File putPropertyFile(String key, File value) throws InvalidValueException {
        if (this.userProperties != null && value != null) {
            value = this.userProperties.convertRelativeToCanonical(value);
        }
        return (File)this.putProperty(key, value, true);
    }

    public CharList putPropertyCharList(String key, CharList value) throws InvalidValueException {
        return (CharList)this.putProperty(key, value, true);
    }

    public Object removeProperty(String key) {
        try {
            return this.putProperty(key, this.defaultProperties.get(key), false);
        }
        catch (InvalidValueException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Object putProperty(String key, Object newValue, boolean event) throws InvalidValueException {
        Object oldValue = null;
        if (!(this.removeProperties != null && this.removeProperties.containsKey(key) || (oldValue = this.newProperties.get(key)) != null)) {
            oldValue = this.oldProperties.get(key);
        }
        if (event && this.listeners != null) {
            try {
                for (int i = 0; i < this.listeners.length; ++i) {
                    this.listeners[i].propertyChange(this.option, key, oldValue, newValue);
                }
            }
            catch (InvalidValueException e) {
                System.out.println(e);
                if (!e.hasNewValue()) {
                    this.rollback();
                    throw e;
                }
                newValue = e.getNewValue();
            }
        }
        if (newValue != null) {
            this.newProperties.put(key, newValue);
            if (this.removeProperties != null) {
                this.removeProperties.remove(key);
            }
            Hashtable hashtable = this.defaultKey;
            synchronized (hashtable) {
                if (!this.defaultKey.containsKey(key)) {
                    this.defaultKey.put(key, key);
                    this.defaultList.addElement(key);
                }
            }
        } else {
            this.newProperties.remove(key);
            if (this.removeProperties == null) {
                this.removeProperties = new Hashtable();
            }
            this.removeProperties.put(key, key);
        }
        return oldValue;
    }
}

