/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.option;

import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.TextField;
import java.io.File;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.BorderContainer;
import net.hizlab.kagetaka.awt.BrowseButton;
import net.hizlab.kagetaka.awt.LayoutUtils;
import net.hizlab.kagetaka.awt.QuietPanel;
import net.hizlab.kagetaka.awt.ToolTip;
import net.hizlab.kagetaka.awt.TreeItem;
import net.hizlab.kagetaka.awt.event.KeyFilter;
import net.hizlab.kagetaka.java2.AWTWrapper;
import net.hizlab.kagetaka.option.AlignPanel;
import net.hizlab.kagetaka.option.ComponentListener;
import net.hizlab.kagetaka.option.OptionComponent;
import net.hizlab.kagetaka.option.Setter;
import net.hizlab.kagetaka.option.ViewerOption;
import net.hizlab.kagetaka.util.CharList;

class OptionPage
implements TreeItem {
    private static final String RESOURCE = "net.hizlab.kagetaka.option.Resource";
    private static final int MARGIN = 3;
    private final ViewerOption viewerOption;
    private final String resourcePath;
    private final Setter setter;
    private ToolTip toolTip;
    final String optionPath;
    final String optionTitle;
    final String[] optionPaths;
    Vector child = new Vector();
    private Vector items = new Vector();
    private MainPanel panel;
    private GridBagLayout gbl;
    private int maxY;

    OptionPage(ViewerOption option, String path, Setter setter) {
        this.viewerOption = option;
        this.resourcePath = path;
        this.setter = setter;
        this.optionPath = this.getResource("kagetaka.option.path");
        if (this.optionPath == null) {
            throw new IllegalArgumentException("kagetaka.option.path not found");
        }
        this.optionTitle = this.getResource("kagetaka.option.title");
        if (this.optionTitle == null) {
            throw new IllegalArgumentException("kagetaka.option.title not found");
        }
        this.toolTip = option.getToolTip();
        StringTokenizer st = new StringTokenizer(this.optionPath, "/");
        Vector<String> v = new Vector<String>();
        while (st.hasMoreTokens()) {
            v.addElement(st.nextToken());
        }
        this.optionPaths = new String[v.size()];
        v.copyInto(this.optionPaths);
        String itemList = this.getResource("kagetaka.option.items");
        if (itemList != null) {
            st = new StringTokenizer(itemList, ",");
            while (st.hasMoreTokens()) {
                String key = st.nextToken().trim();
                try {
                    Item item = new Item(key);
                    this.items.addElement(item);
                    if (item.layoutY <= this.maxY) continue;
                    this.maxY = item.layoutY;
                }
                catch (Exception e) {
                    System.out.println(key + ":" + e);
                    e.printStackTrace(System.out);
                }
                catch (ClassFormatError e) {
                    System.out.println(key + ":" + e);
                    e.printStackTrace(System.out);
                }
            }
        }
        this.gbl = new GridBagLayout();
        this.panel = new MainPanel(this.gbl);
    }

    public Image getTreeIcon(boolean opened) {
        return null;
    }

    public String getTreeLabel() {
        return this.optionTitle;
    }

    public Vector getTreeItems() {
        return this.child;
    }

    void attachContainer(Container container) {
        for (int i = 0; i < this.items.size(); ++i) {
            ((Item)this.items.elementAt(i)).attach(this.panel, this.gbl);
        }
        LayoutUtils.addGridBag(this.panel, new QuietPanel(), this.gbl, 0, this.maxY + 1, 1, 1, 1.0, 1.0, 1, 17, new Insets(0, 0, 0, 0));
        container.add((Component)this.panel, this.optionPath);
    }

    void reload() {
        for (int i = 0; i < this.items.size(); ++i) {
            ((Item)this.items.elementAt(i)).reload();
        }
    }

    void reset() {
        for (int i = 0; i < this.items.size(); ++i) {
            ((Item)this.items.elementAt(i)).reset();
        }
    }

    void dispose() {
        for (int i = 0; i < this.items.size(); ++i) {
            ((Item)this.items.elementAt(i)).dispose();
        }
    }

    private String getResource(String key) {
        String s = Resource.getMessage(this.resourcePath, key, null, null);
        if (s == null) {
            return null;
        }
        return this.getResourceString(s.trim());
    }

    private String getResourceString(String key) {
        if (key.length() > 0 && key.charAt(0) == '@') {
            return this.getMessage(key.substring(1));
        }
        return key;
    }

    private String getMessage(String key) {
        return Resource.getMessage(RESOURCE, key, null);
    }

    private class Item {
        private final String key;
        private final String type;
        private final String title;
        private final String tips;
        private final String option;
        private final int width;
        private final int layoutX;
        private final int layoutY;
        private final int layoutWidth;
        private final int layoutHeight;
        private final double layoutWeightX;
        private final double layoutWeightY;
        private final Component component;
        private final int optionType;
        private final Object optionDefault;
        private KeyFilter filter;
        private OptionComponent optionComponent;

        private Item(String key) throws ClassNotFoundException, InstantiationException, IllegalAccessException, ClassFormatError {
            this.key = key;
            this.type = OptionPage.this.getResource(key + ".type").toLowerCase();
            this.title = OptionPage.this.getResource(key + ".title");
            this.tips = OptionPage.this.getResource(key + ".tips");
            this.option = OptionPage.this.getResource(key + ".option");
            String layout = OptionPage.this.getResource(key + ".layout");
            StringTokenizer st = new StringTokenizer(layout, ",");
            this.layoutX = st.hasMoreTokens() ? Integer.parseInt(st.nextToken().trim()) : 0;
            this.layoutY = st.hasMoreTokens() ? Integer.parseInt(st.nextToken().trim()) : 0;
            this.layoutWidth = st.hasMoreTokens() ? Integer.parseInt(st.nextToken().trim()) : 0;
            this.layoutHeight = st.hasMoreTokens() ? Integer.parseInt(st.nextToken().trim()) : 0;
            this.layoutWeightX = st.hasMoreTokens() ? Double.valueOf(st.nextToken().trim()) : 1.0;
            this.layoutWeightY = st.hasMoreTokens() ? Double.valueOf(st.nextToken().trim()) : 0.0;
            String widthString = OptionPage.this.getResource(key + ".width");
            int n = this.width = widthString != null ? Integer.parseInt(widthString.trim()) : 0;
            if (this.option != null) {
                this.optionType = OptionPage.this.viewerOption.getPropertyType(this.option);
                this.optionDefault = OptionPage.this.viewerOption.getPropertyObject(this.option);
            } else {
                this.optionType = -1;
                this.optionDefault = null;
            }
            if (this.type.compareTo("label") == 0) {
                this.component = new Label(this.title);
            } else if (this.type.compareTo("check") == 0) {
                Checkbox c = new Checkbox(this.title, OptionPage.this.viewerOption.getPropertyBoolean(this.option, false));
                c.addItemListener(new ComponentListener(OptionPage.this.viewerOption, OptionPage.this.setter, this.option, this.optionType));
                this.component = c;
            } else if (this.type.compareTo("text") == 0) {
                String s = "";
                Object ext = null;
                switch (this.optionType) {
                    case 2: {
                        s = String.valueOf(OptionPage.this.viewerOption.getPropertyInteger(this.option, 0));
                        this.filter = new KeyFilter(4);
                        break;
                    }
                    case 3: {
                        s = String.valueOf(OptionPage.this.viewerOption.getPropertyDouble(this.option, 0.0));
                        this.filter = new KeyFilter(7);
                        break;
                    }
                    case 4: {
                        s = OptionPage.this.viewerOption.getPropertyString(this.option);
                        break;
                    }
                    case 5: {
                        String[] list = OptionPage.this.viewerOption.getPropertyStrings(this.option);
                        if (list == null || list.length <= 0) break;
                        StringBuffer sb = new StringBuffer();
                        sb.append(list[0]);
                        for (int i = 1; i < list.length; ++i) {
                            sb.append(", ");
                            sb.append(list[i]);
                        }
                        s = sb.toString();
                        break;
                    }
                    case 10: {
                        CharList cl = OptionPage.this.viewerOption.getPropertyCharList(this.option);
                        if (cl == null) break;
                        s = cl.toString();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid type " + this.type);
                    }
                }
                if (s == null) {
                    s = "";
                }
                TextField c = new TextField(s, this.width);
                if (this.filter != null) {
                    this.filter.attach(c);
                }
                c.addTextListener(new ComponentListener(OptionPage.this.viewerOption, OptionPage.this.setter, this.option, this.optionType));
                this.component = new AlignPanel(new Label(this.title), 0.0, c, this.width > 0 ? 0.5 : 1.0);
            } else if (this.type.compareTo("combo") == 0) {
                int i;
                Vector<String> values = new Vector<String>();
                Choice choice = new Choice();
                String itemList = OptionPage.this.getResource(key + ".items");
                if (itemList != null) {
                    st = new StringTokenizer(itemList, ",");
                    while (st.hasMoreTokens()) {
                        String value = st.nextToken().trim();
                        if (!st.hasMoreTokens()) continue;
                        values.addElement(OptionPage.this.getResourceString(value));
                        choice.add(OptionPage.this.getResourceString(st.nextToken().trim()));
                    }
                }
                String s = null;
                switch (this.optionType) {
                    case 2: {
                        s = String.valueOf(OptionPage.this.viewerOption.getPropertyInteger(this.option, 0));
                        break;
                    }
                    case 3: {
                        s = String.valueOf(OptionPage.this.viewerOption.getPropertyDouble(this.option, 0.0));
                        break;
                    }
                    case 4: {
                        s = OptionPage.this.viewerOption.getPropertyString(this.option);
                    }
                }
                if (s != null && (i = values.indexOf(s)) != -1) {
                    choice.select(i);
                }
                choice.addItemListener(new ComponentListener(OptionPage.this.viewerOption, OptionPage.this.setter, this.option, this.optionType, values));
                AlignPanel c = new AlignPanel(new Label(this.title), 0.0, choice, 0.5);
                this.component = c;
            } else if (this.type.compareTo("font") == 0) {
                Font f = OptionPage.this.viewerOption.getPropertyFont(this.option);
                Choice choice = new Choice();
                TextField text = new TextField(f != null ? String.valueOf(f.getSize()) : "", this.width);
                AWTWrapper awtw = AWTWrapper.getInstance();
                if (awtw != null) {
                    String[] list = awtw.getAvailableFontFamilyNames(Locale.JAPANESE);
                    for (int i = 0; i < list.length; ++i) {
                        choice.add(list[i]);
                    }
                } else {
                    choice.add("SansSerif");
                    choice.add("Serif");
                    choice.add("Monospaced");
                }
                if (f != null) {
                    choice.select(f.getName());
                }
                this.filter = new KeyFilter(4);
                this.filter.attach(text);
                choice.addItemListener(new ComponentListener(OptionPage.this.viewerOption, OptionPage.this.setter, this.option, this.optionType, text));
                text.addTextListener(new ComponentListener(OptionPage.this.viewerOption, OptionPage.this.setter, this.option, this.optionType, choice));
                AlignPanel c = new AlignPanel(new Label(this.title), 0.0, choice, 0.0, text, 0.5);
                this.component = c;
            } else if (this.type.compareTo("file") == 0 || this.type.compareTo("directory") == 0) {
                File f = OptionPage.this.viewerOption.getPropertyFile(this.option);
                TextField c1 = new TextField(f != null ? OptionPage.this.viewerOption.convertCanonicalToRelative(f).getPath() : "", this.width);
                BrowseButton c2 = new BrowseButton(this.type.compareTo("file") == 0 ? 2 : 1, c1);
                c1.addTextListener(new ComponentListener(OptionPage.this.viewerOption, OptionPage.this.setter, this.option, this.optionType));
                c2.setPathAbsoluter(OptionPage.this.viewerOption);
                this.component = new AlignPanel(new Label(this.title), 0.0, c1, this.width > 0 ? 0.5 : 1.0, c2, 0.0);
            } else if (this.type.compareTo("panel") == 0) {
                String subtype = OptionPage.this.getResource(key + ".subtype").toLowerCase();
                BorderContainer c = null;
                if (subtype.compareTo("label") == 0) {
                    c = new BorderContainer(this.title);
                } else if (subtype.compareTo("check") == 0) {
                    Checkbox check = new Checkbox(this.title, OptionPage.this.viewerOption.getPropertyBoolean(this.option, false));
                    check.addItemListener(new ComponentListener(OptionPage.this.viewerOption, OptionPage.this.setter, this.option, this.optionType));
                    c = new BorderContainer(check);
                } else {
                    throw new IllegalArgumentException("invalid subtype " + subtype);
                }
                GridBagLayout gbl = new GridBagLayout();
                c.setLayout(gbl);
                String itemList = OptionPage.this.getResource(key + ".items");
                if (itemList != null) {
                    st = new StringTokenizer(itemList, ",");
                    while (st.hasMoreTokens()) {
                        String subKey = st.nextToken().trim();
                        try {
                            new Item(subKey).attach(c, gbl);
                        }
                        catch (Exception e) {
                            System.out.println(subKey + ":" + e);
                            e.printStackTrace(System.out);
                        }
                    }
                }
                this.component = c;
            } else if (this.type.compareTo("class") == 0) {
                String subtype = OptionPage.this.getResource(key + ".subtype");
                this.optionComponent = (OptionComponent)Class.forName(subtype).newInstance();
                this.optionComponent.initialize(OptionPage.this.viewerOption, OptionPage.this.setter, this.option);
                this.component = this.optionComponent.getComponent();
            } else {
                throw new IllegalArgumentException("invalid type " + this.type);
            }
        }

        private void attach(Container container, GridBagLayout gbl) {
            Insets insets = new Insets(3, 3, 3, 3);
            int w = 0;
            if (this.layoutWeightX > 0.0 && this.layoutWeightY > 0.0) {
                w = 1;
            } else if (this.layoutWeightX > 0.0) {
                w = 2;
            } else if (this.layoutWeightY > 0.0) {
                w = 3;
            }
            LayoutUtils.addGridBag(container, this.component, gbl, this.layoutX, this.layoutY, this.layoutWidth, this.layoutHeight, this.layoutWeightX, this.layoutWeightY, w, 17, insets);
            if (this.tips != null && OptionPage.this.toolTip != null) {
                OptionPage.this.toolTip.attachComponent(this.component, this.tips);
            }
        }

        private void reload() {
        }

        private void reset() {
        }

        private void dispose() {
            if (this.tips != null && OptionPage.this.toolTip != null) {
                OptionPage.this.toolTip.detachComponent(this.component);
            }
            if (this.optionComponent != null) {
                this.optionComponent.dispose();
            }
        }
    }

    private class MainPanel
    extends QuietPanel {
        private MainPanel(LayoutManager layout) {
            super(layout);
        }

        public void paint(Graphics g) {
            Dimension size = this.getSize();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, size.width, size.height);
            this.paintComponents(g);
        }
    }
}

