/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.option;

import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.StringTokenizer;
import java.util.Vector;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.DialogBox;
import net.hizlab.kagetaka.awt.QuietPanel;
import net.hizlab.kagetaka.awt.Tree;
import net.hizlab.kagetaka.awt.TreeItem;
import net.hizlab.kagetaka.option.FancyLabel;
import net.hizlab.kagetaka.option.OptionPage;
import net.hizlab.kagetaka.option.Setter;
import net.hizlab.kagetaka.option.ViewerOption;

public class OptionDialog
extends DialogBox {
    private static final String RESOURCE = "net.hizlab.kagetaka.option.Resource";
    private static final int MARGIN = 3;
    public static final int RESULT_OPEN = 0;
    private ViewerOption option;
    private Setter setter;
    private Tree tree;
    private FancyLabel title;
    private QuietPanel main;
    private CardLayout mainLayout;
    private Button reload;
    private Button reset;
    private Vector rootPages = new Vector();
    private Vector pages = new Vector();

    public static boolean show(Frame owner, ViewerOption option) {
        OptionDialog dialog = new OptionDialog(owner, option);
        dialog.show();
        return dialog.getResult() == 0;
    }

    public OptionDialog(Frame owner, ViewerOption option) {
        super(owner, 257);
        this.setTitle(this.getMessage("title"));
        this.setResizable(true);
        this.setModal(true);
        this.option = option;
        this.setter = option.getSetter();
        GridBagLayout gbl = new GridBagLayout();
        Insets insets = new Insets(3, 0, 3, 3);
        this.mainPanel.setLayout(gbl);
        this.tree = new Tree(10, 20){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        QuietPanel buttons = new QuietPanel(new FlowLayout(0, 3, 0));
        this.addToPanel(this.tree, gbl, 0, 0, 1, 3, 0.0, 1.0, 3, 17, insets);
        insets.right = 0;
        this.title = new FancyLabel("");
        this.addToPanel(this.title, gbl, 1, 0, 1, 1, 1.0, 0.0, 2, 18, insets);
        this.mainLayout = new CardLayout();
        this.main = new QuietPanel(this.mainLayout);
        this.addToPanel(this.main, gbl, 1, 1, 1, 1, 1.0, 1.0, 1, 18, insets);
        this.reload = new Button(this.getMessage("label.reload"));
        buttons.add(this.reload);
        this.reset = new Button(this.getMessage("label.reset"));
        buttons.add(this.reset);
        this.title.setFont(Font.decode(this.getMessage("title.font")));
        String pageList = this.getMessage("pages");
        StringTokenizer st = new StringTokenizer(pageList, ",");
        block0: while (st.hasMoreTokens()) {
            int j;
            OptionPage page = new OptionPage(option, "net.hizlab.kagetaka.option.pages." + st.nextToken().trim(), this.setter);
            this.pages.addElement(page);
            page.attachContainer(this.main);
            Vector v = this.rootPages;
            block1: for (int i = 0; i < page.optionPaths.length - 1; ++i) {
                for (j = 0; j < v.size(); ++j) {
                    OptionPage op = (OptionPage)v.elementAt(j);
                    if (op.optionPaths[i].compareTo(page.optionPaths[i]) != 0) {
                        continue;
                    }
                    v = op.child;
                    continue block1;
                }
            }
            int last = page.optionPaths.length - 1;
            for (j = 0; j < v.size(); ++j) {
                if (((OptionPage)v.elementAt((int)j)).optionPaths[last].compareTo(page.optionPaths[last]) == 0) continue block0;
            }
            v.addElement(page);
        }
        this.tree.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                OptionPage page = (OptionPage)OptionDialog.this.tree.getSelectedTreeItem();
                if (page == null) {
                    return;
                }
                OptionDialog.this.title.setText(page.optionTitle);
                OptionDialog.this.mainLayout.show(OptionDialog.this.main, page.optionPath);
            }
        });
        this.reload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                for (int i = OptionDialog.this.pages.size() - 1; i >= 0; --i) {
                    ((OptionPage)OptionDialog.this.pages.elementAt(i)).reload();
                }
            }
        });
        this.reset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                for (int i = OptionDialog.this.pages.size() - 1; i >= 0; --i) {
                    ((OptionPage)OptionDialog.this.pages.elementAt(i)).reset();
                }
            }
        });
        this.tree.setRootTreeItem(new Item());
        this.tree.setBackground(SystemColor.window);
        this.tree.selecteIndex(0);
        this.setButtonLabel(0, this.getMessage("label.ok"));
        this.setButtonLabel(1, this.getMessage("label.cancel"));
        this.pack(600, 0);
    }

    private String getMessage(String key) {
        if (key == null) {
            return "";
        }
        return Resource.getMessage(RESOURCE, "optiondialog." + key, null);
    }

    protected boolean dialogClosing(int result) {
        if (result == 0) {
            this.setter.commit();
            this.option.save();
        } else {
            this.setter.rollback();
        }
        return true;
    }

    public void dispose() {
        for (int i = this.pages.size() - 1; i >= 0; --i) {
            ((OptionPage)this.pages.elementAt(i)).dispose();
        }
        super.dispose();
    }

    private class Item
    implements TreeItem {
        private Item() {
        }

        public Image getTreeIcon(boolean opened) {
            return null;
        }

        public String getTreeLabel() {
            return "root";
        }

        public Vector getTreeItems() {
            return OptionDialog.this.rootPages;
        }
    }
}

