/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.option;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.ImageLabel;
import net.hizlab.kagetaka.awt.LayoutUtils;
import net.hizlab.kagetaka.awt.SizedLabel;
import net.hizlab.kagetaka.awt.ToolTip;
import net.hizlab.kagetaka.option.InvalidValueException;
import net.hizlab.kagetaka.option.OptionComponent;
import net.hizlab.kagetaka.option.Setter;
import net.hizlab.kagetaka.option.ViewerOption;
import net.hizlab.kagetaka.theme.Theme;
import net.hizlab.kagetaka.theme.ThemeManager;

class OptionComponentTheme
extends Container
implements OptionComponent {
    private static final String RESOURCE = "net.hizlab.kagetaka.option.Resource";
    private static final int MARGIN = 3;
    private static final int MINIMUM = 130;
    private Theme[] themes;
    private String tips;
    private String authorHeader;
    private Label label;
    private List list;
    private ImageLabel view;
    private Label name;
    private Label version;
    private Label date;
    private Label author;
    private SizedLabel memo;
    private ViewerOption option;
    private Setter setter;
    private String key;
    private ToolTip toolTip;
    private Theme selectedTheme;

    OptionComponentTheme() {
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        Insets insets = new Insets(0, 0, 3, 0);
        this.label = new Label();
        LayoutUtils.addGridBag(this, this.label, gbl, 0, 0, 3, 1, 1.0, 0.0, 2, 17, insets);
        this.list = new List(5);
        LayoutUtils.addGridBag(this, this.list, gbl, 0, 1, 3, 1, 1.0, 0.0, 2, 17, insets);
        this.view = new View();
        LayoutUtils.addGridBag(this, this.view, gbl, 0, 2, 3, 1, 1.0, 0.0, 2, 17, insets);
        this.name = new Label();
        LayoutUtils.addGridBag(this, this.name, gbl, 0, 3, 1, 1, 0.0, 0.0, 0, 17, insets);
        this.version = new Label();
        LayoutUtils.addGridBag(this, this.version, gbl, 1, 3, 1, 1, 0.0, 0.0, 0, 17, insets);
        this.date = new Label();
        LayoutUtils.addGridBag(this, this.date, gbl, 2, 3, 1, 1, 1.0, 0.0, 0, 17, insets);
        this.author = new Label();
        LayoutUtils.addGridBag(this, this.author, gbl, 0, 4, 3, 1, 1.0, 0.0, 0, 17, insets);
        insets.bottom = 0;
        this.memo = new SizedLabel();
        LayoutUtils.addGridBag(this, this.memo, gbl, 0, 5, 3, 1, 1.0, 0.0, 0, 17, insets);
        this.list.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                int index = OptionComponentTheme.this.list.getSelectedIndex();
                if (index == -1 || index >= OptionComponentTheme.this.themes.length) {
                    return;
                }
                OptionComponentTheme.this.select(OptionComponentTheme.this.themes[index]);
                try {
                    OptionComponentTheme.this.setter.putPropertyString(OptionComponentTheme.this.key, OptionComponentTheme.this.themes[index].getKey());
                }
                catch (InvalidValueException ex) {
                    System.out.println(e);
                }
            }
        });
        this.name.setFont(Font.decode(this.getMessage("key.font")));
        this.label.setText(this.getMessage("key"));
        this.tips = this.getMessage("key.tips");
        this.authorHeader = this.getMessage("key.author");
    }

    public void initialize(ViewerOption option, Setter setter, String key) {
        this.option = option;
        this.setter = setter;
        this.key = key;
        this.toolTip = option.getToolTip();
        ThemeManager tm = option.getThemeManager();
        this.themes = tm.getThemes();
        Theme nowTheme = tm.getTheme();
        for (int i = 0; i < this.themes.length; ++i) {
            Theme theme = this.themes[i];
            this.list.add(theme.getString("theme.name") + "   (" + theme.getString("theme.version") + ")");
            if (theme != nowTheme) continue;
            this.list.select(i);
            this.select(theme);
        }
        if (this.tips != null && this.toolTip != null) {
            this.toolTip.attachComponent(this.label, this.tips);
            this.toolTip.attachComponent(this.list, this.tips);
        }
    }

    public Component getComponent() {
        return this;
    }

    public void reload() {
    }

    public void reset() {
    }

    public void dispose() {
        if (this.tips != null && this.toolTip != null) {
            this.toolTip.detachComponent(this.label);
            this.toolTip.detachComponent(this.list);
        }
    }

    private String getMessage(String key) {
        return Resource.getMessage(RESOURCE, "page.view.theme." + key, null);
    }

    private synchronized void select(Theme theme) {
        if (theme == this.selectedTheme) {
            return;
        }
        this.name.setText(theme.getString("theme.name"));
        this.version.setText(theme.getString("theme.version"));
        this.date.setText(theme.getString("theme.date"));
        this.author.setText(theme.getString("theme.author"));
        this.memo.setText(theme.getString("theme.memo"));
        this.view.setImage(theme.getImage("theme.sample", this.getToolkit()));
        this.selectedTheme = theme;
    }

    private class View
    extends ImageLabel {
        private View() {
        }

        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            if (size.height < 130) {
                size.height = 130;
            }
            return size;
        }
    }
}

