/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.option;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.BrowseButton;
import net.hizlab.kagetaka.awt.DialogBox;
import net.hizlab.kagetaka.awt.LayoutUtils;
import net.hizlab.kagetaka.awt.MessageBox;
import net.hizlab.kagetaka.awt.ToolTip;
import net.hizlab.kagetaka.option.InvalidValueException;
import net.hizlab.kagetaka.option.OptionComponent;
import net.hizlab.kagetaka.option.Setter;
import net.hizlab.kagetaka.option.ViewerOption;

class OptionComponentApplication
extends Container
implements OptionComponent {
    private static final String RESOURCE = "net.hizlab.kagetaka.option.Resource";
    private static final int MARGIN = 3;
    private static final int MINIMUM = 130;
    private static final String COMMAND_UP = "up";
    private static final String COMMAND_DOWN = "down";
    private static final String COMMAND_ADD = "add";
    private static final String COMMAND_EDIT = "edit";
    private static final String COMMAND_DELETE = "delete";
    private ViewerOption.Application[] apps;
    private String tips;
    private String authorHeader;
    private List list;
    private Button up;
    private Button down;
    private Button add;
    private Button edit;
    private Button delete;
    private Label name;
    private Label path;
    private ViewerOption option;
    private Setter setter;
    private String key;
    private ToolTip toolTip;
    private ViewerOption.Application selectedApp;

    OptionComponentApplication() {
        GridBagLayout gbl = new GridBagLayout();
        this.setLayout(gbl);
        Insets insets = new Insets(0, 0, 3, 3);
        this.list = new List(5);
        LayoutUtils.addGridBag(this, this.list, gbl, 0, 1, 4, 3, 1.0, 0.0, 2, 17, insets);
        insets.right = 0;
        this.up = new Button(this.getMessage("button.up"));
        LayoutUtils.addGridBag(this, this.up, gbl, 4, 1, 1, 1, 0.0, 0.0, 0, 17, insets);
        this.down = new Button(this.getMessage("button.down"));
        LayoutUtils.addGridBag(this, this.down, gbl, 4, 2, 1, 1, 0.0, 0.0, 0, 17, insets);
        insets.right = 3;
        this.add = new Button(this.getMessage("button.add"));
        LayoutUtils.addGridBag(this, this.add, gbl, 0, 4, 1, 1, 0.0, 0.0, 0, 17, insets);
        this.edit = new Button(this.getMessage("button.edit"));
        LayoutUtils.addGridBag(this, this.edit, gbl, 1, 4, 1, 1, 0.0, 0.0, 0, 17, insets);
        this.delete = new Button(this.getMessage("button.delete"));
        LayoutUtils.addGridBag(this, this.delete, gbl, 2, 4, 1, 1, 0.0, 0.0, 0, 17, insets);
        insets.right = 0;
        this.name = new Label();
        LayoutUtils.addGridBag(this, this.name, gbl, 0, 5, 5, 1, 1.0, 0.0, 2, 17, insets);
        insets.bottom = 0;
        this.path = new Label();
        LayoutUtils.addGridBag(this, this.path, gbl, 0, 6, 5, 1, 1.0, 0.0, 2, 17, insets);
        this.up.setActionCommand(COMMAND_UP);
        this.down.setActionCommand(COMMAND_DOWN);
        this.add.setActionCommand(COMMAND_ADD);
        this.edit.setActionCommand(COMMAND_EDIT);
        this.delete.setActionCommand(COMMAND_DELETE);
        this.list.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                int index = OptionComponentApplication.this.list.getSelectedIndex();
                if (index == -1 || index >= OptionComponentApplication.this.apps.length) {
                    OptionComponentApplication.this.up.setEnabled(false);
                    OptionComponentApplication.this.down.setEnabled(false);
                    return;
                }
                OptionComponentApplication.this.select(index, false, false);
            }
        });
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String command = e.getActionCommand();
                if (command.compareTo(OptionComponentApplication.COMMAND_ADD) == 0) {
                    OptionComponentApplication.this.showDetail(-1);
                    return;
                }
                int index = OptionComponentApplication.this.list.getSelectedIndex();
                if (index == -1 || index >= OptionComponentApplication.this.apps.length) {
                    return;
                }
                if (command.compareTo(OptionComponentApplication.COMMAND_UP) == 0) {
                    if (index < 1) {
                        return;
                    }
                    ViewerOption.Application app = OptionComponentApplication.this.apps[index];
                    ((OptionComponentApplication)OptionComponentApplication.this).apps[index] = OptionComponentApplication.this.apps[index - 1];
                    ((OptionComponentApplication)OptionComponentApplication.this).apps[index - 1] = app;
                    OptionComponentApplication.this.list.replaceItem(OptionComponentApplication.this.apps[index].getName(), index);
                    OptionComponentApplication.this.list.replaceItem(app.getName(), index - 1);
                    OptionComponentApplication.this.select(index - 1, true, true);
                    try {
                        OptionComponentApplication.this.putAppsList();
                    }
                    catch (InvalidValueException ex) {
                        System.out.println(ex);
                    }
                } else if (command.compareTo(OptionComponentApplication.COMMAND_DOWN) == 0) {
                    if (index >= OptionComponentApplication.this.list.getItemCount() - 1) {
                        return;
                    }
                    ViewerOption.Application app = OptionComponentApplication.this.apps[index];
                    ((OptionComponentApplication)OptionComponentApplication.this).apps[index] = OptionComponentApplication.this.apps[index + 1];
                    ((OptionComponentApplication)OptionComponentApplication.this).apps[index + 1] = app;
                    OptionComponentApplication.this.list.replaceItem(OptionComponentApplication.this.apps[index].getName(), index);
                    OptionComponentApplication.this.list.replaceItem(app.getName(), index + 1);
                    OptionComponentApplication.this.select(index + 1, true, true);
                    try {
                        OptionComponentApplication.this.putAppsList();
                    }
                    catch (InvalidValueException ex) {
                        System.out.println(ex);
                    }
                } else if (command.compareTo(OptionComponentApplication.COMMAND_EDIT) == 0) {
                    OptionComponentApplication.this.showDetail(index);
                } else if (command.compareTo(OptionComponentApplication.COMMAND_DELETE) == 0) {
                    ViewerOption.Application app = OptionComponentApplication.this.apps[index];
                    String id = app.getId();
                    ViewerOption.Application[] newApps = new ViewerOption.Application[OptionComponentApplication.this.apps.length - 1];
                    if (index > 0) {
                        System.arraycopy(OptionComponentApplication.this.apps, 0, newApps, 0, index);
                    }
                    if (index < OptionComponentApplication.this.list.getItemCount() - 1) {
                        System.arraycopy(OptionComponentApplication.this.apps, index + 1, newApps, index, OptionComponentApplication.this.apps.length - index - 1);
                    }
                    OptionComponentApplication.access$102(OptionComponentApplication.this, newApps);
                    OptionComponentApplication.this.list.delItem(index);
                    try {
                        OptionComponentApplication.this.putAppsList();
                        OptionComponentApplication.this.setter.putPropertyString(ViewerOption.KEY_APP_NAME[0] + id + ViewerOption.KEY_APP_NAME[1], null);
                        OptionComponentApplication.this.setter.putPropertyFile(ViewerOption.KEY_APP_PATH[0] + id + ViewerOption.KEY_APP_PATH[1], null);
                        OptionComponentApplication.this.setter.putPropertyString(ViewerOption.KEY_APP_OPTION[0] + id + ViewerOption.KEY_APP_OPTION[1], null);
                        OptionComponentApplication.this.setter.putPropertyBoolean(ViewerOption.KEY_APP_ONLINE[0] + id + ViewerOption.KEY_APP_ONLINE[1], null);
                    }
                    catch (InvalidValueException ex) {
                        System.out.println(ex);
                    }
                    if (OptionComponentApplication.this.apps.length > 0) {
                        if (--index < 0) {
                            index = 0;
                        }
                        OptionComponentApplication.this.select(index, true, true);
                    } else {
                        OptionComponentApplication.this.up.setEnabled(false);
                        OptionComponentApplication.this.down.setEnabled(false);
                        OptionComponentApplication.this.edit.setEnabled(false);
                        OptionComponentApplication.this.delete.setEnabled(false);
                        OptionComponentApplication.this.name.setText("");
                        OptionComponentApplication.this.path.setText("");
                    }
                }
            }
        };
        this.up.addActionListener(al);
        this.down.addActionListener(al);
        this.add.addActionListener(al);
        this.edit.addActionListener(al);
        this.delete.addActionListener(al);
        this.name.setFont(Font.decode(this.getMessage("name.font")));
        this.up.setEnabled(false);
        this.down.setEnabled(false);
        this.edit.setEnabled(false);
        this.delete.setEnabled(false);
    }

    public void initialize(ViewerOption option, Setter setter, String key) {
        this.option = option;
        this.setter = setter;
        this.key = key;
        this.toolTip = option.getToolTip();
        this.apps = option.getApplications();
        for (int i = 0; i < this.apps.length; ++i) {
            this.list.addItem(this.apps[i].getName());
        }
    }

    public Component getComponent() {
        return this;
    }

    public void reload() {
    }

    public void reset() {
    }

    public void dispose() {
    }

    private String getMessage(String key) {
        return Resource.getMessage(RESOURCE, "page.application." + key, null);
    }

    private synchronized void select(int index, boolean force, boolean move) {
        if (move) {
            this.list.select(index);
        }
        ViewerOption.Application app = this.apps[index];
        if (!force && app == this.selectedApp) {
            return;
        }
        this.name.setText(app.getName());
        this.path.setText(app.getPath().getPath());
        this.up.setEnabled(index > 0);
        this.down.setEnabled(index < this.list.getItemCount() - 1);
        this.edit.setEnabled(true);
        this.delete.setEnabled(true);
        this.selectedApp = app;
    }

    private void showDetail(int index) {
        ViewerOption.Application app;
        app = index >= 0 ? (app = this.apps[index]) : null;
        Container parent = this.getParent();
        if (parent == null) {
            return;
        }
        while (!(parent instanceof Frame)) {
            if ((parent = parent.getParent()) != null) continue;
            return;
        }
        Detail dialog = new Detail((Frame)parent, app);
        dialog.show();
        if (dialog.getResult() != 0) {
            return;
        }
        try {
            String id;
            if (index >= 0) {
                id = app.getId();
                this.setter.putPropertyString(ViewerOption.KEY_APP_NAME[0] + id + ViewerOption.KEY_APP_NAME[1], null);
                this.setter.putPropertyFile(ViewerOption.KEY_APP_PATH[0] + id + ViewerOption.KEY_APP_PATH[1], null);
                this.setter.putPropertyString(ViewerOption.KEY_APP_OPTION[0] + id + ViewerOption.KEY_APP_OPTION[1], null);
                this.setter.putPropertyBoolean(ViewerOption.KEY_APP_ONLINE[0] + id + ViewerOption.KEY_APP_ONLINE[1], null);
            }
            id = dialog.id.getText();
            String name = dialog.name.getText();
            File path = this.option.convertRelativeToCanonical(new File(dialog.path.getText()));
            String option = dialog.option.getText();
            boolean online = dialog.online.getState();
            app = new ViewerOption.Application(id, name, path, option, online);
            if (index >= 0) {
                this.list.replaceItem(app.getName(), index);
            } else {
                index = this.list.getSelectedIndex() + 1;
                if (index == 0) {
                    index = this.list.getItemCount();
                }
                ViewerOption.Application[] newApps = new ViewerOption.Application[this.apps.length + 1];
                if (index > 0) {
                    System.arraycopy(this.apps, 0, newApps, 0, index);
                }
                if (index < this.list.getItemCount()) {
                    System.arraycopy(this.apps, index, newApps, index + 1, this.apps.length - index);
                }
                this.apps = newApps;
                this.list.addItem(app.getName(), index);
            }
            this.apps[index] = app;
            this.putAppsList();
            this.setter.putPropertyString(ViewerOption.KEY_APP_NAME[0] + id + ViewerOption.KEY_APP_NAME[1], name);
            this.setter.putPropertyFile(ViewerOption.KEY_APP_PATH[0] + id + ViewerOption.KEY_APP_PATH[1], path);
            this.setter.putPropertyString(ViewerOption.KEY_APP_OPTION[0] + id + ViewerOption.KEY_APP_OPTION[1], option);
            this.setter.putPropertyBoolean(ViewerOption.KEY_APP_ONLINE[0] + id + ViewerOption.KEY_APP_ONLINE[1], online);
            this.select(index, true, true);
        }
        catch (InvalidValueException e) {
            System.out.println(e);
        }
    }

    private void putAppsList() throws InvalidValueException {
        String[] lists = new String[this.apps.length];
        for (int i = 0; i < lists.length; ++i) {
            lists[i] = this.apps[i].getId();
        }
        this.setter.putPropertyStrings("app.list", lists);
    }

    static /* synthetic */ ViewerOption.Application[] access$102(OptionComponentApplication x0, ViewerOption.Application[] x1) {
        x0.apps = x1;
        return x1;
    }

    private class Detail
    extends DialogBox {
        private Frame owner;
        private String oldId;
        private Label idl;
        private TextField id;
        private Label namel;
        private TextField name;
        private Label pathl;
        private TextField path;
        private BrowseButton pathb;
        private Label optionl;
        private TextField option;
        private Checkbox online;

        private Detail(Frame owner, ViewerOption.Application app) {
            super(owner, 1);
            this.setResizable(false);
            this.setModal(true);
            this.owner = owner;
            this.setTitle(OptionComponentApplication.this.getMessage(app != null ? "detail.edit" : "detail.new"));
            if (app != null) {
                this.oldId = app.getId();
            }
            GridBagLayout gbl = new GridBagLayout();
            Insets insets = new Insets(3, 3, 3, 3);
            this.mainPanel.setLayout(gbl);
            this.idl = new Label(OptionComponentApplication.this.getMessage("id"));
            this.addToPanel(this.idl, gbl, 0, 0, 1, 1, 0.0, 0.0, 2, 17, insets);
            this.id = new TextField(app != null ? app.getId() : "");
            this.addToPanel(this.id, gbl, 1, 0, 2, 1, 1.0, 0.0, 2, 10, insets);
            this.namel = new Label(OptionComponentApplication.this.getMessage("name"));
            this.addToPanel(this.namel, gbl, 0, 1, 1, 1, 0.0, 0.0, 2, 17, insets);
            this.name = new TextField(app != null ? app.getName() : "");
            this.addToPanel(this.name, gbl, 1, 1, 2, 1, 1.0, 0.0, 2, 10, insets);
            this.pathl = new Label(OptionComponentApplication.this.getMessage("path"));
            this.addToPanel(this.pathl, gbl, 0, 2, 1, 1, 0.0, 0.0, 2, 17, insets);
            this.path = new TextField(app != null ? app.getPath().getPath() : "", 30);
            this.addToPanel(this.path, gbl, 1, 2, 1, 1, 1.0, 0.0, 2, 10, insets);
            this.pathb = new BrowseButton(2, this.path);
            this.addToPanel(this.pathb, gbl, 2, 2, 1, 1, 0.0, 0.0, 2, 17, insets);
            this.optionl = new Label(OptionComponentApplication.this.getMessage("option"));
            this.addToPanel(this.optionl, gbl, 0, 3, 1, 1, 0.0, 0.0, 2, 17, insets);
            this.option = new TextField(app != null ? app.getOption() : "");
            this.addToPanel(this.option, gbl, 1, 3, 2, 1, 1.0, 0.0, 2, 10, insets);
            this.online = new Checkbox(OptionComponentApplication.this.getMessage("online"), app != null ? app.getOnline() : true);
            this.addToPanel(this.online, gbl, 0, 4, 3, 1, 1.0, 0.0, 2, 10, insets);
            this.pathb.setPathAbsoluter(OptionComponentApplication.this.option);
            this.online.setEnabled(false);
            this.pack();
        }

        public void show() {
            if (OptionComponentApplication.this.toolTip != null) {
                OptionComponentApplication.this.toolTip.attachComponent(this.idl, OptionComponentApplication.this.getMessage("id.tips"));
                OptionComponentApplication.this.toolTip.attachComponent(this.id, OptionComponentApplication.this.getMessage("id.tips"));
                OptionComponentApplication.this.toolTip.attachComponent(this.namel, OptionComponentApplication.this.getMessage("name.tips"));
                OptionComponentApplication.this.toolTip.attachComponent(this.name, OptionComponentApplication.this.getMessage("name.tips"));
                OptionComponentApplication.this.toolTip.attachComponent(this.pathl, OptionComponentApplication.this.getMessage("path.tips"));
                OptionComponentApplication.this.toolTip.attachComponent(this.path, OptionComponentApplication.this.getMessage("path.tips"));
                OptionComponentApplication.this.toolTip.attachComponent(this.pathb, OptionComponentApplication.this.getMessage("path.tips"));
                OptionComponentApplication.this.toolTip.attachComponent(this.optionl, OptionComponentApplication.this.getMessage("option.tips"));
                OptionComponentApplication.this.toolTip.attachComponent(this.option, OptionComponentApplication.this.getMessage("option.tips"));
                OptionComponentApplication.this.toolTip.attachComponent(this.online, OptionComponentApplication.this.getMessage("online.tips"));
            }
            super.show();
        }

        protected boolean dialogClosing(int result) {
            if (result == 1) {
                return true;
            }
            if (this.id.getText().length() == 0 || this.name.getText().length() == 0 || this.path.getText().length() == 0) {
                MessageBox.show(this.owner, OptionComponentApplication.this.getMessage("novalue.text"), OptionComponentApplication.this.getMessage("novalue.title"), 65536);
                return false;
            }
            String newId = this.id.getText();
            if (this.oldId == null || this.oldId.compareTo(newId) != 0) {
                for (int i = 0; i < OptionComponentApplication.this.apps.length; ++i) {
                    if (OptionComponentApplication.this.apps[i].getId().compareTo(newId) != 0) continue;
                    MessageBox.show(this.owner, OptionComponentApplication.this.getMessage("duplicate.text"), OptionComponentApplication.this.getMessage("duplicate.title"), 65536);
                    return false;
                }
            }
            if (OptionComponentApplication.this.toolTip != null) {
                OptionComponentApplication.this.toolTip.detachComponent(this.idl);
                OptionComponentApplication.this.toolTip.detachComponent(this.id);
                OptionComponentApplication.this.toolTip.detachComponent(this.namel);
                OptionComponentApplication.this.toolTip.detachComponent(this.name);
                OptionComponentApplication.this.toolTip.detachComponent(this.pathl);
                OptionComponentApplication.this.toolTip.detachComponent(this.path);
                OptionComponentApplication.this.toolTip.detachComponent(this.pathb);
                OptionComponentApplication.this.toolTip.detachComponent(this.optionl);
                OptionComponentApplication.this.toolTip.detachComponent(this.option);
                OptionComponentApplication.this.toolTip.detachComponent(this.online);
            }
            return true;
        }
    }
}

