/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.option;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.SystemColor;

class FancyLabel
extends Component {
    private static final int BORDER = 4;
    private Image offscreen;
    private Dimension offscreenSize;
    private Graphics offscreenGraphics;
    private Object offscreenLock = new Object();
    private boolean changeLabel = true;
    private String label;
    private Dimension preferredSize = new Dimension(0, 0);

    FancyLabel(String label) {
        this.setText(label);
        this.setForeground(SystemColor.controlLtHighlight);
        this.setBackground(SystemColor.controlShadow);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        Dimension size = null;
        Image image = null;
        Object object = this.offscreenLock;
        synchronized (object) {
            size = this.getSize();
            if (this.changeLabel || !size.equals(this.offscreenSize)) {
                if (!size.equals(this.offscreenSize)) {
                    if (this.offscreen != null) {
                        this.offscreenGraphics.dispose();
                        this.offscreen.flush();
                    }
                    this.offscreen = this.createImage(size.width, size.height);
                    this.offscreenSize = size;
                    this.offscreenGraphics = this.offscreen.getGraphics();
                }
                this.offscreenGraphics.setColor(this.getBackground());
                this.offscreenGraphics.fillRect(0, 0, size.width, size.height);
                this.offscreenGraphics.setColor(SystemColor.controlDkShadow);
                this.offscreenGraphics.drawLine(1, 1, 1, size.height - 2);
                this.offscreenGraphics.drawLine(1, 1, size.width - 2, 1);
                this.offscreenGraphics.drawLine(2, size.height - 2, size.width - 2, size.height - 2);
                this.offscreenGraphics.drawLine(size.width - 2, 2, size.width - 2, size.height - 2);
                this.offscreenGraphics.setColor(SystemColor.controlLtHighlight);
                this.offscreenGraphics.drawLine(1, size.height - 1, size.width - 1, size.height - 1);
                this.offscreenGraphics.drawLine(size.width - 1, 1, size.width - 1, size.height - 1);
                this.offscreenGraphics.setFont(this.getFont());
                this.offscreenGraphics.setColor(this.getForeground());
                FontMetrics fm = this.getFontMetrics(this.getFont());
                int height = fm.getHeight();
                this.offscreenGraphics.drawString(this.label, 6, (size.height - height) / 2 + height - fm.getDescent());
                this.changeLabel = false;
            }
            image = this.offscreen;
        }
        g.drawImage(image, 0, 0, size.width, size.height, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setText(String label) {
        Object object = this.offscreenLock;
        synchronized (object) {
            this.label = label;
            this.changeLabel = true;
            this.resetSize();
            this.invalidate();
        }
        if (this.isVisible()) {
            this.repaint();
        }
    }

    String getText() {
        return this.label;
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.preferredSize);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.preferredSize);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.resetSize();
        this.invalidate();
    }

    private void resetSize() {
        Font font = this.getFont();
        if (font == null) {
            return;
        }
        FontMetrics fm = this.getFontMetrics(font);
        this.preferredSize = new Dimension(fm.stringWidth(this.label) + 4, fm.getHeight() + 4);
    }
}

