/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.option;

import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Font;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import net.hizlab.kagetaka.option.InvalidValueException;
import net.hizlab.kagetaka.option.Setter;
import net.hizlab.kagetaka.option.ViewerOption;
import net.hizlab.kagetaka.util.CharList;

class ComponentListener
implements ItemListener,
TextListener {
    private ViewerOption option;
    private Setter setter;
    private String key;
    private int type;
    private Component other;
    private Vector values;

    ComponentListener(ViewerOption option, Setter setter, String key, int type) {
        this.option = option;
        this.setter = setter;
        this.key = key;
        this.type = type;
    }

    ComponentListener(ViewerOption option, Setter setter, String key, int type, Component other) {
        this(option, setter, key, type);
        this.other = other;
    }

    ComponentListener(ViewerOption option, Setter setter, String key, int type, Vector values) {
        this(option, setter, key, type);
        this.values = values;
    }

    public void itemStateChanged(ItemEvent e) {
        Component c = (Component)e.getSource();
        try {
            if (this.values != null) {
                int index = ((Choice)c).getSelectedIndex();
                String value = (String)this.values.elementAt(index);
                switch (this.type) {
                    case 2: {
                        this.setter.putPropertyInteger(this.key, Integer.parseInt(value));
                        return;
                    }
                    case 3: {
                        this.setter.putPropertyDouble(this.key, (double)Double.valueOf(value));
                        return;
                    }
                    case 4: {
                        this.setter.putPropertyString(this.key, value);
                        return;
                    }
                }
            }
            if (c instanceof Checkbox && this.type == 1) {
                this.setter.putPropertyBoolean(this.key, new Boolean(e.getStateChange() == 1));
                return;
            }
            if (this.type == 7) {
                this.setter.putPropertyFont(this.key, new Font(((Choice)c).getSelectedItem(), 0, this.getFontSize(((TextField)this.other).getText())));
                return;
            }
        }
        catch (InvalidValueException ex) {
            System.out.println(e);
        }
    }

    public void textValueChanged(TextEvent e) {
        String value = ((TextComponent)e.getSource()).getText();
        try {
            if (this.type == 2) {
                if (value.length() == 0) {
                    this.setter.putPropertyInteger(this.key, null);
                } else {
                    this.setter.putPropertyInteger(this.key, Integer.valueOf(value));
                }
                return;
            }
            if (this.type == 3) {
                if (value.length() == 0) {
                    this.setter.putPropertyDouble(this.key, null);
                } else {
                    this.setter.putPropertyDouble(this.key, Double.valueOf(value));
                }
                return;
            }
            if (this.type == 4) {
                this.setter.putPropertyString(this.key, value);
                return;
            }
            if (this.type == 5) {
                Vector<String> v = new Vector<String>();
                StringTokenizer st = new StringTokenizer(value, ",");
                while (st.hasMoreTokens()) {
                    v.addElement(st.nextToken().trim());
                }
                Object[] values = new String[v.size()];
                v.copyInto(values);
                this.setter.putPropertyStrings(this.key, (String[])values);
                return;
            }
            if (this.type == 9) {
                this.setter.putPropertyFile(this.key, this.option.convertRelativeToCanonical(new File(value)));
                return;
            }
            if (this.type == 10) {
                this.setter.putPropertyCharList(this.key, new CharList(value));
                return;
            }
            if (this.type == 7) {
                this.setter.putPropertyFont(this.key, new Font(((Choice)this.other).getSelectedItem(), 0, this.getFontSize(value)));
                return;
            }
        }
        catch (InvalidValueException ex) {
            System.out.println(e);
        }
    }

    private int getFontSize(String value) {
        Font font;
        Object o;
        if (value.length() > 0) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((o = this.option.defaultProperties.get(this.key)) != null && o instanceof Font && (font = (Font)o) != null) {
            return font.getSize();
        }
        return 14;
    }
}

