/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.java2.bridge;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.SystemFlavorMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class FileFlavorMap
implements FlavorMap {
    static final String KEY_TEXT = "TEXT";
    static final String KEY_FILE_NAME = "FileName";
    static final String KEY_FILE_NAME_WIDE = "FileNameW";
    static final String HPN_TEXT = null;
    static final String HPN_FILE_NAME = "File Name";
    static final String HPN_FILE_NAME_WIDE = "File Name Wide";
    private Map nativeToFlavor;
    private Map flavorToNative;

    FileFlavorMap() {
        this(SystemFlavorMap.getDefaultFlavorMap().getFlavorsForNatives(null));
    }

    FileFlavorMap(Map map) {
        DataFlavorEx f;
        Object key;
        this.nativeToFlavor = new HashMap(map.size());
        this.flavorToNative = new HashMap(map.size());
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            key = it.next();
            f = new DataFlavorEx((DataFlavor)map.get(key));
            this.nativeToFlavor.put(key, f);
            this.flavorToNative.put(f, key);
        }
        String[][] additional = new String[][]{{KEY_TEXT, "text/plain; class=java.io.InputStream", HPN_TEXT}, {KEY_FILE_NAME, "text/plain; class=java.io.InputStream", HPN_FILE_NAME}, {KEY_FILE_NAME_WIDE, "text/plain; charset=UnicodeLittleUnmarked; class=java.io.InputStream", HPN_FILE_NAME_WIDE}};
        for (int i = 0; i < additional.length; ++i) {
            key = additional[i][0];
            if (this.nativeToFlavor.containsKey(key)) {
                this.flavorToNative.remove(this.nativeToFlavor.get(key));
                this.nativeToFlavor.remove(key);
            }
            f = new DataFlavorEx(additional[i][1], additional[i][2]);
            this.nativeToFlavor.put(key, f);
            this.flavorToNative.put(f, key);
        }
    }

    public synchronized Map getNativesForFlavors(DataFlavor[] flavors) {
        if (flavors == null) {
            return new HashMap(this.flavorToNative);
        }
        if (flavors.length == 0) {
            return null;
        }
        HashMap<DataFlavor, String> map = new HashMap<DataFlavor, String>(flavors.length);
        for (int i = 0; i < flavors.length; ++i) {
            DataFlavor f = flavors[i];
            String n = (String)this.flavorToNative.get(f);
            if (n == null) {
                String emts = SystemFlavorMap.encodeJavaMIMEType(f.getMimeType());
                map.put(f, emts);
                this.nativeToFlavor.put(emts, f);
                this.flavorToNative.put(f, emts);
                continue;
            }
            map.put(f, n);
        }
        return map;
    }

    public synchronized Map getFlavorsForNatives(String[] natives) {
        if (natives == null) {
            return new HashMap(this.flavorToNative);
        }
        if (natives.length == 0) {
            return new HashMap();
        }
        HashMap<String, DataFlavor> map = new HashMap<String, DataFlavor>(natives.length);
        for (int i = 0; i < natives.length; ++i) {
            String n = natives[i];
            DataFlavor f = this.getFlavorsForNatives(n);
            if (f == null) continue;
            map.put(n, f);
        }
        return map;
    }

    public synchronized DataFlavor getFlavorsForNatives(String n) {
        DataFlavor f = (DataFlavor)this.nativeToFlavor.get(n);
        if (f == null) {
            if (!SystemFlavorMap.isJavaMIMEType(n)) {
                return null;
            }
            String mts = SystemFlavorMap.decodeJavaMIMEType(n);
            try {
                f = new DataFlavor(mts);
            }
            catch (Exception e) {
                System.out.println("Exception \"" + e.getClass().getName() + ": " + e.getMessage() + "\"while constructing DataFlavor for: " + mts);
                return null;
            }
            this.nativeToFlavor.put(n, f);
            this.flavorToNative.put(f, n);
        }
        return f;
    }

    private class DataFlavorEx
    extends DataFlavor {
        private DataFlavorEx(DataFlavor f) {
            super(f.getMimeType(), f.getHumanPresentableName());
        }

        private DataFlavorEx(String mimeType, String humanPresentableName) {
            super(mimeType, humanPresentableName);
        }

        public boolean equals(DataFlavor that) {
            if (!super.equals(that)) {
                return false;
            }
            String thisName = this.getHumanPresentableName();
            String thatName = that.getHumanPresentableName();
            return thisName == null && thatName == null || thisName != null && thatName != null && thisName.compareTo(thatName) == 0;
        }

        public int hashCode() {
            int total = super.hashCode();
            return (total += this.getHumanPresentableName().hashCode()) != 0 ? total : 25324987;
        }
    }
}

