/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.io;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BinaryInputStream
extends FilterInputStream {
    private byte[] buffer;
    private long offset;

    public BinaryInputStream(InputStream in, int bufferSize) {
        super(in);
        this.buffer = new byte[bufferSize];
    }

    public int read() throws IOException {
        int b = this.in.read();
        if (b != -1) {
            ++this.offset;
        }
        return b;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int length = this.in.read(b, off, len);
        this.offset += (long)length;
        return length;
    }

    public long readNumber(int size) throws IOException {
        int length = 0;
        for (int p = 0; p < size; p += length) {
            length = this.in.read(this.buffer, p, size);
            if (length != -1) continue;
            throw new EOFException();
        }
        this.offset += (long)size;
        return BinaryInputStream.byteToLong(this.buffer, 0, size);
    }

    public String readString(String encoding) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(this.buffer.length);
        int data = 0;
        while (true) {
            if ((data = this.in.read()) == -1) {
                throw new EOFException();
            }
            if (data == 0) break;
            os.write(data);
        }
        ((OutputStream)os).close();
        this.offset += (long)os.size();
        if (encoding == null) {
            return os.toString();
        }
        return os.toString(encoding);
    }

    public long skip(long size) throws IOException {
        long length;
        if (size <= 0L) {
            return 0L;
        }
        long total = 0L;
        while ((total += (length = this.in.skip(size))) < size) {
            size -= length;
        }
        this.offset += total;
        return total;
    }

    public long getOffset() {
        return this.offset;
    }

    public static long byteToLong(byte[] b, int off, int len) {
        long value = 0L;
        for (int i = off + len - 1; i >= off; --i) {
            value = value << 8 | (long)(0xFF & b[i]);
        }
        return value;
    }
}

