/*
 * Decompiled with CFR 0.152.
 */
package net.hizlab.kagetaka.history;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import net.hizlab.kagetaka.history.History;
import net.hizlab.kagetaka.history.HistoryEditor;
import net.hizlab.kagetaka.option.ViewerOption;

public class HistoryManager {
    private static final String ENCODING = "Unicode";
    private static final int LF = 10;
    private ViewerOption option;
    private HistoryEditor editor;
    private File historyFile;
    private History top;
    private History last;
    private Hashtable hash = new Hashtable();

    public HistoryManager(ViewerOption option) {
        this.option = option;
        this.load(option.getPropertyFile("history.path"));
    }

    private synchronized void load(File file) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), ENCODING));
            this.historyFile = file;
            while ((line = br.readLine()) != null) {
                try {
                    History h = new History(line, true);
                    this.hash.put(h.getURLText(), h);
                    if (this.last == null) {
                        this.top = this.last = h;
                        continue;
                    }
                    this.top.prev = h;
                    h.next = this.top;
                    this.top = h;
                }
                catch (InvalidObjectException e) {}
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            return;
        }
        catch (IOException e) {
            System.out.println(e);
            e.printStackTrace(System.out);
        }
    }

    public synchronized void save() {
        File file = this.option.getPropertyFile("history.path");
        int num = this.option.getPropertyInteger("history.save.num", 500);
        try {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), ENCODING));
            History h = this.last;
            while (h != null && num-- != 0) {
                h.write(bw);
                bw.write(10);
                h = h.prev;
            }
            bw.flush();
            bw.close();
        }
        catch (IOException e) {
            System.out.println(e);
            e.printStackTrace(System.out);
        }
    }

    public synchronized History[] getHistories(boolean reverse) {
        History[] histories = new History[this.hash.size()];
        int index = 0;
        if (reverse) {
            History h = this.last;
            while (h != null) {
                histories[index++] = h;
                h = h.prev;
            }
        } else {
            History h = this.top;
            while (h != null) {
                histories[index++] = h;
                h = h.next;
            }
        }
        return histories;
    }

    public synchronized History visited(String url) {
        History h = (History)this.hash.get(url);
        if (h == null) {
            h = new History(url);
            this.hash.put(url, h);
        } else {
            h.visited();
            if (h.prev != null && h.next != null) {
                h.prev.next = h.next;
                h.next.prev = h.prev;
            } else if (h.next != null) {
                h.next.prev = null;
                this.top = h.next;
            } else {
                return h;
            }
            h.next = null;
            h.prev = null;
        }
        if (this.top == null) {
            this.top = this.last = h;
        } else {
            h.prev = this.last;
            this.last.next = h;
            this.last = h;
        }
        return h;
    }

    public synchronized boolean contains(String url) {
        return this.hash.containsKey(url);
    }

    public synchronized void remove(History h) {
        String url = h.getURLText();
        if (!this.hash.containsKey(url)) {
            return;
        }
        if (h == null) {
            return;
        }
        if (h.prev != null && h.next != null) {
            h.prev.next = h.next;
            h.next.prev = h.prev;
        } else if (h.next != null) {
            h.next.prev = null;
            this.top = h.next;
        } else if (h.prev != null) {
            h.prev.next = null;
            this.last = h.prev;
        } else {
            this.last = null;
            this.top = null;
        }
        h.next = null;
        h.prev = null;
        this.hash.remove(url);
    }

    public synchronized void showEditor() {
        if (this.editor == null || !this.editor.isVisible()) {
            this.editor = new HistoryEditor(this.option);
        }
        this.editor.show();
    }
}

